/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.guava.io;

import java.io.Flushable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sparkproject.connect.guava.annotations.Beta;
import org.sparkproject.connect.guava.annotations.GwtIncompatible;
import org.sparkproject.connect.guava.annotations.J2ktIncompatible;

@J2ktIncompatible
@GwtIncompatible
public final class Flushables {
    private static final Logger logger = Logger.getLogger(Flushables.class.getName());

    private Flushables() {
    }

    public static void flush(Flushable flushable, boolean swallowIOException) throws IOException {
        try {
            flushable.flush();
        }
        catch (IOException e) {
            if (swallowIOException) {
                logger.log(Level.WARNING, "IOException thrown while flushing Flushable.", e);
            }
            throw e;
        }
    }

    @Beta
    public static void flushQuietly(Flushable flushable) {
        try {
            Flushables.flush(flushable, true);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "IOException should not have been thrown.", e);
        }
    }
}

