/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.StateStoreColumnFamilySchemaUtils$;
import org.apache.spark.sql.execution.streaming.runtime.StreamingCheckpointConstants$;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StatePartitionWriterColumnFamilyInfo;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCheckpointInfo;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema$;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider;
import org.apache.spark.sql.execution.streaming.state.StateStoreProvider$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.MapView;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Uc\u0001B\f\u0019\u0001\u001dB\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tg\u0001\u0011\t\u0011)A\u0005i!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!a\u0005A!A!\u0002\u0013i\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u0011E\u0003!\u0011!Q\u0001\n5C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t3\u0002\u0011\t\u0011)A\u00055\")\u0001\r\u0001C\u0001C\"9A\u000e\u0001b\u0001\n\u0013i\u0007BB9\u0001A\u0003%a\u000eC\u0004s\u0001\t\u0007I\u0011B:\t\r]\u0004\u0001\u0015!\u0003u\u0011\u001dA\bA1A\u0005\neDq!!\u0001\u0001A\u0003%!\u0010\u0003\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0003z\u0011\u001d\t)\u0001\u0001Q\u0001\niD!\"a\u0002\u0001\u0011\u000b\u0007I\u0011CA\u0005\u0011)\t\t\u0002\u0001EC\u0002\u0013%\u00111\u0003\u0005\b\u00037\u0001A\u0011AA\u000f\u0011\u001d\t9\u0005\u0001C\u0005\u0003\u0013\u0012Qe\u0015;bi\u0016\u0004\u0016M\u001d;ji&|g.\u00117m\u0007>dW/\u001c8GC6LG.[3t/JLG/\u001a:\u000b\u0005eQ\u0012!B:uCR,'BA\u000e\u001d\u0003%\u0019HO]3b[&twM\u0003\u0002\u001e=\u0005IQ\r_3dkRLwN\u001c\u0006\u0003?\u0001\n1a]9m\u0015\t\t#%A\u0003ta\u0006\u00148N\u0003\u0002$I\u00051\u0011\r]1dQ\u0016T\u0011!J\u0001\u0004_J<7\u0001A\n\u0003\u0001!\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0017!C:u_J,7i\u001c8g!\t\u0001\u0014'D\u0001\u0019\u0013\t\u0011\u0004D\u0001\bTi\u0006$Xm\u0015;pe\u0016\u001cuN\u001c4\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u00026u5\taG\u0003\u00028q\u0005!1m\u001c8g\u0015\tI$%\u0001\u0004iC\u0012|w\u000e]\u0005\u0003wY\u0012QbQ8oM&<WO]1uS>t\u0017a\u00039beRLG/[8o\u0013\u0012\u0004\"!\u000b \n\u0005}R#aA%oi\u0006\u0001B/\u0019:hKR\u001c\u0005\u000fT8dCRLwN\u001c\t\u0003\u0005&s!aQ$\u0011\u0005\u0011SS\"A#\u000b\u0005\u00193\u0013A\u0002\u001fs_>$h(\u0003\u0002IU\u00051\u0001K]3eK\u001aL!AS&\u0003\rM#(/\u001b8h\u0015\tA%&\u0001\u0006pa\u0016\u0014\u0018\r^8s\u0013\u0012\u0004\"!\u000b(\n\u0005=S#\u0001\u0002'p]\u001e\f\u0011b\u001d;pe\u0016t\u0015-\\3\u0002\u001d\r,(O]3oi\n\u000bGo\u00195JI\u0006A2m\u001c7GC6LG.\u001f+p/JLG/\u001a:J]\u001a|W*\u00199\u0011\t\t#\u0016IV\u0005\u0003+.\u00131!T1q!\t\u0001t+\u0003\u0002Y1\t!3\u000b^1uKB\u000b'\u000f^5uS>twK]5uKJ\u001cu\u000e\\;n]\u001a\u000bW.\u001b7z\u0013:4w.A\ttG\",W.\u0019)s_ZLG-\u001a:PaR\u00042!K.^\u0013\ta&F\u0001\u0004PaRLwN\u001c\t\u0003ayK!a\u0018\r\u0003'M#\u0018\r^3TG\",W.\u0019)s_ZLG-\u001a:\u0002\rqJg.\u001b;?))\u00117\rZ3gO\"L'n\u001b\t\u0003a\u0001AQA\f\u0006A\u0002=BQa\r\u0006A\u0002QBQ\u0001\u0010\u0006A\u0002uBQ\u0001\u0011\u0006A\u0002\u0005CQ\u0001\u0014\u0006A\u00025CQ\u0001\u0015\u0006A\u0002\u0005CQ!\u0015\u0006A\u00025CQA\u0015\u0006A\u0002MCQ!\u0017\u0006A\u0002i\u000b\u0011#^:f\u0007>dW/\u001c8GC6LG.[3t+\u0005q\u0007CA\u0015p\u0013\t\u0001(FA\u0004C_>dW-\u00198\u0002%U\u001cXmQ8mk6tg)Y7jY&,7\u000fI\u0001\u000eI\u00164\u0017-\u001e7u'\u000eDW-\\1\u0016\u0003Q\u0004\"\u0001M;\n\u0005YD\"!G*uCR,7\u000b^8sK\u000e{GNR1nS2L8k\u00195f[\u0006\fa\u0002Z3gCVdGoU2iK6\f\u0007%A\u000fd_2,XN\u001c$b[&d\u0017\u0010V8LKf\u001c6\r[3nC2+g.T1q+\u0005Q\b\u0003B>\u007f\u0003vj\u0011\u0001 \u0006\u0003{*\n!bY8mY\u0016\u001cG/[8o\u0013\tyHPA\u0004NCB4\u0016.Z<\u0002=\r|G.^7o\r\u0006l\u0017\u000e\\=U_.+\u0017pU2iK6\fG*\u001a8NCB\u0004\u0013aH2pYVlgNR1nS2LHk\u001c,bYV,7k\u00195f[\u0006dUM\\'ba\u0006\u00013m\u001c7v[:4\u0015-\\5msR{g+\u00197vKN\u001b\u0007.Z7b\u0019\u0016tW*\u00199!\u0003!\u0001(o\u001c<jI\u0016\u0014XCAA\u0006!\r\u0001\u0014QB\u0005\u0004\u0003\u001fA\"AE*uCR,7\u000b^8sKB\u0013xN^5eKJ\f!b\u001d;bi\u0016\u001cFo\u001c:f+\t\t)\u0002E\u00021\u0003/I1!!\u0007\u0019\u0005)\u0019F/\u0019;f'R|'/Z\u0001\u0006oJLG/\u001a\u000b\u0005\u0003?\t)\u0003E\u00021\u0003CI1!a\t\u0019\u0005a\u0019F/\u0019;f'R|'/Z\"iK\u000e\\\u0007o\\5oi&sgm\u001c\u0005\b\u0003O)\u0002\u0019AA\u0015\u0003\u0011\u0011xn^:\u0011\r\u0005-\u0012QGA\u001e\u001d\u0011\ti#!\r\u000f\u0007\u0011\u000by#C\u0001,\u0013\r\t\u0019DK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9$!\u000f\u0003\u0011%#XM]1u_JT1!a\r+!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!=\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002F\u0005}\"aC%oi\u0016\u0014h.\u00197S_^\f\u0001b\u001e:ji\u0016\u0014vn\u001e\u000b\u0005\u0003\u0017\n\t\u0006E\u0002*\u0003\u001bJ1!a\u0014+\u0005\u0011)f.\u001b;\t\u000f\u0005Mc\u00031\u0001\u0002<\u00051!/Z2pe\u0012\u0004")
public class StatePartitionAllColumnFamiliesWriter {
    private StateStoreProvider provider;
    private StateStore stateStore;
    private final StateStoreConf storeConf;
    private final Configuration hadoopConf;
    private final int partitionId;
    private final String targetCpLocation;
    private final long operatorId;
    private final String storeName;
    private final long currentBatchId;
    private final Map<String, StatePartitionWriterColumnFamilyInfo> colFamilyToWriterInfoMap;
    private final Option<StateSchemaProvider> schemaProviderOpt;
    private final boolean useColumnFamilies;
    private final StateStoreColFamilySchema defaultSchema;
    private final MapView<String, Object> columnFamilyToKeySchemaLenMap;
    private final MapView<String, Object> columnFamilyToValueSchemaLenMap;
    private volatile byte bitmap$0;

    private boolean useColumnFamilies() {
        return this.useColumnFamilies;
    }

    private StateStoreColFamilySchema defaultSchema() {
        return this.defaultSchema;
    }

    private MapView<String, Object> columnFamilyToKeySchemaLenMap() {
        return this.columnFamilyToKeySchemaLenMap;
    }

    private MapView<String, Object> columnFamilyToValueSchemaLenMap() {
        return this.columnFamilyToValueSchemaLenMap;
    }

    private StateStoreProvider provider$lzycompute() {
        StatePartitionAllColumnFamiliesWriter statePartitionAllColumnFamiliesWriter = this;
        synchronized (statePartitionAllColumnFamiliesWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                StateStoreProvider provider;
                String stateCheckpointLocation = new Path(this.targetCpLocation, StreamingCheckpointConstants$.MODULE$.DIR_NAME_STATE()).toString();
                StateStoreId stateStoreId = new StateStoreId(stateCheckpointLocation, this.operatorId, this.partitionId, this.storeName);
                StateStoreProviderId stateStoreProviderId = new StateStoreProviderId(stateStoreId, UUID.randomUUID());
                this.provider = provider = StateStoreProvider$.MODULE$.createAndInit(stateStoreProviderId, this.defaultSchema().keySchema(), this.defaultSchema().valueSchema(), (KeyStateEncoderSpec)this.defaultSchema().keyStateEncoderSpec().get(), this.useColumnFamilies(), this.storeConf, this.hadoopConf, false, this.schemaProviderOpt);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.provider;
    }

    public StateStoreProvider provider() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.provider$lzycompute();
        }
        return this.provider;
    }

    /*
     * WARNING - void declaration
     */
    private StateStore stateStore$lzycompute() {
        StatePartitionAllColumnFamiliesWriter statePartitionAllColumnFamiliesWriter = this;
        synchronized (statePartitionAllColumnFamiliesWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_6;
                long x$1 = this.currentBatchId;
                None$ x$2 = None$.MODULE$;
                boolean x$3 = true;
                boolean x$4 = this.provider().getStore$default$3();
                StateStore store = this.provider().getStore(x$1, (Option<String>)x$2, x$4, true);
                if (this.useColumnFamilies()) {
                    this.colFamilyToWriterInfoMap.foreach((Function1 & Serializable)pair -> {
                        StatePartitionAllColumnFamiliesWriter.$anonfun$stateStore$1(store, pair);
                        return BoxedUnit.UNIT;
                    });
                }
                this.stateStore = var2_6;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.stateStore;
    }

    private StateStore stateStore() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.stateStore$lzycompute();
        }
        return this.stateStore;
    }

    public StateStoreCheckpointInfo write(Iterator<InternalRow> rows) {
        StateStoreCheckpointInfo stateStoreCheckpointInfo;
        try {
            rows.foreach((Function1 & Serializable)row -> {
                this.writeRow(row);
                return BoxedUnit.UNIT;
            });
            this.stateStore().commit();
            stateStoreCheckpointInfo = this.stateStore().getStateStoreCheckpointInfo();
        }
        finally {
            if (!this.stateStore().hasCommitted()) {
                this.stateStore().abort();
            }
            this.provider().close();
        }
        return stateStoreCheckpointInfo;
    }

    private void writeRow(InternalRow record) {
        Predef$.MODULE$.assert(record.numFields() == 4, (Function0 & Serializable)() -> "Invalid record schema: expected 4 fields (partition_key, key_bytes, value_bytes, column_family_name), got " + record.numFields());
        byte[] keyBytes = record.getBinary(1);
        byte[] valueBytes = record.getBinary(2);
        String colFamilyName = record.getString(3);
        UnsafeRow keyRow = new UnsafeRow(BoxesRunTime.unboxToInt((Object)this.columnFamilyToKeySchemaLenMap().apply((Object)colFamilyName)));
        keyRow.pointTo(keyBytes, keyBytes.length);
        UnsafeRow valueRow = new UnsafeRow(BoxesRunTime.unboxToInt((Object)this.columnFamilyToValueSchemaLenMap().apply((Object)colFamilyName)));
        valueRow.pointTo(valueBytes, valueBytes.length);
        if (((StatePartitionWriterColumnFamilyInfo)this.colFamilyToWriterInfoMap.apply((Object)colFamilyName)).useMultipleValuesPerKey() && this.stateStore().keyExists(keyRow, colFamilyName)) {
            this.stateStore().merge(keyRow, valueRow, colFamilyName);
            return;
        }
        this.stateStore().put(keyRow, valueRow, colFamilyName);
    }

    public static final /* synthetic */ boolean $anonfun$useColumnFamilies$1(String x$1) {
        String string = x$1;
        String string2 = StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ int $anonfun$columnFamilyToKeySchemaLenMap$1(StatePartitionWriterColumnFamilyInfo x$2) {
        return x$2.schema().keySchema().length();
    }

    public static final /* synthetic */ int $anonfun$columnFamilyToValueSchemaLenMap$1(StatePartitionWriterColumnFamilyInfo x$3) {
        return x$3.schema().valueSchema().length();
    }

    public static final /* synthetic */ void $anonfun$stateStore$1(StateStore store$1, Tuple2 pair) {
        String colFamilyName = (String)pair._1();
        StateStoreColFamilySchema cfSchema = ((StatePartitionWriterColumnFamilyInfo)pair._2()).schema();
        String string = colFamilyName;
        String string2 = StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return;
        }
        Predef$.MODULE$.require(cfSchema.keyStateEncoderSpec().isDefined(), (Function0 & Serializable)() -> "keyStateEncoderSpec must be defined for column family " + cfSchema.colFamilyName());
        boolean isInternal = StateStoreColumnFamilySchemaUtils$.MODULE$.isInternalColFamily(colFamilyName);
        store$1.createColFamilyIfAbsent(colFamilyName, cfSchema.keySchema(), cfSchema.valueSchema(), (KeyStateEncoderSpec)cfSchema.keyStateEncoderSpec().get(), ((StatePartitionWriterColumnFamilyInfo)pair._2()).useMultipleValuesPerKey(), isInternal);
    }

    public StatePartitionAllColumnFamiliesWriter(StateStoreConf storeConf, Configuration hadoopConf, int partitionId, String targetCpLocation, long operatorId, String storeName, long currentBatchId, Map<String, StatePartitionWriterColumnFamilyInfo> colFamilyToWriterInfoMap, Option<StateSchemaProvider> schemaProviderOpt) {
        StateStoreColFamilySchema stateStoreColFamilySchema;
        this.storeConf = storeConf;
        this.hadoopConf = hadoopConf;
        this.partitionId = partitionId;
        this.targetCpLocation = targetCpLocation;
        this.operatorId = operatorId;
        this.storeName = storeName;
        this.currentBatchId = currentBatchId;
        this.colFamilyToWriterInfoMap = colFamilyToWriterInfoMap;
        this.schemaProviderOpt = schemaProviderOpt;
        this.useColumnFamilies = colFamilyToWriterInfoMap.keys().toSeq().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StatePartitionAllColumnFamiliesWriter.$anonfun$useColumnFamilies$1(x$1)));
        Option option = colFamilyToWriterInfoMap.get((Object)StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME());
        if (option instanceof Some) {
            Some some = (Some)option;
            StatePartitionWriterColumnFamilyInfo info = (StatePartitionWriterColumnFamilyInfo)some.value();
            stateStoreColFamilySchema = info.schema();
        } else if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.assert(this.useColumnFamilies(), (Function0 & Serializable)() -> "useColumnFamilies should be true when there is no StatePartitionWriterColumnFamilyInfo for DEFAULT column family");
            StateStoreColFamilySchema placeholderSchema = ((StatePartitionWriterColumnFamilyInfo)((Tuple2)colFamilyToWriterInfoMap.head())._2()).schema();
            stateStoreColFamilySchema = new StateStoreColFamilySchema("__dummy__", 0, placeholderSchema.keySchema(), 0, placeholderSchema.valueSchema(), (Option<KeyStateEncoderSpec>)Option$.MODULE$.apply((Object)new NoPrefixKeyStateEncoderSpec(placeholderSchema.keySchema())), StateStoreColFamilySchema$.MODULE$.apply$default$7());
        } else {
            throw new MatchError((Object)option);
        }
        this.defaultSchema = stateStoreColFamilySchema;
        this.columnFamilyToKeySchemaLenMap = colFamilyToWriterInfoMap.view().mapValues((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StatePartitionAllColumnFamiliesWriter.$anonfun$columnFamilyToKeySchemaLenMap$1(x$2)));
        this.columnFamilyToValueSchemaLenMap = colFamilyToWriterInfoMap.view().mapValues((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)StatePartitionAllColumnFamiliesWriter.$anonfun$columnFamilyToValueSchemaLenMap$1(x$3)));
    }
}

