/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.execution.streaming.state.ArrayIndexRange;
import org.apache.spark.sql.execution.streaming.state.KeyValueChecksumEncoder$;
import org.apache.spark.sql.execution.streaming.state.KeyValueIntegrityVerifier;
import org.apache.spark.unsafe.Platform;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class KeyValueChecksumEncoder$ {
    public static final KeyValueChecksumEncoder$ MODULE$ = new KeyValueChecksumEncoder$();

    public byte[] encodeValueRowWithChecksum(byte[] rowBytes, int checksum) {
        byte[] result = new byte[8 + rowBytes.length];
        Platform.putInt((Object)result, (long)Platform.BYTE_ARRAY_OFFSET, (int)checksum);
        Platform.putInt((Object)result, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (int)rowBytes.length);
        Platform.copyMemory((Object)rowBytes, (long)Platform.BYTE_ARRAY_OFFSET, (Object)result, (long)(Platform.BYTE_ARRAY_OFFSET + 8), (long)rowBytes.length);
        return result;
    }

    public byte[] decodeAndVerifyValueRowWithChecksum(Option<KeyValueIntegrityVerifier> verifier, byte[] keyBytes, byte[] valueBytes) {
        int valuesEnd = Platform.BYTE_ARRAY_OFFSET + valueBytes.length;
        int currentPosition = Platform.BYTE_ARRAY_OFFSET;
        int resultSize = 0;
        int numValues = 0;
        while (currentPosition < valuesEnd) {
            int valueRowSize = Platform.getInt((Object)valueBytes, (long)(currentPosition += 4));
            currentPosition += 4 + valueRowSize + 1;
            resultSize += valueRowSize;
            ++numValues;
        }
        byte[] result = new byte[resultSize += numValues - 1];
        int resultPosition = Platform.BYTE_ARRAY_OFFSET;
        ArrayIndexRange keyRowIndex = new ArrayIndexRange(keyBytes, 0, keyBytes.length);
        currentPosition = Platform.BYTE_ARRAY_OFFSET;
        int currentValueCount = 0;
        while (currentPosition < valuesEnd) {
            ++currentValueCount;
            int checksum = Platform.getInt((Object)valueBytes, (long)currentPosition);
            int valueRowSize = Platform.getInt((Object)valueBytes, (long)(currentPosition += 4));
            int from = this.byteOffsetToIndex(currentPosition += 4);
            int until = from + valueRowSize;
            ArrayIndexRange valueRowIndex = new ArrayIndexRange(valueBytes, from, until);
            verifier.foreach((Function1 & Serializable)x$2 -> {
                x$2.verify(keyRowIndex, (Option<ArrayIndexRange<Object>>)new Some((Object)valueRowIndex), checksum);
                return BoxedUnit.UNIT;
            });
            int copyLength = currentValueCount < numValues ? valueRowSize + 1 : valueRowSize;
            Platform.copyMemory((Object)valueBytes, (long)currentPosition, (Object)result, (long)resultPosition, (long)copyLength);
            currentPosition += copyLength;
            resultPosition += copyLength;
        }
        return result;
    }

    public Iterator<ArrayIndexRange<Object>> decodeAndVerifyMultiValueRowWithChecksum(Option<KeyValueIntegrityVerifier> verifier, byte[] keyBytes, byte[] valueBytes) {
        if (valueBytes == null) {
            return Nil$.MODULE$.iterator();
        }
        return new Iterator<ArrayIndexRange<Object>>(keyBytes, valueBytes, verifier){
            private final ArrayIndexRange<Object> keyRowIndex;
            private int position;
            private final int valuesEnd;
            private final byte[] valueBytes$1;
            private final Option verifier$1;

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<ArrayIndexRange<Object>> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<ArrayIndexRange<Object>> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<ArrayIndexRange<Object>> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<ArrayIndexRange<Object>>, Iterator<ArrayIndexRange<Object>>> partition(Function1<ArrayIndexRange<Object>, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, ArrayIndexRange<Object>, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<ArrayIndexRange<Object>, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<ArrayIndexRange<Object>, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<ArrayIndexRange<Object>> filter(Function1<ArrayIndexRange<Object>, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<ArrayIndexRange<Object>> filterNot(Function1<ArrayIndexRange<Object>, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<ArrayIndexRange<Object>> filterImpl(Function1<ArrayIndexRange<Object>, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<ArrayIndexRange<Object>> withFilter(Function1<ArrayIndexRange<Object>, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<ArrayIndexRange<Object>, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<ArrayIndexRange<Object>> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B> Iterator<ArrayIndexRange<Object>> distinctBy(Function1<ArrayIndexRange<Object>, B> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B> Iterator<B> map(Function1<ArrayIndexRange<Object>, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> flatMap(Function1<ArrayIndexRange<Object>, IterableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B> Iterator<B> flatten(Function1<ArrayIndexRange<Object>, IterableOnce<B>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<ArrayIndexRange<Object>> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<ArrayIndexRange<Object>> takeWhile(Function1<ArrayIndexRange<Object>, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<ArrayIndexRange<Object>> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<ArrayIndexRange<Object>> dropWhile(Function1<ArrayIndexRange<Object>, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<ArrayIndexRange<Object>>, Iterator<ArrayIndexRange<Object>>> span(Function1<ArrayIndexRange<Object>, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<ArrayIndexRange<Object>> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<ArrayIndexRange<Object>> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<Tuple2<ArrayIndexRange<Object>, B>> zip(IterableOnce<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<ArrayIndexRange<Object>, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<ArrayIndexRange<Object>>, Iterator<ArrayIndexRange<Object>>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U$> Iterator<ArrayIndexRange<Object>> tapEach(Function1<ArrayIndexRange<Object>, U$> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<ArrayIndexRange<Object>> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<ArrayIndexRange<Object>>, Iterator<ArrayIndexRange<Object>>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U$> void foreach(Function1<ArrayIndexRange<Object>, U$> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<ArrayIndexRange<Object>, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<ArrayIndexRange<Object>, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<ArrayIndexRange<Object>, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<ArrayIndexRange<Object>> find(Function1<ArrayIndexRange<Object>, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B> B foldLeft(B z, Function2<B, ArrayIndexRange<Object>, B> op) {
                return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B> B foldRight(B z, Function2<ArrayIndexRange<Object>, B, B> op) {
                return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B> B $div$colon(B z, Function2<B, ArrayIndexRange<Object>, B> op) {
                return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B> B $colon$bslash(B z, Function2<ArrayIndexRange<Object>, B, B> op) {
                return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, ArrayIndexRange<Object>, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<ArrayIndexRange<Object>, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, ArrayIndexRange<Object>, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<ArrayIndexRange<Object>, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object dest) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest);
            }

            public <B> int copyToArray(Object dest, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start);
            }

            public <B> int copyToArray(Object dest, int start, int n) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)dest, (int)start, (int)n);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<ArrayIndexRange<Object>> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<ArrayIndexRange<Object>> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering ord) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<ArrayIndexRange<Object>> maxByOption(Function1<ArrayIndexRange<Object>, B> f, Ordering<B> ord) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
            }

            public Object minBy(Function1 f, Ordering ord) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B> Option<ArrayIndexRange<Object>> minByOption(Function1<ArrayIndexRange<Object>, B> f, Ordering<B> ord) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
            }

            public <B> Option<B> collectFirst(PartialFunction<ArrayIndexRange<Object>, B> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, ArrayIndexRange<Object>, B> seqop, Function2<B, B, B> combop) {
                return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B> boolean corresponds(IterableOnce<B> that, Function2<ArrayIndexRange<Object>, B, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<ArrayIndexRange<Object>, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<ArrayIndexRange<Object>> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<ArrayIndexRange<Object>> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<ArrayIndexRange<Object>> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> Map<K, V> toMap(.less.colon.less<ArrayIndexRange<Object>, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<ArrayIndexRange<Object>> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<ArrayIndexRange<Object>> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<ArrayIndexRange<Object>> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<ArrayIndexRange<Object>> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S$ extends Stepper<?>> S$ stepper(StepperShape<ArrayIndexRange<Object>, S$> shape) {
                return (S$)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private ArrayIndexRange<Object> keyRowIndex() {
                return this.keyRowIndex;
            }

            private int position() {
                return this.position;
            }

            private void position_$eq(int x$1) {
                this.position = x$1;
            }

            private int valuesEnd() {
                return this.valuesEnd;
            }

            public boolean hasNext() {
                return this.position() < this.valuesEnd();
            }

            public ArrayIndexRange<Object> next() {
                Tuple2<ArrayIndexRange<Object>, Object> tuple2 = KeyValueChecksumEncoder$.MODULE$.org$apache$spark$sql$execution$streaming$state$KeyValueChecksumEncoder$$getValueRowIndexAndChecksum(this.valueBytes$1, this.position());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                ArrayIndexRange valueRowIndex = (ArrayIndexRange)tuple2._1();
                int checksum = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)valueRowIndex, (Object)BoxesRunTime.boxToInteger((int)checksum));
                ArrayIndexRange valueRowIndex2 = (ArrayIndexRange)tuple22._1();
                int checksum2 = tuple22._2$mcI$sp();
                this.verifier$1.foreach((Function1 & Serializable)x$4 -> {
                    anon.1.$anonfun$next$1(this, valueRowIndex2, checksum2, x$4);
                    return BoxedUnit.UNIT;
                });
                this.position_$eq(KeyValueChecksumEncoder$.MODULE$.org$apache$spark$sql$execution$streaming$state$KeyValueChecksumEncoder$$byteIndexToOffset(valueRowIndex2.untilIndex()) + 1);
                return valueRowIndex2;
            }

            public static final /* synthetic */ void $anonfun$next$1(anon.1 $this, ArrayIndexRange valueRowIndex$2, int checksum$2, KeyValueIntegrityVerifier x$4) {
                x$4.verify($this.keyRowIndex(), (Option<ArrayIndexRange<Object>>)new Some((Object)valueRowIndex$2), checksum$2);
            }
            {
                this.valueBytes$1 = valueBytes$1;
                this.verifier$1 = verifier$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.keyRowIndex = new ArrayIndexRange<T>(keyBytes$1, 0, keyBytes$1.length);
                this.position = Platform.BYTE_ARRAY_OFFSET;
                this.valuesEnd = Platform.BYTE_ARRAY_OFFSET + valueBytes$1.length;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$next$1$adapted(org.apache.spark.sql.execution.streaming.state.KeyValueChecksumEncoder$$anon$1 org.apache.spark.sql.execution.streaming.state.ArrayIndexRange int org.apache.spark.sql.execution.streaming.state.KeyValueIntegrityVerifier )}, serializedLambda);
            }
        };
    }

    public Tuple2<ArrayIndexRange<Object>, Object> decodeOneValueRowIndexWithChecksum(byte[] bytes) {
        return this.org$apache$spark$sql$execution$streaming$state$KeyValueChecksumEncoder$$getValueRowIndexAndChecksum(bytes, Platform.BYTE_ARRAY_OFFSET);
    }

    public Tuple2<ArrayIndexRange<Object>, Object> org$apache$spark$sql$execution$streaming$state$KeyValueChecksumEncoder$$getValueRowIndexAndChecksum(byte[] bytes, int startingPosition) {
        int position = startingPosition;
        int checksum = Platform.getInt((Object)bytes, (long)position);
        int rowSize = Platform.getInt((Object)bytes, (long)(position += 4));
        int fromIndex = this.byteOffsetToIndex(position += 4);
        return new Tuple2(new ArrayIndexRange(bytes, fromIndex, fromIndex + rowSize), (Object)BoxesRunTime.boxToInteger((int)checksum));
    }

    public byte[] encodeKeyRowWithChecksum(byte[] rowBytes, int checksum) {
        return this.encodeSingleValueRowWithChecksum(rowBytes, checksum);
    }

    public Tuple2<byte[], Object> decodeKeyRowWithChecksum(byte[] bytes) {
        return this.decodeSingleValueRowWithChecksum(bytes);
    }

    public byte[] decodeAndVerifyKeyRowWithChecksum(Option<KeyValueIntegrityVerifier> verifier, byte[] bytes) {
        Tuple2<byte[], Object> tuple2 = this.decodeKeyRowWithChecksum(bytes);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte[] originalBytes = (byte[])tuple2._1();
        int checksum = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)originalBytes, (Object)BoxesRunTime.boxToInteger((int)checksum));
        byte[] originalBytes2 = (byte[])tuple22._1();
        int checksum2 = tuple22._2$mcI$sp();
        verifier.foreach((Function1 & Serializable)x$6 -> {
            x$6.verify(originalBytes2, (Option<byte[]>)None$.MODULE$, checksum2);
            return BoxedUnit.UNIT;
        });
        return originalBytes2;
    }

    public Tuple2<ArrayIndexRange<Object>, Object> decodeKeyRowIndexWithChecksum(byte[] keyBytes) {
        return this.decodeSingleValueRowIndexWithChecksum(keyBytes);
    }

    public byte[] encodeSingleValueRowWithChecksum(byte[] rowBytes, int checksum) {
        byte[] result = new byte[4 + rowBytes.length];
        Platform.putInt((Object)result, (long)Platform.BYTE_ARRAY_OFFSET, (int)checksum);
        Platform.copyMemory((Object)rowBytes, (long)Platform.BYTE_ARRAY_OFFSET, (Object)result, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (long)rowBytes.length);
        return result;
    }

    public Tuple2<byte[], Object> decodeSingleValueRowWithChecksum(byte[] bytes) {
        int checksum = Platform.getInt((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET);
        byte[] row = new byte[bytes.length - 4];
        Platform.copyMemory((Object)bytes, (long)(Platform.BYTE_ARRAY_OFFSET + 4), (Object)row, (long)Platform.BYTE_ARRAY_OFFSET, (long)row.length);
        return new Tuple2((Object)row, (Object)BoxesRunTime.boxToInteger((int)checksum));
    }

    public byte[] decodeAndVerifySingleValueRowWithChecksum(Option<KeyValueIntegrityVerifier> verifier, byte[] keyBytes, byte[] valueBytes) {
        Tuple2<byte[], Object> tuple2 = this.decodeSingleValueRowWithChecksum(valueBytes);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte[] originalValueBytes = (byte[])tuple2._1();
        int checksum = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)originalValueBytes, (Object)BoxesRunTime.boxToInteger((int)checksum));
        byte[] originalValueBytes2 = (byte[])tuple22._1();
        int checksum2 = tuple22._2$mcI$sp();
        verifier.foreach((Function1 & Serializable)x$8 -> {
            x$8.verify(keyBytes, (Option<byte[]>)new Some((Object)originalValueBytes2), checksum2);
            return BoxedUnit.UNIT;
        });
        return originalValueBytes2;
    }

    public Tuple2<ArrayIndexRange<Object>, Object> decodeSingleValueRowIndexWithChecksum(byte[] bytes) {
        int position = Platform.BYTE_ARRAY_OFFSET;
        int checksum = Platform.getInt((Object)bytes, (long)position);
        int fromIndex = this.byteOffsetToIndex(position += 4);
        return new Tuple2(new ArrayIndexRange(bytes, fromIndex, bytes.length), (Object)BoxesRunTime.boxToInteger((int)checksum));
    }

    private int byteOffsetToIndex(int offset) {
        return offset - Platform.BYTE_ARRAY_OFFSET;
    }

    public int org$apache$spark$sql$execution$streaming$state$KeyValueChecksumEncoder$$byteIndexToOffset(int index) {
        return index + Platform.BYTE_ARRAY_OFFSET;
    }

    private KeyValueChecksumEncoder$() {
    }
}

