/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.execution.streaming.state.AutoSnapshotLoader$;
import org.apache.spark.sql.execution.streaming.state.StateStoreErrors$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005q4Q\u0001E\t\u0002\u0002\u0001B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!AQ\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u0015Q\u0005\u0001\"\u0015L\u0011\u0015a\u0005A\"\u0005N\u0011\u0015\t\u0006A\"\u0005S\u0011\u0015A\u0006A\"\u0005N\u0011\u0015I\u0006A\"\u0005[\u0011\u00151\u0007\u0001\"\u0001h\u000f\u001da\u0017#!A\t\u000254q\u0001E\t\u0002\u0002#\u0005a\u000eC\u0003C\u001b\u0011\u0005q\u000eC\u0004q\u001bE\u0005I\u0011A9\u0003%\u0005+Ho\\*oCB\u001c\bn\u001c;M_\u0006$WM\u001d\u0006\u0003%M\tQa\u001d;bi\u0016T!\u0001F\u000b\u0002\u0013M$(/Z1nS:<'B\u0001\f\u0018\u0003%)\u00070Z2vi&|gN\u0003\u0002\u00193\u0005\u00191/\u001d7\u000b\u0005iY\u0012!B:qCJ\\'B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u001a\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0017*\u0005\u001daunZ4j]\u001e\f\u0011$Y;u_Ns\u0017\r]:i_R\u0014V\r]1je\u0016s\u0017M\u00197fIB\u0011!eL\u0005\u0003a\r\u0012qAQ8pY\u0016\fg.A\u000eok64\u0015-\u001b7ve\u0016\u001c()\u001a4pe\u0016\f5\r^5wCRLgn\u001a\t\u0003EMJ!\u0001N\u0012\u0003\u0007%sG/A\nnCb\u001c\u0005.\u00198hK\u001aKG.\u001a*fa2\f\u00170A\u0005m_\u001e<\u0017N\\4JIB\u0011\u0001h\u0010\b\u0003su\u0002\"AO\u0012\u000e\u0003mR!\u0001P\u0010\u0002\rq\u0012xn\u001c;?\u0013\tq4%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0001\u0006\u0013aa\u0015;sS:<'B\u0001 $\u0003\u0019a\u0014N\\5u}Q)AIR$I\u0013B\u0011Q\tA\u0007\u0002#!)Q&\u0002a\u0001]!)\u0011'\u0002a\u0001e!)Q'\u0002a\u0001e!9a'\u0002I\u0001\u0002\u00049\u0014a\u00027pO:\u000bW.Z\u000b\u0002o\u0005Q!-\u001a4pe\u0016du.\u00193\u0015\u00039\u0003\"AI(\n\u0005A\u001b#\u0001B+oSR\f!\u0004\\8bINs\u0017\r]:i_R4%o\\7DQ\u0016\u001c7\u000e]8j]R$\"AT*\t\u000bQC\u0001\u0019A+\u0002\u001fMt\u0017\r]:i_R4VM]:j_:\u0004\"A\t,\n\u0005]\u001b#\u0001\u0002'p]\u001e\f1e\u001c8M_\u0006$7K\\1qg\"|GO\u0012:p[\u000eCWmY6q_&tGOR1jYV\u0014X-\u0001\u000bhKR,E.[4jE2,7K\\1qg\"|Go\u001d\u000b\u00037\u0012\u00042\u0001X1V\u001d\tivL\u0004\u0002;=&\tA%\u0003\u0002aG\u00059\u0001/Y2lC\u001e,\u0017B\u00012d\u0005\r\u0019V-\u001d\u0006\u0003A\u000eBQ!\u001a\u0006A\u0002U\u000bQB^3sg&|g\u000eV8M_\u0006$\u0017\u0001\u00047pC\u0012\u001cf.\u00199tQ>$HC\u00015l!\u0011\u0011\u0013.\u0016\u0018\n\u0005)\u001c#A\u0002+va2,'\u0007C\u0003f\u0017\u0001\u0007Q+\u0001\nBkR|7K\\1qg\"|G\u000fT8bI\u0016\u0014\bCA#\u000e'\ti\u0011\u0005F\u0001n\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\t!O\u000b\u00028g.\nA\u000f\u0005\u0002vu6\taO\u0003\u0002xq\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003s\u000e\n!\"\u00198o_R\fG/[8o\u0013\tYhOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public abstract class AutoSnapshotLoader
implements Logging {
    private final boolean autoSnapshotRepairEnabled;
    private final int numFailuresBeforeActivating;
    private final int maxChangeFileReplay;
    private final String loggingId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String $lessinit$greater$default$4() {
        return AutoSnapshotLoader$.MODULE$.$lessinit$greater$default$4();
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.logName$((Logging)this) + " " + this.loggingId;
    }

    public abstract void beforeLoad();

    public abstract void loadSnapshotFromCheckpoint(long var1);

    public abstract void onLoadSnapshotFromCheckpointFailure();

    public abstract Seq<Object> getEligibleSnapshots(long var1);

    public Tuple2<Object, Object> loadSnapshot(long versionToLoad) {
        Seq eligibleSnapshots = (Seq)((SeqOps)((SeqOps)this.getEligibleSnapshots(versionToLoad).$colon$plus((Object)BoxesRunTime.boxToLong((long)0L))).distinct()).sorted(package$.MODULE$.Ordering().apply((Ordering)Ordering.Long$.MODULE$).reverse());
        long firstEligibleSnapshot = BoxesRunTime.unboxToLong((Object)eligibleSnapshots.head());
        int maxNumFailures = this.autoSnapshotRepairEnabled ? this.numFailuresBeforeActivating : 1;
        IntRef numFailuresForFirstSnapshot = IntRef.create((int)0);
        ObjectRef lastException = ObjectRef.create(null);
        ObjectRef loadedSnapshot = ObjectRef.create((Object)None$.MODULE$);
        while (((Option)loadedSnapshot.elem).isEmpty() && numFailuresForFirstSnapshot.elem < maxNumFailures) {
            this.beforeLoad();
            try {
                this.loadSnapshotFromCheckpoint(firstEligibleSnapshot);
                loadedSnapshot.elem = new Some((Object)BoxesRunTime.boxToLong((long)firstEligibleSnapshot));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    if (this.autoSnapshotRepairEnabled) {
                        this.onLoadSnapshotFromCheckpointFailure();
                        ++numFailuresForFirstSnapshot.elem;
                        this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load snapshot version "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.VERSION_NUM, BoxesRunTime.boxToLong((long)firstEligibleSnapshot))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"attempt ", " out of "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_RETRY, BoxesRunTime.boxToInteger((int)numFailuresForFirstSnapshot$1.elem))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " attempts"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.NUM_RETRIES, BoxesRunTime.boxToInteger((int)maxNumFailures))})))), e);
                        lastException.elem = e;
                        continue;
                    }
                }
                if (throwable2 != null) {
                    Throwable throwable3 = throwable2;
                    this.onLoadSnapshotFromCheckpointFailure();
                    throw throwable3;
                }
                throw throwable;
            }
        }
        boolean autoRepairCompleted = false;
        if (((Option)loadedSnapshot.elem).isEmpty()) {
            Predef$.MODULE$.assert(this.autoSnapshotRepairEnabled);
            Seq remainingEligibleSnapshots = eligibleSnapshots.length() > 1 ? (Seq)eligibleSnapshots.tail() : (Seq)package$.MODULE$.Seq().empty();
            Seq selectedRemainingSnapshots = (Seq)remainingEligibleSnapshots.filter((Function1)(JFunction1.mcZJ.sp & Serializable)s -> versionToLoad - s <= (long)$this.maxChangeFileReplay);
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to auto repair snapshot by skipping "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"snapshot version ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.VERSION_NUM, BoxesRunTime.boxToLong((long)firstEligibleSnapshot))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"and trying to load with one of the selected snapshots "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ", out of eligible snapshots "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.VERSION_NUM, selectedRemainingSnapshots)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ". "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.VERSION_NUM, remainingEligibleSnapshots)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"maxChangeFileReplay: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.VERSION_NUM, BoxesRunTime.boxToInteger((int)$this.maxChangeFileReplay))})))));
            selectedRemainingSnapshots.withFilter((Function1)(JFunction1.mcZJ.sp & Serializable)snapshotVersion -> ((Option)loadedSnapshot$1.elem).isEmpty()).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)snapshotVersion -> {
                this.beforeLoad();
                try {
                    this.loadSnapshotFromCheckpoint(snapshotVersion);
                    loadedSnapshot$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)snapshotVersion));
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully loaded snapshot version "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ". Repair complete."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.VERSION_NUM, BoxesRunTime.boxToLong((long)snapshotVersion))})))));
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load snapshot version "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ", will retry repair with "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.VERSION_NUM, BoxesRunTime.boxToLong((long)snapshotVersion))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"the next eligible snapshot version"}))).log((Seq)Nil$.MODULE$))), throwable2);
                        this.onLoadSnapshotFromCheckpointFailure();
                        lastException$1.elem = throwable2;
                    }
                    throw throwable;
                }
            });
            if (((Option)loadedSnapshot.elem).isEmpty()) {
                this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Auto snapshot repair failed to load any snapshot:"}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" latestSnapshotVersion: ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.VERSION_NUM, BoxesRunTime.boxToLong((long)firstEligibleSnapshot))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"attemptedSnapshots: ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.VERSION_NUM, selectedRemainingSnapshots)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"eligibleSnapshots:  ", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.VERSION_NUM, remainingEligibleSnapshots)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"maxChangeFileReplay: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.VERSION_NUM, BoxesRunTime.boxToInteger((int)$this.maxChangeFileReplay))})))), (Throwable)lastException.elem);
                throw StateStoreErrors$.MODULE$.autoSnapshotRepairFailed(this.loggingId, firstEligibleSnapshot, (Seq<Object>)selectedRemainingSnapshots, (Seq<Object>)remainingEligibleSnapshots, (Throwable)lastException.elem);
            }
            autoRepairCompleted = true;
        }
        return new Tuple2.mcJZ.sp(BoxesRunTime.unboxToLong((Object)((Option)loadedSnapshot.elem).get()), autoRepairCompleted);
    }

    public AutoSnapshotLoader(boolean autoSnapshotRepairEnabled, int numFailuresBeforeActivating, int maxChangeFileReplay, String loggingId) {
        this.autoSnapshotRepairEnabled = autoSnapshotRepairEnabled;
        this.numFailuresBeforeActivating = numFailuresBeforeActivating;
        this.maxChangeFileReplay = maxChangeFileReplay;
        this.loggingId = loggingId;
        Logging.$init$((Logging)this);
    }
}

