/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.metric;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.execution.metric.CustomMetrics$;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetric$;
import org.apache.spark.sql.execution.ui.SparkListenerDriverAccumUpdates;
import org.apache.spark.util.AccumulatorContext$;
import org.sparkproject.guava.cache.CacheBuilder;
import org.sparkproject.guava.cache.CacheLoader;
import org.sparkproject.guava.cache.LoadingCache;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class SQLMetrics$ {
    public static final SQLMetrics$ MODULE$ = new SQLMetrics$();
    private static final String SUM_METRIC = "sum";
    private static final String SIZE_METRIC = "size";
    private static final String TIMING_METRIC = "timing";
    private static final String NS_TIMING_METRIC = "nsTiming";
    private static final String AVERAGE_METRIC = "average";
    private static final int baseForAvgMetric = 10;
    private static final Some<String> cachedSQLAccumIdentifier = new Some((Object)AccumulatorContext$.MODULE$.SQL_ACCUM_IDENTIFIER());
    private static final LoadingCache<String, Option<String>> metricsCache = CacheBuilder.newBuilder().maximumSize(10000L).build((CacheLoader)new CacheLoader<String, Option<String>>(){

        public Option<String> load(String name) {
            return Option$.MODULE$.apply((Object)name);
        }
    });

    private String SUM_METRIC() {
        return SUM_METRIC;
    }

    private String SIZE_METRIC() {
        return SIZE_METRIC;
    }

    private String TIMING_METRIC() {
        return TIMING_METRIC;
    }

    private String NS_TIMING_METRIC() {
        return NS_TIMING_METRIC;
    }

    private String AVERAGE_METRIC() {
        return AVERAGE_METRIC;
    }

    private int baseForAvgMetric() {
        return baseForAvgMetric;
    }

    public Some<String> cachedSQLAccumIdentifier() {
        return cachedSQLAccumIdentifier;
    }

    private LoadingCache<String, Option<String>> metricsCache() {
        return metricsCache;
    }

    public void setDoubleForAverageMetrics(SQLMetric metric, double v) {
        String string = metric.metricType();
        String string2 = this.AVERAGE_METRIC();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0 & Serializable)() -> "Can't set a double to a metric of metrics type: " + metric.metricType());
        metric.set((long)(v * (double)this.baseForAvgMetric()));
    }

    public SQLMetric createMetric(SparkContext sc, String name) {
        SQLMetric acc = new SQLMetric(this.SUM_METRIC(), SQLMetric$.MODULE$.$lessinit$greater$default$2());
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return acc;
    }

    public SQLMetric createV2CustomMetric(SparkContext sc, CustomMetric customMetric) {
        SQLMetric acc = new SQLMetric(CustomMetrics$.MODULE$.buildV2CustomMetricTypeName(customMetric), SQLMetric$.MODULE$.$lessinit$greater$default$2());
        acc.register(sc, (Option)this.metricsCache().get((Object)customMetric.description()), false);
        return acc;
    }

    public SQLMetric createSizeMetric(SparkContext sc, String name, long initValue) {
        SQLMetric acc = new SQLMetric(this.SIZE_METRIC(), initValue);
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return acc;
    }

    public long createSizeMetric$default$3() {
        return -1L;
    }

    public SQLMetric createTimingMetric(SparkContext sc, String name, long initValue) {
        SQLMetric acc = new SQLMetric(this.TIMING_METRIC(), initValue);
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return acc;
    }

    public long createTimingMetric$default$3() {
        return -1L;
    }

    public SQLMetric createNanoTimingMetric(SparkContext sc, String name, long initValue) {
        SQLMetric acc = new SQLMetric(this.NS_TIMING_METRIC(), initValue);
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return acc;
    }

    public long createNanoTimingMetric$default$3() {
        return -1L;
    }

    public SQLMetric createAverageMetric(SparkContext sc, String name) {
        SQLMetric acc = new SQLMetric(this.AVERAGE_METRIC(), SQLMetric$.MODULE$.$lessinit$greater$default$2());
        acc.register(sc, (Option)this.metricsCache().get((Object)name), false);
        return acc;
    }

    public void postDriverMetricsUpdatedByValue(SparkContext sc, String executionId, Seq<Tuple2<Object, Object>> accumUpdates) {
        if (executionId != null) {
            sc.listenerBus().post((SparkListenerEvent)new SparkListenerDriverAccumUpdates(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(executionId)), accumUpdates));
            return;
        }
    }

    public void postDriverMetricUpdates(SparkContext sc, String executionId, Seq<SQLMetric> metrics) {
        if (executionId != null) {
            sc.listenerBus().post((SparkListenerEvent)new SparkListenerDriverAccumUpdates(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(executionId)), (Seq<Tuple2<Object, Object>>)((Seq)metrics.map((Function1 & Serializable)m -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)m.id())), (Object)BoxesRunTime.boxToLong((long)m.value()))))));
            return;
        }
    }

    public <T> T withTimingNs(SQLMetric metric, Function0<T> f) {
        long startTime = System.nanoTime();
        Object result = f.apply();
        long endTime = System.nanoTime();
        metric.add(endTime - startTime);
        return (T)result;
    }

    private SQLMetrics$() {
    }
}

