/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util.geo;

import java.util.List;
import org.apache.spark.sql.catalyst.util.geo.GeoTypeId;
import org.apache.spark.sql.catalyst.util.geo.GeometryModel;
import org.apache.spark.sql.catalyst.util.geo.Ring;

class Polygon
extends GeometryModel {
    private final List<Ring> rings;

    Polygon(List<Ring> rings, int srid, boolean hasZ, boolean hasM) {
        super(GeoTypeId.POLYGON, srid, hasZ, hasM);
        this.rings = rings;
    }

    List<Ring> getRings() {
        return this.rings;
    }

    Ring getExteriorRing() {
        return this.rings.isEmpty() ? null : this.rings.get(0);
    }

    int getNumInteriorRings() {
        return Math.max(0, this.rings.size() - 1);
    }

    Ring getInteriorRingN(int n) {
        return this.rings.get(n + 1);
    }

    @Override
    boolean isEmpty() {
        return this.rings.isEmpty() || this.rings.stream().allMatch(Ring::isEmpty);
    }

    @Override
    int getDimensionCount() {
        return 2 + (this.hasZ ? 1 : 0) + (this.hasM ? 1 : 0);
    }
}

