/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.st;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.expressions.st.ExpressionDefaults$;
import org.apache.spark.sql.catalyst.expressions.st.GeospatialInputTypes;
import org.apache.spark.sql.catalyst.expressions.st.STExpressionUtils$;
import org.apache.spark.sql.catalyst.expressions.st.ST_GeomFromWKB$;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.STUtils;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.GeometryType;
import org.apache.spark.sql.types.IntegerType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(wkb[, srid]) - Parses the WKB description of a geometry and returns the corresponding GEOMETRY value.", arguments="\n    Arguments:\n      * wkb - A BINARY value in WKB format, representing a GEOMETRY value.\n      * srid - The optional SRID value of the geometry. Default is 0.\n  ", examples="\n    Examples:\n      > SELECT hex(st_asbinary(_FUNC_(X'0101000000000000000000F03F0000000000000040')));\n       0101000000000000000000F03F0000000000000040\n      > SELECT st_srid(_FUNC_(X'0101000000000000000000F03F0000000000000040'));\n       0\n      > SELECT hex(st_asbinary(_FUNC_(X'0101000000000000000000F03F0000000000000040', 4326)));\n       0101000000000000000000F03F0000000000000040\n      > SELECT st_srid(_FUNC_(X'0101000000000000000000F03F0000000000000040', 4326));\n       4326\n  ", since="4.1.0", group="st_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mg\u0001\u0002\u0010 \u0001:B\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t)\u0002\u0011\t\u0012)A\u0005_!AQ\u000b\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005W\u0001\tE\t\u0015!\u00030\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u00159\u0006\u0001\"\u0001]\u0011\u0015q\u0006\u0001\"\u0011`\u0011!I\u0007\u0001#b\u0001\n\u0003\u001a\u0006\"\u00026\u0001\t\u0003Z\u0007\"\u0002;\u0001\t\u0003\u001a\u0006\"B;\u0001\t\u0003\u001a\u0006\"\u0002<\u0001\t#:\bb\u0002?\u0001\u0003\u0003%\t! \u0005\n\u0003\u0003\u0001\u0011\u0013!C\u0001\u0003\u0007A\u0011\"!\u0007\u0001#\u0003%\t!a\u0001\t\u0013\u0005m\u0001!!A\u0005B\u0005u\u0001\"CA\u0017\u0001\u0005\u0005I\u0011AA\u0018\u0011%\t9\u0004AA\u0001\n\u0003\tI\u0004C\u0005\u0002F\u0001\t\t\u0011\"\u0011\u0002H!I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0011q\u000b\u0005\n\u0003C\u0002\u0011\u0011!C!\u0003GB\u0011\"a\u001a\u0001\u0003\u0003%\t%!\u001b\b\u0013\u0005Mu$!A\t\u0002\u0005Ue\u0001\u0003\u0010 \u0003\u0003E\t!a&\t\r]CB\u0011AAX\u0011%\t\t\fGA\u0001\n\u000b\n\u0019\fC\u0005\u00026b\t\t\u0011\"!\u00028\"I\u0011Q\u0018\r\u0002\u0002\u0013\u0005\u0015q\u0018\u0005\n\u0003#D\u0012\u0011!C\u0005\u0003'\u0014ab\u0015+`\u000f\u0016|WN\u0012:p[^[%I\u0003\u0002!C\u0005\u00111\u000f\u001e\u0006\u0003E\r\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011A%J\u0001\tG\u0006$\u0018\r\\=ti*\u0011aeJ\u0001\u0004gFd'B\u0001\u0015*\u0003\u0015\u0019\b/\u0019:l\u0015\tQ3&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Y\u0005\u0019qN]4\u0004\u0001M9\u0001aL\u001a7u\u00013\u0005C\u0001\u00192\u001b\u0005\t\u0013B\u0001\u001a\"\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003aQJ!!N\u0011\u0003%I+h\u000e^5nKJ+\u0007\u000f\\1dK\u0006\u0014G.\u001a\t\u0003oaj\u0011aH\u0005\u0003s}\u0011AcR3pgB\fG/[1m\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bcA\u001e?_5\tAH\u0003\u0002>G\u0005)AO]3fg&\u0011q\b\u0010\u0002\u000b\u0005&t\u0017M]=MS.,\u0007CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%a\u0002)s_\u0012,8\r\u001e\t\u0003\u000f>s!\u0001S'\u000f\u0005%cU\"\u0001&\u000b\u0005-k\u0013A\u0002\u001fs_>$h(C\u0001D\u0013\tq%)A\u0004qC\u000e\\\u0017mZ3\n\u0005A\u000b&\u0001D*fe&\fG.\u001b>bE2,'B\u0001(C\u0003\r98NY\u000b\u0002_\u0005!qo\u001b2!\u0003\u0011\u0019(/\u001b3\u0002\u000bM\u0014\u0018\u000e\u001a\u0011\u0002\rqJg.\u001b;?)\rI&l\u0017\t\u0003o\u0001AQAU\u0003A\u0002=BQ!V\u0003A\u0002=\"\"!W/\t\u000bI3\u0001\u0019A\u0018\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001a!\r9\u0015mY\u0005\u0003EF\u00131aU3r!\t!w-D\u0001f\u0015\t1W%A\u0003usB,7/\u0003\u0002iK\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\fe\u0016\u0004H.Y2f[\u0016tG/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012\u0001\u001c\t\u0003[Ft!A\\8\u0011\u0005%\u0013\u0015B\u00019C\u0003\u0019\u0001&/\u001a3fM&\u0011!o\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A\u0014\u0015\u0001\u00027fMR\fQA]5hQR\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u0007eC(\u0010C\u0003z\u0019\u0001\u0007q&A\u0004oK^dUM\u001a;\t\u000bmd\u0001\u0019A\u0018\u0002\u00119,wOU5hQR\fAaY8qsR\u0019\u0011L`@\t\u000fIk\u0001\u0013!a\u0001_!9Q+\u0004I\u0001\u0002\u0004y\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000bQ3aLA\u0004W\t\tI\u0001\u0005\u0003\u0002\f\u0005UQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u0013Ut7\r[3dW\u0016$'bAA\n\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005]\u0011Q\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005}\u0001\u0003BA\u0011\u0003Wi!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\u0005Y\u0006twM\u0003\u0002\u0002*\u0005!!.\u0019<b\u0013\r\u0011\u00181E\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003c\u00012!QA\u001a\u0013\r\t)D\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003w\t\t\u0005E\u0002B\u0003{I1!a\u0010C\u0005\r\te.\u001f\u0005\n\u0003\u0007\u0012\u0012\u0011!a\u0001\u0003c\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA%!\u0019\tY%!\u0015\u0002<5\u0011\u0011Q\n\u0006\u0004\u0003\u001f\u0012\u0015AC2pY2,7\r^5p]&!\u00111KA'\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005e\u0013q\f\t\u0004\u0003\u0006m\u0013bAA/\u0005\n9!i\\8mK\u0006t\u0007\"CA\")\u0005\u0005\t\u0019AA\u001e\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005}\u0011Q\r\u0005\n\u0003\u0007*\u0012\u0011!a\u0001\u0003c\ta!Z9vC2\u001cH\u0003BA-\u0003WB\u0011\"a\u0011\u0017\u0003\u0003\u0005\r!a\u000f)/\u0001\ty'!\u001e\u0002x\u0005m\u0014QPAA\u0003\u0007\u000b9)!#\u0002\u000e\u0006=\u0005c\u0001\u0019\u0002r%\u0019\u00111O\u0011\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011P\u0001m?\u001a+fjQ0)o.\u00147\f\f\u0011te&$W,\u000b\u0011.AA\u000b'o]3tAQDW\rI,L\u0005\u0002\"Wm]2sSB$\u0018n\u001c8!_\u001a\u0004\u0013\rI4f_6,GO]=!C:$\u0007E]3ukJt7\u000f\t;iK\u0002\u001awN\u001d:fgB|g\u000eZ5oO\u0002:UiT'F)JK\u0006E^1mk\u0016t\u0013!C1sOVlWM\u001c;tC\t\ty(AA$\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002so\u001b2![\u0001\n\u0005EQ%O\u0003JK\u0006E^1mk\u0016\u0004\u0013N\u001c\u0011X\u0017\n\u0003cm\u001c:nCRd\u0003E]3qe\u0016\u001cXM\u001c;j]\u001e\u0004\u0013\rI$F\u001f6+EKU-!m\u0006dW/\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM\u0014\u0018\u000e\u001a\u0011.AQCW\rI8qi&|g.\u00197!'JKE\t\t<bYV,\u0007e\u001c4!i\",\u0007eZ3p[\u0016$(/\u001f\u0018!\t\u00164\u0017-\u001e7uA%\u001c\b\u0005\r\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u000b\u000b1\u0011\u001a\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!Q\u0016D\bf\u001d;`CN\u0014\u0017N\\1ss\"zf)\u0016(D?\"Bv\u0005M\u00191cA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r$1g\u0019\u0003\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\"\u0004gJ\u0015*SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003'\r\u00192aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004G\u0012\u00194\rB\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aQ\u0002$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI:u?N\u0014\u0018\u000e\u001a\u0015`\rVs5i\u0018\u0015YOA\n\u0004'\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA2\u0005g\r$1aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00195a\u001dJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00111\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002BW\r\u001f\u0015ti~\u000b7OY5oCJL\bf\u0018$V\u001d\u000e{\u0006\u0006W\u00141cA\n\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191\rB\u001ad\t\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\u000e\u0019(Y\u0001\"4G\r\u001c*S%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005M\u00191cA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r$1g\u0019\u0003\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\"\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011ti~\u001b(/\u001b3)?\u001a+fjQ0)1\u001e\u0002\u0014\u0007M\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191aA\u0002d\tM\u001aGaA\u0002\u0004\u0007\r\u00191aA\u0002\u0004\u0007\r\u00191iA:C\u0006\t\u001b4eYJ\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00115gI2$\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005-\u0015!\u0002\u001b/c9\u0002\u0014!B4s_V\u0004\u0018EAAI\u0003!\u0019Ho\u00184v]\u000e\u001c\u0018AD*U?\u001e+w.\u001c$s_6<6J\u0011\t\u0003oa\u0019R\u0001GAM\u0003K\u0003r!a'\u0002\">z\u0013,\u0004\u0002\u0002\u001e*\u0019\u0011q\u0014\"\u0002\u000fI,h\u000e^5nK&!\u00111UAO\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\t\u0005\u0003O\u000bi+\u0004\u0002\u0002**!\u00111VA\u0014\u0003\tIw.C\u0002Q\u0003S#\"!!&\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000be\u000bI,a/\t\u000bI[\u0002\u0019A\u0018\t\u000bU[\u0002\u0019A\u0018\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011YAg!\u0015\t\u00151YAd\u0013\r\t)M\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b\u0005\u000bImL\u0018\n\u0007\u0005-'I\u0001\u0004UkBdWM\r\u0005\t\u0003\u001fd\u0012\u0011!a\u00013\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\u0005U\u0007\u0003BA\u0011\u0003/LA!!7\u0002$\t1qJ\u00196fGR\u0004")
public class ST_GeomFromWKB
extends Expression
implements RuntimeReplaceable,
GeospatialInputTypes,
BinaryLike<Expression>,
Serializable {
    private Expression replacement;
    private final Expression wkb;
    private final Expression srid;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ST_GeomFromWKB x$0) {
        return ST_GeomFromWKB$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ST_GeomFromWKB> tupled() {
        return ST_GeomFromWKB$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ST_GeomFromWKB>> curried() {
        return ST_GeomFromWKB$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$st$GeospatialInputTypes$$super$checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return GeospatialInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private Seq<Expression> children$lzycompute() {
        ST_GeomFromWKB sT_GeomFromWKB = this;
        synchronized (sT_GeomFromWKB) {
            if (!this.bitmap$trans$0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        ST_GeomFromWKB sT_GeomFromWKB = this;
        synchronized (sT_GeomFromWKB) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression wkb() {
        return this.wkb;
    }

    public Expression srid() {
        return this.srid;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    private Expression replacement$lzycompute() {
        ST_GeomFromWKB sT_GeomFromWKB = this;
        synchronized (sT_GeomFromWKB) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Class<STUtils> x$1 = STUtils.class;
                GeometryType x$2 = STExpressionUtils$.MODULE$.geometryTypeWithSrid(this.srid());
                String x$3 = "stGeomFromWKB";
                .colon.colon x$4 = new .colon.colon((Object)this.wkb(), (List)new .colon.colon((Object)this.srid(), (List)Nil$.MODULE$));
                boolean x$5 = false;
                Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
                boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
                boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
                Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
                this.replacement = new StaticInvoke(STUtils.class, (DataType)x$2, "stGeomFromWKB", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "st_geomfromwkb";
    }

    @Override
    public Expression left() {
        return this.wkb();
    }

    @Override
    public Expression right() {
        return this.srid();
    }

    @Override
    public ST_GeomFromWKB withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ST_GeomFromWKB copy(Expression wkb, Expression srid) {
        return new ST_GeomFromWKB(wkb, srid);
    }

    public Expression copy$default$1() {
        return this.wkb();
    }

    public Expression copy$default$2() {
        return this.srid();
    }

    @Override
    public String productPrefix() {
        return "ST_GeomFromWKB";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.wkb();
            }
            case 1: {
                return this.srid();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ST_GeomFromWKB;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "wkb";
            }
            case 1: {
                return "srid";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ST_GeomFromWKB)) return false;
        boolean bl = true;
        if (!bl) return false;
        ST_GeomFromWKB sT_GeomFromWKB = (ST_GeomFromWKB)x$1;
        Expression expression = this.wkb();
        Expression expression2 = sT_GeomFromWKB.wkb();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.srid();
        Expression expression4 = sT_GeomFromWKB.srid();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sT_GeomFromWKB.canEqual(this)) return false;
        return true;
    }

    public ST_GeomFromWKB(Expression wkb, Expression srid) {
        this.wkb = wkb;
        this.srid = srid;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        GeospatialInputTypes.$init$(this);
        BinaryLike.$init$(this);
        Statics.releaseFence();
    }

    public ST_GeomFromWKB(Expression wkb) {
        this(wkb, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ExpressionDefaults$.MODULE$.DEFAULT_GEOMETRY_SRID())));
    }
}

