/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.SqlScriptingContextManager$;
import org.apache.spark.sql.catalyst.catalog.SqlScriptingExecutionContextExtension;
import org.apache.spark.sql.catalyst.expressions.CursorDefinition;
import org.apache.spark.sql.catalyst.expressions.CursorReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnresolvedCursor;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.TreePatternBits;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Y2A\u0001B\u0003\u0001%!)\u0011\u0005\u0001C\u0001E!)Q\u0005\u0001C!M!)\u0011\u0006\u0001C\u0005U\tq!+Z:pYZ,7)\u001e:t_J\u001c(B\u0001\u0004\b\u0003!\tg.\u00197zg&\u001c(B\u0001\u0005\n\u0003!\u0019\u0017\r^1msN$(B\u0001\u0006\f\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00195\tQa\u001d9be.T!AD\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0012aA8sO\u000e\u00011C\u0001\u0001\u0014!\r!r#G\u0007\u0002+)\u0011acB\u0001\u0006eVdWm]\u0005\u00031U\u0011AAU;mKB\u0011!dH\u0007\u00027)\u0011A$H\u0001\bY><\u0017nY1m\u0015\tqr!A\u0003qY\u0006t7/\u0003\u0002!7\tYAj\\4jG\u0006d\u0007\u000b\\1o\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\tQ!A\u0003baBd\u0017\u0010\u0006\u0002\u001aO!)\u0001F\u0001a\u00013\u0005!\u0001\u000f\\1o\u00035\u0011Xm]8mm\u0016\u001cUO]:peR\u00111&\r\t\u0003Y=j\u0011!\f\u0006\u0003]\u001d\t1\"\u001a=qe\u0016\u001c8/[8og&\u0011\u0001'\f\u0002\u0010\u0007V\u00148o\u001c:SK\u001a,'/\u001a8dK\")!g\u0001a\u0001g\u0005\u0011Qo\u0019\t\u0003YQJ!!N\u0017\u0003!Us'/Z:pYZ,GmQ;sg>\u0014\b")
public class ResolveCursors
extends Rule<LogicalPlan> {
    @Override
    public LogicalPlan apply(LogicalPlan plan2) {
        return plan2.resolveExpressionsWithPruning((Function1<TreePatternBits, Object>)(Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.containsPattern(TreePattern$.MODULE$.UNRESOLVED_CURSOR())), plan2.resolveExpressionsWithPruning$default$2(), (PartialFunction<Expression, Expression>)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ ResolveCursors $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof UnresolvedCursor) {
                    UnresolvedCursor unresolvedCursor = (UnresolvedCursor)A1;
                    return (B1)this.$outer.org$apache$spark$sql$catalyst$analysis$ResolveCursors$$resolveCursor(unresolvedCursor);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                return expression instanceof UnresolvedCursor;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public CursorReference org$apache$spark$sql$catalyst$analysis$ResolveCursors$$resolveCursor(UnresolvedCursor uc) {
        Option<CursorDefinition> cursorDef;
        Option<CursorDefinition> option;
        Tuple2 tuple2;
        Seq<String> nameParts = uc.nameParts();
        boolean caseSensitive = SQLConf$.MODULE$.get().caseSensitiveAnalysis();
        Predef$.MODULE$.assert(nameParts.length() <= 2, (Function0 & Serializable)() -> "Cursor reference has too many parts: " + nameParts.mkString("."));
        Tuple2 tuple22 = tuple2 = nameParts.length() == 2 ? new Tuple2((Object)new Some(nameParts.head()), nameParts.last()) : new Tuple2((Object)None$.MODULE$, nameParts.head());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option scopeLabel = (Option)tuple2._1();
        String cursorName = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)scopeLabel, (Object)cursorName);
        Option scopeLabel2 = (Option)tuple23._1();
        String cursorName2 = (String)tuple23._2();
        String normalizedName = caseSensitive ? cursorName2 : cursorName2.toLowerCase(Locale.ROOT);
        Option normalizedScopeLabel = scopeLabel2.map((Function1 & Serializable)label -> {
            if (caseSensitive) {
                return label;
            }
            return label.toLowerCase(Locale.ROOT);
        });
        SqlScriptingExecutionContextExtension context = (SqlScriptingExecutionContextExtension)SqlScriptingContextManager$.MODULE$.get().map((Function1 & Serializable)x$3 -> x$3.getContext()).getOrElse((Function0 & Serializable)() -> {
            throw new AnalysisException("CURSOR_OUTSIDE_SCRIPT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cursorName"), (Object)nameParts.mkString("."))})));
        });
        Option option2 = normalizedScopeLabel;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String label2 = (String)some.value();
            option = context.findCursorInScope(label2, normalizedName);
        } else if (None$.MODULE$.equals(option2)) {
            option = context.findCursorByName(normalizedName);
        } else {
            throw new MatchError((Object)option2);
        }
        Option<CursorDefinition> option3 = cursorDef = option;
        if (option3 instanceof Some) {
            Some some = (Some)option3;
            CursorDefinition definition = (CursorDefinition)some.value();
            return new CursorReference(nameParts, normalizedName, (Option<String>)normalizedScopeLabel, definition);
        }
        if (None$.MODULE$.equals(option3)) {
            throw new AnalysisException("CURSOR_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cursorName"), (Object)nameParts.mkString("."))})));
        }
        throw new MatchError(option3);
    }
}

