/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.vector;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedColumnReader;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorizedStructColumnReader
implements VectorizedColumnReader {
    private final List<VectorizedColumnReader> fieldReaders;

    public VectorizedStructColumnReader(List<VectorizedColumnReader> fieldReaders) {
        this.fieldReaders = fieldReaders;
    }

    @Override
    public void readBatch(int total, ColumnVector column, TypeInfo columnType) throws IOException {
        StructColumnVector structColumnVector = (StructColumnVector)column;
        StructTypeInfo structTypeInfo = (StructTypeInfo)columnType;
        ColumnVector[] vectors = structColumnVector.fields;
        for (int i = 0; i < vectors.length; ++i) {
            this.fieldReaders.get(i).readBatch(total, vectors[i], (TypeInfo)structTypeInfo.getAllStructFieldTypeInfos().get(i));
            structColumnVector.isRepeating = structColumnVector.isRepeating && vectors[i].isRepeating;
            for (int j = 0; j < vectors[i].isNull.length; ++j) {
                structColumnVector.isNull[j] = i == 0 ? vectors[i].isNull[j] : structColumnVector.isNull[j] && vectors[i].isNull[j];
            }
            structColumnVector.noNulls = i == 0 ? vectors[i].noNulls : structColumnVector.noNulls && vectors[i].noNulls;
        }
    }
}

