/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTableResult;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinInnerBigOnlyGenerateResultOperator
extends VectorMapJoinGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorMapJoinInnerBigOnlyGenerateResultOperator.class.getName());
    protected transient VectorMapJoinHashMultiSetResult[] hashMultiSetResults;
    protected transient int[] allMatchs;
    protected transient long[] equalKeySeriesValueCounts;
    protected transient int[] equalKeySeriesAllMatchIndices;
    protected transient int[] equalKeySeriesDuplicateCounts;
    protected transient int[] spills;
    protected transient int[] spillHashMapResultIndices;

    protected VectorMapJoinInnerBigOnlyGenerateResultOperator() {
    }

    public VectorMapJoinInnerBigOnlyGenerateResultOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinInnerBigOnlyGenerateResultOperator(CompilationOpContext ctx, VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(ctx, vContext, conf);
    }

    @Override
    protected void commonSetup(VectorizedRowBatch batch) throws HiveException {
        super.commonSetup(batch);
        VectorMapJoinHashMultiSet baseHashMultiSet = (VectorMapJoinHashMultiSet)this.vectorMapJoinHashTable;
        this.hashMultiSetResults = new VectorMapJoinHashMultiSetResult[1024];
        for (int i = 0; i < this.hashMultiSetResults.length; ++i) {
            this.hashMultiSetResults[i] = baseHashMultiSet.createHashMultiSetResult();
        }
        this.allMatchs = new int[1024];
        this.equalKeySeriesValueCounts = new long[1024];
        this.equalKeySeriesAllMatchIndices = new int[1024];
        this.equalKeySeriesDuplicateCounts = new int[1024];
        this.spills = new int[1024];
        this.spillHashMapResultIndices = new int[1024];
    }

    protected void finishInnerBigOnly(VectorizedRowBatch batch, int allMatchCount, int equalKeySeriesCount, int spillCount, VectorMapJoinHashTableResult[] hashTableResults, int hashMapResultCount) throws HiveException, IOException {
        if (spillCount > 0) {
            this.spillHashMapBatch(batch, hashTableResults, this.spills, this.spillHashMapResultIndices, spillCount);
        }
        if (allMatchCount > 0 && this.bigTableValueExpressions != null) {
            this.performValueExpressions(batch, this.allMatchs, allMatchCount);
        }
        int numSel = 0;
        for (int i = 0; i < equalKeySeriesCount; ++i) {
            long count = this.equalKeySeriesValueCounts[i];
            int allMatchesIndex = this.equalKeySeriesAllMatchIndices[i];
            int duplicateCount = this.equalKeySeriesDuplicateCounts[i];
            if (count == 1L) {
                numSel = this.generateHashMultiSetResultSingleValue(batch, this.allMatchs, allMatchesIndex, duplicateCount, numSel);
                continue;
            }
            this.generateHashMultiSetResultMultiValue(batch, this.allMatchs, allMatchesIndex, duplicateCount, count);
        }
        batch.size = numSel;
        batch.selectedInUse = true;
    }

    private int generateHashMultiSetResultSingleValue(VectorizedRowBatch batch, int[] allMatchs, int allMatchesIndex, int duplicateCount, int numSel) throws HiveException, IOException {
        for (int i = 0; i < duplicateCount; ++i) {
            int batchIndex = allMatchs[allMatchesIndex + i];
            batch.selected[numSel++] = batchIndex;
        }
        return numSel;
    }

    private void generateHashMultiSetResultMultiValue(VectorizedRowBatch batch, int[] allMatchs, int allMatchesIndex, int duplicateCount, long count) throws HiveException, IOException {
        for (int i = 0; i < duplicateCount; ++i) {
            int batchIndex = allMatchs[allMatchesIndex + i];
            for (long l = 0L; l < count; ++l) {
                if (this.bigTableRetainedVectorCopy != null) {
                    this.bigTableRetainedVectorCopy.copyByValue(batch, batchIndex, this.overflowBatch, this.overflowBatch.size);
                }
                ++this.overflowBatch.size;
                if (this.overflowBatch.size != 1024) continue;
                this.forwardOverflow();
            }
        }
    }

    protected int generateHashMultiSetResultRepeatedAll(VectorizedRowBatch batch, VectorMapJoinHashMultiSetResult hashMultiSetResult) throws HiveException {
        long count = hashMultiSetResult.count();
        if (!batch.selectedInUse) {
            int[] selected = batch.selected;
            for (int i = 0; i < batch.size; ++i) {
                selected[i] = i;
            }
            batch.selectedInUse = true;
        }
        do {
            this.forwardBigTableBatch(batch);
        } while (--count > 0L);
        return 0;
    }

    protected void finishInnerBigOnlyRepeated(VectorizedRowBatch batch, JoinUtil.JoinResult joinResult, VectorMapJoinHashMultiSetResult hashMultiSetResult) throws HiveException, IOException {
        switch (joinResult) {
            case MATCH: {
                int numSel;
                if (this.bigTableValueExpressions != null) {
                    for (VectorExpression ve : this.bigTableValueExpressions) {
                        ve.evaluate(batch);
                    }
                }
                batch.size = numSel = this.generateHashMultiSetResultRepeatedAll(batch, hashMultiSetResult);
                batch.selectedInUse = true;
                break;
            }
            case SPILL: {
                this.spillBatchRepeated(batch, hashMultiSetResult);
                batch.size = 0;
                break;
            }
            case NOMATCH: {
                batch.size = 0;
            }
        }
    }
}

