/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.util.ConstantThrowable;
import org.sparkproject.jetty.util.IO;
import org.sparkproject.jetty.util.Promise;
import org.sparkproject.jetty.util.TypeUtil;
import org.sparkproject.jetty.util.thread.Invocable;

public class Blocker {
    private static final Logger LOG = LoggerFactory.getLogger(Blocker.class);
    private static final Throwable ACQUIRED = new ConstantThrowable("ACQUIRED");
    private static final Throwable SUCCEEDED = new ConstantThrowable("SUCCEEDED");

    public static Runnable runnable() {
        return new Runnable(){
            final CountDownLatch _complete = new CountDownLatch(1);

            @Override
            public void run() {
                this._complete.countDown();
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.InvocationType.NON_BLOCKING;
            }

            @Override
            public void block() throws IOException {
                try {
                    this._complete.await();
                }
                catch (Throwable t) {
                    throw IO.rethrow(t);
                }
            }

            @Override
            public void block(long time, TimeUnit unit) throws IOException, TimeoutException {
                try {
                    if (!this._complete.await(time, unit)) {
                        throw new TimeoutException();
                    }
                }
                catch (TimeoutException x) {
                    throw x;
                }
                catch (Throwable t) {
                    throw IO.rethrow(t);
                }
            }

            @Override
            public void close() {
                if (this._complete.getCount() != 0L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Blocking.Runnable incomplete", new Throwable());
                    } else {
                        LOG.warn("Blocking.Runnable incomplete");
                    }
                }
            }
        };
    }

    public static Callback callback() {
        return new Callback(){
            private final CompletableFuture<Throwable> _future = new CompletableFuture();

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.InvocationType.NON_BLOCKING;
            }

            @Override
            public void succeeded() {
                this._future.complete(SUCCEEDED);
            }

            @Override
            public void failed(Throwable x) {
                this._future.complete(x == null ? new Throwable() : x);
            }

            @Override
            public void block() throws IOException {
                Throwable result;
                try {
                    result = this._future.get();
                }
                catch (Throwable t) {
                    result = t;
                }
                if (result != SUCCEEDED) {
                    throw IO.rethrow(result);
                }
            }

            @Override
            public void block(long time, TimeUnit unit) throws IOException, TimeoutException {
                Throwable result;
                try {
                    result = this._future.get(time, unit);
                }
                catch (TimeoutException x) {
                    throw x;
                }
                catch (Throwable t) {
                    result = t;
                }
                if (result != SUCCEEDED) {
                    throw IO.rethrow(result);
                }
            }

            @Override
            public void close() {
                if (!this._future.isDone()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Blocking.Callback incomplete", new Throwable());
                    } else {
                        LOG.warn("Blocking.Callback incomplete");
                    }
                }
            }
        };
    }

    public static <C> Promise<C> promise() {
        return Blocker.promise(null);
    }

    public static <C> Promise<C> promise(final Consumer<C> consumer) {
        return new Promise<C>(){
            private final CompletableFuture<C> _future = new CompletableFuture();

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.InvocationType.NON_BLOCKING;
            }

            @Override
            public C block() throws IOException {
                try {
                    return this._future.get();
                }
                catch (Throwable t) {
                    throw IO.rethrow(t);
                }
            }

            @Override
            public C block(long time, TimeUnit unit) throws IOException, TimeoutException {
                try {
                    return this._future.get(time, unit);
                }
                catch (TimeoutException x) {
                    throw x;
                }
                catch (Throwable t) {
                    throw IO.rethrow(t);
                }
            }

            @Override
            public void close() {
                if (!this._future.isDone()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Blocking.Promise incomplete", new Throwable());
                    } else {
                        LOG.warn("Blocking.Promise incomplete");
                    }
                }
            }

            @Override
            public void succeeded(C result) {
                if (consumer != null) {
                    consumer.accept(result);
                }
                this._future.complete(result);
            }

            @Override
            public void failed(Throwable x) {
                this._future.completeExceptionally(x);
            }
        };
    }

    public static <R> R blockWithPromise(Consumer<Promise<R>> consumer) throws IOException {
        try (Promise promise = Blocker.promise();){
            consumer.accept(promise);
            Object c = promise.block();
            return (R)c;
        }
    }

    public static <R> R blockWithPromise(long time, TimeUnit unit, Consumer<Promise<R>> consumer) throws IOException, TimeoutException {
        try (Promise promise = Blocker.promise();){
            consumer.accept(promise);
            Object c = promise.block(time, unit);
            return (R)c;
        }
    }

    public static interface Promise<C>
    extends Promise.Invocable<C>,
    AutoCloseable {
        public C block() throws IOException;

        public C block(long var1, TimeUnit var3) throws IOException, TimeoutException;

        @Override
        public void close();
    }

    public static class Shared {
        private final ReentrantLock _lock = new ReentrantLock();
        private final Condition _idle = this._lock.newCondition();
        private final Condition _complete = this._lock.newCondition();
        private Throwable _completed;
        private final Callback _callback = new Callback(){

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.InvocationType.NON_BLOCKING;
            }

            @Override
            public void succeeded() {
                _lock.lock();
                try {
                    if (_completed == ACQUIRED) {
                        _completed = SUCCEEDED;
                        _complete.signalAll();
                    }
                }
                finally {
                    _lock.unlock();
                }
            }

            @Override
            public void failed(Throwable x) {
                _lock.lock();
                try {
                    if (_completed == ACQUIRED) {
                        _completed = x;
                        _complete.signalAll();
                    }
                }
                finally {
                    _lock.unlock();
                }
            }

            @Override
            public void block() throws IOException {
                Throwable result;
                _lock.lock();
                try {
                    while (_completed == ACQUIRED) {
                        _complete.await();
                    }
                    result = _completed;
                }
                catch (Throwable t) {
                    result = t;
                }
                finally {
                    _lock.unlock();
                }
                if (result != SUCCEEDED) {
                    throw IO.rethrow(result);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void block(long time, TimeUnit unit) throws IOException, TimeoutException {
                Throwable result;
                _lock.lock();
                try {
                    while (_completed == ACQUIRED) {
                        if (_complete.await(time, unit)) continue;
                        throw new TimeoutException();
                    }
                    result = _completed;
                }
                catch (Throwable t) {
                    result = t;
                }
                finally {
                    _lock.unlock();
                }
                if (result != SUCCEEDED) {
                    throw IO.rethrow(result);
                }
            }

            @Override
            public void close() {
                boolean completed;
                _lock.lock();
                try {
                    completed = _completed != ACQUIRED;
                }
                finally {
                    _completed = null;
                    _idle.signalAll();
                    _lock.unlock();
                }
                if (!completed) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Blocking.Shared incomplete", new Throwable());
                    } else {
                        LOG.warn("Blocking.Shared incomplete");
                    }
                }
            }
        };
        private final Runnable _runnable = new Runnable(){

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.InvocationType.NON_BLOCKING;
            }

            @Override
            public void run() {
                _callback.succeeded();
            }

            @Override
            public void block() throws IOException {
                _callback.block();
            }

            @Override
            public void block(long time, TimeUnit unit) throws IOException, TimeoutException {
                _callback.block(time, unit);
            }

            @Override
            public void close() {
                _callback.close();
            }
        };

        public Callback callback() throws IOException {
            this._lock.lock();
            try {
                while (this._completed != null) {
                    this._idle.await();
                }
                this._completed = ACQUIRED;
                Callback callback = this._callback;
                return callback;
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
            finally {
                this._lock.unlock();
            }
        }

        public Runnable runnable() throws IOException {
            this._lock.lock();
            try {
                while (this._completed != null) {
                    this._idle.await();
                }
                this._completed = ACQUIRED;
                Runnable runnable = this._runnable;
                return runnable;
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
            finally {
                this._lock.unlock();
            }
        }

        public String toString() {
            return "%s@%x[c=%s]".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this._completed);
        }
    }

    public static interface Callback
    extends org.sparkproject.jetty.util.Callback,
    AutoCloseable,
    Invocable {
        public void block() throws IOException;

        public void block(long var1, TimeUnit var3) throws IOException, TimeoutException;

        @Override
        public void close();
    }

    public static interface Runnable
    extends java.lang.Runnable,
    AutoCloseable,
    Invocable {
        public void block() throws IOException;

        public void block(long var1, TimeUnit var3) throws IOException, TimeoutException;

        @Override
        public void close();
    }
}

