/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.session;

import java.util.concurrent.atomic.AtomicReference;
import org.sparkproject.jetty.http.HttpCookie;
import org.sparkproject.jetty.server.Handler;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.Response;
import org.sparkproject.jetty.server.Server;
import org.sparkproject.jetty.server.Session;
import org.sparkproject.jetty.session.AbstractSessionManager;
import org.sparkproject.jetty.session.ManagedSession;
import org.sparkproject.jetty.util.Callback;

public class SessionHandler
extends AbstractSessionManager
implements Handler.Singleton {
    private Server _server;
    private Handler _handler;

    @Override
    public void setServer(Server server) {
        this._server = server;
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.setServer(server);
        }
    }

    @Override
    public Handler getHandler() {
        return this._handler;
    }

    @Override
    public void setHandler(Handler handler) {
        this._handler = Handler.Singleton.updateHandler(this, handler);
    }

    @Override
    public Server getServer() {
        return this._server;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Handler next = this.getHandler();
        if (next == null) {
            return false;
        }
        SessionRequest sessionRequest = new SessionRequest(request);
        this.addSessionStreamWrapper(sessionRequest);
        return sessionRequest.process(next, response, callback);
    }

    @Override
    public ManagedSession getManagedSession(Request request) {
        return Request.get(request, SessionRequest.class, SessionRequest::getManagedSession);
    }

    @Override
    public Session.API newSessionAPIWrapper(ManagedSession session) {
        return null;
    }

    public class SessionRequest
    extends Request.Wrapper {
        private final AtomicReference<ManagedSession> _session;
        AbstractSessionManager.RequestedSession _requestedSession;
        private Response _response;

        public SessionRequest(Request request) {
            super(request);
            this._session = new AtomicReference();
        }

        void setManagedSession(ManagedSession session) {
            this._session.set(session);
        }

        ManagedSession getManagedSession() {
            return this._session.get();
        }

        @Override
        public Object getAttribute(String name) {
            if (AbstractSessionManager.RequestedSession.isApplicableAttribute(name)) {
                return this._requestedSession.getAttribute(name);
            }
            return super.getAttribute(name);
        }

        @Override
        public Session getSession(boolean create) {
            if (this._response == null) {
                throw new IllegalStateException("!processing");
            }
            ManagedSession session = this._session.get();
            if (session == null && create) {
                SessionHandler.this.newSession(this, this._requestedSession.sessionId(), this::setManagedSession);
                session = this._session.get();
                HttpCookie cookie = SessionHandler.this.getSessionCookie(session, this.getConnectionMetaData().isSecure());
                if (cookie != null) {
                    Response.putCookie(this._response, cookie);
                }
            }
            return session == null || !session.isValid() ? null : session;
        }

        public boolean process(Request.Handler handler, Response response, Callback callback) throws Exception {
            this._response = response;
            this._requestedSession = SessionHandler.this.resolveRequestedSessionId(this);
            ManagedSession session = this._requestedSession.session();
            if (session != null) {
                this._session.set(session);
                HttpCookie cookie = SessionHandler.this.access(session, this.getConnectionMetaData().isSecure());
                if (cookie != null) {
                    Response.putCookie(this._response, cookie);
                }
            }
            return handler.handle(this, this._response, callback);
        }
    }
}

