/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jetty.server.handler;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.jetty.server.Handler;
import org.sparkproject.jetty.server.Request;
import org.sparkproject.jetty.server.Response;
import org.sparkproject.jetty.util.Callback;
import org.sparkproject.jetty.util.TypeUtil;
import org.sparkproject.jetty.util.annotation.ManagedAttribute;
import org.sparkproject.jetty.util.annotation.ManagedObject;
import org.sparkproject.jetty.util.component.Dumpable;
import org.sparkproject.jetty.util.component.DumpableCollection;
import org.sparkproject.jetty.util.thread.Invocable;
import org.sparkproject.jetty.util.thread.Scheduler;

@ManagedObject
public class StateTrackingHandler
extends Handler.Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(StateTrackingHandler.class);
    private final Map<Request, StateInfo> stateInfos = new ConcurrentHashMap<Request, StateInfo>();
    private final Listener listener;
    private long handlerCallbackTimeout;
    private boolean completeHandlerCallbackAtTimeout;
    private long demandCallbackTimeout;
    private long writeTimeout;
    private long writeCallbackTimeout;

    public StateTrackingHandler() {
        this(new WarnListener());
    }

    public StateTrackingHandler(Listener listener) {
        this.listener = listener;
    }

    @ManagedAttribute(value="The timeout in ms for the completion of the handle() callback")
    public long getHandlerCallbackTimeout() {
        return this.handlerCallbackTimeout;
    }

    public void setHandlerCallbackTimeout(long timeout) {
        this.handlerCallbackTimeout = timeout;
    }

    @ManagedAttribute(value="Whether the handle() callback is completed in case of timeout")
    public boolean isCompleteHandlerCallbackAtTimeout() {
        return this.completeHandlerCallbackAtTimeout;
    }

    public void setCompleteHandlerCallbackAtTimeout(boolean completeHandlerCallbackAtTimeout) {
        this.completeHandlerCallbackAtTimeout = completeHandlerCallbackAtTimeout;
    }

    @ManagedAttribute(value="The timeout in ms for the execution of the demand callback")
    public long getDemandCallbackTimeout() {
        return this.demandCallbackTimeout;
    }

    public void setDemandCallbackTimeout(long timeout) {
        this.demandCallbackTimeout = timeout;
    }

    @ManagedAttribute(value="The timeout in ms for the execution of a response write")
    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(long timeout) {
        this.writeTimeout = timeout;
    }

    @ManagedAttribute(value="The timeout in ms for the execution of the response write callback")
    public long getWriteCallbackTimeout() {
        return this.writeCallbackTimeout;
    }

    public void setWriteCallbackTimeout(long timeout) {
        this.writeCallbackTimeout = timeout;
    }

    @Override
    public boolean handle(Request originalRequest, Response originalResponse, Callback originalCallback) throws Exception {
        HandlerCallback callback;
        StateInfo stateInfo = new StateInfo(originalRequest);
        this.stateInfos.put(originalRequest, stateInfo);
        Request.addCompletionListener(originalRequest, x -> this.stateInfos.remove(originalRequest));
        Request request = originalRequest;
        if (this.demandCallbackTimeout > 0L) {
            request = new RequestWrapper(stateInfo);
        }
        Response response = originalResponse;
        if (this.writeTimeout > 0L || this.writeCallbackTimeout > 0L) {
            response = new ResponseWrapper(stateInfo, originalResponse);
        }
        stateInfo.handlerCallback = callback = new HandlerCallback(stateInfo, originalCallback);
        try {
            ThreadInfo completionThreadInfo;
            boolean handled = super.handle(request, response, callback);
            callback.setHandled(handled);
            if (!handled && (completionThreadInfo = callback.getCompletionThreadInfo()) != null) {
                this.notifyInvalidHandlerReturnValue(stateInfo.request, completionThreadInfo);
            }
            return handled;
        }
        catch (Throwable x2) {
            this.stateInfos.remove(originalRequest);
            this.notifyHandlerException(stateInfo.request, x2, callback.getCompletionThreadInfo());
            throw x2;
        }
    }

    private void notifyInvalidHandlerReturnValue(Request request, ThreadInfo completionThreadInfo) {
        try {
            this.listener.onInvalidHandlerReturnValue(request, completionThreadInfo);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying {}", (Object)this.listener, (Object)x);
        }
    }

    private void notifyHandlerException(Request request, Throwable failure, ThreadInfo completionThreadInfo) {
        try {
            this.listener.onHandlerException(request, failure, completionThreadInfo);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying {}", (Object)this.listener, (Object)x);
        }
    }

    private void notifyHandlerCallbackNotCompleted(Request request, ThreadInfo handlerThreadInfo) {
        try {
            this.listener.onHandlerCallbackNotCompleted(request, handlerThreadInfo);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying {}", (Object)this.listener, (Object)x);
        }
    }

    private void notifyDemandCallbackBlocked(Request request, ThreadInfo demandThreadInfo, ThreadInfo runThreadInfo) {
        try {
            this.listener.onDemandCallbackBlocked(request, demandThreadInfo, runThreadInfo);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying {}", (Object)this.listener, (Object)x);
        }
    }

    private void notifyWriteBlocked(Request request, ThreadInfo writeThreadInfo, ThreadInfo writingThreadInfo) {
        try {
            this.listener.onWriteBlocked(request, writeThreadInfo, writingThreadInfo);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying {}", (Object)this.listener, (Object)x);
        }
    }

    private void notifyWriteCallbackNotCompleted(Request request, Throwable failure, ThreadInfo writeThreadInfo) {
        try {
            this.listener.onWriteCallbackNotCompleted(request, failure, writeThreadInfo);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying {}", (Object)this.listener, (Object)x);
        }
    }

    private void notifyWriteCallbackBlocked(Request request, Throwable writeFailure, ThreadInfo writeThreadInfo, ThreadInfo callbackThreadInfo) {
        try {
            this.listener.onWriteCallbackBlocked(request, writeFailure, writeThreadInfo, callbackThreadInfo);
        }
        catch (Throwable x) {
            LOG.info("failure while notifying {}", (Object)this.listener, (Object)x);
        }
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpObjects(out, indent, new DumpableCollection("requests", this.stateInfos.values()));
    }

    @Override
    public String toString() {
        return "%s@%x".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode());
    }

    private static class WarnListener
    implements Listener {
        private WarnListener() {
        }

        @Override
        public void onInvalidHandlerReturnValue(Request request, ThreadInfo completionThreadInfo) {
            LOG.warn("handler callback completed but false returned for: {}{}completed by: {}", new Object[]{request, System.lineSeparator(), completionThreadInfo});
        }

        @Override
        public void onHandlerException(Request request, Throwable failure, ThreadInfo completionThreadInfo) {
            Object format = "handler exception thrown for {}";
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(request);
            if (completionThreadInfo != null) {
                format = (String)format + "{}completed by: {}";
                args.add(System.lineSeparator());
                args.add(completionThreadInfo);
            }
            args.add(failure);
            LOG.warn((String)format, args.toArray());
        }

        @Override
        public void onHandlerCallbackNotCompleted(Request request, ThreadInfo handlerThreadInfo) {
            LOG.warn("handler callback not completed for: {}{}handled by: {}", new Object[]{request, System.lineSeparator(), handlerThreadInfo});
        }

        @Override
        public void onDemandCallbackBlocked(Request request, ThreadInfo demandThreadInfo, ThreadInfo runThreadInfo) {
            LOG.warn("demand callback blocked for: {}{}demanded by: {}{}possibly blocked: {}", new Object[]{request, System.lineSeparator(), demandThreadInfo, System.lineSeparator(), runThreadInfo});
        }

        @Override
        public void onWriteBlocked(Request request, ThreadInfo writeThreadInfo, ThreadInfo writingThreadInfo) {
            LOG.warn("write blocked for: {}{}write by: {}{}possibly blocked: {}", new Object[]{request, System.lineSeparator(), writeThreadInfo, System.lineSeparator(), writingThreadInfo});
        }

        @Override
        public void onWriteCallbackNotCompleted(Request request, Throwable writeFailure, ThreadInfo writeThreadInfo) {
            LOG.warn("write callback not completed for: {}{}write {} by: {}", new Object[]{request, System.lineSeparator(), writeFailure == null ? "succeeded" : "failed with " + String.valueOf(writeFailure), writeThreadInfo});
        }

        @Override
        public void onWriteCallbackBlocked(Request request, Throwable writeFailure, ThreadInfo writeThreadInfo, ThreadInfo callbackThreadInfo) {
            LOG.warn("write callback blocked for: {}{}write {} by: {}{}possibly blocked: {}", new Object[]{request, System.lineSeparator(), writeFailure == null ? "succeeded" : "failed with " + String.valueOf(writeFailure), writeThreadInfo, System.lineSeparator(), callbackThreadInfo});
        }
    }

    public static interface Listener
    extends EventListener {
        default public void onInvalidHandlerReturnValue(Request request, ThreadInfo completionThreadInfo) {
        }

        default public void onHandlerException(Request request, Throwable failure, ThreadInfo completionThreadInfo) {
        }

        default public void onHandlerCallbackNotCompleted(Request request, ThreadInfo handlerThreadInfo) {
        }

        default public void onDemandCallbackBlocked(Request request, ThreadInfo demandThreadInfo, ThreadInfo runThreadInfo) {
        }

        default public void onWriteBlocked(Request request, ThreadInfo writeThreadInfo, ThreadInfo writingThreadInfo) {
        }

        default public void onWriteCallbackNotCompleted(Request request, Throwable writeFailure, ThreadInfo writeThreadInfo) {
        }

        default public void onWriteCallbackBlocked(Request request, Throwable writeFailure, ThreadInfo writeThreadInfo, ThreadInfo callbackThreadInfo) {
        }
    }

    private class StateInfo
    implements Dumpable {
        private final Queue<RequestWrapper.DemandCallback> demandCallbacks = new ConcurrentLinkedQueue<RequestWrapper.DemandCallback>();
        private final Queue<ResponseWrapper.WriteCallback> writeCallbacks = new ConcurrentLinkedQueue<ResponseWrapper.WriteCallback>();
        private final Request request;
        private volatile HandlerCallback handlerCallback;

        private StateInfo(Request request) {
            this.request = request;
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            Dumpable demandDumpable = StateTrackingHandler.this.demandCallbackTimeout > 0L ? new DumpableCollection("demands", this.demandCallbacks) : (o, i) -> o.append("demands not tracked\n");
            Dumpable writeDumpable = StateTrackingHandler.this.writeTimeout > 0L || StateTrackingHandler.this.writeCallbackTimeout > 0L ? new DumpableCollection("writes", this.writeCallbacks) : (o, i) -> o.append("writes not tracked\n");
            Dumpable.dumpObjects(out, indent, this.request.toString(), this.handlerCallback, demandDumpable, writeDumpable);
        }
    }

    private class RequestWrapper
    extends Request.Wrapper {
        private final StateInfo stateInfo;

        private RequestWrapper(StateInfo stateInfo) {
            super(stateInfo.request);
            this.stateInfo = stateInfo;
        }

        @Override
        public void demand(Runnable reader) {
            DemandCallback demandCallback = new DemandCallback(reader);
            this.stateInfo.demandCallbacks.offer(demandCallback);
            super.demand(demandCallback);
        }

        private class DemandCallback
        implements Invocable.Task,
        Dumpable {
            private final Runnable callback;
            private final ThreadInfo demandThreadInfo;
            private volatile Object demandRunner;

            private DemandCallback(Runnable callback) {
                this.callback = callback;
                this.demandThreadInfo = new ThreadInfo(Thread.currentThread());
            }

            @Override
            public void run() {
                this.demandRunner = Thread.currentThread();
                Scheduler.Task task = RequestWrapper.this.getComponents().getScheduler().schedule(this::expired, StateTrackingHandler.this.getDemandCallbackTimeout(), TimeUnit.MILLISECONDS);
                try {
                    this.callback.run();
                }
                finally {
                    this.demandRunner = this;
                    RequestWrapper.this.stateInfo.demandCallbacks.remove(this);
                    task.cancel();
                }
            }

            private void expired() {
                Object demandRunner = this.demandRunner;
                if (demandRunner == this) {
                    return;
                }
                Logger log = LOG;
                if (log.isDebugEnabled()) {
                    log.debug("demand callback blocked more than {} for {}", (Object)StateTrackingHandler.this.getDemandCallbackTimeout(), (Object)RequestWrapper.this.getWrapped());
                }
                ThreadInfo runThreadInfo = new ThreadInfo((Thread)demandRunner);
                StateTrackingHandler.this.notifyDemandCallbackBlocked(RequestWrapper.this.getWrapped(), this.demandThreadInfo, runThreadInfo);
            }

            @Override
            public void dump(Appendable out, String indent) throws IOException {
                Object demandRunner = this.demandRunner;
                if (demandRunner instanceof Thread) {
                    Thread runThread = (Thread)demandRunner;
                    out.append("demand: running [%s]\n".formatted(this.callback));
                    out.append(indent).append(new ThreadInfo(runThread).toString(indent));
                } else {
                    out.append("demand: %s [%s]\n".formatted(demandRunner == null ? "pending" : "none", this.callback));
                }
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.getInvocationType(this.callback);
            }
        }
    }

    private class ResponseWrapper
    extends Response.Wrapper {
        private final StateInfo stateInfo;

        private ResponseWrapper(StateInfo stateInfo, Response wrapped) {
            super(stateInfo.request, wrapped);
            this.stateInfo = stateInfo;
        }

        @Override
        public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
            WriteCallback writeCallback = new WriteCallback(callback);
            this.stateInfo.writeCallbacks.offer(writeCallback);
            try {
                super.write(last, byteBuffer, writeCallback);
                writeCallback.writeComplete(null);
            }
            catch (Throwable x) {
                writeCallback.writeComplete(x);
                throw x;
            }
        }

        private class WriteCallback
        extends Callback.Nested
        implements Dumpable {
            private final AtomicBoolean callbackCompleted;
            private final Thread writeThread;
            private final ThreadInfo writeThreadInfo;
            private final Scheduler.Task writeTask;
            private volatile Object writeCompleted;
            private volatile Object callbackRunner;

            private WriteCallback(Callback callback) {
                super(callback);
                this.callbackCompleted = new AtomicBoolean();
                this.writeThread = Thread.currentThread();
                this.writeThreadInfo = new ThreadInfo(this.writeThread);
                long writeTimeout = StateTrackingHandler.this.getWriteTimeout();
                this.writeTask = writeTimeout > 0L ? ResponseWrapper.this.stateInfo.request.getComponents().getScheduler().schedule(this::writeExpired, writeTimeout, TimeUnit.MILLISECONDS) : null;
            }

            private void writeComplete(Throwable failure) {
                this.writeCompleted = failure == null ? this : failure;
            }

            private void writeExpired() {
                Object writeCompleted = this.writeCompleted;
                Request request = ResponseWrapper.this.stateInfo.request;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("write not completed within {} for {}", (Object)StateTrackingHandler.this.getWriteTimeout(), (Object)request);
                }
                if (writeCompleted == null) {
                    StateTrackingHandler.this.notifyWriteBlocked(request, this.writeThreadInfo, new ThreadInfo(this.writeThread));
                } else {
                    StateTrackingHandler.this.notifyWriteCallbackNotCompleted(request, writeCompleted == this ? null : (Throwable)writeCompleted, this.writeThreadInfo);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void succeeded() {
                if (!this.callbackCompleted.compareAndSet(false, true)) {
                    return;
                }
                if (this.writeTask != null) {
                    this.writeTask.cancel();
                }
                this.callbackRunner = Thread.currentThread();
                long timeout = StateTrackingHandler.this.getWriteCallbackTimeout();
                Scheduler.Task task = timeout > 0L ? ResponseWrapper.this.stateInfo.request.getComponents().getScheduler().schedule(() -> this.callbackExpired(null), timeout, TimeUnit.MILLISECONDS) : null;
                try {
                    super.succeeded();
                }
                finally {
                    this.callbackRunner = this;
                    ResponseWrapper.this.stateInfo.writeCallbacks.remove(this);
                    if (task != null) {
                        task.cancel();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(Throwable x) {
                if (!this.callbackCompleted.compareAndSet(false, true)) {
                    return;
                }
                if (this.writeTask != null) {
                    this.writeTask.cancel();
                }
                this.callbackRunner = Thread.currentThread();
                long timeout = StateTrackingHandler.this.getWriteCallbackTimeout();
                Scheduler.Task task = timeout > 0L ? ResponseWrapper.this.stateInfo.request.getComponents().getScheduler().schedule(() -> this.callbackExpired(x), timeout, TimeUnit.MILLISECONDS) : null;
                try {
                    super.failed(x);
                }
                finally {
                    this.callbackRunner = this;
                    ResponseWrapper.this.stateInfo.writeCallbacks.remove(this);
                    if (task != null) {
                        task.cancel();
                    }
                }
            }

            private void callbackExpired(Throwable failure) {
                Object callbackRunner = this.callbackRunner;
                if (callbackRunner == this) {
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("write callback not completed within {} for {}", (Object)StateTrackingHandler.this.getWriteCallbackTimeout(), (Object)ResponseWrapper.this.getRequest());
                }
                ThreadInfo callbackThreadInfo = new ThreadInfo((Thread)callbackRunner);
                StateTrackingHandler.this.notifyWriteCallbackBlocked(ResponseWrapper.this.getRequest(), failure, this.writeThreadInfo, callbackThreadInfo);
            }

            @Override
            public void dump(Appendable out, String indent) throws IOException {
                Object writeCompleted = this.writeCompleted;
                if (writeCompleted == null) {
                    out.append("write: pending\n");
                    out.append(indent).append(new ThreadInfo(this.writeThread).toString(indent));
                } else {
                    out.append("write: %s\n".formatted(writeCompleted == this ? "succeeded" : "failed with " + String.valueOf(writeCompleted)));
                }
                Object callbackRunner = this.callbackRunner;
                if (callbackRunner instanceof Thread) {
                    Thread callbackThread = (Thread)callbackRunner;
                    out.append(indent).append("write callback: running [%s]\n".formatted(this.getCallback()));
                    out.append(indent).append(new ThreadInfo(callbackThread).toString(indent));
                } else {
                    out.append(indent).append("write callback: %s [%s]\n".formatted(callbackRunner == null ? "pending" : "completed", this.getCallback()));
                }
            }
        }
    }

    private class HandlerCallback
    extends Callback.Nested
    implements Runnable,
    Dumpable {
        private final AtomicBoolean completed;
        private final Request request;
        private final Scheduler.Task task;
        private final Thread handleThread;
        private volatile Boolean handled;
        private volatile ThreadInfo completionThreadInfo;
        private volatile String completion;

        private HandlerCallback(StateInfo stateInfo, Callback callback) {
            super(callback);
            this.completed = new AtomicBoolean();
            this.request = stateInfo.request;
            long timeout = StateTrackingHandler.this.getHandlerCallbackTimeout();
            this.task = timeout > 0L ? this.request.getComponents().getScheduler().schedule(this, timeout, TimeUnit.MILLISECONDS) : () -> true;
            this.handleThread = Thread.currentThread();
        }

        private void setHandled(boolean handled) {
            if (!handled) {
                this.task.cancel();
            }
            this.handled = handled;
        }

        @Override
        public void succeeded() {
            if (this.completed(null)) {
                super.succeeded();
            }
        }

        @Override
        public void failed(Throwable x) {
            if (this.completed(x)) {
                super.failed(x);
            }
        }

        private boolean completed(Throwable failure) {
            boolean notify;
            if (!this.completed.compareAndSet(false, true)) {
                return false;
            }
            boolean cancelled = this.task.cancel();
            if (LOG.isDebugEnabled()) {
                LOG.debug("handler callback timeout cancelled={} for {}", (Object)cancelled, (Object)this.request);
            }
            this.completion = failure == null ? "succeeded" : "failed with " + String.valueOf(failure);
            ThreadInfo threadInfo = this.completionThreadInfo = new ThreadInfo(Thread.currentThread());
            boolean bl = notify = this.handled == Boolean.FALSE;
            if (notify) {
                StateTrackingHandler.this.notifyInvalidHandlerReturnValue(this.request, threadInfo);
            }
            return true;
        }

        private ThreadInfo getCompletionThreadInfo() {
            return this.completionThreadInfo;
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("handler callback not completed within {} for {}", (Object)StateTrackingHandler.this.getHandlerCallbackTimeout(), (Object)this.request);
            }
            Boolean handled = this.handled;
            ThreadInfo handlerThreadInfo = null;
            if (handled == null) {
                handlerThreadInfo = new ThreadInfo(this.handleThread);
            }
            StateTrackingHandler.this.notifyHandlerCallbackNotCompleted(this.request, handlerThreadInfo);
            if (StateTrackingHandler.this.isCompleteHandlerCallbackAtTimeout()) {
                super.failed(new TimeoutException());
            }
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            Boolean handled = this.handled;
            ThreadInfo handleThreadInfo = null;
            if (handled == null) {
                handleThreadInfo = new ThreadInfo(this.handleThread);
            }
            String completion = this.completion;
            ThreadInfo completionThreadInfo = this.completionThreadInfo;
            out.append("handle() result: %s\n".formatted(handled == null ? "pending" : handled));
            if (handleThreadInfo != null) {
                out.append(indent).append(handleThreadInfo.toString(indent));
            }
            out.append(indent).append("handler callback: %s [%s]\n".formatted(Objects.toString(completion, "not completed"), this.getCallback()));
            if (completionThreadInfo != null) {
                out.append(indent).append(completionThreadInfo.toString(indent));
            }
        }
    }

    public static class ThreadInfo {
        private final String info;
        private final StackTraceElement[] stackFrames;

        private ThreadInfo(Thread thread) {
            this.info = thread.toString();
            this.stackFrames = thread.getStackTrace();
        }

        public String getInfo() {
            return this.info;
        }

        public StackTraceElement[] getStackFrames() {
            return this.stackFrames;
        }

        public String toString() {
            return this.toString("");
        }

        private String toString(String indent) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getInfo()).append(System.lineSeparator());
            for (StackTraceElement stackFrame : this.getStackFrames()) {
                builder.append(indent).append("\tat ").append(stackFrame).append(System.lineSeparator());
            }
            return builder.toString();
        }
    }
}

