/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackend;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IngressBackendFluent<A extends IngressBackendFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private TypedLocalObjectReference resource;
    private IngressServiceBackendBuilder service;

    public IngressBackendFluent() {
    }

    public IngressBackendFluent(IngressBackend instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public IngressServiceBackend buildService() {
        return this.service != null ? this.service.build() : null;
    }

    protected void copyInstance(IngressBackend instance) {
        IngressBackend ingressBackend = instance = instance != null ? instance : new IngressBackend();
        if (instance != null) {
            this.withResource(instance.getResource());
            this.withService(instance.getService());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(new IngressServiceBackendBuilder().build()));
    }

    public ServiceNested<A> editOrNewServiceLike(IngressServiceBackend item) {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(item));
    }

    public ServiceNested<A> editService() {
        return this.withNewServiceLike(Optional.ofNullable(this.buildService()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressBackendFluent that = (IngressBackendFluent)((Object)o);
        if (!Objects.equals(this.resource, that.resource)) {
            return false;
        }
        if (!Objects.equals((Object)this.service, (Object)that.service)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public TypedLocalObjectReference getResource() {
        return this.resource;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public boolean hasService() {
        return this.service != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resource, this.service, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resource != null) {
            sb.append("resource:");
            sb.append(this.resource);
            sb.append(",");
        }
        if (this.service != null) {
            sb.append("service:");
            sb.append((Object)this.service);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withNewResource(String apiGroup, String kind, String name) {
        return this.withResource(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    public ServiceNested<A> withNewService() {
        return new ServiceNested(null);
    }

    public ServiceNested<A> withNewServiceLike(IngressServiceBackend item) {
        return new ServiceNested(item);
    }

    public A withResource(TypedLocalObjectReference resource) {
        this.resource = resource;
        return (A)((Object)this);
    }

    public A withService(IngressServiceBackend service) {
        this._visitables.remove((Object)"service");
        if (service != null) {
            this.service = new IngressServiceBackendBuilder(service);
            this._visitables.get((Object)"service").add(this.service);
        } else {
            this.service = null;
            this._visitables.get((Object)"service").remove((Object)this.service);
        }
        return (A)((Object)this);
    }

    public class ServiceNested<N>
    extends IngressServiceBackendFluent<ServiceNested<N>>
    implements Nested<N> {
        IngressServiceBackendBuilder builder;

        ServiceNested(IngressServiceBackend item) {
            this.builder = new IngressServiceBackendBuilder(this, item);
        }

        public N and() {
            return (N)IngressBackendFluent.this.withService(this.builder.build());
        }

        public N endService() {
            return this.and();
        }
    }
}

