/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasVarianceCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel$;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$NodeData$;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.DecisionTreeRegressorParams;
import org.apache.spark.ml.tree.HasVarianceImpurity;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.Node$;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JsonDSL$;
import org.json4s.MonadicJValue$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\t%e\u0001\u0002\u0014(\u0001IB\u0001b\u0017\u0001\u0003\u0006\u0004%\t\u0005\u0018\u0005\tK\u0002\u0011\t\u0011)A\u0005;\"Aa\r\u0001BC\u0002\u0013\u0005s\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003i\u0011!a\u0007A!b\u0001\n\u0003j\u0007\u0002\u0003:\u0001\u0005\u0003\u0005\u000b\u0011\u00028\t\rM\u0004A\u0011A\u0015u\u0011\u0015A\b\u0001\"\u0001z\u0011\u0019\u0019\b\u0001\"\u0001*{\"91\u000f\u0001C\u0001S\u0005\u0005\u0001\u0002CA\u0002\u0001\u0011\u00053&!\u0002\t\u000f\u00055\u0001\u0001\"\u0011\u0002\u0010!9\u00111\u0004\u0001\u0005\u0012\u0005u\u0001bBA\u0011\u0001\u0011\u0005\u00131\u0005\u0005\b\u0003\u0017\u0002A\u0011IA'\u0011\u001d\t)\n\u0001C!\u0003/Cq!a+\u0001\t\u0003\ni\u000b\u0003\u0006\u00022\u0002A)\u0019!C\u0001\u0003gC\u0001\"a.\u0001\t\u0003Z\u0013\u0011\u0018\u0005\b\u0003\u0017\u0004A\u0011IAg\u000f\u001d\tIn\nE\u0001\u000374aAJ\u0014\t\u0002\u0005u\u0007BB:\u0017\t\u0003\tI\u0010C\u0004\u0002|Z!\t%!@\t\u000f\t\u001da\u0003\"\u0011\u0003\n\u00199!\u0011\u0003\f\u0001-\tM\u0001\"\u0003B\u000b5\t\u0005\t\u0015!\u0003>\u0011\u0019\u0019(\u0004\"\u0001\u0003\u0018!9!q\u0004\u000e\u0005R\t\u0005bA\u0002B\u0016-\u0011\u0011i\u0003\u0003\u0004t=\u0011\u0005!q\u0006\u0005\n\u0005gq\"\u0019!C\u0005\u0005kA\u0001B!\u0011\u001fA\u0003%!q\u0007\u0005\b\u0005\u000fqB\u0011\tB\"\u0011!\u00119E\u0006C\u0001S\t%\u0003B\u0003B3-E\u0005I\u0011A\u0015\u0003h!I!1\u0010\f\u0002\u0002\u0013%!Q\u0010\u0002\u001c\t\u0016\u001c\u0017n]5p]R\u0013X-\u001a*fOJ,7o]5p]6{G-\u001a7\u000b\u0005!J\u0013A\u0003:fOJ,7o]5p]*\u0011!fK\u0001\u0003[2T!\u0001L\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00059z\u0013AB1qC\u000eDWMC\u00011\u0003\ry'oZ\u0002\u0001'\u0019\u00011G\u0010#H\u001bB!A'N\u001c>\u001b\u00059\u0013B\u0001\u001c(\u0005=\u0011Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001\u001d<\u001b\u0005I$B\u0001\u001e*\u0003\u0019a\u0017N\\1mO&\u0011A(\u000f\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005Q\u0002\u0001CA C\u001b\u0005\u0001%BA!*\u0003\u0011!(/Z3\n\u0005\r\u0003%!\u0005#fG&\u001c\u0018n\u001c8Ue\u0016,Wj\u001c3fYB\u0011q(R\u0005\u0003\r\u0002\u00131\u0004R3dSNLwN\u001c+sK\u0016\u0014Vm\u001a:fgN|'\u000fU1sC6\u001c\bC\u0001%L\u001b\u0005I%B\u0001&*\u0003\u0011)H/\u001b7\n\u00051K%AC'M/JLG/\u00192mKB\u0011a\n\u0017\b\u0003\u001fVs!\u0001U*\u000e\u0003ES!AU\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0016!B:dC2\f\u0017B\u0001,X\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011\u0001V\u0005\u00033j\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!AV,\u0002\u0007ULG-F\u0001^!\tq&M\u0004\u0002`AB\u0011\u0001kV\u0005\u0003C^\u000ba\u0001\u0015:fI\u00164\u0017BA2e\u0005\u0019\u0019FO]5oO*\u0011\u0011mV\u0001\u0005k&$\u0007%\u0001\u0005s_>$hj\u001c3f+\u0005A\u0007CA j\u0013\tQ\u0007I\u0001\u0003O_\u0012,\u0017!\u0003:p_Rtu\u000eZ3!\u0003-qW/\u001c$fCR,(/Z:\u0016\u00039\u0004\"a\u001c9\u000e\u0003]K!!],\u0003\u0007%sG/\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0005{U4x\u000fC\u0003\\\u000f\u0001\u0007Q\fC\u0003g\u000f\u0001\u0007\u0001\u000eC\u0003m\u000f\u0001\u0007a.\u0001\btKR4\u0016M]5b]\u000e,7i\u001c7\u0015\u0005i\\X\"\u0001\u0001\t\u000bqD\u0001\u0019A/\u0002\u000bY\fG.^3\u0015\u0007urx\u0010C\u0003g\u0013\u0001\u0007\u0001\u000eC\u0003m\u0013\u0001\u0007a\u000eF\u0001>\u00035)7\u000f^5nCR,GmU5{KV\u0011\u0011q\u0001\t\u0004_\u0006%\u0011bAA\u0006/\n!Aj\u001c8h\u0003\u001d\u0001(/\u001a3jGR$B!!\u0005\u0002\u0018A\u0019q.a\u0005\n\u0007\u0005UqK\u0001\u0004E_V\u0014G.\u001a\u0005\u0007\u00033a\u0001\u0019A\u001c\u0002\u0011\u0019,\u0017\r^;sKN\fq\u0002\u001d:fI&\u001cGOV1sS\u0006t7-\u001a\u000b\u0005\u0003#\ty\u0002\u0003\u0004\u0002\u001a5\u0001\raN\u0001\u0010iJ\fgn\u001d4pe6\u001c6\r[3nCR!\u0011QEA\u001b!\u0011\t9#!\r\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\tQ\u0001^=qKNT1!a\f,\u0003\r\u0019\u0018\u000f\\\u0005\u0005\u0003g\tIC\u0001\u0006TiJ,8\r\u001e+za\u0016Dq!a\u000e\u000f\u0001\u0004\t)#\u0001\u0004tG\",W.\u0019\u0015\u0006\u001d\u0005m\u0012q\t\t\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011I\u0016\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002F\u0005}\"!B*j]\u000e,\u0017EAA%\u0003\u0015\td\u0006\u000e\u00181\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0003\u0002P\u0005-\u0004\u0003BA)\u0003KrA!a\u0015\u0002d9!\u0011QKA1\u001d\u0011\t9&a\u0018\u000f\t\u0005e\u0013Q\f\b\u0004!\u0006m\u0013\"\u0001\u0019\n\u00059z\u0013B\u0001\u0017.\u0013\r\tycK\u0005\u0004-\u00065\u0012\u0002BA4\u0003S\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007Y\u000bi\u0003C\u0004\u0002n=\u0001\r!a\u001c\u0002\u000f\u0011\fG/Y:fiB\"\u0011\u0011OA?!\u0019\t\u0019(!\u001e\u0002z5\u0011\u0011QF\u0005\u0005\u0003o\niCA\u0004ECR\f7/\u001a;\u0011\t\u0005m\u0014Q\u0010\u0007\u0001\t1\ty(a\u001b\u0002\u0002\u0003\u0005)\u0011AAA\u0005\ryFEM\t\u0005\u0003\u0007\u000bI\tE\u0002p\u0003\u000bK1!a\"X\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\\AF\u0013\r\tii\u0016\u0002\u0004\u0003:L\b&B\b\u0002<\u0005E\u0015EAAJ\u0003\u0015\u0011d\u0006\r\u00181\u0003\u0011\u0019w\u000e]=\u0015\u0007u\nI\nC\u0004\u0002\u001cB\u0001\r!!(\u0002\u000b\u0015DHO]1\u0011\t\u0005}\u0015QU\u0007\u0003\u0003CS1!a)*\u0003\u0015\u0001\u0018M]1n\u0013\u0011\t9+!)\u0003\u0011A\u000b'/Y7NCBDS\u0001EA\u001e\u0003\u000f\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002;\"*\u0011#a\u000f\u0002H\u0005\u0011b-Z1ukJ,\u0017*\u001c9peR\fgnY3t+\u00059\u0004&\u0002\n\u0002<\u0005E\u0015!\u0002;p\u001f2$WCAA^!\u0011\ti,!3\u000e\u0005\u0005}&\u0002BAa\u0003\u0007\fQ!\\8eK2T1!QAc\u0015\r\t9mK\u0001\u0006[2d\u0017NY\u0005\u0004\u0007\u0006}\u0016!B<sSR,WCAAh!\rA\u0015\u0011[\u0005\u0004\u0003'L%\u0001C'M/JLG/\u001a:)\u000bQ\tY$!%)\u000b\u0001\tY$a\u0012\u00027\u0011+7-[:j_:$&/Z3SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\t!dcE\u0004\u0017\u0003?\f)/a;\u0011\u0007=\f\t/C\u0002\u0002d^\u0013a!\u00118z%\u00164\u0007\u0003\u0002%\u0002hvJ1!!;J\u0005)iEJU3bI\u0006\u0014G.\u001a\t\u0005\u0003[\f90\u0004\u0002\u0002p*!\u0011\u0011_Az\u0003\tIwN\u0003\u0002\u0002v\u0006!!.\u0019<b\u0013\rI\u0016q\u001e\u000b\u0003\u00037\fAA]3bIV\u0011\u0011q \t\u0005\u0011\n\u0005Q(C\u0002\u0003\u0004%\u0013\u0001\"\u0014'SK\u0006$WM\u001d\u0015\u00061\u0005m\u0012\u0011S\u0001\u0005Y>\fG\rF\u0002>\u0005\u0017AaA!\u0004\u001a\u0001\u0004i\u0016\u0001\u00029bi\"DS!GA\u001e\u0003#\u0013\u0011\u0005R3dSNLwN\u001c+sK\u0016\u0014Vm\u001a:fgNLwN\\'pI\u0016dwK]5uKJ\u001c2AGAh\u0003!Ign\u001d;b]\u000e,G\u0003\u0002B\r\u0005;\u00012Aa\u0007\u001b\u001b\u00051\u0002B\u0002B\u000b9\u0001\u0007Q(\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\u0011\u0019C!\u000b\u0011\u0007=\u0014)#C\u0002\u0003(]\u0013A!\u00168ji\"1!QB\u000fA\u0002u\u0013\u0011\u0005R3dSNLwN\u001c+sK\u0016\u0014Vm\u001a:fgNLwN\\'pI\u0016d'+Z1eKJ\u001c2AHA\u0000)\t\u0011\t\u0004E\u0002\u0003\u001cy\t\u0011b\u00197bgNt\u0015-\\3\u0016\u0005\t]\u0002\u0003\u0002B\u001d\u0005\u007fi!Aa\u000f\u000b\t\tu\u00121_\u0001\u0005Y\u0006tw-C\u0002d\u0005w\t!b\u00197bgNt\u0015-\\3!)\ri$Q\t\u0005\u0007\u0005\u001b\u0011\u0003\u0019A/\u0002\u000f\u0019\u0014x.\\(mIRIQHa\u0013\u0003P\te#1\r\u0005\b\u0005\u001b\u001a\u0003\u0019AA^\u0003!yG\u000eZ'pI\u0016d\u0007b\u0002B)G\u0001\u0007!1K\u0001\u0007a\u0006\u0014XM\u001c;\u0011\u0007Q\u0012)&C\u0002\u0003X\u001d\u0012Q\u0003R3dSNLwN\u001c+sK\u0016\u0014Vm\u001a:fgN|'\u000fC\u0004\u0003\\\r\u0002\rA!\u0018\u0002'\r\fG/Z4pe&\u001c\u0017\r\u001c$fCR,(/Z:\u0011\u000by\u0013yF\u001c8\n\u0007\t\u0005DMA\u0002NCBDq\u0001\\\u0012\u0011\u0002\u0003\u0007a.A\tge>lw\n\u001c3%I\u00164\u0017-\u001e7uIQ*\"A!\u001b+\u00079\u0014Yg\u000b\u0002\u0003nA!!q\u000eB<\u001b\t\u0011\tH\u0003\u0003\u0003t\tU\u0014!C;oG\",7m[3e\u0015\r\t\teV\u0005\u0005\u0005s\u0012\tHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa \u0011\t\te\"\u0011Q\u0005\u0005\u0005\u0007\u0013YD\u0001\u0004PE*,7\r\u001e\u0015\u0006-\u0005m\u0012\u0011\u0013\u0015\u0006+\u0005m\u0012\u0011\u0013")
public class DecisionTreeRegressionModel
extends RegressionModel<Vector, DecisionTreeRegressionModel>
implements DecisionTreeModel,
DecisionTreeRegressorParams,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final Node rootNode;
    private final int numFeatures;
    private Param<String> varianceCol;
    private Param<String> impurity;
    private Param<String> leafCol;
    private IntParam maxDepth;
    private IntParam maxBins;
    private IntParam minInstancesPerNode;
    private DoubleParam minWeightFractionPerNode;
    private DoubleParam minInfoGain;
    private IntParam maxMemoryInMB;
    private BooleanParam cacheNodeIds;
    private Param<String> weightCol;
    private LongParam seed;
    private IntParam checkpointInterval;
    private int depth;
    private int numLeave;
    private NominalAttribute leafAttr;
    private transient Map<LeafNode, Object> org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static DecisionTreeRegressionModel load(String path) {
        return DecisionTreeRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<DecisionTreeRegressionModel> read() {
        return DecisionTreeRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$DecisionTreeRegressorParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return DecisionTreeRegressorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getVarianceCol() {
        return HasVarianceCol.getVarianceCol$(this);
    }

    @Override
    public final String getImpurity() {
        return HasVarianceImpurity.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return HasVarianceImpurity.getOldImpurity$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public int numNodes() {
        return DecisionTreeModel.numNodes$(this);
    }

    @Override
    public String toDebugString() {
        return DecisionTreeModel.toDebugString$(this);
    }

    @Override
    public int maxSplitFeatureIndex() {
        return DecisionTreeModel.maxSplitFeatureIndex$(this);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return DecisionTreeModel.getLeafField$(this, leafCol);
    }

    @Override
    public double predictLeaf(Vector features) {
        return DecisionTreeModel.predictLeaf$(this, features);
    }

    @Override
    public long getEstimatedSize() {
        return DecisionTreeModel.getEstimatedSize$(this);
    }

    @Override
    public final Param<String> varianceCol() {
        return this.varianceCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasVarianceCol$_setter_$varianceCol_$eq(Param<String> x$1) {
        this.varianceCol = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasVarianceImpurity$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    private int depth$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.depth = DecisionTreeModel.depth$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.depth;
    }

    @Override
    public int depth() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.depth$lzycompute();
        }
        return this.depth;
    }

    private int numLeave$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.numLeave = DecisionTreeModel.numLeave$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.numLeave;
    }

    @Override
    public int numLeave() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.numLeave$lzycompute();
        }
        return this.numLeave;
    }

    private NominalAttribute leafAttr$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.leafAttr = DecisionTreeModel.leafAttr$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.leafAttr;
    }

    @Override
    public NominalAttribute leafAttr() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.leafAttr$lzycompute();
        }
        return this.leafAttr;
    }

    private Map<LeafNode, Object> org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if (!this.bitmap$trans$0) {
                this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices = DecisionTreeModel.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices;
    }

    @Override
    public Map<LeafNode, Object> org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices() {
        if (!this.bitmap$trans$0) {
            return this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices$lzycompute();
        }
        return this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public Node rootNode() {
        return this.rootNode;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public DecisionTreeRegressionModel setVarianceCol(String value) {
        return (DecisionTreeRegressionModel)this.set(this.varianceCol(), value);
    }

    @Override
    public long estimatedSize() {
        return this.getEstimatedSize();
    }

    @Override
    public double predict(Vector features) {
        return this.rootNode().predictImpl(features).prediction();
    }

    public double predictVariance(Vector features) {
        return this.rootNode().predictImpl(features).impurityStats().calculate();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block1: {
            outputSchema = super.transformSchema(schema);
            if (this.isDefined(this.varianceCol()) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.varianceCol())))) {
                outputSchema = SchemaUtils$.MODULE$.updateNumeric(outputSchema, this.$(this.varianceCol()));
            }
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) break block1;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return outputSchema;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)scala.package$.MODULE$.Seq().empty();
        Seq predictionColumns = (Seq)scala.package$.MODULE$.Seq().empty();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator1$1(DecisionTreeRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator1$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.predictionCol()), outputSchema.apply(this.$(this.predictionCol())).metadata()));
        }
        if (this.isDefined(this.varianceCol()) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.varianceCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator2$1(DecisionTreeRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictVarianceUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)this.predictVariance(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator2$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.varianceCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictVarianceUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.varianceCol()), outputSchema.apply(this.$(this.varianceCol())).metadata()));
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator3$1(DecisionTreeRegressionModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)this.predictLeaf(features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator3$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.leafCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)leafUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.leafCol()), outputSchema.apply(this.$(this.leafCol())).metadata()));
        }
        if (predictionColNames.nonEmpty()) {
            return dataset.withColumns(predictionColNames, predictionColumns);
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ": DecisionTreeRegressionModel.transform() "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.UUID, this.uid())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"does nothing because no output columns were set."}))).log((Seq)Nil$.MODULE$))));
        return dataset.toDF();
    }

    @Override
    public DecisionTreeRegressionModel copy(ParamMap extra) {
        return (DecisionTreeRegressionModel)((Model)this.copyValues(new DecisionTreeRegressionModel(this.uid(), this.rootNode(), this.numFeatures()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return "DecisionTreeRegressionModel: uid=" + this.uid() + ", depth=" + this.depth() + ", numNodes=" + this.numNodes() + ", numFeatures=" + this.numFeatures();
    }

    private Vector featureImportances$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this, this.numFeatures(), ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.featureImportances$lzycompute();
        }
        return this.featureImportances;
    }

    @Override
    public org.apache.spark.mllib.tree.model.DecisionTreeModel toOld() {
        return new org.apache.spark.mllib.tree.model.DecisionTreeModel(this.rootNode().toOld(1), Algo$.MODULE$.Regression());
    }

    @Override
    public MLWriter write() {
        return new DecisionTreeRegressionModelWriter(this);
    }

    public DecisionTreeRegressionModel(String uid, Node rootNode, int numFeatures) {
        this.uid = uid;
        this.rootNode = rootNode;
        this.numFeatures = numFeatures;
        DecisionTreeModel.$init$(this);
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        HasVarianceImpurity.$init$(this);
        HasVarianceCol.$init$(this);
        DecisionTreeRegressorParams.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(rootNode != null, (Function0 & Serializable)() -> "DecisionTreeRegressionModel given null rootNode, but it requires a non-null rootNode.");
        Statics.releaseFence();
    }

    public DecisionTreeRegressionModel(Node rootNode, int numFeatures) {
        this(Identifiable$.MODULE$.randomUID("dtr"), rootNode, numFeatures);
    }

    public DecisionTreeRegressionModel() {
        this("", Node$.MODULE$.dummyNode(), -1);
    }

    private static class DecisionTreeRegressionModelReader
    extends MLReader<DecisionTreeRegressionModel> {
        private final String className = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public DecisionTreeRegressionModel load(String path) {
            DefaultFormats$ format = DefaultFormats$.MODULE$;
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            int numFeatures = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata.metadata()), "numFeatures")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            Node root = DecisionTreeModelReadWrite$.MODULE$.loadTreeNodes(path, metadata, this.sparkSession());
            DecisionTreeRegressionModel model = new DecisionTreeRegressionModel(metadata.uid(), root, numFeatures);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class DecisionTreeRegressionModelWriter
    extends MLWriter {
        private final DecisionTreeRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml.tree")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.ml.tree.DecisionTreeModelReadWrite")), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.tree.DecisionTreeModelReadWrite.NodeData"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$$typecreator1$2(DecisionTreeRegressionModelWriter $outer) {
                }
            }
            JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures()))})), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession(), (Option<JObject>)new Some((Object)extraMetadata));
            Tuple2<Seq<DecisionTreeModelReadWrite.NodeData>, Object> tuple2 = DecisionTreeModelReadWrite$NodeData$.MODULE$.build(this.instance.rootNode(), 0);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq nodeData = (Seq)tuple2._1();
            Seq nodeData2 = nodeData;
            String dataPath = new Path(path, "data").toString();
            int numDataParts = DecisionTreeModelReadWrite$NodeData$.MODULE$.inferNumPartitions(this.instance.numNodes());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModelWriter.class.getClassLoader());
            ReadWriteUtils$.MODULE$.saveArray(dataPath, nodeData2.toArray(ClassTag$.MODULE$.apply(DecisionTreeModelReadWrite.NodeData.class)), this.sparkSession(), (Function2 & Serializable)(data, dos) -> {
                DecisionTreeModelReadWrite$NodeData$.MODULE$.serializeData(data, dos);
                return BoxedUnit.UNIT;
            }, numDataParts, ClassTag$.MODULE$.apply(DecisionTreeModelReadWrite.NodeData.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$$typecreator1$2(null)));
        }

        public DecisionTreeRegressionModelWriter(DecisionTreeRegressionModel instance) {
            this.instance = instance;
        }
    }
}

