/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.runtime;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.streaming.operators.stateful.EventTimeWatermarkExec;
import org.apache.spark.sql.execution.streaming.operators.stateful.StateStoreWriter;
import org.apache.spark.sql.execution.streaming.operators.stateful.StatefulOperatorStateInfo;
import org.apache.spark.sql.execution.streaming.runtime.PropagateWatermarkSimulator$;
import org.apache.spark.sql.execution.streaming.runtime.WatermarkPropagator;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005-b\u0001\u0002\b\u0010\u0001yAQa\f\u0001\u0005\u0002ABqA\r\u0001C\u0002\u0013%1\u0007\u0003\u0004@\u0001\u0001\u0006I\u0001\u000e\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0011\u00199\u0006\u0001)A\u0005\u0005\")\u0001\f\u0001C\u00053\")q\f\u0001C\u0005A\")a\u000f\u0001C\u0005o\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0001bBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\b\u0003+\u0001A\u0011IA\f\u0011\u001d\ti\u0002\u0001C!\u0003?Aq!!\n\u0001\t\u0003\n9CA\u000eQe>\u0004\u0018mZ1uK^\u000bG/\u001a:nCJ\\7+[7vY\u0006$xN\u001d\u0006\u0003!E\tqA];oi&lWM\u0003\u0002\u0013'\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003)U\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005Y9\u0012aA:rY*\u0011\u0001$G\u0001\u0006gB\f'o\u001b\u0006\u00035m\ta!\u00199bG\",'\"\u0001\u000f\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001yR%\u000b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019:S\"A\b\n\u0005!z!aE,bi\u0016\u0014X.\u0019:l!J|\u0007/Y4bi>\u0014\bC\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0018\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0018,\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0019\u0011\u0005\u0019\u0002\u0011A\u00052bi\u000eD\u0017\n\u001a+p/\u0006$XM]7be.,\u0012\u0001\u000e\t\u0005kibD(D\u00017\u0015\t9\u0004(\u0001\u0003vi&d'\"A\u001d\u0002\t)\fg/Y\u0005\u0003wY\u0012q\u0001\u0016:fK6\u000b\u0007\u000f\u0005\u0002!{%\u0011a(\t\u0002\u0005\u0019>tw-A\ncCR\u001c\u0007.\u00133U_^\u000bG/\u001a:nCJ\\\u0007%A\bj]B,HoV1uKJl\u0017M]6t+\u0005\u0011\u0005\u0003B\"Iy)k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bq!\\;uC\ndWM\u0003\u0002HC\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005%#%aA'baB!1J\u0015\u001fU\u001d\ta\u0005\u000b\u0005\u0002NC5\taJ\u0003\u0002P;\u00051AH]8pizJ!!U\u0011\u0002\rA\u0013X\rZ3g\u0013\tI5K\u0003\u0002RCA\u0019\u0001%\u0016\u001f\n\u0005Y\u000b#AB(qi&|g.\u0001\tj]B,HoV1uKJl\u0017M]6tA\u0005i\u0011n]%oSRL\u0017\r\\5{K\u0012$\"AW/\u0011\u0005\u0001Z\u0016B\u0001/\"\u0005\u001d\u0011un\u001c7fC:DQA\u0018\u0004A\u0002q\nqAY1uG\"LE-\u0001\nhKRLe\u000e];u/\u0006$XM]7be.\u001cHcA1kaB\u0019!m\u001a\u001f\u000f\u0005\r,gBA'e\u0013\u0005\u0011\u0013B\u00014\"\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001[5\u0003\u0007M+\u0017O\u0003\u0002gC!)1n\u0002a\u0001Y\u0006!an\u001c3f!\tig.D\u0001\u0014\u0013\ty7CA\u0005Ta\u0006\u00148\u000e\u00157b]\")\u0011o\u0002a\u0001e\u0006)bn\u001c3f)>|U\u000f\u001e9vi^\u000bG/\u001a:nCJ\\\u0007\u0003B\"IgR\u0003\"\u0001\t;\n\u0005U\f#aA%oi\u0006QAm\\*j[Vd\u0017\r^3\u0015\ta\\HP \t\u0003AeL!A_\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006=\"\u0001\r\u0001\u0010\u0005\u0006{\"\u0001\r\u0001\\\u0001\u0005a2\fg\u000eC\u0003\u0000\u0011\u0001\u0007A(A\bpe&<\u0017N\\,bi\u0016\u0014X.\u0019:l\u0003%\u0001(o\u001c9bO\u0006$X\rF\u0004y\u0003\u000b\t9!!\u0003\t\u000byK\u0001\u0019\u0001\u001f\t\u000buL\u0001\u0019\u00017\t\u000b}L\u0001\u0019\u0001\u001f\u0002#\u001d,G/\u00138qkR<\u0016\r^3s[\u0006\u00148\u000eF\u0003=\u0003\u001f\t\t\u0002C\u0003_\u0015\u0001\u0007A\b\u0003\u0004\u0002\u0014)\u0001\r\u0001P\u0001\ngR\fG/Z(q\u0013\u0012\fadZ3u\u0013:\u0004X\u000f^,bi\u0016\u0014X.\u0019:l\r>\u0014H*\u0019;f\u000bZ,g\u000e^:\u0015\u000bq\nI\"a\u0007\t\u000by[\u0001\u0019\u0001\u001f\t\r\u0005M1\u00021\u0001=\u0003q9W\r^%oaV$x+\u0019;fe6\f'o\u001b$pe\u00163\u0018n\u0019;j_:$R\u0001PA\u0011\u0003GAQA\u0018\u0007A\u0002qBa!a\u0005\r\u0001\u0004a\u0014!\u00029ve\u001e,Gc\u0001=\u0002*!)a,\u0004a\u0001y\u0001")
public class PropagateWatermarkSimulator
implements WatermarkPropagator,
Logging {
    private final TreeMap<Object, Object> batchIdToWatermark;
    private final scala.collection.mutable.Map<Object, scala.collection.immutable.Map<Object, Option<Object>>> inputWatermarks;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private TreeMap<Object, Object> batchIdToWatermark() {
        return this.batchIdToWatermark;
    }

    private scala.collection.mutable.Map<Object, scala.collection.immutable.Map<Object, Option<Object>>> inputWatermarks() {
        return this.inputWatermarks;
    }

    private boolean isInitialized(long batchId) {
        return this.batchIdToWatermark().containsKey(BoxesRunTime.boxToLong((long)batchId));
    }

    public Seq<Object> org$apache$spark$sql$execution$streaming$runtime$PropagateWatermarkSimulator$$getInputWatermarks(SparkPlan node, scala.collection.mutable.Map<Object, Option<Object>> nodeToOutputWatermark) {
        return (Seq)node.children().flatMap((Function1 & Serializable)child -> (Option)nodeToOutputWatermark.getOrElse((Object)BoxesRunTime.boxToInteger((int)child.id()), (Function0 & Serializable)() -> {
            throw new IllegalStateException("watermark for the node " + child.id() + " should be registered");
        }));
    }

    private void doSimulate(long batchId, SparkPlan plan, long originWatermark) {
        HashMap nodeToOutputWatermark = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        HashMap nextStatefulOperatorToWatermark = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        plan.transformUp((PartialFunction)new Serializable(this, nodeToOutputWatermark, originWatermark, nextStatefulOperatorToWatermark){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ PropagateWatermarkSimulator $outer;
            private final HashMap nodeToOutputWatermark$2;
            private final long originWatermark$2;
            private final HashMap nextStatefulOperatorToWatermark$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof EventTimeWatermarkExec) {
                    EventTimeWatermarkExec eventTimeWatermarkExec = (EventTimeWatermarkExec)A1;
                    Seq<Object> inputWatermarks = this.$outer.org$apache$spark$sql$execution$streaming$runtime$PropagateWatermarkSimulator$$getInputWatermarks(eventTimeWatermarkExec, (scala.collection.mutable.Map<Object, Option<Object>>)this.nodeToOutputWatermark$2);
                    if (inputWatermarks.nonEmpty()) {
                        throw new AnalysisException("_LEGACY_ERROR_TEMP_3076", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"config"), (Object)SQLConf$.MODULE$.STATEFUL_OPERATOR_ALLOW_MULTIPLE().key())})));
                    }
                    this.nodeToOutputWatermark$2.put((Object)BoxesRunTime.boxToInteger((int)eventTimeWatermarkExec.id()), (Object)new Some((Object)BoxesRunTime.boxToLong((long)this.originWatermark$2)));
                    return (B1)eventTimeWatermarkExec;
                }
                if (A1 instanceof StateStoreWriter) {
                    StateStoreWriter stateStoreWriter = (StateStoreWriter)((Object)A1);
                    long stOpId = ((StatefulOperatorStateInfo)stateStoreWriter.stateInfo().get()).operatorId();
                    Seq<Object> inputWatermarks = this.$outer.org$apache$spark$sql$execution$streaming$runtime$PropagateWatermarkSimulator$$getInputWatermarks((SparkPlan)((Object)stateStoreWriter), (scala.collection.mutable.Map<Object, Option<Object>>)this.nodeToOutputWatermark$2);
                    None$ finalInputWatermarkMs = inputWatermarks.nonEmpty() ? new Some(inputWatermarks.min((Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
                    Option outputWatermarkMs = finalInputWatermarkMs.flatMap((Function1 & Serializable)wm -> $anonfun$doSimulate$1.$anonfun$applyOrElse$1(stateStoreWriter, BoxesRunTime.unboxToLong((Object)wm)));
                    this.nodeToOutputWatermark$2.put((Object)BoxesRunTime.boxToInteger((int)((SparkPlan)((Object)stateStoreWriter)).id()), (Object)outputWatermarkMs);
                    this.nextStatefulOperatorToWatermark$1.put((Object)BoxesRunTime.boxToLong((long)stOpId), (Object)finalInputWatermarkMs);
                    return (B1)stateStoreWriter;
                }
                Seq<Object> inputWatermarks = this.$outer.org$apache$spark$sql$execution$streaming$runtime$PropagateWatermarkSimulator$$getInputWatermarks(A1, (scala.collection.mutable.Map<Object, Option<Object>>)this.nodeToOutputWatermark$2);
                None$ finalInputWatermarkMs = inputWatermarks.nonEmpty() ? new Some(inputWatermarks.min((Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
                this.nodeToOutputWatermark$2.put((Object)BoxesRunTime.boxToInteger((int)A1.id()), (Object)finalInputWatermarkMs);
                return (B1)A1;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                if (sparkPlan instanceof EventTimeWatermarkExec) {
                    return true;
                }
                if (sparkPlan instanceof StateStoreWriter) {
                    return true;
                }
                return true;
            }

            public static final /* synthetic */ Option $anonfun$applyOrElse$1(StateStoreWriter x3$1, long wm) {
                return x3$1.produceOutputWatermark(wm);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.nodeToOutputWatermark$2 = nodeToOutputWatermark$2;
                this.originWatermark$2 = originWatermark$2;
                this.nextStatefulOperatorToWatermark$1 = nextStatefulOperatorToWatermark$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.execution.streaming.operators.stateful.StateStoreWriter java.lang.Object )}, serializedLambda);
            }
        });
        this.inputWatermarks().put((Object)BoxesRunTime.boxToLong((long)batchId), (Object)nextStatefulOperatorToWatermark.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.batchIdToWatermark().put(BoxesRunTime.boxToLong((long)batchId), BoxesRunTime.boxToLong((long)originWatermark));
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "global watermark for batch ID " + batchId + " is set to " + originWatermark);
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "input watermarks for batch ID " + batchId + " is set to " + nextStatefulOperatorToWatermark);
    }

    @Override
    public void propagate(long batchId, SparkPlan plan, long originWatermark) {
        if (batchId < 0L) {
            return;
        }
        if (this.isInitialized(batchId)) {
            long cached = BoxesRunTime.unboxToLong((Object)this.batchIdToWatermark().get(BoxesRunTime.boxToLong((long)batchId)));
            Predef$.MODULE$.assert(cached == originWatermark, (Function0 & Serializable)() -> "Watermark has been changed for the same batch ID! Batch ID: " + batchId + ", Value in cache: " + cached + ", value given: " + originWatermark);
            return;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "watermark for batch ID " + batchId + " is received as " + originWatermark + ", call site: " + Utils$.MODULE$.getCallSite(Utils$.MODULE$.getCallSite$default$1()).longForm());
        if (originWatermark == 0L) {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "skipping the propagation for batch " + batchId + " as origin watermark is 0.");
            this.batchIdToWatermark().put(BoxesRunTime.boxToLong((long)batchId), BoxesRunTime.boxToLong((long)0L));
            this.inputWatermarks().put((Object)BoxesRunTime.boxToLong((long)batchId), (Object)Predef$.MODULE$.Map().empty());
            return;
        }
        this.doSimulate(batchId, plan, originWatermark);
    }

    private long getInputWatermark(long batchId, long stateOpId) {
        if (batchId < 0L) {
            return 0L;
        }
        Predef$.MODULE$.assert(this.isInitialized(batchId), (Function0 & Serializable)() -> "Watermark for batch ID " + batchId + " is not yet set!");
        Option option = ((MapOps)this.inputWatermarks().apply((Object)BoxesRunTime.boxToLong((long)batchId))).get((Object)BoxesRunTime.boxToLong((long)stateOpId));
        if (option instanceof Some) {
            Some some = (Some)option;
            Option wmOpt = (Option)some.value();
            return Math.max(BoxesRunTime.unboxToLong((Object)wmOpt.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)), 0L);
        }
        if (None$.MODULE$.equals(option)) {
            if (BoxesRunTime.unboxToLong((Object)this.batchIdToWatermark().get(BoxesRunTime.boxToLong((long)batchId))) == 0L) {
                return 0L;
            }
            throw new IllegalStateException("Watermark for batch ID " + batchId + " and stateOpId " + stateOpId + " is not yet set!");
        }
        throw new MatchError((Object)option);
    }

    @Override
    public long getInputWatermarkForLateEvents(long batchId, long stateOpId) {
        return this.getInputWatermark(batchId - 1L, stateOpId);
    }

    @Override
    public long getInputWatermarkForEviction(long batchId, long stateOpId) {
        return this.getInputWatermark(batchId, stateOpId);
    }

    @Override
    public void purge(long batchId) {
        Iterator<Object> keyIter = this.batchIdToWatermark().keySet().iterator();
        boolean stopIter = false;
        while (keyIter.hasNext() && !stopIter) {
            BoxedUnit boxedUnit;
            long currKey = BoxesRunTime.unboxToLong((Object)keyIter.next());
            if (currKey <= batchId) {
                keyIter.remove();
                boxedUnit = this.inputWatermarks().remove((Object)BoxesRunTime.boxToLong((long)currKey));
                continue;
            }
            stopIter = true;
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public PropagateWatermarkSimulator() {
        Logging.$init$((Logging)this);
        this.batchIdToWatermark = new TreeMap();
        this.inputWatermarks = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

