/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2.state;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSource$;
import org.apache.spark.sql.execution.datasources.v2.state.StateDataSourceErrors$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$;
import org.apache.spark.sql.execution.datasources.v2.state.StateSourceOptions$JoinSideValues$;
import org.apache.spark.sql.execution.datasources.v2.state.StateStoreReaderInfo;
import org.apache.spark.sql.execution.datasources.v2.state.StateTable;
import org.apache.spark.sql.execution.datasources.v2.state.StreamStreamJoinStateHelper$;
import org.apache.spark.sql.execution.datasources.v2.state.metadata.StateMetadataTableEntry;
import org.apache.spark.sql.execution.datasources.v2.state.utils.SchemaUtil$;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeq;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqLog;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadata;
import org.apache.spark.sql.execution.streaming.checkpointing.OffsetSeqMetadata$;
import org.apache.spark.sql.execution.streaming.operators.stateful.StatefulOperatorsUtils$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.StreamingSymmetricHashJoinHelper;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.StreamingSymmetricHashJoinHelper$LeftSide$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.StreamingSymmetricHashJoinHelper$RightSide$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.SymmetricHashJoinStateManager$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateOperatorProperties;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateOperatorProperties$;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.TransformWithStateVariableInfo;
import org.apache.spark.sql.execution.streaming.operators.stateful.transformwithstate.timers.TimerStateUtils$;
import org.apache.spark.sql.execution.streaming.runtime.StreamingQueryCheckpointMetadata;
import org.apache.spark.sql.execution.streaming.state.InMemoryStateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.PrefixKeyScanStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker;
import org.apache.spark.sql.execution.streaming.state.StateSchemaCompatibilityChecker$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadata;
import org.apache.spark.sql.execution.streaming.state.StateSchemaMetadata$;
import org.apache.spark.sql.execution.streaming.state.StateSchemaProvider;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf$;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.streaming.TimeMode;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u00055g\u0001B\t\u0013\u0001\rBQ\u0001\u0011\u0001\u0005\u0002\u0005C\u0001\u0002\u0012\u0001\t\u0006\u0004%I!\u0012\u0005\t\u0015\u0002A)\u0019!C\u0005\u0017\")A\u000b\u0001C!+\")1\r\u0001C!I\"9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0001bBA\u000e\u0001\u0011\u0005\u0013Q\u0004\u0005\b\u0003K\u0001A\u0011BA\u0014\u0011\u001d\t)\u0005\u0001C\u0005\u0003\u000fBq!a\u001b\u0001\t\u0013\ti\u0007C\u0004\u0002x\u0001!I!!\u001f\b\u000f\u0005=%\u0003#\u0001\u0002\u0012\u001a1\u0011C\u0005E\u0001\u0003'Ca\u0001Q\u0007\u0005\u0002\u0005m\u0005bBAO\u001b\u0011%\u0011q\u0014\u0005\b\u0003OkA\u0011AAU\u0005=\u0019F/\u0019;f\t\u0006$\u0018mU8ve\u000e,'BA\n\u0015\u0003\u0015\u0019H/\u0019;f\u0015\t)b#\u0001\u0002we)\u0011q\u0003G\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002\u001a5\u0005IQ\r_3dkRLwN\u001c\u0006\u00037q\t1a]9m\u0015\tib$A\u0003ta\u0006\u00148N\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<7\u0001A\n\u0006\u0001\u0011bCG\u000f\t\u0003K)j\u0011A\n\u0006\u0003O!\nA\u0001\\1oO*\t\u0011&\u0001\u0003kCZ\f\u0017BA\u0016'\u0005\u0019y%M[3diB\u0011QFM\u0007\u0002])\u0011q\u0006M\u0001\bG\u0006$\u0018\r\\8h\u0015\t\t$$A\u0005d_:tWm\u0019;pe&\u00111G\f\u0002\u000e)\u0006\u0014G.\u001a)s_ZLG-\u001a:\u0011\u0005UBT\"\u0001\u001c\u000b\u0005]R\u0012aB:pkJ\u001cWm]\u0005\u0003sY\u0012!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;feB\u00111HP\u0007\u0002y)\u0011Q\bH\u0001\tS:$XM\u001d8bY&\u0011q\b\u0010\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t!\t\u0005\u0002D\u00015\t!#A\u0004tKN\u001c\u0018n\u001c8\u0016\u0003\u0019\u0003\"a\u0012%\u000e\u0003iI!!\u0013\u000e\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0015!\fGm\\8q\u0007>tg-F\u0001M!\ti%+D\u0001O\u0015\ty\u0005+\u0001\u0003d_:4'BA)\u001f\u0003\u0019A\u0017\rZ8pa&\u00111K\u0014\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u0013MDwN\u001d;OC6,G#\u0001,\u0011\u0005]\u0003gB\u0001-_!\tIF,D\u0001[\u0015\tY&%\u0001\u0004=e>|GO\u0010\u0006\u0002;\u0006)1oY1mC&\u0011q\fX\u0001\u0007!J,G-\u001a4\n\u0005\u0005\u0014'AB*ue&twM\u0003\u0002`9\u0006Aq-\u001a;UC\ndW\r\u0006\u0003fQBd\bCA\u0017g\u0013\t9gFA\u0003UC\ndW\rC\u0003j\u000b\u0001\u0007!.\u0001\u0004tG\",W.\u0019\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[j\tQ\u0001^=qKNL!a\u001c7\u0003\u0015M#(/^2u)f\u0004X\rC\u0003r\u000b\u0001\u0007!/\u0001\u0007qCJ$\u0018\u000e^5p]&tw\rE\u0002tiZl\u0011\u0001X\u0005\u0003kr\u0013Q!\u0011:sCf\u0004\"a\u001e>\u000e\u0003aT!!\u001f\u0019\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003wb\u0014\u0011\u0002\u0016:b]N4wN]7\t\u000bu,\u0001\u0019\u0001@\u0002\u0015A\u0014x\u000e]3si&,7\u000fE\u0003\u0000\u0003\u000b1f+\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u0015\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u000f\t\tAA\u0002NCB\f1\"\u001b8gKJ\u001c6\r[3nCR\u0019!.!\u0004\t\u000f\u0005=a\u00011\u0001\u0002\u0012\u00059q\u000e\u001d;j_:\u001c\b\u0003BA\n\u0003/i!!!\u0006\u000b\u0007\u0005\r!$\u0003\u0003\u0002\u001a\u0005U!\u0001G\"bg\u0016Len]3og&$\u0018N^3TiJLgnZ'ba\u0006A2/\u001e9q_J$8/\u0012=uKJt\u0017\r\\'fi\u0006$\u0017\r^1\u0015\u0005\u0005}\u0001cA:\u0002\"%\u0019\u00111\u0005/\u0003\u000f\t{w\u000e\\3b]\u0006\u0019\"-^5mIN#\u0018\r^3Ti>\u0014XmQ8oMR1\u0011\u0011FA\u001c\u0003w\u0001B!a\u000b\u000245\u0011\u0011Q\u0006\u0006\u0004'\u0005=\"bAA\u00191\u0005I1\u000f\u001e:fC6LgnZ\u0005\u0005\u0003k\tiC\u0001\bTi\u0006$Xm\u0015;pe\u0016\u001cuN\u001c4\t\r\u0005e\u0002\u00021\u0001W\u0003I\u0019\u0007.Z2la>Lg\u000e\u001e'pG\u0006$\u0018n\u001c8\t\u000f\u0005u\u0002\u00021\u0001\u0002@\u00059!-\u0019;dQ&#\u0007cA:\u0002B%\u0019\u00111\t/\u0003\t1{gnZ\u0001\u0012eVt7\u000b^1uKZ\u000b'o\u00115fG.\u001cHCBA%\u0003\u001f\nI\u0006E\u0002t\u0003\u0017J1!!\u0014]\u0005\u0011)f.\u001b;\t\u000f\u0005E\u0013\u00021\u0001\u0002T\u0005i1o\\;sG\u0016|\u0005\u000f^5p]N\u00042aQA+\u0013\r\t9F\u0005\u0002\u0013'R\fG/Z*pkJ\u001cWm\u00149uS>t7\u000fC\u0004\u0002\\%\u0001\r!!\u0018\u0002%M$\u0018\r^3Ti>\u0014X-T3uC\u0012\fG/\u0019\t\u0005gR\fy\u0006\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)GE\u0001\t[\u0016$\u0018\rZ1uC&!\u0011\u0011NA2\u0005]\u0019F/\u0019;f\u001b\u0016$\u0018\rZ1uCR\u000b'\r\\3F]R\u0014\u00180\u0001\u000fhKR\u001cFo\u001c:f\u001b\u0016$\u0018\rZ1uC\u0006sGMU;o\u0007\",7m[:\u0015\t\u0005=\u0014Q\u000f\t\u0004\u0007\u0006E\u0014bAA:%\t!2\u000b^1uKN#xN]3SK\u0006$WM]%oM>Dq!!\u0015\u000b\u0001\u0004\t\u0019&\u0001\fhKR\\U-_*uCR,WI\\2pI\u0016\u00148\u000b]3d)\u0019\tY(!!\u0002\fB!\u00111FA?\u0013\u0011\ty(!\f\u0003'-+\u0017p\u0015;bi\u0016,enY8eKJ\u001c\u0006/Z2\t\u000f\u0005\r5\u00021\u0001\u0002\u0006\u0006y1m\u001c7GC6LG._*dQ\u0016l\u0017\r\u0005\u0003\u0002,\u0005\u001d\u0015\u0002BAE\u0003[\u0011\u0011d\u0015;bi\u0016\u001cFo\u001c:f\u0007>dg)Y7jYf\u001c6\r[3nC\"9\u0011QR\u0006A\u0002\u0005u\u0013!D:u_J,W*\u001a;bI\u0006$\u0018-A\bTi\u0006$X\rR1uCN{WO]2f!\t\u0019UbE\u0002\u000e\u0003+\u00032a]AL\u0013\r\tI\n\u0018\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005E\u0015!F4fiN#\u0018\r^3Ti>\u0014X-T3uC\u0012\fG/\u0019\u000b\u0007\u0003;\n\t+!*\t\u000f\u0005\rv\u00021\u0001\u0002T\u0005\u00112\u000f^1uKN{WO]2f\u001fB$\u0018n\u001c8t\u0011\u0015Qu\u00021\u0001M\u0003U9W\r^(mIN\u001b\u0007.Z7b\r&dW\rU1uQN$b!a+\u0002J\u0006-\u0007CBAW\u0003o\u000biL\u0004\u0003\u00020\u0006MfbA-\u00022&\tQ,C\u0002\u00026r\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002:\u0006m&\u0001\u0002'jgRT1!!.]!\u0011\ty,!2\u000e\u0005\u0005\u0005'bAAb!\u0006\u0011am]\u0005\u0005\u0003\u000f\f\tM\u0001\u0003QCRD\u0007bBAR!\u0001\u0007\u00111\u000b\u0005\u0006\u0015B\u0001\r\u0001\u0014")
public class StateDataSource
implements TableProvider,
DataSourceRegister,
Logging {
    private SparkSession session;
    private Configuration hadoopConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static List<Path> getOldSchemaFilePaths(StateSourceOptions stateSourceOptions, Configuration hadoopConf) {
        return StateDataSource$.MODULE$.getOldSchemaFilePaths(stateSourceOptions, hadoopConf);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Transform[] inferPartitioning(CaseInsensitiveStringMap x$1) {
        return super.inferPartitioning(x$1);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkSession session$lzycompute() {
        StateDataSource stateDataSource = this;
        synchronized (stateDataSource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.session = SparkSession$.MODULE$.active();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.session;
    }

    private SparkSession session() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.session$lzycompute();
        }
        return this.session;
    }

    private Configuration hadoopConf$lzycompute() {
        StateDataSource stateDataSource = this;
        synchronized (stateDataSource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hadoopConf = this.session().sessionState().newHadoopConf();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hadoopConf;
    }

    private Configuration hadoopConf() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.hadoopConf$lzycompute();
        }
        return this.hadoopConf;
    }

    @Override
    public String shortName() {
        return "statestore";
    }

    public Table getTable(StructType schema, Transform[] partitioning2, Map<String, String> properties) {
        KeyStateEncoderSpec keyStateEncoderSpec;
        StateSourceOptions sourceOptions = StateSourceOptions$.MODULE$.modifySourceOptions(this.hadoopConf(), StateSourceOptions$.MODULE$.apply(this.session(), this.hadoopConf(), properties));
        StateStoreConf stateConf = this.buildStateStoreConf(sourceOptions.resolvedCpLocation(), sourceOptions.batchId());
        StateStoreReaderInfo stateStoreReaderInfo = this.getStoreMetadataAndRunChecks(sourceOptions);
        if (stateStoreReaderInfo.keyStateEncoderSpecOpt().isDefined()) {
            keyStateEncoderSpec = (KeyStateEncoderSpec)stateStoreReaderInfo.keyStateEncoderSpecOpt().get();
        } else {
            StructType keySchema = (StructType)SchemaUtil$.MODULE$.getSchemaAsDataType(schema, "key");
            keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(keySchema);
        }
        KeyStateEncoderSpec keyStateEncoderSpec2 = keyStateEncoderSpec;
        return new StateTable(this.session(), schema, sourceOptions, stateConf, keyStateEncoderSpec2, stateStoreReaderInfo.transformWithStateVariableInfoOpt(), stateStoreReaderInfo.stateStoreColFamilySchemaOpt(), stateStoreReaderInfo.stateSchemaProviderOpt(), stateStoreReaderInfo.joinColFamilyOpt());
    }

    public StructType inferSchema(CaseInsensitiveStringMap options) {
        StructType structType;
        StateSourceOptions sourceOptions = StateSourceOptions$.MODULE$.modifySourceOptions(this.hadoopConf(), StateSourceOptions$.MODULE$.apply(this.session(), this.hadoopConf(), options));
        StateStoreReaderInfo stateStoreReaderInfo = this.getStoreMetadataAndRunChecks(sourceOptions);
        List<Path> oldSchemaFilePaths = StateDataSource$.MODULE$.getOldSchemaFilePaths(sourceOptions, this.hadoopConf());
        Path stateCheckpointLocation = sourceOptions.stateCheckpointLocation();
        try {
            Tuple2 tuple2;
            Enumeration.Value value = sourceOptions.joinSide();
            Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.left();
            Enumeration.Value value3 = value;
            if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                tuple2 = StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema(this.session(), stateCheckpointLocation.toString(), sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$, oldSchemaFilePaths, StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema$default$6());
            } else {
                Enumeration.Value value4 = StateSourceOptions$JoinSideValues$.MODULE$.right();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    tuple2 = StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema(this.session(), stateCheckpointLocation.toString(), sourceOptions.operatorId(), StreamingSymmetricHashJoinHelper$RightSide$.MODULE$, oldSchemaFilePaths, StreamStreamJoinStateHelper$.MODULE$.readKeyValueSchema$default$6());
                } else {
                    Enumeration.Value value6 = StateSourceOptions$JoinSideValues$.MODULE$.none();
                    Enumeration.Value value7 = value;
                    if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                        Predef$.MODULE$.require(stateStoreReaderInfo.stateStoreColFamilySchemaOpt().isDefined());
                        StateStoreColFamilySchema resultSchema = (StateStoreColFamilySchema)stateStoreReaderInfo.stateStoreColFamilySchemaOpt().get();
                        tuple2 = new Tuple2((Object)resultSchema.keySchema(), (Object)resultSchema.valueSchema());
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            StructType keySchema = (StructType)tuple22._1();
            StructType valueSchema = (StructType)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)keySchema, (Object)valueSchema);
            StructType keySchema2 = (StructType)tuple23._1();
            StructType valueSchema2 = (StructType)tuple23._2();
            structType = SchemaUtil$.MODULE$.getSourceSchema(sourceOptions, keySchema2, valueSchema2, stateStoreReaderInfo.transformWithStateVariableInfoOpt(), stateStoreReaderInfo.stateStoreColFamilySchemaOpt());
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                throw StateDataSourceErrors$.MODULE$.failedToReadStateSchema(sourceOptions, throwable2);
            }
            throw throwable;
        }
        return structType;
    }

    public boolean supportsExternalMetadata() {
        return false;
    }

    private StateStoreConf buildStateStoreConf(String checkpointLocation, long batchId) {
        OffsetSeqLog offsetLog = new StreamingQueryCheckpointMetadata(this.session(), checkpointLocation).offsetLog();
        Option option = offsetLog.get(batchId);
        if (option instanceof Some) {
            Some some = (Some)option;
            OffsetSeq value = (OffsetSeq)some.value();
            OffsetSeqMetadata metadata = (OffsetSeqMetadata)value.metadata().getOrElse((Function0 & Serializable)() -> {
                throw StateDataSourceErrors$.MODULE$.offsetMetadataLogUnavailable(batchId, checkpointLocation);
            });
            SQLConf clonedSqlConf = this.session().sessionState().conf().clone();
            OffsetSeqMetadata$.MODULE$.setSessionConf(metadata, clonedSqlConf);
            return StateStoreConf$.MODULE$.apply(clonedSqlConf);
        }
        throw StateDataSourceErrors$.MODULE$.offsetLogUnavailable(batchId, checkpointLocation);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void runStateVarChecks(StateSourceOptions sourceOptions, StateMetadataTableEntry[] stateStoreMetadata) {
        Option<String> option = sourceOptions.stateVarName();
        if (option instanceof Some) {
            Some some = (Some)option;
            String name = (String)some.value();
            Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata)) == 1);
            StateMetadataTableEntry opMetadata = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata));
            String string = opMetadata.operatorName();
            if (string != null) {
                String string2;
                String string3 = string2 = string;
                String string4 = StatefulOperatorsUtils$.MODULE$.SYMMETRIC_HASH_JOIN_EXEC_OP_NAME();
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    Seq<String> possibleStoreNames = SymmetricHashJoinStateManager$.MODULE$.allStateStoreNames((Seq<StreamingSymmetricHashJoinHelper.JoinSide>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StreamingSymmetricHashJoinHelper.JoinSide[]{StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$, StreamingSymmetricHashJoinHelper$RightSide$.MODULE$}));
                    if (possibleStoreNames.contains((Object)name)) return;
                    String errorMsg = "Store name " + name + " not allowed for join operator. Allowed names are " + possibleStoreNames + ". Please remove this option and re-run the query.";
                    throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STORE_NAME(), errorMsg);
                }
            }
            if (string != null) {
                String string5 = string;
                if (StatefulOperatorsUtils$.MODULE$.TRANSFORM_WITH_STATE_OP_NAMES().contains((Object)string5)) {
                    StateDataSource.runTWSChecks$1(opMetadata, sourceOptions);
                    return;
                }
            }
            String errorMsg = "Providing state variable names is only supported with the transformWithState operator. Found operator=" + opMetadata.operatorName() + ". Please remove this option and re-run the query.";
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), errorMsg);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        if (!sourceOptions.readRegisteredTimers()) {
            if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata)) != 1) return;
            if (!StatefulOperatorsUtils$.MODULE$.TRANSFORM_WITH_STATE_OP_NAMES().contains((Object)((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata))).operatorName())) return;
            throw StateDataSourceErrors$.MODULE$.requiredOptionUnspecified("stateVarName");
        }
        Predef$.MODULE$.require(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata)) == 1);
        StateMetadataTableEntry opMetadata = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])stateStoreMetadata));
        String string = opMetadata.operatorName();
        if (string != null) {
            String string6 = string;
            if (StatefulOperatorsUtils$.MODULE$.TRANSFORM_WITH_STATE_OP_NAMES().contains((Object)string6)) {
                StateDataSource.runTWSChecks$1(opMetadata, sourceOptions);
                return;
            }
        }
        String errorMsg = "Providing readRegisteredTimers=true is only supported with the transformWithState operator. Found operator=" + opMetadata.operatorName() + ". Please remove this option and re-run the query.";
        throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.READ_REGISTERED_TIMERS(), errorMsg);
    }

    private StateStoreReaderInfo getStoreMetadataAndRunChecks(StateSourceOptions sourceOptions) {
        StateMetadataTableEntry[] storeMetadata = StateDataSource$.MODULE$.org$apache$spark$sql$execution$datasources$v2$state$StateDataSource$$getStateStoreMetadata(sourceOptions, this.hadoopConf());
        this.runStateVarChecks(sourceOptions, storeMetadata);
        None$ keyStateEncoderSpecOpt = None$.MODULE$;
        None$ stateStoreColFamilySchemaOpt = None$.MODULE$;
        None$ transformWithStateVariableInfoOpt = None$.MODULE$;
        None$ stateSchemaProvider = None$.MODULE$;
        None$ joinColFamilyOpt = None$.MODULE$;
        String timeMode = TimeMode.None().toString();
        Enumeration.Value value = sourceOptions.joinSide();
        Enumeration.Value value2 = StateSourceOptions$JoinSideValues$.MODULE$.none();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            List list;
            ObjectRef stateVarName = ObjectRef.create((Object)((String)sourceOptions.stateVarName().getOrElse((Function0 & Serializable)() -> StateStore$.MODULE$.DEFAULT_COL_FAMILY_NAME())));
            if (storeMetadata.length > 0 && ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))).version() == 2) {
                String opName = ((StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata))).operatorName();
                if (StatefulOperatorsUtils$.MODULE$.TRANSFORM_WITH_STATE_OP_NAMES().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)opName.contains(x$1)))) {
                    List stateVarInfoList;
                    StateMetadataTableEntry storeMetadataEntry = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata));
                    TransformWithStateOperatorProperties operatorProperties = TransformWithStateOperatorProperties$.MODULE$.fromJson(storeMetadataEntry.operatorPropertiesJson());
                    timeMode = operatorProperties.timeMode();
                    if (sourceOptions.readRegisteredTimers()) {
                        stateVarName.elem = (String)TimerStateUtils$.MODULE$.getTimerStateVarNames(timeMode)._1();
                    }
                    Predef$.MODULE$.require((stateVarInfoList = operatorProperties.stateVariables().filter((Function1 & Serializable)stateVar -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$getStoreMetadataAndRunChecks$3(stateVarName, stateVar)))).size() == 1, (Function0 & Serializable)() -> "Failed to find unique state variable info for state variable " + (String)stateVarName$2.elem + " in operator " + sourceOptions.operatorId());
                    TransformWithStateVariableInfo stateVarInfo = (TransformWithStateVariableInfo)stateVarInfoList.head();
                    transformWithStateVariableInfoOpt = new Some((Object)stateVarInfo);
                    List<String> schemaFilePaths = storeMetadataEntry.stateSchemaFilePaths();
                    StateSchemaMetadata stateSchemaMetadata = StateSchemaMetadata$.MODULE$.createStateSchemaMetadata(sourceOptions.stateCheckpointLocation().toString(), this.hadoopConf(), schemaFilePaths);
                    stateSchemaProvider = new Some((Object)new InMemoryStateSchemaProvider(stateSchemaMetadata));
                    list = schemaFilePaths.map((Function1 & Serializable)x$2 -> new Path(x$2));
                } else {
                    String string = opName;
                    String string2 = StatefulOperatorsUtils$.MODULE$.SYMMETRIC_HASH_JOIN_EXEC_OP_NAME();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        joinColFamilyOpt = new Some((Object)((String)stateVarName.elem));
                    }
                    list = StateDataSource$.MODULE$.getOldSchemaFilePaths(sourceOptions, this.hadoopConf());
                }
            } else {
                list = StateDataSource$.MODULE$.getOldSchemaFilePaths(sourceOptions, this.hadoopConf());
            }
            List oldSchemaFilePaths = list;
            try {
                int partitionId = StateStore$.MODULE$.PARTITION_ID_TO_CHECK_SCHEMA();
                Path stateCheckpointLocation = sourceOptions.stateCheckpointLocation();
                StateStoreId storeId = new StateStoreId(stateCheckpointLocation.toString(), sourceOptions.operatorId(), partitionId, sourceOptions.storeName());
                StateStoreProviderId providerId = new StateStoreProviderId(storeId, UUID.randomUUID());
                StateSchemaCompatibilityChecker manager = new StateSchemaCompatibilityChecker(providerId, this.hadoopConf(), oldSchemaFilePaths, StateSchemaCompatibilityChecker$.MODULE$.$lessinit$greater$default$4());
                List<StateStoreColFamilySchema> stateSchema = manager.readSchemaFile();
                StateStoreColFamilySchema resultSchema = (StateStoreColFamilySchema)stateSchema.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$getStoreMetadataAndRunChecks$6(stateVarName, x$3))).head();
                keyStateEncoderSpecOpt = new Some((Object)this.getKeyStateEncoderSpec(resultSchema, storeMetadata));
                stateStoreColFamilySchemaOpt = new Some((Object)resultSchema);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable throwable3 = throwable;
                if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                    throw StateDataSourceErrors$.MODULE$.failedToReadStateSchema(sourceOptions, throwable2);
                }
                throw throwable;
            }
        }
        return new StateStoreReaderInfo((Option<KeyStateEncoderSpec>)keyStateEncoderSpecOpt, (Option<StateStoreColFamilySchema>)stateStoreColFamilySchemaOpt, (Option<TransformWithStateVariableInfo>)transformWithStateVariableInfoOpt, (Option<StateSchemaProvider>)stateSchemaProvider, (Option<String>)joinColFamilyOpt);
    }

    private KeyStateEncoderSpec getKeyStateEncoderSpec(StateStoreColFamilySchema colFamilySchema, StateMetadataTableEntry[] storeMetadata) {
        KeyStateEncoderSpec keyStateEncoderSpec;
        if (storeMetadata.length == 0) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Metadata for state store not found, possible cause is this checkpoint is created by older version of spark. If the query has session window aggregation, the state can't be read correctly and runtime exception will be thrown. Run the streaming query in newer spark version to generate state metadata can fix the issue.");
            keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(colFamilySchema.keySchema());
        } else {
            Predef$.MODULE$.require(storeMetadata.length == 1);
            StateMetadataTableEntry storeMetadataEntry = (StateMetadataTableEntry)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])storeMetadata));
            if (storeMetadataEntry.version() == 1 && storeMetadataEntry.numColsPrefixKey() == 0) {
                keyStateEncoderSpec = new NoPrefixKeyStateEncoderSpec(colFamilySchema.keySchema());
            } else if (storeMetadataEntry.version() == 1 && storeMetadataEntry.numColsPrefixKey() > 0) {
                keyStateEncoderSpec = new PrefixKeyScanStateEncoderSpec(colFamilySchema.keySchema(), storeMetadataEntry.numColsPrefixKey());
            } else if (storeMetadataEntry.version() == 2) {
                Predef$.MODULE$.require(colFamilySchema.keyStateEncoderSpec().isDefined());
                keyStateEncoderSpec = (KeyStateEncoderSpec)colFamilySchema.keyStateEncoderSpec().get();
            } else {
                throw StateDataSourceErrors$.MODULE$.internalError("Failed to read key state encoder spec for operator=" + storeMetadataEntry.operatorId());
            }
        }
        NoPrefixKeyStateEncoderSpec keyStateEncoderSpec2 = keyStateEncoderSpec;
        return keyStateEncoderSpec2;
    }

    public static final /* synthetic */ boolean $anonfun$runStateVarChecks$1(String stateVarName$1, TransformWithStateVariableInfo stateVar) {
        String string = stateVar.stateName();
        String string2 = stateVarName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final void runTWSChecks$1(StateMetadataTableEntry opMetadata, StateSourceOptions sourceOptions$1) {
        String operatorProperties = opMetadata.operatorPropertiesJson();
        if (operatorProperties.isEmpty()) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), "No state variable names are defined for the transformWithState operator");
        }
        TransformWithStateOperatorProperties twsOperatorProperties = TransformWithStateOperatorProperties$.MODULE$.fromJson(operatorProperties);
        String timeMode = twsOperatorProperties.timeMode();
        if (sourceOptions$1.readRegisteredTimers()) {
            String string = timeMode;
            String string2 = TimeMode.None().toString();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.READ_REGISTERED_TIMERS(), "Registered timers are not available in TimeMode=None.");
            }
        }
        String stateVarName = sourceOptions$1.readRegisteredTimers() ? (String)TimerStateUtils$.MODULE$.getTimerStateVarNames(timeMode)._1() : (String)sourceOptions$1.stateVarName().get();
        List<TransformWithStateVariableInfo> stateVars = twsOperatorProperties.stateVariables();
        List stateVarInfo = stateVars.filter((Function1 & Serializable)stateVar -> BoxesRunTime.boxToBoolean((boolean)StateDataSource.$anonfun$runStateVarChecks$1(stateVarName, stateVar)));
        if (stateVarInfo.size() != 1) {
            throw StateDataSourceErrors$.MODULE$.invalidOptionValue(StateSourceOptions$.MODULE$.STATE_VAR_NAME(), "State variable " + stateVarName + " is not defined for the transformWithState operator.");
        }
    }

    public static final /* synthetic */ boolean $anonfun$getStoreMetadataAndRunChecks$3(ObjectRef stateVarName$2, TransformWithStateVariableInfo stateVar) {
        String string = stateVar.stateName();
        String string2 = (String)stateVarName$2.elem;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getStoreMetadataAndRunChecks$6(ObjectRef stateVarName$2, StateStoreColFamilySchema x$3) {
        String string = x$3.colFamilyName();
        String string2 = (String)stateVarName$2.elem;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public StateDataSource() {
        Logging.$init$((Logging)this);
    }
}

