/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.SubstringIndex$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.CollationSupport;
import org.apache.spark.sql.internal.types.StringTypeNonCSAICollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, delim, count) - Returns the substring from `str` before `count` occurrences of the delimiter `delim`.\n      If `count` is positive, everything to the left of the final delimiter (counting from the\n      left) is returned. If `count` is negative, everything to the right of the final delimiter\n      (counting from the right) is returned. The function substring_index performs a case-sensitive match\n      when searching for `delim`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('www.apache.org', '.', 2);\n       www.apache\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t}a\u0001\u0002\u0014(\u0001RB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011!1\u0006A!f\u0001\n\u0003y\u0005\u0002C,\u0001\u0005#\u0005\u000b\u0011\u0002)\t\u000ba\u0003A\u0011A-\t\u000by\u0003A\u0011I0\t\u0011\r\u0004\u0001R1A\u0005\u0006\u0011DQ\u0001\u001b\u0001\u0005B%DQ\u0001\u001d\u0001\u0005BEDQ\u0001\u001f\u0001\u0005B}CQ!\u001f\u0001\u0005B=CQA\u001f\u0001\u0005B=CQa\u001f\u0001\u0005B=CQ\u0001 \u0001\u0005BuDq!!\u0004\u0001\t\u0003\ny\u0001C\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005\u0005\u0003\u0001\"\u0015\u0002D!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u00037\u0002\u0011\u0013!C\u0001\u0003;B\u0011\"a\u001d\u0001#\u0003%\t!!\u0018\t\u0013\u0005U\u0004!%A\u0005\u0002\u0005u\u0003\"CA<\u0001\u0005\u0005I\u0011IA=\u0011!\tI\tAA\u0001\n\u0003!\u0007\"CAF\u0001\u0005\u0005I\u0011AAG\u0011%\t\u0019\nAA\u0001\n\u0003\n)\nC\u0005\u0002$\u0002\t\t\u0011\"\u0001\u0002&\"I\u0011\u0011\u0016\u0001\u0002\u0002\u0013\u0005\u00131\u0016\u0005\n\u0003_\u0003\u0011\u0011!C!\u0003c;\u0011\"!6(\u0003\u0003E\t!a6\u0007\u0011\u0019:\u0013\u0011!E\u0001\u00033Da\u0001\u0017\u0011\u0005\u0002\u0005E\b\"CAzA\u0005\u0005IQIA{\u0011%\t9\u0010IA\u0001\n\u0003\u000bI\u0010C\u0005\u0003\u0002\u0001\n\t\u0011\"!\u0003\u0004!I!Q\u0003\u0011\u0002\u0002\u0013%!q\u0003\u0002\u000f'V\u00147\u000f\u001e:j]\u001eLe\u000eZ3y\u0015\tA\u0013&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0016,\u0003!\u0019\u0017\r^1msN$(B\u0001\u0017.\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003]=\nQa\u001d9be.T!\u0001M\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0014aA8sO\u000e\u00011#\u0002\u00016sq\u0012\u0005C\u0001\u001c8\u001b\u00059\u0013B\u0001\u001d(\u0005E!VM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003miJ!aO\u0014\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002D\u0017:\u0011A)\u0013\b\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000fN\na\u0001\u0010:p_Rt\u0014\"A \n\u0005)s\u0014a\u00029bG.\fw-Z\u0005\u0003\u00196\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!A\u0013 \u0002\u000fM$(/\u0012=qeV\t\u0001\u000b\u0005\u00027#&\u0011!k\n\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017\u0001C:ue\u0016C\bO\u001d\u0011\u0002\u0013\u0011,G.[7FqB\u0014\u0018A\u00033fY&lW\t\u001f9sA\u0005I1m\\;oi\u0016C\bO]\u0001\u000bG>,h\u000e^#yaJ\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003[7rk\u0006C\u0001\u001c\u0001\u0011\u0015qu\u00011\u0001Q\u0011\u0015!v\u00011\u0001Q\u0011\u00151v\u00011\u0001Q\u00039qW\u000f\u001c7J]R|G.\u001a:b]R,\u0012\u0001\u0019\t\u0003{\u0005L!A\u0019 \u0003\u000f\t{w\u000e\\3b]\u0006Y1m\u001c7mCRLwN\\%e+\u0005)\u0007CA\u001fg\u0013\t9gHA\u0002J]R\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002UB\u00111N\\\u0007\u0002Y*\u0011QnK\u0001\u0006if\u0004Xm]\u0005\u0003_2\u0014\u0001\u0002R1uCRK\b/Z\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#\u0001:\u0011\u0007\r\u001bX/\u0003\u0002u\u001b\n\u00191+Z9\u0011\u0005-4\u0018BA<m\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u000ed_:$X\r\u001f;J]\u0012,\u0007/\u001a8eK:$hi\u001c7eC\ndW-A\u0003gSJ\u001cH/\u0001\u0004tK\u000e|g\u000eZ\u0001\u0006i\"L'\u000fZ\u0001\u000baJ,G\u000f^=OC6,W#\u0001@\u0011\u0007}\f9A\u0004\u0003\u0002\u0002\u0005\r\u0001CA#?\u0013\r\t)AP\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00111\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015a(\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0005\u0002\u0012\u0005]\u00111DA\u0010!\ri\u00141C\u0005\u0004\u0003+q$aA!os\"9\u0011\u0011D\tA\u0002\u0005E\u0011aA:ue\"9\u0011QD\tA\u0002\u0005E\u0011!\u00023fY&l\u0007bBA\u0011#\u0001\u0007\u0011\u0011C\u0001\u0006G>,h\u000e^\u0001\nI><UM\\\"pI\u0016$b!a\n\u00024\u0005u\u0002\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055r%A\u0004d_\u0012,w-\u001a8\n\t\u0005E\u00121\u0006\u0002\t\u000bb\u0004(oQ8eK\"9\u0011Q\u0007\nA\u0002\u0005]\u0012aA2uqB!\u0011\u0011FA\u001d\u0013\u0011\tY$a\u000b\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011q\b\nA\u0002\u0005\u001d\u0012AA3w\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0004[\u0003\u000b\nI%!\u0014\t\r\u0005\u001d3\u00031\u0001Q\u0003!qWm\u001e$jeN$\bBBA&'\u0001\u0007\u0001+A\u0005oK^\u001cVmY8oI\"1\u0011qJ\nA\u0002A\u000b\u0001B\\3x)\"L'\u000fZ\u0001\u0005G>\u0004\u0018\u0010F\u0004[\u0003+\n9&!\u0017\t\u000f9#\u0002\u0013!a\u0001!\"9A\u000b\u0006I\u0001\u0002\u0004\u0001\u0006b\u0002,\u0015!\u0003\u0005\r\u0001U\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyFK\u0002Q\u0003CZ#!a\u0019\u0011\t\u0005\u0015\u0014qN\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[r\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011OA4\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA>!\u0011\ti(a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0007\u000bA\u0001\\1oO*\u0011\u0011QQ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\n\u0005}\u0014\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003#\ty\t\u0003\u0005\u0002\u0012j\t\t\u00111\u0001f\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0013\t\u0007\u00033\u000by*!\u0005\u000e\u0005\u0005m%bAAO}\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0005\u00161\u0014\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002a\u0003OC\u0011\"!%\u001d\u0003\u0003\u0005\r!!\u0005\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003w\ni\u000b\u0003\u0005\u0002\u0012v\t\t\u00111\u0001f\u0003\u0019)\u0017/^1mgR\u0019\u0001-a-\t\u0013\u0005Ee$!AA\u0002\u0005E\u0001f\u0005\u0001\u00028\u0006u\u0016qXAb\u0003\u000b\fI-a3\u0002P\u0006E\u0007c\u0001\u001c\u0002:&\u0019\u00111X\u0014\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011\u0011Y\u0001\u0004\n*\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015tiJd\u0003\u0005Z3mS6d\u0003eY8v]RL\u0003%\f\u0011SKR,(O\\:!i\",\u0007e];cgR\u0014\u0018N\\4!MJ|W\u000e\t1tiJ\u0004\u0007EY3g_J,\u0007\u0005Y2pk:$\b\rI8dGV\u0014(/\u001a8dKN\u0004sN\u001a\u0011uQ\u0016\u0004C-\u001a7j[&$XM\u001d\u0011aI\u0016d\u0017.\u001c1/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0013\u001a\u0004\u0003mY8v]R\u0004\u0007%[:!a>\u001c\u0018\u000e^5wK2\u0002SM^3ssRD\u0017N\\4!i>\u0004C\u000f[3!Y\u00164G\u000fI8gAQDW\r\t4j]\u0006d\u0007\u0005Z3mS6LG/\u001a:!Q\r|WO\u001c;j]\u001e\u0004cM]8nAQDWM\u0003\u0011!A\u0001\u0002\u0003\u0005\\3gi&\u0002\u0013n\u001d\u0011sKR,(O\\3e]\u0001Je\r\t1d_VtG\u000f\u0019\u0011jg\u0002rWmZ1uSZ,G\u0006I3wKJLH\u000f[5oO\u0002\"x\u000e\t;iK\u0002\u0012\u0018n\u001a5uA=4\u0007\u0005\u001e5fA\u0019Lg.\u00197!I\u0016d\u0017.\\5uKJT\u0001\u0005\t\u0011!A\u0001B3m\\;oi&tw\r\t4s_6\u0004C\u000f[3!e&<\u0007\u000e^\u0015!SN\u0004#/\u001a;ve:,GM\f\u0011UQ\u0016\u0004c-\u001e8di&|g\u000eI:vEN$(/\u001b8h?&tG-\u001a=!a\u0016\u0014hm\u001c:ng\u0002\n\u0007eY1tK6\u001aXM\\:ji&4X\rI7bi\u000eD'\u0002\t\u0011!A\u0001\u0002s\u000f[3oAM,\u0017M]2iS:<\u0007EZ8sA\u0001$W\r\\5nA:R\u0001\u0005I\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011qY\u0001U\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":so^</CB\f7\r[3/_J<w\u0005\f\u0011(]\u001db\u0003EM\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A]<xOL1qC\u000eDWM\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\ti-A\u00032]Ur\u0003'A\u0003he>,\b/\t\u0002\u0002T\u0006a1\u000f\u001e:j]\u001e|f-\u001e8dg\u0006q1+\u001e2tiJLgnZ%oI\u0016D\bC\u0001\u001c!'\u0015\u0001\u00131\\At!!\ti.a9Q!BSVBAAp\u0015\r\t\tOP\u0001\beVtG/[7f\u0013\u0011\t)/a8\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0002j\u0006=XBAAv\u0015\u0011\ti/a!\u0002\u0005%|\u0017b\u0001'\u0002lR\u0011\u0011q[\u0001\ti>\u001cFO]5oOR\u0011\u00111P\u0001\u0006CB\u0004H.\u001f\u000b\b5\u0006m\u0018Q`A\u0000\u0011\u0015q5\u00051\u0001Q\u0011\u0015!6\u00051\u0001Q\u0011\u001516\u00051\u0001Q\u0003\u001d)h.\u00199qYf$BA!\u0002\u0003\u0012A)QHa\u0002\u0003\f%\u0019!\u0011\u0002 \u0003\r=\u0003H/[8o!\u0019i$Q\u0002)Q!&\u0019!q\u0002 \u0003\rQ+\b\u000f\\34\u0011!\u0011\u0019\u0002JA\u0001\u0002\u0004Q\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0004\t\u0005\u0003{\u0012Y\"\u0003\u0003\u0003\u001e\u0005}$AB(cU\u0016\u001cG\u000f")
public class SubstringIndex
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private int collationId;
    private final Expression strExpr;
    private final Expression delimExpr;
    private final Expression countExpr;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(SubstringIndex x$0) {
        return SubstringIndex$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, SubstringIndex> tupled() {
        return SubstringIndex$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, SubstringIndex>>> curried() {
        return SubstringIndex$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression strExpr() {
        return this.strExpr;
    }

    public Expression delimExpr() {
        return this.delimExpr;
    }

    public Expression countExpr() {
        return this.countExpr;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    private int collationId$lzycompute() {
        SubstringIndex substringIndex = this;
        synchronized (substringIndex) {
            if (!this.bitmap$0) {
                this.collationId = ((StringType)this.first().dataType()).collationId();
                this.bitmap$0 = true;
            }
        }
        return this.collationId;
    }

    public final int collationId() {
        if (!this.bitmap$0) {
            return this.collationId$lzycompute();
        }
        return this.collationId;
    }

    @Override
    public DataType dataType() {
        return this.strExpr().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)new .colon.colon((Object)StringTypeNonCSAICollation$.MODULE$.apply(true), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.children().forall((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)x$23.contextIndependentFoldable()));
    }

    @Override
    public Expression first() {
        return this.strExpr();
    }

    @Override
    public Expression second() {
        return this.delimExpr();
    }

    @Override
    public Expression third() {
        return this.countExpr();
    }

    @Override
    public String prettyName() {
        return "substring_index";
    }

    @Override
    public Object nullSafeEval(Object str, Object delim, Object count) {
        return CollationSupport.SubstringIndex.exec((UTF8String)((UTF8String)str), (UTF8String)((UTF8String)delim), (int)BoxesRunTime.unboxToInt((Object)count), (int)this.collationId());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(str, delim, count) -> CollationSupport.SubstringIndex.genCode((String)str, (String)delim, (String)count, (int)this.collationId()));
    }

    @Override
    public SubstringIndex withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public SubstringIndex copy(Expression strExpr, Expression delimExpr, Expression countExpr) {
        return new SubstringIndex(strExpr, delimExpr, countExpr);
    }

    public Expression copy$default$1() {
        return this.strExpr();
    }

    public Expression copy$default$2() {
        return this.delimExpr();
    }

    public Expression copy$default$3() {
        return this.countExpr();
    }

    @Override
    public String productPrefix() {
        return "SubstringIndex";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.strExpr();
            }
            case 1: {
                return this.delimExpr();
            }
            case 2: {
                return this.countExpr();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SubstringIndex;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "strExpr";
            }
            case 1: {
                return "delimExpr";
            }
            case 2: {
                return "countExpr";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SubstringIndex)) return false;
        boolean bl = true;
        if (!bl) return false;
        SubstringIndex substringIndex = (SubstringIndex)x$1;
        Expression expression = this.strExpr();
        Expression expression2 = substringIndex.strExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimExpr();
        Expression expression4 = substringIndex.delimExpr();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.countExpr();
        Expression expression6 = substringIndex.countExpr();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substringIndex.canEqual(this)) return false;
        return true;
    }

    public SubstringIndex(Expression strExpr, Expression delimExpr, Expression countExpr) {
        this.strExpr = strExpr;
        this.delimExpr = delimExpr;
        this.countExpr = countExpr;
        ExpectsInputTypes.$init$(this);
    }
}

