/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.frequencies.ItemsSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ApproxTopKEstimate$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxTopK$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(state, k) - Returns top k items with their frequency.\n      `k` An optional INTEGER literal greater than 0. If k is not specified, it defaults to 5.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(approx_top_k_accumulate(expr)) FROM VALUES (0), (0), (1), (1), (2), (3), (4), (4) AS tab(expr);\n       [{\"item\":0,\"count\":2},{\"item\":4,\"count\":2},{\"item\":1,\"count\":2},{\"item\":2,\"count\":1},{\"item\":3,\"count\":1}]\n\n      > SELECT _FUNC_(approx_top_k_accumulate(expr), 2) FROM VALUES 'a', 'b', 'c', 'c', 'c', 'c', 'd', 'd' tab(expr);\n       [{\"item\":\"c\",\"count\":4},{\"item\":\"d\",\"count\":2}]\n  ", group="misc_funcs", since="4.1.0")
@ScalaSignature(bytes="\u0006\u0005\tea\u0001\u0002\u0013&\u0001JB\u0001B\u0015\u0001\u0003\u0016\u0004%\ta\u0015\u0005\t/\u0002\u0011\t\u0012)A\u0005)\"A\u0001\f\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005Z\u0001\tE\t\u0015!\u0003U\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015Q\u0006\u0001\"\u0001`\u0011\u0015Q\u0006\u0001\"\u0001h\u0011!I\u0007\u0001#b\u0001\n\u0013Q\u0007\"B9\u0001\t\u0003\u001a\u0006\"\u0002:\u0001\t\u0003\u001a\u0006\"B:\u0001\t\u0003\"\b\"B>\u0001\t\u0013a\bbBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\u0007\u0003\u001b\u0001A\u0011\t6\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!9\u0011Q\u0005\u0001\u0005R\u0005\u001d\u0002bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011%\ty\u0005AA\u0001\n\u0003\t\t\u0006C\u0005\u0002X\u0001\t\n\u0011\"\u0001\u0002Z!I\u0011q\u000e\u0001\u0012\u0002\u0013\u0005\u0011\u0011\f\u0005\n\u0003c\u0002\u0011\u0011!C!\u0003gB\u0011\"a!\u0001\u0003\u0003%\t!!\"\t\u0013\u0005\u001d\u0005!!A\u0005\u0002\u0005%\u0005\"CAH\u0001\u0005\u0005I\u0011IAI\u0011%\ty\nAA\u0001\n\u0003\t\t\u000bC\u0005\u0002&\u0002\t\t\u0011\"\u0011\u0002(\"I\u00111\u0016\u0001\u0002\u0002\u0013\u0005\u0013QV\u0004\n\u0003#,\u0013\u0011!E\u0001\u0003'4\u0001\u0002J\u0013\u0002\u0002#\u0005\u0011Q\u001b\u0005\u00075z!\t!!<\t\u0013\u0005=h$!A\u0005F\u0005E\b\"CAz=\u0005\u0005I\u0011QA{\u0011%\tYPHA\u0001\n\u0003\u000bi\u0010C\u0005\u0003\u0010y\t\t\u0011\"\u0003\u0003\u0012\t\u0011\u0012\t\u001d9s_b$v\u000e]&FgRLW.\u0019;f\u0015\t1s%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0015*\u0003!\u0019\u0017\r^1msN$(B\u0001\u0016,\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Y5\nQa\u001d9be.T!AL\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0014aA8sO\u000e\u00011C\u0002\u00014ou\u0002e\t\u0005\u00025k5\tQ%\u0003\u00027K\t\u0001\")\u001b8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003qmj\u0011!\u000f\u0006\u0003u\u0015\nqaY8eK\u001e,g.\u0003\u0002=s\ty1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000e\u0005\u00025}%\u0011q(\n\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n9\u0001K]8ek\u000e$\bCA$P\u001d\tAUJ\u0004\u0002J\u00196\t!J\u0003\u0002Lc\u00051AH]8pizJ\u0011aQ\u0005\u0003\u001d\n\u000bq\u0001]1dW\u0006<W-\u0003\u0002Q#\na1+\u001a:jC2L'0\u00192mK*\u0011aJQ\u0001\u0006gR\fG/Z\u000b\u0002)B\u0011A'V\u0005\u0003-\u0016\u0012!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019H/\u0019;fA\u0005\t1.\u0001\u0002lA\u00051A(\u001b8jiz\"2\u0001X/_!\t!\u0004\u0001C\u0003S\u000b\u0001\u0007A\u000bC\u0003Y\u000b\u0001\u0007A\u000bF\u0002]A\nDQ!\u0019\u0004A\u0002Q\u000bQa\u00195jY\u0012DQa\u0019\u0004A\u0002\u0011\fA\u0001^8q\u0017B\u0011\u0011)Z\u0005\u0003M\n\u00131!\u00138u)\ta\u0006\u000eC\u0003b\u000f\u0001\u0007A+\u0001\u0007ji\u0016lG)\u0019;b)f\u0004X-F\u0001l!\taw.D\u0001n\u0015\tq\u0017&A\u0003usB,7/\u0003\u0002q[\nAA)\u0019;b)f\u0004X-\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018AC5oaV$H+\u001f9fgV\tQ\u000fE\u0002HmbL!a^)\u0003\u0007M+\u0017\u000f\u0005\u0002ms&\u0011!0\u001c\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\fac\u00195fG.\u001cF/\u0019;f\r&,G\u000eZ!oIRK\b/\u001a\u000b\u0004{\u0006\u001d\u0001c\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002\u001d\n\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0004\u0003\u000by(a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\t\u000bIc\u0001\u0019\u0001+\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003u\f\u0001\u0002Z1uCRK\b/Z\u0001\u0005KZ\fG\u000e\u0006\u0003\u0002\u0014\u0005e\u0001cA!\u0002\u0016%\u0019\u0011q\u0003\"\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u001c=\u0001\n\u00111\u0001\u0002\u001e\u0005)\u0011N\u001c9viB!\u0011qDA\u0011\u001b\u00059\u0013bAA\u0012O\tY\u0011J\u001c;fe:\fGNU8x\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0003U\u0003S\ti\u0003\u0003\u0004\u0002,A\u0001\r\u0001V\u0001\t]\u0016<8\u000b^1uK\"1\u0011q\u0006\tA\u0002Q\u000bAA\\3x\u0017\u0006Aa.\u001e7mC\ndW-\u0006\u0002\u00026A\u0019\u0011)a\u000e\n\u0007\u0005e\"IA\u0004C_>dW-\u00198\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-\u0006\u0002\u0002@A!\u0011\u0011IA%\u001d\u0011\t\u0019%!\u0012\u0011\u0005%\u0013\u0015bAA$\u0005\u00061\u0001K]3eK\u001aLA!a\u0013\u0002N\t11\u000b\u001e:j]\u001eT1!a\u0012C\u0003\u0011\u0019w\u000e]=\u0015\u000bq\u000b\u0019&!\u0016\t\u000fI\u001b\u0002\u0013!a\u0001)\"9\u0001l\u0005I\u0001\u0002\u0004!\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u00037R3\u0001VA/W\t\ty\u0006\u0005\u0003\u0002b\u0005-TBAA2\u0015\u0011\t)'a\u001a\u0002\u0013Ut7\r[3dW\u0016$'bAA5\u0005\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00141\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\u0004\u0003BA<\u0003\u0003k!!!\u001f\u000b\t\u0005m\u0014QP\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0000\u0005!!.\u0019<b\u0013\u0011\tY%!\u001f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0003\u0011\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0014\u0005-\u0005\u0002CAG1\u0005\u0005\t\u0019\u00013\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\n\u0005\u0004\u0002\u0016\u0006m\u00151C\u0007\u0003\u0003/S1!!'C\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003;\u000b9J\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001b\u0003GC\u0011\"!$\u001b\u0003\u0003\u0005\r!a\u0005\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003k\nI\u000b\u0003\u0005\u0002\u000en\t\t\u00111\u0001e\u0003\u0019)\u0017/^1mgR!\u0011QGAX\u0011%\ti\tHA\u0001\u0002\u0004\t\u0019\u0002K\n\u0001\u0003g\u000bI,a/\u0002@\u0006\u0005\u0017QYAd\u0003\u0017\fi\rE\u00025\u0003kK1!a.&\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!0\u0002\u0003\u000fR\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\fG/\u001a\u0017!W&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011u_B\u00043\u000eI5uK6\u001c\be^5uQ\u0002\"\b.Z5sA\u0019\u0014X-];f]\u000eLhF\u0003\u0011!A\u0001\u0002\u0003\u0005Y6aA\u0005s\u0007e\u001c9uS>t\u0017\r\u001c\u0011J\u001dR+u)\u0012*!Y&$XM]1mA\u001d\u0014X-\u0019;fe\u0002\"\b.\u00198!a9\u0002\u0013J\u001a\u0011lA%\u001c\bE\\8uAM\u0004XmY5gS\u0016$G\u0006I5uA\u0011,g-Y;miN\u0004Co\u001c\u00116])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\u0019-AB(\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n\u0007\u000f\u001d:pq~#x\u000e]0l?\u0006\u001c7-^7vY\u0006$X\rK3yaJL\u0013\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003\u0006M\u0015-A!\u0002\u0014\u0006\f\u0011)c%b\u0003\u0005K\u0019*Y\u0001B#'\u000b\u0017!QMJC\u0006\t\u00155S1\u0002\u0003\u0006N\u0015!\u0003N\u0003C/\u00192)Kb\u0004(/K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7n\u0014\u0013\u000e^3nEi\u0002DFI2pk:$(E\u000f\u001a~Ym\u0014\u0013\u000e^3nEi\"DFI2pk:$(E\u000f\u001a~Ym\u0014\u0013\u000e^3nEi\nDFI2pk:$(E\u000f\u001a~Ym\u0014\u0013\u000e^3nEi\u0012DFI2pk:$(EO\u0019~Ym\u0014\u0013\u000e^3nEi\u001aDFI2pk:$(EO\u0019~;*Q\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u00199qe>Dx\f^8q?.|\u0016mY2v[Vd\u0017\r^3)Kb\u0004(/\u000b\u0017!e%\u0002cIU(NAY\u000bE*V#TA\u001d\nw\u0005\f\u0011(E\u001eb\u0003eJ2(Y\u0001:3m\n\u0017!O\r<C\u0006I\u0014dO1\u0002s\u0005Z\u0014-A\u001d\"w\u0005\t;bE\"*\u0007\u0010\u001d:*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6PI5uK6\u0014#HI2#Y\t\u001aw.\u001e8uEi\"T\u0010L>#SR,WN\t\u001e#I\nb#eY8v]R\u0014#HM?^\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAe\u0003)i\u0017n]2`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003\u001f\fQ\u0001\u000e\u00182]A\n!#\u00119qe>DHk\u001c9L\u000bN$\u0018.\\1uKB\u0011AGH\n\u0006=\u0005]\u00171\u001d\t\b\u00033\fy\u000e\u0016+]\u001b\t\tYNC\u0002\u0002^\n\u000bqA];oi&lW-\u0003\u0003\u0002b\u0006m'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011Q]Av\u001b\t\t9O\u0003\u0003\u0002j\u0006u\u0014AA5p\u0013\r\u0001\u0016q\u001d\u000b\u0003\u0003'\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003k\nQ!\u00199qYf$R\u0001XA|\u0003sDQAU\u0011A\u0002QCQ\u0001W\u0011A\u0002Q\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0000\n-\u0001#B!\u0003\u0002\t\u0015\u0011b\u0001B\u0002\u0005\n1q\n\u001d;j_:\u0004R!\u0011B\u0004)RK1A!\u0003C\u0005\u0019!V\u000f\u001d7fe!A!Q\u0002\u0012\u0002\u0002\u0003\u0007A,A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\u0005\u0011\t\u0005]$QC\u0005\u0005\u0005/\tIH\u0001\u0004PE*,7\r\u001e")
public class ApproxTopKEstimate
extends BinaryExpression
implements CodegenFallback,
ImplicitCastInputTypes,
Serializable {
    private DataType itemDataType;
    private final Expression state;
    private final Expression k;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ApproxTopKEstimate x$0) {
        return ApproxTopKEstimate$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, ApproxTopKEstimate> tupled() {
        return ApproxTopKEstimate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ApproxTopKEstimate>> curried() {
        return ApproxTopKEstimate$.MODULE$.curried();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    public Expression state() {
        return this.state;
    }

    public Expression k() {
        return this.k;
    }

    private DataType itemDataType$lzycompute() {
        ApproxTopKEstimate approxTopKEstimate = this;
        synchronized (approxTopKEstimate) {
            if (!this.bitmap$0) {
                this.itemDataType = ((StructType)this.state().dataType()).apply(1).dataType();
                this.bitmap$0 = true;
            }
        }
        return this.itemDataType;
    }

    private DataType itemDataType() {
        if (!this.bitmap$0) {
            return this.itemDataType$lzycompute();
        }
        return this.itemDataType;
    }

    @Override
    public Expression left() {
        return this.state();
    }

    @Override
    public Expression right() {
        return this.k();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)StructType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    private TypeCheckResult checkStateFieldAndType(Expression state) {
        StructType stateStructType = (StructType)state.dataType();
        if (stateStructType.length() != 3) {
            return new TypeCheckResult.TypeCheckFailure("State must be a struct with 3 fields. Expected struct: struct<sketch:binary,itemDataType:any,maxItemsTracked:int>. Got: " + state.dataType().simpleString());
        }
        DataType dataType = ((StructField)stateStructType.head()).dataType();
        BinaryType$ binaryType$ = BinaryType$.MODULE$;
        if (dataType == null ? binaryType$ != null : !dataType.equals(binaryType$)) {
            return new TypeCheckResult.TypeCheckFailure("State struct must have the first field to be binary. Got: " + ((StructField)stateStructType.head()).dataType().simpleString());
        }
        if (!ApproxTopK$.MODULE$.isDataTypeSupported(this.itemDataType())) {
            return new TypeCheckResult.TypeCheckFailure("State struct must have the second field to be a supported data type. Got: " + this.itemDataType().simpleString());
        }
        DataType dataType2 = stateStructType.apply(2).dataType();
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        if (dataType2 == null ? integerType$ != null : !dataType2.equals(integerType$)) {
            return new TypeCheckResult.TypeCheckFailure("State struct must have the third field to be int. Got: " + stateStructType.apply(2).dataType().simpleString());
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        if (defaultCheck.isFailure()) {
            return defaultCheck;
        }
        TypeCheckResult stateCheck = this.checkStateFieldAndType(this.state());
        if (stateCheck.isFailure()) {
            return stateCheck;
        }
        if (!this.k().foldable()) {
            return new TypeCheckResult.TypeCheckFailure("K must be a constant literal");
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public DataType dataType() {
        return ApproxTopK$.MODULE$.getResultDataType(this.itemDataType());
    }

    @Override
    public Object eval(InternalRow input) {
        ApproxTopK$.MODULE$.checkExpressionNotNull(this.k(), "k");
        Object stateEval = this.left().eval(input);
        Object kEval = this.right().eval(input);
        byte[] dataSketchBytes = ((InternalRow)stateEval).getBinary(0);
        int maxItemsTrackedVal = ((InternalRow)stateEval).getInt(2);
        int kVal = BoxesRunTime.unboxToInt((Object)kEval);
        ApproxTopK$.MODULE$.checkK(kVal);
        ApproxTopK$.MODULE$.checkMaxItemsTracked(maxItemsTrackedVal, kVal);
        ItemsSketch itemsSketch = ItemsSketch.getInstance((Memory)Memory.wrap((byte[])dataSketchBytes), ApproxTopK$.MODULE$.genSketchSerDe(this.itemDataType()));
        return ApproxTopK$.MODULE$.genEvalResult((ItemsSketch<Object>)itemsSketch, kVal, this.itemDataType());
    }

    @Override
    public Expression withNewChildrenInternal(Expression newState, Expression newK) {
        return this.copy(newState, newK);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "approx_top_k_estimate");
    }

    public ApproxTopKEstimate copy(Expression state, Expression k) {
        return new ApproxTopKEstimate(state, k);
    }

    public Expression copy$default$1() {
        return this.state();
    }

    public Expression copy$default$2() {
        return this.k();
    }

    @Override
    public String productPrefix() {
        return "ApproxTopKEstimate";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.state();
            }
            case 1: {
                return this.k();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproxTopKEstimate;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "state";
            }
            case 1: {
                return "k";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproxTopKEstimate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproxTopKEstimate approxTopKEstimate = (ApproxTopKEstimate)x$1;
        Expression expression = this.state();
        Expression expression2 = approxTopKEstimate.state();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.k();
        Expression expression4 = approxTopKEstimate.k();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!approxTopKEstimate.canEqual(this)) return false;
        return true;
    }

    public ApproxTopKEstimate(Expression state, Expression k) {
        this.state = state;
        this.k = k;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public ApproxTopKEstimate(Expression child, int topK) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)topK)));
    }

    public ApproxTopKEstimate(Expression child) {
        this(child, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproxTopK$.MODULE$.DEFAULT_K())));
    }
}

