/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.netty;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.ExecutorDeadException;
import org.apache.spark.SSLOptions;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.network.BlockDataManager;
import org.apache.spark.network.BlockTransferService;
import org.apache.spark.network.TransportContext;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.buffer.NioManagedBuffer;
import org.apache.spark.network.client.RpcResponseCallback;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportClientFactory;
import org.apache.spark.network.crypto.AuthClientBootstrap;
import org.apache.spark.network.crypto.AuthServerBootstrap;
import org.apache.spark.network.netty.NettyBlockRpcServer;
import org.apache.spark.network.netty.NettyBlockTransferService$;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.sasl.SecretKeyHolder;
import org.apache.spark.network.server.RpcHandler;
import org.apache.spark.network.server.TransportServer;
import org.apache.spark.network.server.TransportServerBootstrap;
import org.apache.spark.network.shuffle.BlockFetchingListener;
import org.apache.spark.network.shuffle.BlockTransferListener;
import org.apache.spark.network.shuffle.DownloadFileManager;
import org.apache.spark.network.shuffle.OneForOneBlockFetcher;
import org.apache.spark.network.shuffle.RetryingBlockTransferor;
import org.apache.spark.network.shuffle.protocol.UploadBlock;
import org.apache.spark.network.shuffle.protocol.UploadBlockStream;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerMessages;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t%d!\u0002\u0011\"\u0001\u0015Z\u0003\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001d\t\u0011q\u0002!\u0011!Q\u0001\nuB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\u0011\"AQ\u000b\u0001BC\u0002\u0013\u0005c\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003I\u0011!A\u0006A!A!\u0002\u0013I\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011y\u0003!\u0011!Q\u0001\n}CQ!\u001a\u0001\u0005\u0002\u0019Dq\u0001\u0012\u0001C\u0002\u0013%\u0011\u000f\u0003\u0004v\u0001\u0001\u0006IA\u001d\u0005\bm\u0002\u0011\r\u0011\"\u0003x\u0011\u0019Y\b\u0001)A\u0005q\"IA\u0010\u0001a\u0001\u0002\u0003\u0006K! \u0005\f\u0003\u0003\u0001\u0001\u0019!A!B\u0013\t\u0019\u0001C\u0004\u0002\u000e\u0001!\t%a\u0004\t\u000f\u0005\u0005\u0002\u0001\"\u0003\u0002$!9\u0011\u0011\t\u0001\u0005B\u0005\r\u0003bBA-\u0001\u0011\u0005\u00131\f\u0005\b\u0003G\u0002A\u0011IAG\u0011\u001d\ty\t\u0001C!\u0003#Cq!!?\u0001\t\u0003\nY\u0010\u0003\u0007\u0002~\u0002\u0001\n\u0011!A\u0001\n\u0003\ty\u0010\u0003\u0007\u0003\u0012\u0001\u0001\n\u0011!A\u0001\n\u0003\u0011\u0019\u0002\u0003\u0007\u0003&\u0001\u0001\n\u0011!A\u0001\n\u0003\u00119\u0003\u0003\u0007\u00038\u0001\u0001\n\u0011!A\u0001\n\u0003\u0011Id\u0002\u0006\u0003D\u0005\n\t\u0011#\u0001&\u0005\u000b2\u0011\u0002I\u0011\u0002\u0002#\u0005QEa\u0012\t\r\u0015lB\u0011\u0001B(\u0011%\u0011\t&HI\u0001\n\u0003\u0011\u0019FA\rOKR$\u0018P\u00117pG.$&/\u00198tM\u0016\u00148+\u001a:wS\u000e,'B\u0001\u0012$\u0003\u0015qW\r\u001e;z\u0015\t!S%A\u0004oKR<xN]6\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c2\u0001\u0001\u00171!\tic&D\u0001$\u0013\ty3E\u0001\u000bCY>\u001c7\u000e\u0016:b]N4WM]*feZL7-\u001a\t\u0003cQj\u0011A\r\u0006\u0003g\u0015\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003kI\u0012q\u0001T8hO&tw-\u0001\u0003d_:47\u0001\u0001\t\u0003sij\u0011!J\u0005\u0003w\u0015\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u001fM,7-\u001e:jifl\u0015M\\1hKJ\u0004\"!\u000f \n\u0005}*#aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\u0002#M,'/[1mSj,'/T1oC\u001e,'\u000f\u0005\u0002C\u000b6\t1I\u0003\u0002EK\u0005Q1/\u001a:jC2L'0\u001a:\n\u0005\u0019\u001b%!E*fe&\fG.\u001b>fe6\u000bg.Y4fe\u0006Y!-\u001b8e\u0003\u0012$'/Z:t!\tI%K\u0004\u0002K!B\u00111JT\u0007\u0002\u0019*\u0011QjN\u0001\u0007yI|w\u000e\u001e \u000b\u0003=\u000bQa]2bY\u0006L!!\u0015(\u0002\rA\u0013X\rZ3g\u0013\t\u0019FK\u0001\u0004TiJLgn\u001a\u0006\u0003#:\u000b\u0001\u0002[8ti:\u000bW.Z\u000b\u0002\u0011\u0006I\u0001n\\:u\u001d\u0006lW\rI\u0001\u0006?B|'\u000f\u001e\t\u00035nk\u0011AT\u0005\u00039:\u00131!\u00138u\u0003!qW/\\\"pe\u0016\u001c\u0018!\u00053sSZ,'/\u00128e!>Lg\u000e\u001e*fMB\u0011\u0001mY\u0007\u0002C*\u0011!-J\u0001\u0004eB\u001c\u0017B\u00013b\u00059\u0011\u0006oY#oIB|\u0017N\u001c;SK\u001a\fa\u0001P5oSRtD#C4jU.dWN\\8q!\tA\u0007!D\u0001\"\u0011\u00151$\u00021\u00019\u0011\u0015a$\u00021\u0001>\u0011\u0015\u0001%\u00021\u0001B\u0011\u00159%\u00021\u0001I\u0011\u0015)&\u00021\u0001I\u0011\u0015A&\u00021\u0001Z\u0011\u0015i&\u00021\u0001Z\u0011\u001dq&\u0002%AA\u0002}+\u0012A\u001d\t\u0003\u0005NL!\u0001^\"\u0003\u0015M+'/[1mSj,'/A\u0006tKJL\u0017\r\\5{KJ\u0004\u0013aC1vi\",e.\u00192mK\u0012,\u0012\u0001\u001f\t\u00035fL!A\u001f(\u0003\u000f\t{w\u000e\\3b]\u0006a\u0011-\u001e;i\u000b:\f'\r\\3eA\u0005\u0001BO]1ogB|'\u000f^\"p]R,\u0007\u0010\u001e\t\u0003[yL!a`\u0012\u0003!Q\u0013\u0018M\\:q_J$8i\u001c8uKb$\u0018AB:feZ,'\u000f\u0005\u0003\u0002\u0006\u0005%QBAA\u0004\u0015\r\t\taI\u0005\u0005\u0003\u0017\t9AA\bUe\u0006t7\u000f]8siN+'O^3s\u0003\u0011Ig.\u001b;\u0015\t\u0005E\u0011q\u0003\t\u00045\u0006M\u0011bAA\u000b\u001d\n!QK\\5u\u0011\u001d\tI\"\u0005a\u0001\u00037\t\u0001C\u00197pG.$\u0015\r^1NC:\fw-\u001a:\u0011\u00075\ni\"C\u0002\u0002 \r\u0012\u0001C\u00117pG.$\u0015\r^1NC:\fw-\u001a:\u0002\u0019\r\u0014X-\u0019;f'\u0016\u0014h/\u001a:\u0015\t\u0005\r\u0011Q\u0005\u0005\b\u0003O\u0011\u0002\u0019AA\u0015\u0003)\u0011wn\u001c;tiJ\f\u0007o\u001d\t\u0007\u0003W\t)$a\u000f\u000f\t\u00055\u0012\u0011\u0007\b\u0004\u0017\u0006=\u0012\"A(\n\u0007\u0005Mb*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005]\u0012\u0011\b\u0002\u0005\u0019&\u001cHOC\u0002\u000249\u0003B!!\u0002\u0002>%!\u0011qHA\u0004\u0005a!&/\u00198ta>\u0014HoU3sm\u0016\u0014(i\\8ugR\u0014\u0018\r]\u0001\u000fg\",hM\u001a7f\u001b\u0016$(/[2t)\t\t)\u0005\u0005\u0003\u0002H\u0005USBAA%\u0015\u0011\tY%!\u0014\u0002\u000f5,GO]5dg*!\u0011qJA)\u0003!\u0019w\u000eZ1iC2,'BAA*\u0003\r\u0019w.\\\u0005\u0005\u0003/\nIEA\u0005NKR\u0014\u0018nY*fi\u0006Ya-\u001a;dQ\ncwnY6t)9\t\t\"!\u0018\u0002b\u0005\u0015\u0014\u0011NA:\u0003\u0007Ca!a\u0018\u0015\u0001\u0004A\u0015\u0001\u00025pgRDa!a\u0019\u0015\u0001\u0004I\u0016\u0001\u00029peRDa!a\u001a\u0015\u0001\u0004A\u0015AB3yK\u000eLE\rC\u0004\u0002lQ\u0001\r!!\u001c\u0002\u0011\tdwnY6JIN\u0004BAWA8\u0011&\u0019\u0011\u0011\u000f(\u0003\u000b\u0005\u0013(/Y=\t\u000f\u0005UD\u00031\u0001\u0002x\u0005AA.[:uK:,'\u000f\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\tihI\u0001\bg\",hM\u001a7f\u0013\u0011\t\t)a\u001f\u0003+\tcwnY6GKR\u001c\u0007.\u001b8h\u0019&\u001cH/\u001a8fe\"9\u0011Q\u0011\u000bA\u0002\u0005\u001d\u0015a\u0004;f[B4\u0015\u000e\\3NC:\fw-\u001a:\u0011\t\u0005e\u0014\u0011R\u0005\u0005\u0003\u0017\u000bYHA\nE_^tGn\\1e\r&dW-T1oC\u001e,'/F\u0001Z\u0003-)\b\u000f\\8bI\ncwnY6\u0015!\u0005M\u0015qTAR\u0003K\u000b9+a.\u0002H\u0006E\u0007CBAK\u00037\u000b\t\"\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\u0014(\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\u001e\u0006]%A\u0002$viV\u0014X\r\u0003\u0004\u0002\"Z\u0001\r\u0001S\u0001\tQ>\u001cHO\\1nK\"1\u00111\r\fA\u0002eCa!a\u001a\u0017\u0001\u0004A\u0005bBAU-\u0001\u0007\u00111V\u0001\bE2|7m[%e!\u0011\ti+a-\u000e\u0005\u0005=&bAAYK\u000591\u000f^8sC\u001e,\u0017\u0002BA[\u0003_\u0013qA\u00117pG.LE\rC\u0004\u0002:Z\u0001\r!a/\u0002\u0013\tdwnY6ECR\f\u0007\u0003BA_\u0003\u0007l!!a0\u000b\u0007\u0005\u00057%\u0001\u0004ck\u001a4WM]\u0005\u0005\u0003\u000b\fyLA\u0007NC:\fw-\u001a3Ck\u001a4WM\u001d\u0005\b\u0003\u00134\u0002\u0019AAf\u0003\u0015aWM^3m!\u0011\ti+!4\n\t\u0005=\u0017q\u0016\u0002\r'R|'/Y4f\u0019\u00164X\r\u001c\u0005\b\u0003'4\u0002\u0019AAk\u0003!\u0019G.Y:t)\u0006<\u0007\u0007BAl\u0003O\u0004b!!7\u0002`\u0006\rXBAAn\u0015\r\tiNT\u0001\be\u00164G.Z2u\u0013\u0011\t\t/a7\u0003\u0011\rc\u0017m]:UC\u001e\u0004B!!:\u0002h2\u0001A\u0001DAu\u0003#\f\t\u0011!A\u0003\u0002\u0005-(aA0%cE!\u0011Q^Az!\rQ\u0016q^\u0005\u0004\u0003ct%a\u0002(pi\"Lgn\u001a\t\u00045\u0006U\u0018bAA|\u001d\n\u0019\u0011I\\=\u0002\u000b\rdwn]3\u0015\u0005\u0005E\u0011a\u00069s_R,7\r^3eI\rd\u0017.\u001a8u\r\u0006\u001cGo\u001c:z)\u0011\u0011\tA!\u0004\u0011\t\t\r!\u0011B\u0007\u0003\u0005\u000bQ1Aa\u0002$\u0003\u0019\u0019G.[3oi&!!1\u0002B\u0003\u0005Y!&/\u00198ta>\u0014Ho\u00117jK:$h)Y2u_JL\b\u0002\u0003B\b1\u0005\u0005\t\u0019A4\u0002\u0007a$\u0013'A\bqe>$Xm\u0019;fI\u0012\n\u0007\u000f]%e)\u0011\u0011)Ba\t\u0011\t\t]!\u0011E\u0007\u0003\u00053QAAa\u0007\u0003\u001e\u0005!A.\u00198h\u0015\t\u0011y\"\u0001\u0003kCZ\f\u0017bA*\u0003\u001a!A!qB\r\u0002\u0002\u0003\u0007q-A\fqe>$Xm\u0019;fI\u0012\"(/\u00198ta>\u0014HoQ8oMR!!\u0011\u0006B\u001b!\u0011\u0011YC!\r\u000e\u0005\t5\"b\u0001B\u0018G\u0005!Q\u000f^5m\u0013\u0011\u0011\u0019D!\f\u0003\u001bQ\u0013\u0018M\\:q_J$8i\u001c8g\u0011!\u0011yAGA\u0001\u0002\u00049\u0017\u0001\u00059s_R,7\r^3eI1|wmZ3s)\u0011\u0011YD!\u0011\u0011\u0007E\u0012i$C\u0002\u0003@I\u00121b\u00159be.dunZ4fe\"A!qB\u000e\u0002\u0002\u0003\u0007q-A\rOKR$\u0018P\u00117pG.$&/\u00198tM\u0016\u00148+\u001a:wS\u000e,\u0007C\u00015\u001e'\ri\"\u0011\n\t\u00045\n-\u0013b\u0001B'\u001d\n1\u0011I\\=SK\u001a$\"A!\u0012\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t\u0011)FK\u0002`\u0005/Z#A!\u0017\u0011\t\tm#QM\u0007\u0003\u0005;RAAa\u0018\u0003b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005Gr\u0015AC1o]>$\u0018\r^5p]&!!q\rB/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class NettyBlockTransferService
extends BlockTransferService
implements Logging {
    private final SparkConf conf;
    private final SecurityManager securityManager;
    private final String bindAddress;
    private final String hostName;
    private final int _port;
    private final int numCores;
    public final RpcEndpointRef org$apache$spark$network$netty$NettyBlockTransferService$$driverEndPointRef;
    private final Serializer serializer;
    private final boolean authEnabled;
    private TransportContext transportContext;
    public TransportServer org$apache$spark$network$netty$NettyBlockTransferService$$server;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static RpcEndpointRef $lessinit$greater$default$8() {
        return NettyBlockTransferService$.MODULE$.$lessinit$greater$default$8();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public /* synthetic */ TransportClientFactory protected$clientFactory(NettyBlockTransferService x$1) {
        return x$1.clientFactory;
    }

    public /* synthetic */ String protected$appId(NettyBlockTransferService x$1) {
        return x$1.appId;
    }

    public /* synthetic */ TransportConf protected$transportConf(NettyBlockTransferService x$1) {
        return x$1.transportConf;
    }

    public /* synthetic */ SparkLogger protected$logger(NettyBlockTransferService x$1) {
        return x$1.logger;
    }

    @Override
    public String hostName() {
        return this.hostName;
    }

    private Serializer serializer() {
        return this.serializer;
    }

    private boolean authEnabled() {
        return this.authEnabled;
    }

    @Override
    public void init(BlockDataManager blockDataManager) {
        NettyBlockRpcServer rpcHandler = new NettyBlockRpcServer(this.conf.getAppId(), this.serializer(), blockDataManager);
        None$ serverBootstrap = None$.MODULE$;
        None$ clientBootstrap = None$.MODULE$;
        SparkConf x$1 = this.conf;
        String x$2 = "shuffle";
        int x$3 = this.numCores;
        Some x$4 = new Some((Object)this.securityManager.getRpcSSLOptions());
        Option<String> x$5 = SparkTransportConf$.MODULE$.fromSparkConf$default$4();
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(x$1, "shuffle", x$3, x$5, (Option<SSLOptions>)x$4);
        if (this.authEnabled()) {
            serverBootstrap = new Some((Object)new AuthServerBootstrap(this.transportConf, (SecretKeyHolder)this.securityManager));
            clientBootstrap = new Some((Object)new AuthClientBootstrap(this.transportConf, this.conf.getAppId(), (SecretKeyHolder)this.securityManager));
        }
        this.transportContext = new TransportContext(this.transportConf, (RpcHandler)rpcHandler);
        this.clientFactory = this.transportContext.createClientFactory(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Option$.MODULE$.option2Iterable((Option)clientBootstrap).toSeq()).asJava());
        this.org$apache$spark$network$netty$NettyBlockTransferService$$server = this.createServer((List<TransportServerBootstrap>)serverBootstrap.toList());
        this.appId = this.conf.getAppId();
        if (this.hostName().equals(this.bindAddress)) {
            this.logger.info("Server created on {}:{}", new MDC[]{this.MDC((LogKey)LogKeys.HOST, this.hostName()), this.MDC((LogKey)LogKeys.PORT, BoxesRunTime.boxToInteger((int)this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort()))});
            return;
        }
        this.logger.info("Server created on {} {}:{}", new MDC[]{this.MDC((LogKey)LogKeys.HOST, this.hostName()), this.MDC((LogKey)LogKeys.BIND_ADDRESS, this.bindAddress), this.MDC((LogKey)LogKeys.PORT, BoxesRunTime.boxToInteger((int)this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort()))});
    }

    private TransportServer createServer(List<TransportServerBootstrap> bootstraps) {
        return (TransportServer)Utils$.MODULE$.startServiceOnPort(this._port, (Function1 & Serializable)port -> this.startService$1(BoxesRunTime.unboxToInt((Object)port), bootstraps), this.conf, this.getClass().getName())._1();
    }

    public MetricSet shuffleMetrics() {
        Predef$.MODULE$.require(this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null && this.clientFactory != null, (Function0 & Serializable)() -> "NettyBlockTransferServer is not initialized");
        return new MetricSet(this){
            private final HashMap<String, Metric> allMetrics;
            private final /* synthetic */ NettyBlockTransferService $outer;

            private HashMap<String, Metric> allMetrics() {
                return this.allMetrics;
            }

            public Map<String, Metric> getMetrics() {
                this.allMetrics().putAll(this.$outer.protected$clientFactory(this.$outer).getAllMetrics().getMetrics());
                this.allMetrics().putAll(this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$server.getAllMetrics().getMetrics());
                return this.allMetrics();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.allMetrics = new HashMap<K, V>();
            }
        };
    }

    public void fetchBlocks(String host, int port, String execId, String[] blockIds, BlockFetchingListener listener, DownloadFileManager tempFileManager) {
        block4: {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Fetch blocks from " + host + ":" + port + " (executor id " + execId + ")");
            }
            try {
                int maxRetries = this.transportConf.maxIORetries();
                RetryingBlockTransferor.BlockTransferStarter blockFetchStarter = new RetryingBlockTransferor.BlockTransferStarter(this, host, port, maxRetries, execId, tempFileManager){
                    private final /* synthetic */ NettyBlockTransferService $outer;
                    private final String host$1;
                    private final int port$1;
                    private final int maxRetries$1;
                    private final String execId$1;
                    private final DownloadFileManager tempFileManager$1;

                    public void createAndStart(String[] blockIds, BlockTransferListener listener) {
                        Predef$.MODULE$.assert(listener instanceof BlockFetchingListener, (Function0 & Serializable)() -> "Expecting a BlockFetchingListener, but got " + listener.getClass());
                        try {
                            TransportClient client = this.$outer.protected$clientFactory(this.$outer).createClient(this.host$1, this.port$1, this.maxRetries$1 > 0);
                            new OneForOneBlockFetcher(client, this.$outer.protected$appId(this.$outer), this.execId$1, blockIds, (BlockFetchingListener)listener, this.$outer.protected$transportConf(this.$outer), this.tempFileManager$1).start();
                        }
                        catch (IOException e) {
                            Success success;
                            boolean v;
                            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> BoxesRunTime.unboxToBoolean($this.$outer.org$apache$spark$network$netty$NettyBlockTransferService$$driverEndPointRef.askSync(new BlockManagerMessages.IsExecutorAlive($this.execId$1), ClassTag$.MODULE$.Boolean())));
                            if (try_ instanceof Success && !(v = BoxesRunTime.unboxToBoolean((Object)(success = (Success)try_).value()))) {
                                throw new ExecutorDeadException("The relative remote executor(Id: " + this.execId$1 + "), which maintains the block data to fetch is dead.");
                            }
                            throw e;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.host$1 = host$1;
                        this.port$1 = port$1;
                        this.maxRetries$1 = maxRetries$1;
                        this.execId$1 = execId$1;
                        this.tempFileManager$1 = tempFileManager$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$createAndStart$1(org.apache.spark.network.shuffle.BlockTransferListener ), $anonfun$createAndStart$2(org.apache.spark.network.netty.NettyBlockTransferService$$anon$2 )}, serializedLambda);
                    }
                };
                if (maxRetries > 0) {
                    new RetryingBlockTransferor(this.transportConf, blockFetchStarter, blockIds, listener).start();
                    break block4;
                }
                blockFetchStarter.createAndStart(blockIds, (BlockTransferListener)listener);
            }
            catch (Exception e) {
                this.logger.error("Exception while beginning fetchBlocks", (Throwable)e);
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), (Function1 & Serializable)x$3 -> {
                    listener.onBlockFetchFailure(x$3, (Throwable)e);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    @Override
    public int port() {
        return this.org$apache$spark$network$netty$NettyBlockTransferService$$server.getPort();
    }

    @Override
    public Future<BoxedUnit> uploadBlock(String hostname, int port, String execId, BlockId blockId, ManagedBuffer blockData, StorageLevel level, ClassTag<?> classTag) {
        Promise result = Promise$.MODULE$.apply();
        TransportClient client = this.clientFactory.createClient(hostname, port);
        byte[] metadata = JavaUtils.bufferToArray((ByteBuffer)this.serializer().newInstance().serialize(new Tuple2((Object)level, classTag), ClassTag$.MODULE$.apply(Tuple2.class)));
        boolean asStream = blockData.size() > BoxesRunTime.unboxToLong((Object)this.conf.get(org.apache.spark.internal.config.package$.MODULE$.MAX_REMOTE_BLOCK_SIZE_FETCH_TO_MEM())) || blockId.isShuffle();
        RpcResponseCallback callback = new RpcResponseCallback(this, blockId, asStream, result){
            private final /* synthetic */ NettyBlockTransferService $outer;
            private final BlockId blockId$1;
            private final boolean asStream$1;
            private final Promise result$1;

            public void onSuccess(ByteBuffer response) {
                if (this.$outer.protected$logger(this.$outer).isTraceEnabled()) {
                    this.$outer.protected$logger(this.$outer).trace("Successfully uploaded block " + this.blockId$1 + (this.asStream$1 ? " as stream" : ""));
                }
                this.result$1.success((Object)BoxedUnit.UNIT);
            }

            public void onFailure(Throwable e) {
                if (this.asStream$1) {
                    this.$outer.protected$logger(this.$outer).error("Error while uploading {} as stream", e, new MDC[]{this.$outer.MDC((LogKey)LogKeys.BLOCK_ID, this.blockId$1)});
                } else {
                    this.$outer.protected$logger(this.$outer).error("Error while uploading {}", e, new MDC[]{this.$outer.MDC((LogKey)LogKeys.BLOCK_ID, this.blockId$1)});
                }
                this.result$1.failure(e);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.blockId$1 = blockId$1;
                this.asStream$1 = asStream$1;
                this.result$1 = result$1;
            }
        };
        if (asStream) {
            ByteBuffer streamHeader = new UploadBlockStream(blockId.name(), metadata).toByteBuffer();
            v0 = client.uploadStream((ManagedBuffer)new NioManagedBuffer(streamHeader), blockData, callback);
        } else {
            byte[] array = JavaUtils.bufferToArray((ByteBuffer)blockData.nioByteBuffer());
            v0 = client.sendRpc(new UploadBlock(this.appId, execId, blockId.name(), metadata, array).toByteBuffer(), callback);
        }
        return result.future();
    }

    public void close() {
        if (this.org$apache$spark$network$netty$NettyBlockTransferService$$server != null) {
            this.org$apache$spark$network$netty$NettyBlockTransferService$$server.close();
        }
        if (this.clientFactory != null) {
            this.clientFactory.close();
        }
        if (this.transportContext != null) {
            this.transportContext.close();
            return;
        }
    }

    private final Tuple2 startService$1(int port, List bootstraps$1) {
        TransportServer server = this.transportContext.createServer(this.bindAddress, port, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)bootstraps$1).asJava());
        return new Tuple2((Object)server, (Object)BoxesRunTime.boxToInteger((int)server.getPort()));
    }

    public NettyBlockTransferService(SparkConf conf, SecurityManager securityManager, SerializerManager serializerManager, String bindAddress, String hostName, int _port, int numCores, RpcEndpointRef driverEndPointRef) {
        this.conf = conf;
        this.securityManager = securityManager;
        this.bindAddress = bindAddress;
        this.hostName = hostName;
        this._port = _port;
        this.numCores = numCores;
        this.org$apache$spark$network$netty$NettyBlockTransferService$$driverEndPointRef = driverEndPointRef;
        Logging.$init$((Logging)this);
        this.serializer = serializerManager.getSerializer(package$.MODULE$.classTag(ClassTag$.MODULE$.Any()), false);
        this.authEnabled = securityManager.isAuthenticationEnabled();
    }
}

