/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc;

import java.util.List;
import org.sparkproject.connect.grpc.Configurator;
import org.sparkproject.connect.grpc.ConfiguratorRegistry;
import org.sparkproject.connect.grpc.Internal;
import org.sparkproject.connect.grpc.InternalConfigurator;
import org.sparkproject.connect.grpc.ManagedChannelBuilder;
import org.sparkproject.connect.grpc.ServerBuilder;

@Internal
public final class InternalConfiguratorRegistry {
    private InternalConfiguratorRegistry() {
    }

    public static void setConfigurators(List<InternalConfigurator> configurators) {
        ConfiguratorRegistry.getDefaultRegistry().setConfigurators(configurators);
    }

    public static List<?> getConfigurators() {
        return ConfiguratorRegistry.getDefaultRegistry().getConfigurators();
    }

    public static void configureChannelBuilder(ManagedChannelBuilder<?> channelBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureChannelBuilder(channelBuilder);
        }
    }

    public static void configureServerBuilder(ServerBuilder<?> serverBuilder) {
        for (Configurator configurator : ConfiguratorRegistry.getDefaultRegistry().getConfigurators()) {
            configurator.configureServerBuilder(serverBuilder);
        }
    }

    public static boolean wasSetConfiguratorsCalled() {
        return ConfiguratorRegistry.getDefaultRegistry().wasSetConfiguratorsCalled();
    }
}

