/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.planner;

import org.apache.spark.connect.proto.Expression;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.WithRelations;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.sparkproject.connect.protobuf.Descriptors;
import org.sparkproject.connect.protobuf.Internal;
import org.sparkproject.connect.protobuf.ProtocolMessageEnum;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.runtime.ScalaRunTime$;

public final class InvalidInputErrors$ {
    public static final InvalidInputErrors$ MODULE$ = new InvalidInputErrors$();

    public InvalidPlanInput noHandlerFoundForExtension() {
        return InvalidPlanInput$.MODULE$.apply("No handler found for extension");
    }

    public InvalidPlanInput invalidSQLWithReferences(WithRelations query) {
        return InvalidPlanInput$.MODULE$.apply(query + " is not a valid relation for SQL with references");
    }

    public InvalidPlanInput naFillValuesEmpty() {
        return InvalidPlanInput$.MODULE$.apply("values must contains at least 1 item!");
    }

    public InvalidPlanInput naFillValuesLengthMismatch() {
        return InvalidPlanInput$.MODULE$.apply("When values contains more than 1 items, values and cols should have the same length!");
    }

    public InvalidPlanInput deduplicateNeedsInput() {
        return InvalidPlanInput$.MODULE$.apply("Deduplicate needs a plan input");
    }

    public InvalidPlanInput deduplicateAllColumnsAndSubset() {
        return InvalidPlanInput$.MODULE$.apply("Cannot deduplicate on both all columns and a subset of columns");
    }

    public InvalidPlanInput deduplicateRequiresColumnsOrAll() {
        return InvalidPlanInput$.MODULE$.apply("Deduplicate requires to either deduplicate on all columns or a subset of columns");
    }

    public InvalidPlanInput invalidDeduplicateColumn(String colName) {
        return InvalidPlanInput$.MODULE$.apply("Invalid deduplicate column " + colName);
    }

    public InvalidPlanInput functionEvalTypeNotSupported(int evalType) {
        return InvalidPlanInput$.MODULE$.apply("Function with EvalType: " + evalType + " is not supported");
    }

    public InvalidPlanInput groupingExpressionAbsentForKeyValueGroupedDataset() {
        return InvalidPlanInput$.MODULE$.apply("The grouping expression cannot be absent for KeyValueGroupedDataset");
    }

    public InvalidPlanInput expectingScalaUdfButGot(Expression.ExprTypeCase exprType) {
        return InvalidPlanInput$.MODULE$.apply("Expecting a Scala UDF, but get " + exprType);
    }

    public InvalidPlanInput rowNotSupportedForUdf(String errorType) {
        return InvalidPlanInput$.MODULE$.apply("Row is not a supported " + errorType + " type for this UDF.");
    }

    public InvalidPlanInput notFoundCachedLocalRelation(String hash, String sessionUUID) {
        return InvalidPlanInput$.MODULE$.apply("Not found any cached local relation with the hash: " + hash + " in the session with sessionUUID " + sessionUUID + ".");
    }

    public InvalidPlanInput withColumnsRequireSingleNamePart(String got) {
        return InvalidPlanInput$.MODULE$.apply("WithColumns require column name only contains one name part, but got " + got);
    }

    public InvalidPlanInput inputDataForLocalRelationNoSchema() {
        return InvalidPlanInput$.MODULE$.apply("Input data for LocalRelation does not produce a schema.");
    }

    public InvalidPlanInput schemaRequiredForLocalRelation() {
        return InvalidPlanInput$.MODULE$.apply("Schema for LocalRelation is required when the input data is not provided.");
    }

    public InvalidPlanInput invalidSchemaStringNonStructType(String schema, DataType dataType) {
        return InvalidPlanInput$.MODULE$.apply("INVALID_SCHEMA.NON_STRUCT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSchema"), (Object)DataTypeErrors$.MODULE$.quoteByDefault(schema)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)DataTypeErrors$.MODULE$.toSQLType((AbstractDataType)dataType))}))));
    }

    public InvalidPlanInput invalidJdbcParams() {
        return InvalidPlanInput$.MODULE$.apply("Invalid jdbc params, please specify jdbc url and table.");
    }

    public InvalidPlanInput predicatesNotSupportedForDataSource(String format) {
        return InvalidPlanInput$.MODULE$.apply("Predicates are not supported for " + format + " data sources.");
    }

    public InvalidPlanInput multiplePathsNotSupportedForStreamingSource() {
        return InvalidPlanInput$.MODULE$.apply("Multiple paths are not supported for streaming source");
    }

    public InvalidPlanInput invalidEnum(Enum<?> protoEnum) {
        return InvalidPlanInput$.MODULE$.apply("This enum value of " + ((ProtocolMessageEnum)((Object)protoEnum)).getDescriptorForType().getFullName() + " is invalid: " + protoEnum.name() + "(" + ((ProtocolMessageEnum)((Object)protoEnum)).getNumber() + ")");
    }

    public InvalidPlanInput invalidOneOfField(Enum<?> enumCase, Descriptors.Descriptor descriptor) {
        if (((Internal.EnumLite)((Object)enumCase)).getNumber() == 0) {
            return InvalidPlanInput$.MODULE$.apply("This oneOf field in " + descriptor.getFullName() + " is not set: " + enumCase.name());
        }
        return InvalidPlanInput$.MODULE$.apply("This oneOf field message in " + descriptor.getFullName() + " is not supported: " + enumCase.name() + "(" + ((Internal.EnumLite)((Object)enumCase)).getNumber() + ")");
    }

    public InvalidPlanInput cannotBeEmpty(String fieldName, Descriptors.Descriptor descriptor) {
        return InvalidPlanInput$.MODULE$.apply(fieldName + " in " + descriptor.getFullName() + " cannot be empty");
    }

    public InvalidPlanInput invalidSchemaTypeNonStruct(DataType dataType) {
        return InvalidPlanInput$.MODULE$.apply("INVALID_SCHEMA_TYPE_NON_STRUCT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)DataTypeErrors$.MODULE$.toSQLType((AbstractDataType)dataType))}))));
    }

    public InvalidPlanInput lambdaFunctionArgumentCountInvalid(int got) {
        return InvalidPlanInput$.MODULE$.apply("LambdaFunction requires 1 ~ 3 arguments, but got " + got + " ones!");
    }

    public InvalidPlanInput aliasWithMultipleIdentifiersAndMetadata() {
        return InvalidPlanInput$.MODULE$.apply("Alias expressions with more than 1 identifier must not use optional metadata.");
    }

    public InvalidPlanInput unresolvedStarTargetInvalid(String target) {
        return InvalidPlanInput$.MODULE$.apply("UnresolvedStar requires a unparsed target ending with '.*', but got " + target + ".");
    }

    public InvalidPlanInput unresolvedStarWithBothTargetAndPlanId() {
        return InvalidPlanInput$.MODULE$.apply("UnresolvedStar with both target and plan id is not supported.");
    }

    public InvalidPlanInput windowFunctionRequired() {
        return InvalidPlanInput$.MODULE$.apply("WindowFunction is required in WindowExpression");
    }

    public InvalidPlanInput lowerBoundRequiredInWindowFrame() {
        return InvalidPlanInput$.MODULE$.apply("LowerBound is required in WindowFrame");
    }

    public InvalidPlanInput upperBoundRequiredInWindowFrame() {
        return InvalidPlanInput$.MODULE$.apply("UpperBound is required in WindowFrame");
    }

    public InvalidPlanInput setOperationMustHaveTwoInputs() {
        return InvalidPlanInput$.MODULE$.apply("Set operation must have 2 inputs");
    }

    public InvalidPlanInput exceptDoesNotSupportUnionByName() {
        return InvalidPlanInput$.MODULE$.apply("Except does not support union_by_name");
    }

    public InvalidPlanInput intersectDoesNotSupportUnionByName() {
        return InvalidPlanInput$.MODULE$.apply("Intersect does not support union_by_name");
    }

    public InvalidPlanInput aggregateNeedsPlanInput() {
        return InvalidPlanInput$.MODULE$.apply("Aggregate needs a plan input");
    }

    public InvalidPlanInput aggregateWithPivotRequiresPivot() {
        return InvalidPlanInput$.MODULE$.apply("Aggregate with GROUP_TYPE_PIVOT requires a Pivot");
    }

    public InvalidPlanInput invalidWithRelationReference() {
        return InvalidPlanInput$.MODULE$.apply("Invalid WithRelation reference");
    }

    public InvalidPlanInput assertionFailure(String message) {
        return InvalidPlanInput$.MODULE$.apply(message);
    }

    public InvalidPlanInput unresolvedNamedLambdaVariableRequiresNamePart() {
        return InvalidPlanInput$.MODULE$.apply("UnresolvedNamedLambdaVariable requires at least one name part!");
    }

    public InvalidPlanInput usingColumnsOrJoinConditionSetInJoin() {
        return InvalidPlanInput$.MODULE$.apply("Using columns or join conditions cannot be set at the same time in Join");
    }

    public InvalidPlanInput sqlCommandExpectsSqlOrWithRelations(Relation.RelTypeCase other) {
        return InvalidPlanInput$.MODULE$.apply("SQL command expects either a SQL or a WithRelations, but got " + other);
    }

    public InvalidPlanInput reduceShouldCarryScalarScalaUdf(Buffer<Expression> got) {
        return InvalidPlanInput$.MODULE$.apply("reduce should carry a scalar scala udf, but got " + got);
    }

    public InvalidPlanInput unionByNameAllowMissingColRequiresByName() {
        return InvalidPlanInput$.MODULE$.apply("UnionByName `allowMissingCol` can be true only if `byName` is true.");
    }

    public InvalidPlanInput unsupportedUserDefinedFunctionImplementation(Class<?> clazz) {
        return InvalidPlanInput$.MODULE$.apply("Unsupported UserDefinedFunction implementation: " + clazz);
    }

    public InvalidPlanInput streamingQueryRunIdMismatch(String id, String runId, String serverRunId) {
        return InvalidPlanInput$.MODULE$.apply("Run id mismatch for query id " + id + ". Run id in the request " + runId + " does not match one on the server " + serverRunId + ". The query might have restarted.");
    }

    public InvalidPlanInput streamingQueryNotFound(String id) {
        return InvalidPlanInput$.MODULE$.apply("Streaming query " + id + " is not found");
    }

    private InvalidInputErrors$() {
    }
}

