/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression$;
import org.apache.spark.sql.catalyst.expressions.TimestampAdd$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyTimestampType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(unit, quantity, timestamp) - Adds the specified number of units to the given timestamp.", arguments="\n    Arguments:\n      * unit - this indicates the units of datetime that you want to add.\n        Supported string values of `unit` are (case insensitive):\n          - \"YEAR\"\n          - \"QUARTER\" - 3 months\n          - \"MONTH\"\n          - \"WEEK\" - 7 days\n          - \"DAY\", \"DAYOFYEAR\"\n          - \"HOUR\"\n          - \"MINUTE\"\n          - \"SECOND\"\n          - \"MILLISECOND\"\n          - \"MICROSECOND\"\n      * quantity - this is the number of units of time that you want to add.\n      * timestamp - this is a timestamp (w/ or w/o timezone) to which you want to add.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(HOUR, 8, timestamp_ntz'2022-02-11 20:30:00');\n       2022-02-12 04:30:00\n      > SELECT _FUNC_(MONTH, 1, timestamp_ltz'2022-01-31 00:00:00');\n       2022-02-28 00:00:00\n      > SELECT _FUNC_(SECOND, -10, date'2022-01-01');\n       2021-12-31 23:59:50\n      > SELECT _FUNC_(YEAR, 10, timestamp'2000-01-01 01:02:03.123456');\n       2010-01-01 01:02:03.123456\n  ", group="datetime_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0005\tUd\u0001B\u0017/\u0001nB\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\tE\u0002\u0011\t\u0012)A\u00055\"A1\r\u0001BK\u0002\u0013\u0005A\r\u0003\u0005i\u0001\tE\t\u0015!\u0003f\u0011!I\u0007A!f\u0001\n\u0003!\u0007\u0002\u00036\u0001\u0005#\u0005\u000b\u0011B3\t\u0011-\u0004!Q3A\u0005\u00021D\u0001\u0002\u001d\u0001\u0003\u0012\u0003\u0006I!\u001c\u0005\u0006c\u0002!\tA\u001d\u0005\u0006q\u0002!\t%\u001f\u0005\u0006c\u0002!\t! \u0005\u0007c\u0002!\t!a\u0001\t\r\u0005-\u0001\u0001\"\u0011e\u0011\u0019\ti\u0001\u0001C!I\"9\u0011q\u0002\u0001\u0005B\u0005E\u0001bBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011)\t)\u0004\u0001EC\u0002\u0013%\u0011q\u0007\u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\t\u0019\u0007\u0001C!\u0003KBa!!!\u0001\t\u0003J\u0006\"B\u001a\u0001\t\u0003J\u0006bBAB\u0001\u0011E\u0013Q\u0011\u0005\n\u0003\u001f\u0003\u0011\u0011!C\u0001\u0003#C\u0011\"a'\u0001#\u0003%\t!!(\t\u0013\u0005M\u0006!%A\u0005\u0002\u0005U\u0006\"CA]\u0001E\u0005I\u0011AA[\u0011%\tY\fAI\u0001\n\u0003\ti\fC\u0005\u0002B\u0002\t\t\u0011\"\u0011\u0002D\"I\u0011q\u001a\u0001\u0002\u0002\u0013\u0005\u0011\u0011\u001b\u0005\n\u00033\u0004\u0011\u0011!C\u0001\u00037D\u0011\"!9\u0001\u0003\u0003%\t%a9\t\u0013\u0005E\b!!A\u0005\u0002\u0005M\b\"CA|\u0001\u0005\u0005I\u0011IA}\u0011%\ti\u0010AA\u0001\n\u0003\nypB\u0005\u0003*9\n\t\u0011#\u0001\u0003,\u0019AQFLA\u0001\u0012\u0003\u0011i\u0003\u0003\u0004rK\u0011\u0005!Q\t\u0005\n\u0005\u000f*\u0013\u0011!C#\u0005\u0013B\u0011Ba\u0013&\u0003\u0003%\tI!\u0014\t\u0013\t]S%%A\u0005\u0002\u0005u\u0006\"\u0003B-K\u0005\u0005I\u0011\u0011B.\u0011%\u0011I'JI\u0001\n\u0003\ti\fC\u0005\u0003l\u0015\n\t\u0011\"\u0003\u0003n\taA+[7fgR\fW\u000e]!eI*\u0011q\u0006M\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00022e\u0005A1-\u0019;bYf\u001cHO\u0003\u00024i\u0005\u00191/\u001d7\u000b\u0005U2\u0014!B:qCJ\\'BA\u001c9\u0003\u0019\t\u0007/Y2iK*\t\u0011(A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001y\u0001\u001be\t\u0014\t\u0003{yj\u0011AL\u0005\u0003\u007f9\u0012\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005u\n\u0015B\u0001\"/\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001fE\u0013\t)eFA\fUS6,'l\u001c8f\u0003^\f'/Z#yaJ,7o]5p]B\u0011qIS\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n9\u0001K]8ek\u000e$\bCA'V\u001d\tq5K\u0004\u0002P%6\t\u0001K\u0003\u0002Ru\u00051AH]8pizJ\u0011!S\u0005\u0003)\"\u000bq\u0001]1dW\u0006<W-\u0003\u0002W/\na1+\u001a:jC2L'0\u00192mK*\u0011A\u000bS\u0001\u0005k:LG/F\u0001[!\tYvL\u0004\u0002];B\u0011q\nS\u0005\u0003=\"\u000ba\u0001\u0015:fI\u00164\u0017B\u00011b\u0005\u0019\u0019FO]5oO*\u0011a\fS\u0001\u0006k:LG\u000fI\u0001\tcV\fg\u000e^5usV\tQ\r\u0005\u0002>M&\u0011qM\f\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!C9vC:$\u0018\u000e^=!\u0003%!\u0018.\\3ti\u0006l\u0007/\u0001\u0006uS6,7\u000f^1na\u0002\n!\u0002^5nKj{g.Z%e+\u0005i\u0007cA$o5&\u0011q\u000e\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017QLW.\u001a.p]\u0016LE\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bM$XO^<\u0011\u0005u\u0002\u0001\"\u0002-\n\u0001\u0004Q\u0006\"B2\n\u0001\u0004)\u0007\"B5\n\u0001\u0004)\u0007bB6\n!\u0003\u0005\r!\\\u0001\u000f]VdG.\u00138u_2,'/\u00198u+\u0005Q\bCA$|\u0013\ta\bJA\u0004C_>dW-\u00198\u0015\u000bMtx0!\u0001\t\u000ba[\u0001\u0019\u0001.\t\u000b\r\\\u0001\u0019A3\t\u000b%\\\u0001\u0019A3\u0015\u000fM\f)!a\u0002\u0002\n!)\u0001\f\u0004a\u0001K\")1\r\u0004a\u0001K\")\u0011\u000e\u0004a\u0001K\u0006!A.\u001a4u\u0003\u0015\u0011\u0018n\u001a5u\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0003\u0003'\u0001R!TA\u000b\u00033I1!a\u0006X\u0005\r\u0019V-\u001d\t\u0005\u00037\t\t#\u0004\u0002\u0002\u001e)\u0019\u0011q\u0004\u001a\u0002\u000bQL\b/Z:\n\t\u0005\r\u0012Q\u0004\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003S\u0001B!a\u0007\u0002,%!\u0011QFA\u000f\u0005!!\u0015\r^1UsB,\u0017\u0001D<ji\"$\u0016.\\3[_:,GcA\"\u00024!)1.\u0005a\u00015\u0006a!p\u001c8f\u0013\u0012Le.\u0012<bYV\u0011\u0011\u0011\b\t\u0005\u0003w\t)%\u0004\u0002\u0002>)!\u0011qHA!\u0003\u0011!\u0018.\\3\u000b\u0005\u0005\r\u0013\u0001\u00026bm\u0006LA!a\u0012\u0002>\t1!l\u001c8f\u0013\u0012D3AEA&!\r9\u0015QJ\u0005\u0004\u0003\u001fB%!\u0003;sC:\u001c\u0018.\u001a8u\u00031qW\u000f\u001c7TC\u001a,WI^1m)\u0019\t)&a\u0017\u0002`A\u0019q)a\u0016\n\u0007\u0005e\u0003JA\u0002B]fDq!!\u0018\u0014\u0001\u0004\t)&A\u0001r\u0011\u001d\t\tg\u0005a\u0001\u0003+\na!\\5de>\u001c\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0019\t9'a\u001d\u0002~A!\u0011\u0011NA8\u001b\t\tYGC\u0002\u0002n9\nqaY8eK\u001e,g.\u0003\u0003\u0002r\u0005-$\u0001C#yaJ\u001cu\u000eZ3\t\u000f\u0005UD\u00031\u0001\u0002x\u0005\u00191\r\u001e=\u0011\t\u0005%\u0014\u0011P\u0005\u0005\u0003w\nYG\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000f\u0005}D\u00031\u0001\u0002h\u0005\u0011QM^\u0001\u000baJ,G\u000f^=OC6,\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)\u0015\u0019\u0018qQAF\u0011\u0019\tIi\u0006a\u0001K\u00069a.Z<MK\u001a$\bBBAG/\u0001\u0007Q-\u0001\u0005oK^\u0014\u0016n\u001a5u\u0003\u0011\u0019w\u000e]=\u0015\u0013M\f\u0019*!&\u0002\u0018\u0006e\u0005b\u0002-\u0019!\u0003\u0005\rA\u0017\u0005\bGb\u0001\n\u00111\u0001f\u0011\u001dI\u0007\u0004%AA\u0002\u0015Dqa\u001b\r\u0011\u0002\u0003\u0007Q.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005}%f\u0001.\u0002\".\u0012\u00111\u0015\t\u0005\u0003K\u000by+\u0004\u0002\u0002(*!\u0011\u0011VAV\u0003%)hn\u00195fG.,GMC\u0002\u0002.\"\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\t,a*\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005]&fA3\u0002\"\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u007fS3!\\AQ\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0019\t\u0005\u0003\u000f\fi-\u0004\u0002\u0002J*!\u00111ZA!\u0003\u0011a\u0017M\\4\n\u0007\u0001\fI-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002TB\u0019q)!6\n\u0007\u0005]\u0007JA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002V\u0005u\u0007\"CAp?\u0005\u0005\t\u0019AAj\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u001d\t\u0007\u0003O\fi/!\u0016\u000e\u0005\u0005%(bAAv\u0011\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0018\u0011\u001e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002{\u0003kD\u0011\"a8\"\u0003\u0003\u0005\r!!\u0016\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u000b\fY\u0010C\u0005\u0002`\n\n\t\u00111\u0001\u0002T\u00061Q-];bYN$2A\u001fB\u0001\u0011%\tynIA\u0001\u0002\u0004\t)\u0006K\f\u0001\u0005\u000b\u0011YA!\u0004\u0003\u0012\tM!q\u0003B\r\u0005;\u0011yBa\t\u0003&A\u0019QHa\u0002\n\u0007\t%aFA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t=\u0011AX0G+:\u001bu\fK;oSRd\u0003%];b]RLG/\u001f\u0017!i&lWm\u001d;b[BL\u0003%\f\u0011BI\u0012\u001c\b\u0005\u001e5fAM\u0004XmY5gS\u0016$\u0007E\\;nE\u0016\u0014\be\u001c4!k:LGo\u001d\u0011u_\u0002\"\b.\u001a\u0011hSZ,g\u000e\t;j[\u0016\u001cH/Y7q]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0005+\tAQ\u000e\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AUt\u0017\u000e\u001e\u0011.AQD\u0017n\u001d\u0011j]\u0012L7-\u0019;fg\u0002\"\b.\u001a\u0011v]&$8\u000fI8gA\u0011\fG/\u001a;j[\u0016\u0004C\u000f[1uAe|W\u000fI<b]R\u0004Co\u001c\u0011bI\u0012t#\u0002\t\u0011!A\u0001\u0002\u0003\u0005I*vaB|'\u000f^3eAM$(/\u001b8hAY\fG.^3tA=4\u0007\u0005Y;oSR\u0004\u0007%\u0019:fA!\u001a\u0017m]3!S:\u001cXM\\:ji&4X-\u000b\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012Z\u000b\u0006\u0013&E\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%U+B%R+%K\t\u0011.AM\u0002Sn\u001c8uQNT\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\tjuJ\u0014+IE)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E]+Ui\u0013\u0012![\u0001:\u0004\u0005Z1zg*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E\u0011\u000b\u0015L\t\u0017!E\u0011\u000b\u0015l\u0014$Z\u000b\u0006\u0013&E\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#\u0005S(V%\nR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\tj\u0015JT+U\u000b\nR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t\u001aViQ(O\t\nR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\tj\u0015\n\u0014'J'\u0016\u001buJ\u0014##\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u001b&\u001b%kT*F\u0007>sEI\t\u0006!A\u0001\u0002\u0003\u0005\t\u0016!cV\fg\u000e^5us\u0002j\u0003\u0005\u001e5jg\u0002J7\u000f\t;iK\u0002rW/\u001c2fe\u0002zg\rI;oSR\u001c\be\u001c4!i&lW\r\t;iCR\u0004\u0013p\\;!o\u0006tG\u000f\t;pA\u0005$GM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!i&lWm\u001d;b[B\u0004S\u0006\t;iSN\u0004\u0013n\u001d\u0011bAQLW.Z:uC6\u0004\b\u0005K<0A=\u0014\be^\u0018pAQLW.\u001a>p]\u0016L\u0003\u0005^8!o\"L7\r\u001b\u0011z_V\u0004s/\u00198uAQ|\u0007%\u00193e])\u0001\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011Y\"AB\f\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"Bu*\u0016*-Aab\u0003\u0005^5nKN$\u0018-\u001c9`]RTxE\r\u00193e5\u0002$'L\u00192AI\u0002$h\r\u0019;aA:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aI\u0012T\u0006\r\u001a.cI\u0002\u0003\u0007\u000e\u001e4ai\u0002\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015N\u001f:#\u0006\n\f\u00112Y\u0001\"\u0018.\\3ti\u0006l\u0007o\u00187uu\u001e\u0012\u0004G\r\u001a.aEj3'\r\u00111ai\u0002\u0004G\u000f\u00191O%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00193e5\u0002$'\f\u001a9AA\u0002$\b\r\u0019;aAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fU#D\u001f:#E\u0006I\u00172a1\u0002C-\u0019;fOI\u0002$GM\u00171c5\u0002\u0014gJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002$'M\u00172e5\u001a\u0014\u0007\t\u001a4uUJ$(\u000e\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Qe+\u0015I\u0015\u0017!cAb\u0003\u0005^5nKN$\u0018-\u001c9(eA\u0002\u0004'\f\u00192[A\n\u0004\u0005M\u0019;aIR\u0004g\r\u00182eM\"TGN\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u0019.aEj\u0003'\r\u00111ci\u0002$G\u000f\u00194]E\u00124\u0007N\u001b7\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018E\u0001B\u0011\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#Aa\n\u0002\u000bMr3G\f\u0019\u0002\u0019QKW.Z:uC6\u0004\u0018\t\u001a3\u0011\u0005u*3#B\u0013\u00030\tm\u0002#\u0003B\u0019\u0005oQV-Z7t\u001b\t\u0011\u0019DC\u0002\u00036!\u000bqA];oi&lW-\u0003\u0003\u0003:\tM\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiA!!Q\bB\"\u001b\t\u0011yD\u0003\u0003\u0003B\u0005\u0005\u0013AA5p\u0013\r1&q\b\u000b\u0003\u0005W\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u000b\fQ!\u00199qYf$\u0012b\u001dB(\u0005#\u0012\u0019F!\u0016\t\u000baC\u0003\u0019\u0001.\t\u000b\rD\u0003\u0019A3\t\u000b%D\u0003\u0019A3\t\u000f-D\u0003\u0013!a\u0001[\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tu#Q\r\t\u0005\u000f:\u0014y\u0006E\u0004H\u0005CRV-Z7\n\u0007\t\r\u0004J\u0001\u0004UkBdW\r\u000e\u0005\t\u0005OR\u0013\u0011!a\u0001g\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u0011y\u0007\u0005\u0003\u0002H\nE\u0014\u0002\u0002B:\u0003\u0013\u0014aa\u00142kK\u000e$\b")
public class TimestampAdd
extends BinaryExpression
implements ImplicitCastInputTypes,
TimeZoneAwareExpression,
Serializable {
    private transient ZoneId zoneIdInEval;
    private final String unit;
    private final Expression quantity;
    private final Expression timestamp;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<String> $lessinit$greater$default$4() {
        return TimestampAdd$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple4<String, Expression, Expression, Option<String>>> unapply(TimestampAdd x$0) {
        return TimestampAdd$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$4() {
        return TimestampAdd$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple4<String, Expression, Expression, Option<String>>, TimestampAdd> tupled() {
        return TimestampAdd$.MODULE$.tupled();
    }

    public static Function1<String, Function1<Expression, Function1<Expression, Function1<Option<String>, TimestampAdd>>>> curried() {
        return TimestampAdd$.MODULE$.curried();
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    private boolean resolved$lzycompute() {
        TimestampAdd timestampAdd = this;
        synchronized (timestampAdd) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if (!this.bitmap$0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        TimestampAdd timestampAdd = this;
        synchronized (timestampAdd) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public String unit() {
        return this.unit;
    }

    public Expression quantity() {
        return this.quantity;
    }

    public Expression timestamp() {
        return this.timestamp;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Expression left() {
        return this.quantity();
    }

    @Override
    public Expression right() {
        return this.timestamp();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)LongType$.MODULE$, (List)new .colon.colon((Object)AnyTimestampType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return this.timestamp().dataType();
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        String x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        return this.copy(x$2, x$3, x$4, (Option<String>)x$1);
    }

    private ZoneId zoneIdInEval$lzycompute() {
        TimestampAdd timestampAdd = this;
        synchronized (timestampAdd) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.zoneIdInEval = this.zoneIdForType(this.timestamp().dataType());
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.zoneIdInEval;
    }

    private ZoneId zoneIdInEval() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.zoneIdInEval$lzycompute();
        }
        return this.zoneIdInEval;
    }

    @Override
    public Object nullSafeEval(Object q, Object micros) {
        return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.timestampAdd(this.unit(), BoxesRunTime.unboxToLong((Object)q), BoxesRunTime.unboxToLong((Object)micros), this.zoneIdInEval()));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName()), "$");
        String zid = ctx.addReferenceObj("zoneId", this.zoneIdInEval(), ZoneId.class.getName());
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(q, micros) -> dtu + ".timestampAdd(\"" + this.unit() + "\", " + q + ", " + micros + ", " + zid + ")");
    }

    @Override
    public String prettyName() {
        return "timestampadd";
    }

    @Override
    public String sql() {
        String string = this.unit();
        String childrenSQL = ((IterableOnceOps)((SeqOps)this.children().map((Function1 & Serializable)x$17 -> x$17.sql())).$plus$colon((Object)string)).mkString(", ");
        return this.prettyName() + "(" + childrenSQL + ")";
    }

    @Override
    public TimestampAdd withNewChildrenInternal(Expression newLeft, Expression newRight) {
        Expression x$1 = newLeft;
        Expression x$2 = newRight;
        String x$3 = this.copy$default$1();
        Option<String> x$4 = this.copy$default$4();
        return this.copy(x$3, x$1, x$2, x$4);
    }

    public TimestampAdd copy(String unit, Expression quantity, Expression timestamp, Option<String> timeZoneId) {
        return new TimestampAdd(unit, quantity, timestamp, timeZoneId);
    }

    public String copy$default$1() {
        return this.unit();
    }

    public Expression copy$default$2() {
        return this.quantity();
    }

    public Expression copy$default$3() {
        return this.timestamp();
    }

    public Option<String> copy$default$4() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "TimestampAdd";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.unit();
            }
            case 1: {
                return this.quantity();
            }
            case 2: {
                return this.timestamp();
            }
            case 3: {
                return this.timeZoneId();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TimestampAdd;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "unit";
            }
            case 1: {
                return "quantity";
            }
            case 2: {
                return "timestamp";
            }
            case 3: {
                return "timeZoneId";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TimestampAdd)) return false;
        boolean bl = true;
        if (!bl) return false;
        TimestampAdd timestampAdd = (TimestampAdd)x$1;
        String string = this.unit();
        String string2 = timestampAdd.unit();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Expression expression = this.quantity();
        Expression expression2 = timestampAdd.quantity();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.timestamp();
        Expression expression4 = timestampAdd.timestamp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = timestampAdd.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!timestampAdd.canEqual(this)) return false;
        return true;
    }

    public TimestampAdd(String unit, Expression quantity, Expression timestamp, Option<String> timeZoneId) {
        this.unit = unit;
        this.quantity = quantity;
        this.timestamp = timestamp;
        this.timeZoneId = timeZoneId;
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        Statics.releaseFence();
    }

    public TimestampAdd(String unit, Expression quantity, Expression timestamp) {
        this(unit, quantity, timestamp, (Option<String>)None$.MODULE$);
    }

    public TimestampAdd(Expression unit, Expression quantity, Expression timestamp) {
        this(TimeZoneAwareExpression$.MODULE$.convertExpressionToUnit(unit, "timestamp_add"), quantity, timestamp);
    }
}

