/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Formatter;
import java.util.Locale;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FormatString$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringLiteral$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(strfmt, obj, ...) - Returns a formatted string from printf-style format strings.", examples="\n    Examples:\n      > SELECT _FUNC_(\"Hello World %d %s\", 100, \"days\");\n       Hello World 100 days\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005%h\u0001B\u000f\u001f\u0001.B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\")1\n\u0001C\u0001\u0019\")q\n\u0001C!!\")A\u000b\u0001C!!\")Q\u000b\u0001C!!\")a\u000b\u0001C!/\")a\f\u0001C!?\")a\r\u0001C!O\")a\u000e\u0001C!_\")\u0011\u0010\u0001C!u\"9\u0011\u0011\u0003\u0001\u0005B\u0005M\u0001bBA\u0013\u0001\u0011E\u0013q\u0005\u0005\b\u0003g\u0001A\u0011BA\u001b\u0011%\t\t\u0005AA\u0001\n\u0003\n\u0019\u0005C\u0005\u0002T\u0001\t\t\u0011\"\u0001\u0002V!I\u0011Q\f\u0001\u0002\u0002\u0013\u0005\u0011q\f\u0005\n\u0003K\u0002\u0011\u0011!C!\u0003OB\u0011\"!\u001e\u0001\u0003\u0003%\t!a\u001e\t\u0013\u0005m\u0004!!A\u0005B\u0005u\u0004\"CAA\u0001\u0005\u0005I\u0011IAB\u000f%\t9KHA\u0001\u0012\u0003\tIK\u0002\u0005\u001e=\u0005\u0005\t\u0012AAV\u0011\u0019Yu\u0003\"\u0001\u0002D\"I\u0011QY\f\u0002\u0002\u0013\u0015\u0013q\u0019\u0005\n\u0003\u0013<\u0012\u0011!CA\u0003\u0017D\u0011\"a4\u0018\u0003\u0003%\t)!5\t\u0013\u0005}w#!A\u0005\n\u0005\u0005(\u0001\u0004$pe6\fGo\u0015;sS:<'BA\u0010!\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0005\u0012\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001a\u0003gM\u001d\u0011\u00055rS\"\u0001\u0010\n\u0005=r\"AC#yaJ,7o]5p]B\u0011Q&M\u0005\u0003ey\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\b!J|G-^2u!\tQ$I\u0004\u0002<\u0001:\u0011AhP\u0007\u0002{)\u0011aHK\u0001\u0007yI|w\u000e\u001e \n\u0003YJ!!Q\u001b\u0002\u000fA\f7m[1hK&\u00111\t\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003\u0003V\n\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002\u000fB\u0019A\u0007\u0013\u0017\n\u0005%+$A\u0003\u001fsKB,\u0017\r^3e}\u0005I1\r[5mIJ,g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00055s\u0005CA\u0017\u0001\u0011\u0015)5\u00011\u0001H\u0003!1w\u000e\u001c3bE2,W#A)\u0011\u0005Q\u0012\u0016BA*6\u0005\u001d\u0011un\u001c7fC:\f!dY8oi\u0016DH/\u00138eKB,g\u000eZ3oi\u001a{G\u000eZ1cY\u0016\f\u0001B\\;mY\u0006\u0014G.Z\u0001\tI\u0006$\u0018\rV=qKV\t\u0001\f\u0005\u0002Z96\t!L\u0003\u0002\\E\u0005)A/\u001f9fg&\u0011QL\u0017\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003\u0001\u00042AO1d\u0013\t\u0011GIA\u0002TKF\u0004\"!\u00173\n\u0005\u0015T&\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005A\u0007CA5m\u001b\u0005Q'BA6!\u0003!\tg.\u00197zg&\u001c\u0018BA7k\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001B3wC2$\"\u0001]:\u0011\u0005Q\n\u0018B\u0001:6\u0005\r\te.\u001f\u0005\bi*\u0001\n\u00111\u0001v\u0003\u0015Ig\u000e];u!\t1x/D\u0001!\u0013\tA\bEA\u0006J]R,'O\\1m%><\u0018!\u00033p\u000f\u0016t7i\u001c3f)\u0015Y\u00181AA\u0007!\tax0D\u0001~\u0015\tqh$A\u0004d_\u0012,w-\u001a8\n\u0007\u0005\u0005QP\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\t)a\u0003a\u0001\u0003\u000f\t1a\u0019;y!\ra\u0018\u0011B\u0005\u0004\u0003\u0017i(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u001fY\u0001\u0019A>\u0002\u0005\u00154\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011Q\u0003\t\u0005\u0003/\tyB\u0004\u0003\u0002\u001a\u0005m\u0001C\u0001\u001f6\u0013\r\ti\"N\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00121\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005uQ'A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR\u0019Q*!\u000b\t\u000f\u0005-R\u00021\u0001\u0002.\u0005Ya.Z<DQ&dGM]3o!\u0011Q\u0014q\u0006\u0017\n\u0007\u0005EBI\u0001\u0006J]\u0012,\u00070\u001a3TKF\f\u0011d\u00195fG.\f%oZ;nK:$\u0018J\u001c3fq:{GOW3s_R!\u0011qGA\u001f!\r!\u0014\u0011H\u0005\u0004\u0003w)$\u0001B+oSRDa!a\u0010\u000f\u0001\u0004a\u0013AC3yaJ,7o]5p]\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!\u0012\u0011\t\u0005\u001d\u0013\u0011K\u0007\u0003\u0003\u0013RA!a\u0013\u0002N\u0005!A.\u00198h\u0015\t\ty%\u0001\u0003kCZ\f\u0017\u0002BA\u0011\u0003\u0013\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0016\u0011\u0007Q\nI&C\u0002\u0002\\U\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2\u0001]A1\u0011%\t\u0019'EA\u0001\u0002\u0004\t9&A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003S\u0002R!a\u001b\u0002rAl!!!\u001c\u000b\u0007\u0005=T'\u0001\u0006d_2dWm\u0019;j_:LA!a\u001d\u0002n\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r\t\u0016\u0011\u0010\u0005\t\u0003G\u001a\u0012\u0011!a\u0001a\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t)%a \t\u0013\u0005\rD#!AA\u0002\u0005]\u0013AB3rk\u0006d7\u000fF\u0002R\u0003\u000bC\u0001\"a\u0019\u0016\u0003\u0003\u0005\r\u0001\u001d\u0015\u0014\u0001\u0005%\u0015qRAI\u0003+\u000b9*a'\u0002\u001e\u0006\u0005\u00161\u0015\t\u0004[\u0005-\u0015bAAG=\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAJ\u0003]{f)\u0016(D?\"\u001aHO\u001d4ni2\u0002sN\u00196-A9rc&\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007EZ8s[\u0006$H/\u001a3!gR\u0014\u0018N\\4!MJ|W\u000e\t9sS:$h-L:us2,\u0007EZ8s[\u0006$\be\u001d;sS:<7OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011T\u0001g\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012\u0003*\u001a7m_\u0002:vN\u001d7eA\u0015\"\u0007%J:#Y\u0001\n\u0004\u0007\r\u0017!E\u0011\f\u0017p\u001d\u0012*w)\u0001\u0003\u0005\t\u0011!A\u0001BU\r\u001c7pA]{'\u000f\u001c3!cA\u0002\u0004\u0005Z1zg*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002 \u0006)\u0011GL\u001b/a\u0005)qM]8va\u0006\u0012\u0011QU\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\r\r>\u0014X.\u0019;TiJLgn\u001a\t\u0003[]\u0019RaFAW\u0003s\u0003b!a,\u00026\u001ekUBAAY\u0015\r\t\u0019,N\u0001\beVtG/[7f\u0013\u0011\t9,!-\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0002<\u0006\u0005WBAA_\u0015\u0011\ty,!\u0014\u0002\u0005%|\u0017bA\"\u0002>R\u0011\u0011\u0011V\u0001\ti>\u001cFO]5oOR\u0011\u0011QI\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u001b\u00065\u0007\"B#\u001b\u0001\u00049\u0015AC;oCB\u0004H._*fcR!\u00111[An!\u0015!\u0014Q[Am\u0013\r\t9.\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007i\nG\u0006\u0003\u0005\u0002^n\t\t\u00111\u0001N\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003G\u0004B!a\u0012\u0002f&!\u0011q]A%\u0005\u0019y%M[3di\u0002")
public class FormatString
extends Expression
implements ImplicitCastInputTypes,
Serializable {
    private final Seq<Expression> children;

    public static Option<Seq<Expression>> unapplySeq(FormatString x$0) {
        return FormatString$.MODULE$.unapplySeq(x$0);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<FormatString, A> g) {
        return FormatString$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, FormatString> compose(Function1<A$, Seq<Expression>> g) {
        return FormatString$.MODULE$.compose(g);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)x$24.foldable()));
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.children().forall((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)x$25.contextIndependentFoldable()));
    }

    @Override
    public boolean nullable() {
        return ((Expression)this.children().apply(0)).nullable();
    }

    @Override
    public DataType dataType() {
        return ((Expression)this.children().apply(0)).dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StringTypeWithCollation stringTypeWithCollation = StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3());
        return ((List)package$.MODULE$.List().fill(this.children().size() - 1, (Function0 & Serializable)() -> AnyDataType$.MODULE$)).$colon$colon((Object)stringTypeWithCollation);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (this.children().isEmpty()) {
            throw QueryCompilationErrors$.MODULE$.wrongNumArgsError(Cast$.MODULE$.toSQLId(this.prettyName()), (Seq<Object>)new .colon.colon((Object)"> 0", (List)Nil$.MODULE$), this.children().length(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$4(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$5(), QueryCompilationErrors$.MODULE$.wrongNumArgsError$default$6());
        }
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        Object pattern = ((Expression)this.children().apply(0)).eval(input);
        if (pattern == null) {
            return null;
        }
        Formatter formatter = new Formatter(Locale.US);
        Seq arglist = (Seq)((IterableOps)this.children().tail()).map((Function1 & Serializable)x$26 -> x$26.eval(input));
        return UTF8String.fromString((String)formatter.format(((UTF8String)pattern).toString(), (Object[])arglist.toArray(ClassTag$.MODULE$.AnyRef())).toString());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode pattern = ((Expression)this.children().head()).genCode(ctx);
        Seq argListGen = (Seq)((IterableOps)this.children().tail()).map((Function1 & Serializable)x -> new Tuple2((Object)x.dataType(), (Object)x.genCode(ctx)));
        String argList = ctx.freshName("argLists");
        int numArgLists = argListGen.length();
        Seq argListCode = (Seq)((IterableOps)argListGen.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple2 v = (Tuple2)tuple2._1();
                int index = tuple2._2$mcI$sp();
                String string = CodeGenerator$.MODULE$.boxedType((DataType)v._1());
                String string2 = CodeGenerator$.MODULE$.javaType((DataType)v._1());
                String value = (string == null ? string2 != null : !string.equals(string2)) ? "(" + ((ExprCode)v._2()).isNull() + ") ? (" + CodeGenerator$.MODULE$.boxedType((DataType)v._1()) + ") null : new " + CodeGenerator$.MODULE$.boxedType((DataType)v._1()) + "(" + ((ExprCode)v._2()).value() + ")" : "(" + ((ExprCode)v._2()).isNull() + ") ? null : " + ((ExprCode)v._2()).value();
                return "\n         " + ((ExprCode)v._2()).code() + "\n         " + argList + "[" + index + "] = " + value + ";\n       ";
            }
            throw new MatchError((Object)tuple2);
        });
        Tuple2 tuple2 = new Tuple2((Object)"Object[]", (Object)argList);
        String argListCodes = ctx.splitExpressionsWithCurrentInputs((Seq<String>)argListCode, "valueFormatString", (Seq<Tuple2<String, String>>)Nil$.MODULE$.$colon$colon((Object)tuple2), ctx.splitExpressionsWithCurrentInputs$default$4(), ctx.splitExpressionsWithCurrentInputs$default$5(), ctx.splitExpressionsWithCurrentInputs$default$6());
        String form = ctx.freshName("formatter");
        String formatter = Formatter.class.getName();
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      ", "\n      boolean ", " = ", ";\n      ", " ", " = ", ";\n      if (!", ") {\n        ", " ", " = new ", "(", ".US);\n        Object[] ", " = new Object[", "];\n        ", "\n        ", " = UTF8String.fromString(\n          ", ".format(", ".toString(), ", ").toString());\n      }"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{pattern.code(), ev.isNull(), pattern.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), formatter, form, formatter, Locale.class.getName(), argList, BoxesRunTime.boxToInteger((int)numArgLists), argListCodes, ev.value(), form, pattern.value(), argList})), ev.copy$default$2(), ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "format_string");
    }

    @Override
    public FormatString withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return new FormatString((Seq<Expression>)newChildren);
    }

    private void checkArgumentIndexNotZero(Expression expression) {
        String pattern;
        Option<String> option;
        Expression expression2 = expression;
        if (expression2 != null && !(option = StringLiteral$.MODULE$.unapply(expression2)).isEmpty() && (pattern = (String)option.get()).contains("%0$")) {
            throw QueryCompilationErrors$.MODULE$.zeroArgumentIndexError();
        }
    }

    @Override
    public String productPrefix() {
        return "FormatString";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.children();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FormatString;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "children";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FormatString)) return false;
        boolean bl = true;
        if (!bl) return false;
        FormatString formatString = (FormatString)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = formatString.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!formatString.canEqual(this)) return false;
        return true;
    }

    public FormatString(Seq<Expression> children2) {
        block0: {
            this.children = children2;
            ExpectsInputTypes.$init$(this);
            if (!children2.nonEmpty() || BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.ALLOW_ZERO_INDEX_IN_FORMAT_STRING()))) break block0;
            this.checkArgumentIndexNotZero((Expression)children2.apply(0));
        }
    }
}

