/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.pipelines.graph;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.PersistedView$;
import org.apache.spark.sql.catalyst.analysis.ViewSchemaMode;
import org.apache.spark.sql.catalyst.analysis.ViewType;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.CatalogV2Util$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.TableInfo;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.command.CreateViewCommand;
import org.apache.spark.sql.execution.command.CreateViewCommand$;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.DataflowGraphTransformer;
import org.apache.spark.sql.pipelines.graph.DataflowGraphTransformer$;
import org.apache.spark.sql.pipelines.graph.DatasetManager;
import org.apache.spark.sql.pipelines.graph.PersistedView;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContext;
import org.apache.spark.sql.pipelines.graph.PipelinesTableProperties$;
import org.apache.spark.sql.pipelines.graph.QueryContext;
import org.apache.spark.sql.pipelines.graph.QueryOrigin;
import org.apache.spark.sql.pipelines.graph.QueryOrigin$;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.View;
import org.apache.spark.sql.pipelines.graph.ViewHelpers$;
import org.apache.spark.sql.pipelines.logging.FlowProgressEventLogger;
import org.apache.spark.sql.pipelines.util.SchemaInferenceUtils$;
import org.apache.spark.sql.pipelines.util.SchemaMergingUtils$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SetOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class DatasetManager$
implements Logging {
    public static final DatasetManager$ MODULE$ = new DatasetManager$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DataflowGraph materializeDatasets(DataflowGraph resolvedDataflowGraph, PipelineUpdateContext context) {
        DataflowGraph dataflowGraph;
        Tuple3<Seq<Table>, Seq<TableIdentifier>, Seq<TableIdentifier>> tuple3 = this.constructFullRefreshSet(resolvedDataflowGraph.tables(), context);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Seq refreshTableIdentsSet = (Seq)tuple3._2();
        Seq fullRefreshTableIdentsSet = (Seq)tuple3._3();
        Tuple2 tuple2 = new Tuple2((Object)refreshTableIdentsSet, (Object)fullRefreshTableIdentsSet);
        Seq refreshTableIdentsSet2 = (Seq)tuple2._1();
        Seq fullRefreshTableIdentsSet2 = (Seq)tuple2._2();
        scala.collection.immutable.Map tablesToMaterialize = ((IterableOnceOps)DatasetManager$.tablesToMatz$1(resolvedDataflowGraph, fullRefreshTableIdentsSet2, refreshTableIdentsSet2).map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.table().identifier()), t))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        try {
            dataflowGraph = ((DataflowGraphTransformer)DataflowGraphTransformer$.MODULE$.withDataflowGraphTransformer(resolvedDataflowGraph, (Function1 & Serializable)transformer -> transformer.transformTables((Function1<Table, Table>)(Function1 & Serializable)table -> {
                if (tablesToMaterialize.keySet().contains((Object)table.identifier())) {
                    Table table2;
                    try {
                        table2 = MODULE$.materializeTable(resolvedDataflowGraph, (Table)table, ((DatasetManager.TableRefreshType)tablesToMaterialize.apply((Object)table.identifier())).isFullRefresh(), context);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable throwable3 = throwable;
                        if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                            throw new DatasetManager.TableMaterializationException(table.displayName(), QueryOrigin$.MODULE$.ExceptionHelpers(throwable2).addOrigin(table.origin()));
                        }
                        throw throwable;
                    }
                    return table2;
                }
                return table;
            }))).getDataflowGraph();
        }
        catch (Throwable throwable) {
            SparkException sparkException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SparkException && (sparkException = (SparkException)throwable2).getCause() != null) {
                throw sparkException.getCause();
            }
            throw throwable;
        }
        DataflowGraph materializedGraph = dataflowGraph;
        this.materializeViews(materializedGraph, context);
        return materializedGraph;
    }

    private void materializeViews(DataflowGraph virtualizedConnectedGraphWithTables, PipelineUpdateContext context) {
        ObjectRef viewsToPublish = ObjectRef.create((Object)virtualizedConnectedGraphWithTables.persistedViews().toSet());
        ObjectRef publishedViews = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        ObjectRef failedViews = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        scala.collection.immutable.Set persistedViewIdentifiers = ((IterableOnceOps)virtualizedConnectedGraphWithTables.persistedViews().map((Function1 & Serializable)x$2 -> x$2.identifier())).toSet();
        scala.collection.immutable.Map<TableIdentifier, ResolvedFlow> viewToFlowMap = ViewHelpers$.MODULE$.persistedViewIdentifierToFlow(virtualizedConnectedGraphWithTables);
        scala.collection.immutable.Map materializationDependencies = ((IterableOnceOps)virtualizedConnectedGraphWithTables.persistedViews().map((Function1 & Serializable)v -> {
            ResolvedFlow flow = (ResolvedFlow)viewToFlowMap.apply((Object)v.identifier());
            scala.collection.immutable.Set inputs = (scala.collection.immutable.Set)flow.inputs().intersect((Set)persistedViewIdentifiers);
            return new Tuple2((Object)v.identifier(), (Object)inputs);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        while (((scala.collection.immutable.Set)viewsToPublish.elem).nonEmpty()) {
            ((IterableOnceOps)((scala.collection.immutable.Set)viewsToPublish.elem).filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)DatasetManager$.$anonfun$materializeViews$3(materializationDependencies, failedViews, v)))).foreach((Function1 & Serializable)v -> {
                DatasetManager$.$anonfun$materializeViews$5(viewToFlowMap, context, failedViews, viewsToPublish, v);
                return BoxedUnit.UNIT;
            });
            ((IterableOnceOps)((scala.collection.immutable.Set)viewsToPublish.elem).filter((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)DatasetManager$.$anonfun$materializeViews$6(materializationDependencies, publishedViews, v)))).foreach((Function1 & Serializable)v -> {
                DatasetManager$.$anonfun$materializeViews$7(viewToFlowMap, context, publishedViews, viewsToPublish, failedViews, v);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void materializeView(View view, ResolvedFlow flow, org.apache.spark.sql.classic.SparkSession spark) {
        TableIdentifier x$1 = view.identifier();
        Nil$ x$2 = Nil$.MODULE$;
        PersistedView$ x$3 = PersistedView$.MODULE$;
        Option<String> x$4 = view.comment();
        None$ x$5 = None$.MODULE$;
        scala.collection.immutable.Map<String, String> x$6 = view.properties();
        Option<String> x$7 = view.sqlText();
        LogicalPlan x$8 = flow.df().logicalPlan();
        boolean x$9 = true;
        boolean x$10 = true;
        boolean x$11 = true;
        ViewSchemaMode x$12 = CreateViewCommand$.MODULE$.apply$default$11();
        Seq x$13 = CreateViewCommand$.MODULE$.apply$default$13();
        CreateViewCommand command = new CreateViewCommand(x$1, (Seq)x$2, x$4, (Option)x$5, x$6, x$7, x$8, true, true, (ViewType)x$3, x$12, true, x$13);
        QueryContext queryContext = flow.queryContext();
        CatalogManager catalogManager = spark.sessionState().catalogManager();
        String currentCatalogName = catalogManager.currentCatalog().name();
        String[] currentNamespace = catalogManager.currentNamespace();
        try {
            catalogManager.setCurrentCatalog((String)queryContext.currentCatalog().get());
            queryContext.currentDatabase().foreach((Function1 & Serializable)d -> {
                catalogManager.setCurrentNamespace((String[])((Object[])new String[]{d}));
                return BoxedUnit.UNIT;
            });
            command.run((SparkSession)spark);
        }
        finally {
            catalogManager.setCurrentCatalog(currentCatalogName);
            catalogManager.setCurrentNamespace(currentNamespace);
        }
    }

    private Table materializeTable(DataflowGraph resolvedDataflowGraph, Table table, boolean isFullRefresh, PipelineUpdateContext context) {
        None$ existingTableOpt;
        CatalogPlugin catalogPlugin;
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Materializing metadata for table ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TABLE_NAME, table.identifier())}))));
        CatalogManager catalogManager = context.spark().sessionState().catalogManager();
        Option option = table.identifier().catalog();
        if (option instanceof Some) {
            Some some = (Some)option;
            String catalogName = (String)some.value();
            catalogPlugin = catalogManager.catalog(catalogName);
        } else if (None$.MODULE$.equals(option)) {
            catalogPlugin = catalogManager.currentCatalog();
        } else {
            throw new MatchError((Object)option);
        }
        TableCatalog catalog = (TableCatalog)catalogPlugin;
        Identifier identifier = Identifier.of((String[])((String[])((Object[])new String[]{(String)table.identifier().database().get()})), (String)table.identifier().identifier());
        StructType outputSchema = (StructType)table.specifiedSchema().getOrElse((Function0 & Serializable)() -> ((StructType)resolvedDataflowGraph.inferredSchema().apply((Object)table.identifier())).asNullable());
        scala.collection.immutable.Map<String, String> mergedProperties = this.resolveTableProperties(table, identifier);
        Seq partitioning = (Seq)((IterableOps)Option$.MODULE$.option2Iterable(table.partitionCols()).toSeq().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)x$1 -> Expressions.identity((String)x$1));
        Object object = existingTableOpt = catalog.tableExists(identifier) ? new Some((Object)catalog.loadTable(identifier)) : None$.MODULE$;
        if (existingTableOpt.isDefined()) {
            Seq existingPartitioning;
            Seq seq = existingPartitioning = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])((org.apache.spark.sql.connector.catalog.Table)existingTableOpt.get()).partitioning()));
            Seq seq2 = partitioning;
            if (seq == null ? seq2 != null : !seq.equals(seq2)) {
                throw new AnalysisException("CANNOT_UPDATE_PARTITION_COLUMNS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"existingPartitionColumns"), (Object)existingPartitioning.mkString(", ")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requestedPartitionColumns"), (Object)partitioning.mkString(", "))})));
            }
        }
        Object object2 = (isFullRefresh || !table.isStreamingTable()) && existingTableOpt.isDefined() ? context.spark().sql("TRUNCATE TABLE " + table.identifier().quotedString()) : BoxedUnit.UNIT;
        if (existingTableOpt.isDefined()) {
            StructType existingSchema = CatalogV2Util$.MODULE$.v2ColumnsToStructType(((org.apache.spark.sql.connector.catalog.Table)existingTableOpt.get()).columns());
            StructType targetSchema = table.isStreamingTable() && !isFullRefresh ? SchemaMergingUtils$.MODULE$.mergeSchemas(existingSchema, outputSchema) : outputSchema;
            Seq<TableChange> columnChanges = SchemaInferenceUtils$.MODULE$.diffSchemas(existingSchema, targetSchema);
            Iterable setProperties = (Iterable)mergedProperties.map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    return TableChange.setProperty((String)k, (String)v);
                }
                throw new MatchError((Object)tuple2);
            });
            v4 = catalog.alterTable(identifier, (TableChange[])((IterableOnceOps)columnChanges.$plus$plus((IterableOnce)setProperties)).toArray(ClassTag$.MODULE$.apply(TableChange.class)));
        } else {
            v4 = BoxedUnit.UNIT;
        }
        Object object3 = existingTableOpt.isEmpty() ? catalog.createTable(identifier, new TableInfo.Builder().withProperties(CollectionConverters$.MODULE$.MapHasAsJava(mergedProperties).asJava()).withColumns(CatalogV2Util$.MODULE$.structTypeToV2Columns(outputSchema)).withPartitions((Transform[])partitioning.toArray(ClassTag$.MODULE$.apply(Transform.class))).build()) : BoxedUnit.UNIT;
        Option x$12 = Option$.MODULE$.apply(catalog.loadTable(identifier).properties().get("location"));
        TableIdentifier x$2 = table.copy$default$1();
        Option<StructType> x$3 = table.copy$default$2();
        Option<Seq<String>> x$4 = table.copy$default$3();
        scala.collection.immutable.Map<String, String> x$5 = table.copy$default$5();
        Option<String> x$6 = table.copy$default$6();
        QueryOrigin x$7 = table.copy$default$7();
        boolean x$8 = table.copy$default$8();
        Option<String> x$9 = table.copy$default$9();
        return table.copy(x$2, x$3, x$4, (Option<String>)x$12, x$5, x$6, x$7, x$8, x$9);
    }

    private scala.collection.immutable.Map<String, String> resolveTableProperties(Table table, Identifier identifier) {
        scala.collection.immutable.Map<String, String> validatedAndCanonicalizedProps = PipelinesTableProperties$.MODULE$.validateAndCanonicalize(table.properties(), (Function1<String, BoxedUnit>)(Function1 & Serializable)s -> {
            DatasetManager$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable)() -> s);
            return BoxedUnit.UNIT;
        });
        Seq specialProps = (Seq)((IterableOps)new .colon.colon((Object)new Tuple3(table.comment(), (Object)"comment", (Object)"comment"), (List)new .colon.colon((Object)new Tuple3(table.format(), (Object)"format", (Object)"provider"), (List)Nil$.MODULE$)).map((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                Option value = (Option)tuple3._1();
                String name = (String)tuple3._2();
                String reservedPropKey = (String)tuple3._3();
                validatedAndCanonicalizedProps.get((Object)reservedPropKey).foreach((Function1 & Serializable)pc -> {
                    DatasetManager$.$anonfun$resolveTableProperties$4(value, identifier, name, reservedPropKey, pc);
                    return BoxedUnit.UNIT;
                });
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)reservedPropKey), (Object)value);
            }
            throw new MatchError((Object)tuple3);
        })).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<String, Option<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String key = (String)A1._1();
                    Option option = (Option)A1._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String value = (String)some.value();
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, Option<String>> x1) {
                Option option;
                Tuple2<String, Option<String>> tuple2 = x1;
                return tuple2 != null && (option = (Option)tuple2._2()) instanceof Some;
            }
        });
        return (scala.collection.immutable.Map)validatedAndCanonicalizedProps.$plus$plus((IterableOnce)specialProps);
    }

    private Tuple3<Seq<Table>, Seq<TableIdentifier>, Seq<TableIdentifier>> constructFullRefreshSet(Seq<Table> graphTables, PipelineUpdateContext context) {
        Tuple2 tuple2;
        Seq<Table> specifiedFullRefreshTables = context.fullRefreshTables().filter(graphTables);
        Seq<Table> specifiedRefreshTables = context.refreshTables().filter(graphTables);
        Tuple2 tuple22 = specifiedFullRefreshTables.partition((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)DatasetManager$.$anonfun$constructFullRefreshSet$1(t)));
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Seq fullRefreshAllowed = (Seq)tuple22._1();
        Seq fullRefreshNotAllowed = (Seq)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)fullRefreshAllowed, (Object)fullRefreshNotAllowed);
        Seq fullRefreshAllowed2 = (Seq)tuple23._1();
        Seq fullRefreshNotAllowed2 = (Seq)tuple23._2();
        Seq refreshTables = (Seq)((IterableOps)specifiedRefreshTables.$plus$plus((IterableOnce)fullRefreshNotAllowed2)).filterNot((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)fullRefreshAllowed2.contains((Object)t)));
        if (fullRefreshNotAllowed2.nonEmpty()) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping full refresh on some tables because "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.PROPERTY_NAME, PipelinesTableProperties$.MODULE$.resetAllowed().key())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"was set to false. Tables: "}))).log((Seq)Nil$.MODULE$)).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.TABLE_NAME, fullRefreshNotAllowed2.map((Function1 & Serializable)x$4 -> x$4.identifier()))})))));
        }
        if ((tuple2 = new Tuple2((Object)fullRefreshAllowed2, (Object)refreshTables)) == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq fullRefreshTablesSet = (Seq)tuple2._1();
        Seq refreshTablesSet = (Seq)tuple2._2();
        Tuple2 tuple24 = new Tuple2((Object)fullRefreshTablesSet, (Object)refreshTablesSet);
        Seq fullRefreshTablesSet2 = (Seq)tuple24._1();
        Seq refreshTablesSet2 = (Seq)tuple24._2();
        Seq allRefreshTables = (Seq)fullRefreshTablesSet2.$plus$plus((IterableOnce)refreshTablesSet2);
        Seq refreshTableIdentsSet = (Seq)refreshTablesSet2.map((Function1 & Serializable)x$6 -> x$6.identifier());
        Seq fullRefreshTableIdentsSet = (Seq)fullRefreshTablesSet2.map((Function1 & Serializable)x$7 -> x$7.identifier());
        return new Tuple3((Object)allRefreshTables, (Object)refreshTableIdentsSet, (Object)fullRefreshTableIdentsSet);
    }

    private static final Seq tablesToMatz$1(DataflowGraph graph, Seq fullRefreshTableIdentsSet$1, Seq refreshTableIdentsSet$1) {
        return (Seq)((IterableOps)((IterableOps)graph.tables().filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)fullRefreshTableIdentsSet$1.contains((Object)t.identifier())))).map((Function1 & Serializable)table -> new DatasetManager.TableRefreshType((Table)table, true))).$plus$plus((IterableOnce)((IterableOps)graph.tables().filter((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)refreshTableIdentsSet$1.contains((Object)t.identifier())))).map((Function1 & Serializable)table -> new DatasetManager.TableRefreshType((Table)table, false)));
    }

    public static final /* synthetic */ boolean $anonfun$materializeViews$3(scala.collection.immutable.Map materializationDependencies$1, ObjectRef failedViews$1, PersistedView v) {
        scala.collection.immutable.Set set = (scala.collection.immutable.Set)failedViews$1.elem;
        return ((IterableOnceOps)materializationDependencies$1.apply((Object)v.identifier())).exists((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains((Object)elem)));
    }

    public static final /* synthetic */ void $anonfun$materializeViews$5(scala.collection.immutable.Map viewToFlowMap$1, PipelineUpdateContext context$2, ObjectRef failedViews$1, ObjectRef viewsToPublish$1, PersistedView v) {
        ResolvedFlow flowToView = (ResolvedFlow)viewToFlowMap$1.apply((Object)v.identifier());
        context$2.flowProgressEventLogger().recordSkipped(flowToView);
        failedViews$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)failedViews$1.elem).$plus((Object)v.identifier());
        viewsToPublish$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)viewsToPublish$1.elem).$minus((Object)v);
    }

    public static final /* synthetic */ boolean $anonfun$materializeViews$6(scala.collection.immutable.Map materializationDependencies$1, ObjectRef publishedViews$1, PersistedView v) {
        scala.collection.immutable.Set pendingInputs = (scala.collection.immutable.Set)((SetOps)materializationDependencies$1.apply((Object)v.identifier())).diff((Set)((scala.collection.immutable.Set)publishedViews$1.elem));
        return pendingInputs.isEmpty();
    }

    public static final /* synthetic */ void $anonfun$materializeViews$7(scala.collection.immutable.Map viewToFlowMap$1, PipelineUpdateContext context$2, ObjectRef publishedViews$1, ObjectRef viewsToPublish$1, ObjectRef failedViews$1, PersistedView v) {
        ResolvedFlow flowToView = (ResolvedFlow)viewToFlowMap$1.apply((Object)v.identifier());
        try {
            MODULE$.materializeView(v, flowToView, context$2.spark());
            publishedViews$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)publishedViews$1.elem).$plus((Object)v.identifier());
            viewsToPublish$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)viewsToPublish$1.elem).$minus((Object)v);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                FlowProgressEventLogger qual$1 = context$2.flowProgressEventLogger();
                ResolvedFlow x$1 = flowToView;
                Throwable x$2 = throwable2;
                boolean x$3 = false;
                Option<String> x$4 = qual$1.recordFailed$default$4();
                qual$1.recordFailed(x$1, x$2, false, x$4);
                failedViews$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)failedViews$1.elem).$plus((Object)v.identifier());
                viewsToPublish$1.elem = (scala.collection.immutable.Set)((scala.collection.immutable.Set)viewsToPublish$1.elem).$minus((Object)v);
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$resolveTableProperties$4(Option value$1, Identifier identifier$1, String name$1, String reservedPropKey$1, String pc) {
        if (value$1.isDefined()) {
            Object object = value$1.get();
            String string = pc;
            if (object == null ? string != null : !object.equals(string)) {
                throw new IllegalArgumentException("For dataset " + identifier$1 + ", " + name$1 + " '" + value$1.get() + "' does not match value '" + pc + "' for reserved table property '" + reservedPropKey$1 + "''");
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$constructFullRefreshSet$1(Table t) {
        return BoxesRunTime.unboxToBoolean((Object)PipelinesTableProperties$.MODULE$.resetAllowed().fromMap(t.properties()));
    }

    private DatasetManager$() {
    }
}

