/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.cpc;

import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.PairTable;
import org.apache.datasketches.cpc.RuntimeAsserts;

public class TestUtil {
    static final double pwrLaw10NextDouble(int ppb, double curPoint) {
        double next;
        double cur = curPoint < 1.0 ? 1.0 : curPoint;
        double gi = Math.round(Math.log10(cur) * (double)ppb);
        while ((next = (double)Math.round(Math.pow(10.0, (gi += 1.0) / (double)ppb))) <= curPoint) {
        }
        return next;
    }

    static boolean specialEquals(CpcSketch sk1, CpcSketch sk2, boolean sk1wasMerged, boolean sk2wasMerged) {
        RuntimeAsserts.rtAssertEquals(sk1.seed, sk2.seed);
        RuntimeAsserts.rtAssertEquals(sk1.lgK, sk2.lgK);
        RuntimeAsserts.rtAssertEquals(sk1.numCoupons, sk2.numCoupons);
        RuntimeAsserts.rtAssertEquals(sk1.windowOffset, sk2.windowOffset);
        RuntimeAsserts.rtAssertEquals(sk1.slidingWindow, sk2.slidingWindow);
        PairTable.equals(sk1.pairTable, sk2.pairTable);
        int ficolA = sk1.fiCol;
        int ficolB = sk2.fiCol;
        if (!sk1wasMerged && sk2wasMerged) {
            RuntimeAsserts.rtAssert(!sk1.mergeFlag && sk2.mergeFlag);
            int fiCol1 = TestUtil.calculateFirstInterestingColumn(sk1);
            RuntimeAsserts.rtAssertEquals(fiCol1, sk2.fiCol);
        } else if (sk1wasMerged && !sk2wasMerged) {
            RuntimeAsserts.rtAssert(sk1.mergeFlag && !sk2.mergeFlag);
            int fiCol2 = TestUtil.calculateFirstInterestingColumn(sk2);
            RuntimeAsserts.rtAssertEquals(fiCol2, sk1.fiCol);
        } else {
            RuntimeAsserts.rtAssertEquals(sk1.mergeFlag, sk2.mergeFlag);
            RuntimeAsserts.rtAssertEquals(ficolA, ficolB);
            RuntimeAsserts.rtAssertEquals(sk1.kxp, sk2.kxp, 0.01 * sk1.kxp);
            RuntimeAsserts.rtAssertEquals(sk1.hipEstAccum, sk2.hipEstAccum, 1.0 * sk1.hipEstAccum);
        }
        return true;
    }

    static int calculateFirstInterestingColumn(CpcSketch sketch) {
        int offset = sketch.windowOffset;
        if (offset == 0) {
            return 0;
        }
        PairTable table = sketch.pairTable;
        assert (table != null);
        int[] slots = table.getSlotsArr();
        int numSlots = 1 << table.getLgSizeInts();
        int result = offset;
        for (int i = 0; i < numSlots; ++i) {
            int col;
            int rowCol = slots[i];
            if (rowCol == -1 || (col = rowCol & 0x3F) >= result) continue;
            result = col;
        }
        return result;
    }
}

