/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics;

import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.Map;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.metrics.ExecutorMetricType;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Product;
import scala.StringContext;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class GarbageCollectionMetrics$
implements ExecutorMetricType,
Logging,
Product,
Serializable {
    public static final GarbageCollectionMetrics$ MODULE$ = new GarbageCollectionMetrics$();
    private static Seq<String> youngGenerationGarbageCollector;
    private static Seq<String> oldGenerationGarbageCollector;
    private static Seq<String> nonBuiltInCollectors;
    private static final Seq<String> names;
    private static final Seq<String> YOUNG_GENERATION_BUILTIN_GARBAGE_COLLECTORS;
    private static final Seq<String> OLD_GENERATION_BUILTIN_GARBAGE_COLLECTORS;
    private static final String BUILTIN_CONCURRENT_GARBAGE_COLLECTOR;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile byte bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        Product.$init$((Product)MODULE$);
        nonBuiltInCollectors = Nil$.MODULE$;
        names = new .colon.colon((Object)"MinorGCCount", (List)new .colon.colon((Object)"MinorGCTime", (List)new .colon.colon((Object)"MajorGCCount", (List)new .colon.colon((Object)"MajorGCTime", (List)new .colon.colon((Object)"TotalGCTime", (List)new .colon.colon((Object)"ConcurrentGCCount", (List)new .colon.colon((Object)"ConcurrentGCTime", (List)Nil$.MODULE$)))))));
        YOUNG_GENERATION_BUILTIN_GARBAGE_COLLECTORS = new .colon.colon((Object)"Copy", (List)new .colon.colon((Object)"PS Scavenge", (List)new .colon.colon((Object)"ParNew", (List)new .colon.colon((Object)"G1 Young Generation", (List)Nil$.MODULE$))));
        OLD_GENERATION_BUILTIN_GARBAGE_COLLECTORS = new .colon.colon((Object)"MarkSweepCompact", (List)new .colon.colon((Object)"PS MarkSweep", (List)new .colon.colon((Object)"ConcurrentMarkSweep", (List)new .colon.colon((Object)"G1 Old Generation", (List)Nil$.MODULE$))));
        BUILTIN_CONCURRENT_GARBAGE_COLLECTOR = "G1 Concurrent GC";
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Seq<String> nonBuiltInCollectors() {
        return nonBuiltInCollectors;
    }

    private void nonBuiltInCollectors_$eq(Seq<String> x$1) {
        nonBuiltInCollectors = x$1;
    }

    @Override
    public Seq<String> names() {
        return names;
    }

    public Seq<String> YOUNG_GENERATION_BUILTIN_GARBAGE_COLLECTORS() {
        return YOUNG_GENERATION_BUILTIN_GARBAGE_COLLECTORS;
    }

    public Seq<String> OLD_GENERATION_BUILTIN_GARBAGE_COLLECTORS() {
        return OLD_GENERATION_BUILTIN_GARBAGE_COLLECTORS;
    }

    public String BUILTIN_CONCURRENT_GARBAGE_COLLECTOR() {
        return BUILTIN_CONCURRENT_GARBAGE_COLLECTOR;
    }

    private Seq<String> youngGenerationGarbageCollector$lzycompute() {
        GarbageCollectionMetrics$ garbageCollectionMetrics$ = this;
        synchronized (garbageCollectionMetrics$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                youngGenerationGarbageCollector = SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.EVENT_LOG_GC_METRICS_YOUNG_GENERATION_GARBAGE_COLLECTORS());
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return youngGenerationGarbageCollector;
    }

    private Seq<String> youngGenerationGarbageCollector() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.youngGenerationGarbageCollector$lzycompute();
        }
        return youngGenerationGarbageCollector;
    }

    private Seq<String> oldGenerationGarbageCollector$lzycompute() {
        GarbageCollectionMetrics$ garbageCollectionMetrics$ = this;
        synchronized (garbageCollectionMetrics$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                oldGenerationGarbageCollector = SparkEnv$.MODULE$.get().conf().get(package$.MODULE$.EVENT_LOG_GC_METRICS_OLD_GENERATION_GARBAGE_COLLECTORS());
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return oldGenerationGarbageCollector;
    }

    private Seq<String> oldGenerationGarbageCollector() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.oldGenerationGarbageCollector$lzycompute();
        }
        return oldGenerationGarbageCollector;
    }

    @Override
    public long[] getMetricValues(MemoryManager memoryManager) {
        long[] gcMetrics = new long[this.names().length()];
        Buffer mxBeans = CollectionConverters$.MODULE$.ListHasAsScala(ManagementFactory.getGarbageCollectorMXBeans()).asScala();
        gcMetrics[4] = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)mxBeans.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.getCollectionTime()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        mxBeans.foreach((Function1 & Serializable)mxBean -> {
            GarbageCollectionMetrics$.$anonfun$getMetricValues$2(gcMetrics, mxBean);
            return BoxedUnit.UNIT;
        });
        return gcMetrics;
    }

    public String productPrefix() {
        return "GarbageCollectionMetrics";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GarbageCollectionMetrics$;
    }

    public int hashCode() {
        return 794585264;
    }

    public String toString() {
        return "GarbageCollectionMetrics";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GarbageCollectionMetrics$.class);
    }

    public static final /* synthetic */ void $anonfun$getMetricValues$2(long[] gcMetrics$1, GarbageCollectorMXBean mxBean) {
        if (MODULE$.youngGenerationGarbageCollector().contains((Object)mxBean.getName())) {
            gcMetrics$1[0] = mxBean.getCollectionCount();
            gcMetrics$1[1] = mxBean.getCollectionTime();
            return;
        }
        if (MODULE$.oldGenerationGarbageCollector().contains((Object)mxBean.getName())) {
            gcMetrics$1[2] = mxBean.getCollectionCount();
            gcMetrics$1[3] = mxBean.getCollectionTime();
            return;
        }
        if (MODULE$.BUILTIN_CONCURRENT_GARBAGE_COLLECTOR().equals(mxBean.getName())) {
            gcMetrics$1[5] = mxBean.getCollectionCount();
            gcMetrics$1[6] = mxBean.getCollectionTime();
            return;
        }
        if (!MODULE$.nonBuiltInCollectors().contains((Object)mxBean.getName())) {
            String string = mxBean.getName();
            MODULE$.nonBuiltInCollectors_$eq((Seq<String>)((Seq)MODULE$.nonBuiltInCollectors().$plus$colon((Object)string)));
            MDC youngGenerationGc = MODULE$.MDC((LogKey)LogKeys.YOUNG_GENERATION_GC, package$.MODULE$.EVENT_LOG_GC_METRICS_YOUNG_GENERATION_GARBAGE_COLLECTORS().key());
            MDC oldGenerationGc = MODULE$.MDC((LogKey)LogKeys.OLD_GENERATION_GC, package$.MODULE$.EVENT_LOG_GC_METRICS_OLD_GENERATION_GARBAGE_COLLECTORS().key());
            MODULE$.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"To enable non-built-in garbage collector(s) "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.NON_BUILT_IN_CONNECTORS, MODULE$.nonBuiltInCollectors())}))).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"users should configure it(them) to ", " or ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{youngGenerationGc, oldGenerationGc})))));
            return;
        }
    }

    private GarbageCollectionMetrics$() {
    }
}

