/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.BinaryRandomForestClassificationSummaryImpl;
import org.apache.spark.ml.classification.BinaryRandomForestClassificationTrainingSummary;
import org.apache.spark.ml.classification.BinaryRandomForestClassificationTrainingSummaryImpl;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.classification.RandomForestClassificationModel$;
import org.apache.spark.ml.classification.RandomForestClassificationSummary;
import org.apache.spark.ml.classification.RandomForestClassificationSummaryImpl;
import org.apache.spark.ml.classification.RandomForestClassificationTrainingSummary;
import org.apache.spark.ml.classification.RandomForestClassificationTrainingSummaryImpl;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.RandomForestClassifierParams;
import org.apache.spark.ml.tree.RandomForestParams;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleClassifierParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.HasTrainingSummary;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JsonDSL$;
import org.json4s.MonadicJValue$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\rMb\u0001\u0002\u001a4\u0001yB\u0001\u0002\u001d\u0001\u0003\u0006\u0004%\t%\u001d\u0005\n\u0003\u000f\u0001!\u0011!Q\u0001\nID!\"a\u0003\u0001\u0005\u000b\u0007I\u0011BA\u0007\u0011)\t9\u0002\u0001B\u0001B\u0003%\u0011q\u0002\u0005\u000b\u00033\u0001!Q1A\u0005B\u0005m\u0001BCA\u0015\u0001\t\u0005\t\u0015!\u0003\u0002\u001e!Q\u0011Q\u0006\u0001\u0003\u0006\u0004%\t%a\u0007\t\u0015\u0005E\u0002A!A!\u0002\u0013\ti\u0002\u0003\u0005\u00026\u0001!\t!NA\u001c\u0011!\t)\u0004\u0001C\u0001k\u0005\u001d\u0003\u0002CA\u001b\u0001\u0011\u0005Q'!\u0015\t\u000f\u0005M\u0003\u0001\"\u0011\u0002V!9\u00111\n\u0001\u0005B\u00055\u0001BCA2\u0001!\u0015\r\u0011\"\u0003\u0002f!9\u0011q\u000e\u0001\u0005B\u0005\u0015\u0004bBA:\u0001\u0011\u0005\u0013Q\u000f\u0005\b\u0003{\u0002A\u0011AA@\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017Cq!!0\u0001\t\u0003\ny\fC\u0004\u0002T\u0002!\t%!6\t\u000f\u0005}\b\u0001\"\u0011\u0003\u0002!9!Q\u0002\u0001\u0005R\t=\u0001b\u0002B\u000b\u0001\u0011\u0005#q\u0003\u0005\b\u0005W\u0001A\u0011\tB\u0017\u0011)\u0011\t\u0004\u0001EC\u0002\u0013\u0005!1\u0007\u0005\t\u0005o\u0001A\u0011A\u001b\u0003:!9!Q\n\u0001\u0005B\t=\u0003\u0002\u0003B/\u0001\u0011\u0005qGa\u0018\t\u0011\tM\u0004\u0001\"\u00118\u0005kB\u0001Ba\u001f\u0001\t\u0003:$QP\u0004\b\u0005\u000b\u001b\u0004\u0012\u0001BD\r\u0019\u00114\u0007#\u0001\u0003\n\"9\u0011Q\u0007\u0011\u0005\u0002\t\u0015\u0006b\u0002BTA\u0011\u0005#\u0011\u0016\u0005\b\u0005g\u0003C\u0011\tB[\r\u001d\u0011Y\f\t\u0001!\u0005{C\u0011Ba0%\u0005\u0003\u0005\u000b\u0011B%\t\u000f\u0005UB\u0005\"\u0001\u0003B\"9!\u0011\u001a\u0013\u0005R\t-gA\u0002BhA\u0011\u0011\t\u000eC\u0004\u00026!\"\tAa5\t\u0013\t]\u0007F1A\u0005\n\te\u0007\u0002\u0003BsQ\u0001\u0006IAa7\t\u0013\t\u001d\bF1A\u0005\n\te\u0007\u0002\u0003BuQ\u0001\u0006IAa7\t\u000f\tM\u0006\u0006\"\u0011\u0003l\"A!q\u001e\u0011\u0005\u0002U\u0012\t\u0010\u0003\u0006\u0004\u0010\u0001\n\n\u0011\"\u00016\u0007#A\u0011b!\n!\u0003\u0003%Iaa\n\u0003?I\u000bg\u000eZ8n\r>\u0014Xm\u001d;DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,GN\u0003\u00025k\u0005q1\r\\1tg&4\u0017nY1uS>t'B\u0001\u001c8\u0003\tiGN\u0003\u00029s\u0005)1\u000f]1sW*\u0011!hO\u0001\u0007CB\f7\r[3\u000b\u0003q\n1a\u001c:h\u0007\u0001\u0019r\u0001A K!Zc&\u000e\u0005\u0003A\u0003\u000eKU\"A\u001a\n\u0005\t\u001b$\u0001\t)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[2bi&|g.T8eK2\u0004\"\u0001R$\u000e\u0003\u0015S!AR\u001b\u0002\r1Lg.\u00197h\u0013\tAUI\u0001\u0004WK\u000e$xN\u001d\t\u0003\u0001\u0002\u0001\"a\u0013(\u000e\u00031S!!T\u001b\u0002\tQ\u0014X-Z\u0005\u0003\u001f2\u0013ADU1oI>lgi\u001c:fgR\u001cE.Y:tS\u001aLWM\u001d)be\u0006l7\u000fE\u0002L#NK!A\u0015'\u0003#Q\u0013X-Z#og\u0016l'\r\\3N_\u0012,G\u000e\u0005\u0002A)&\u0011Qk\r\u0002 \t\u0016\u001c\u0017n]5p]R\u0013X-Z\"mCN\u001c\u0018NZ5dCRLwN\\'pI\u0016d\u0007CA,[\u001b\u0005A&BA-6\u0003\u0011)H/\u001b7\n\u0005mC&AC'M/JLG/\u00192mKB\u0011Ql\u001a\b\u0003=\u0012t!a\u00182\u000e\u0003\u0001T!!Y\u001f\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0017!B:dC2\f\u0017BA3g\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011aY\u0005\u0003Q&\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!!\u001a4\u0011\u0007][W.\u0003\u0002m1\n\u0011\u0002*Y:Ue\u0006Lg.\u001b8h'VlW.\u0019:z!\t\u0001e.\u0003\u0002pg\tI#+\u00198e_64uN]3ti\u000ec\u0017m]:jM&\u001c\u0017\r^5p]R\u0013\u0018-\u001b8j]\u001e\u001cV/\\7bef\f1!^5e+\u0005\u0011\bCA:x\u001d\t!X\u000f\u0005\u0002`M&\u0011aOZ\u0001\u0007!J,G-\u001a4\n\u0005aL(AB*ue&twM\u0003\u0002wM\"\"\u0011a_A\u0002!\tax0D\u0001~\u0015\tqx'\u0001\u0006b]:|G/\u0019;j_:L1!!\u0001~\u0005\u0015\u0019\u0016N\\2fC\t\t)!A\u00032]Ur\u0003'\u0001\u0003vS\u0012\u0004\u0003\u0006\u0002\u0002|\u0003\u0007\taa\u0018;sK\u0016\u001cXCAA\b!\u0015\t\t\"a\u0005T\u001b\u00051\u0017bAA\u000bM\n)\u0011I\u001d:bs\u00069q\f\u001e:fKN\u0004\u0013a\u00038v[\u001a+\u0017\r^;sKN,\"!!\b\u0011\t\u0005E\u0011qD\u0005\u0004\u0003C1'aA%oi\"\"Qa_A\u0013C\t\t9#A\u00032]Yr\u0003'\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b\u0005\u000b\u0003\u0007w\u0006\u0015\u0012A\u00038v[\u000ec\u0017m]:fg\"\"qa_A\u0002\u0003-qW/\\\"mCN\u001cXm\u001d\u0011)\t!Y\u00181A\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0013%\u000bI$!\u0010\u0002@\u0005\r\u0003\"\u00029\n\u0001\u0004\u0011\b&BA\u001dw\u0006\r\u0001bBA\u0006\u0013\u0001\u0007\u0011q\u0002\u0005\b\u00033I\u0001\u0019AA\u000fQ\u0015\tyd_A\u0013\u0011\u001d\ti#\u0003a\u0001\u0003;AS!a\u0011|\u0003\u0007!r!SA%\u0003\u001b\ny\u0005C\u0004\u0002L)\u0001\r!a\u0004\u0002\u000bQ\u0014X-Z:\t\u000f\u0005e!\u00021\u0001\u0002\u001e!9\u0011Q\u0006\u0006A\u0002\u0005uA#A%\u0002\u001b\u0015\u001cH/[7bi\u0016$7+\u001b>f+\t\t9\u0006\u0005\u0003\u0002\u0012\u0005e\u0013bAA.M\n!Aj\u001c8hQ\u0011i10a\u0018\"\u0005\u0005\u0005\u0014!B\u0019/i9\u0002\u0014\u0001D0ue\u0016,w+Z5hQR\u001cXCAA4!\u0019\t\t\"a\u0005\u0002jA!\u0011\u0011CA6\u0013\r\tiG\u001a\u0002\u0007\t>,(\r\\3\u0002\u0017Q\u0014X-Z,fS\u001eDGo\u001d\u0015\u0005\u001fm\fy&A\u0004tk6l\u0017M]=\u0016\u00035DC\u0001E>\u0002z\u0005\u0012\u00111P\u0001\u0006g9\nd\u0006M\u0001\u000eE&t\u0017M]=Tk6l\u0017M]=\u0016\u0005\u0005\u0005\u0005c\u0001!\u0002\u0004&\u0019\u0011QQ\u001a\u0003_\tKg.\u0019:z%\u0006tGm\\7G_J,7\u000f^\"mCN\u001c\u0018NZ5dCRLwN\u001c+sC&t\u0017N\\4Tk6l\u0017M]=)\tEY\u0018\u0011P\u0001\tKZ\fG.^1uKR!\u0011QRAJ!\r\u0001\u0015qR\u0005\u0004\u0003#\u001b$!\t*b]\u0012|WNR8sKN$8\t\\1tg&4\u0017nY1uS>t7+^7nCJL\bbBAK%\u0001\u0007\u0011qS\u0001\bI\u0006$\u0018m]3ua\u0011\tI*!+\u0011\r\u0005m\u0015\u0011UAS\u001b\t\tiJC\u0002\u0002 ^\n1a]9m\u0013\u0011\t\u0019+!(\u0003\u000f\u0011\u000bG/Y:fiB!\u0011qUAU\u0019\u0001!A\"a+\u0002\u0014\u0006\u0005\t\u0011!B\u0001\u0003[\u00131a\u0018\u00134#\u0011\ty+!.\u0011\t\u0005E\u0011\u0011W\u0005\u0004\u0003g3'a\u0002(pi\"Lgn\u001a\t\u0005\u0003#\t9,C\u0002\u0002:\u001a\u00141!\u00118zQ\u0011\u001120!\u001f\u0002\u001fQ\u0014\u0018M\\:g_Jl7k\u00195f[\u0006$B!!1\u0002NB!\u00111YAe\u001b\t\t)M\u0003\u0003\u0002H\u0006u\u0015!\u0002;za\u0016\u001c\u0018\u0002BAf\u0003\u000b\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\tym\u0005a\u0001\u0003\u0003\faa]2iK6\f\u0007\u0006B\n|\u0003?\n\u0011\u0002\u001e:b]N4wN]7\u0015\t\u0005]\u00171\u001f\t\u0005\u00033\fiO\u0004\u0003\u0002\\\u0006-h\u0002BAo\u0003StA!a8\u0002h:!\u0011\u0011]As\u001d\ry\u00161]\u0005\u0002y%\u0011!hO\u0005\u0003qeJ1!a(8\u0013\r)\u0017QT\u0005\u0005\u0003_\f\tPA\u0005ECR\fgI]1nK*\u0019Q-!(\t\u000f\u0005UE\u00031\u0001\u0002vB\"\u0011q_A~!\u0019\tY*!)\u0002zB!\u0011qUA~\t1\ti0a=\u0002\u0002\u0003\u0005)\u0011AAW\u0005\ryF\u0005N\u0001\u000baJ,G-[2u%\u0006<HcA\"\u0003\u0004!1!QA\u000bA\u0002\r\u000b\u0001BZ3biV\u0014Xm\u001d\u0015\u0005+m\u0014I!\t\u0002\u0003\f\u0005)1G\f\u0019/a\u00051\"/Y<3aJ|'-\u00192jY&$\u00180\u00138QY\u0006\u001cW\rF\u0002D\u0005#AaAa\u0005\u0017\u0001\u0004\u0019\u0015!\u0004:boB\u0013X\rZ5di&|g.\u0001\u0003d_BLHcA%\u0003\u001a!9!1D\fA\u0002\tu\u0011!B3yiJ\f\u0007\u0003\u0002B\u0010\u0005Ki!A!\t\u000b\u0007\t\rR'A\u0003qCJ\fW.\u0003\u0003\u0003(\t\u0005\"\u0001\u0003)be\u0006lW*\u00199)\t]Y\u0018qL\u0001\ti>\u001cFO]5oOR\t!\u000f\u000b\u0003\u0019w\u0006}\u0013A\u00054fCR,(/Z%na>\u0014H/\u00198dKN,\u0012a\u0011\u0015\u00053m\f\u0019!A\u0003u_>cG-\u0006\u0002\u0003<A!!Q\bB%\u001b\t\u0011yD\u0003\u0003\u0003B\t\r\u0013!B7pI\u0016d'bA'\u0003F)\u0019!qI\u001c\u0002\u000b5dG.\u001b2\n\t\t-#q\b\u0002\u0012%\u0006tGm\\7G_J,7\u000f^'pI\u0016d\u0017!B<sSR,WC\u0001B)!\r9&1K\u0005\u0004\u0005+B&\u0001C'M/JLG/\u001a:)\tmY(\u0011L\u0011\u0003\u00057\nQA\r\u00181]A\nQb\u0019:fCR,7+^7nCJLH\u0003\u0002B1\u0005O\u0002B!!\u0005\u0003d%\u0019!Q\r4\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003+c\u0002\u0019\u0001B5a\u0011\u0011YGa\u001c\u0011\r\u0005m\u0015\u0011\u0015B7!\u0011\t9Ka\u001c\u0005\u0019\tE$qMA\u0001\u0002\u0003\u0015\t!!,\u0003\u0007}#S'A\u0006tCZ,7+^7nCJLH\u0003\u0002B1\u0005oBaA!\u001f\u001e\u0001\u0004\u0011\u0018\u0001\u00029bi\"\f1\u0002\\8bIN+X.\\1ssR1!\u0011\rB@\u0005\u0003CaA!\u001f\u001f\u0001\u0004\u0011\bbBAK=\u0001\u0007\u0011q\u001b\u0015\u0005\u0001m\fy&A\u0010SC:$w.\u001c$pe\u0016\u001cHo\u00117bgNLg-[2bi&|g.T8eK2\u0004\"\u0001\u0011\u0011\u0014\u000f\u0001\u0012YI!%\u0003\u0018B!\u0011\u0011\u0003BG\u0013\r\u0011yI\u001a\u0002\u0007\u0003:L(+\u001a4\u0011\t]\u0013\u0019*S\u0005\u0004\u0005+C&AC'M%\u0016\fG-\u00192mKB!!\u0011\u0014BR\u001b\t\u0011YJ\u0003\u0003\u0003\u001e\n}\u0015AA5p\u0015\t\u0011\t+\u0001\u0003kCZ\f\u0017b\u00015\u0003\u001cR\u0011!qQ\u0001\u0005e\u0016\fG-\u0006\u0002\u0003,B!qK!,J\u0013\r\u0011y\u000b\u0017\u0002\t\u001b2\u0013V-\u00193fe\"\"!e\u001fB-\u0003\u0011aw.\u00193\u0015\u0007%\u00139\f\u0003\u0004\u0003z\r\u0002\rA\u001d\u0015\u0005Gm\u0014IFA\u0013SC:$w.\u001c$pe\u0016\u001cHo\u00117bgNLg-[2bi&|g.T8eK2<&/\u001b;feN\u0019AE!\u0015\u0002\u0011%t7\u000f^1oG\u0016$BAa1\u0003HB\u0019!Q\u0019\u0013\u000e\u0003\u0001BaAa0'\u0001\u0004I\u0015\u0001C:bm\u0016LU\u000e\u001d7\u0015\t\t\u0005$Q\u001a\u0005\u0007\u0005s:\u0003\u0019\u0001:\u0003KI\u000bg\u000eZ8n\r>\u0014Xm\u001d;DY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8N_\u0012,GNU3bI\u0016\u00148c\u0001\u0015\u0003,R\u0011!Q\u001b\t\u0004\u0005\u000bD\u0013!C2mCN\u001ch*Y7f+\t\u0011Y\u000e\u0005\u0003\u0003^\n\rXB\u0001Bp\u0015\u0011\u0011\tOa(\u0002\t1\fgnZ\u0005\u0004q\n}\u0017AC2mCN\u001ch*Y7fA\u0005iAO]3f\u00072\f7o\u001d(b[\u0016\fa\u0002\u001e:fK\u000ec\u0017m]:OC6,\u0007\u0005F\u0002J\u0005[DaA!\u001f/\u0001\u0004\u0011\u0018a\u00024s_6|E\u000e\u001a\u000b\f\u0013\nM(q_B\u0001\u0007\u0017\u0019i\u0001C\u0004\u0003v>\u0002\rAa\u000f\u0002\u0011=dG-T8eK2DqA!?0\u0001\u0004\u0011Y0\u0001\u0004qCJ,g\u000e\u001e\t\u0004\u0001\nu\u0018b\u0001B\u0000g\t1\"+\u00198e_64uN]3ti\u000ec\u0017m]:jM&,'\u000fC\u0004\u0004\u0004=\u0002\ra!\u0002\u0002'\r\fG/Z4pe&\u001c\u0017\r\u001c$fCR,(/Z:\u0011\u000fM\u001c9!!\b\u0002\u001e%\u00191\u0011B=\u0003\u00075\u000b\u0007\u000fC\u0004\u0002.=\u0002\r!!\b\t\u0013\u0005eq\u0006%AA\u0002\u0005u\u0011!\u00054s_6|E\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%kU\u001111\u0003\u0016\u0005\u0003;\u0019)b\u000b\u0002\u0004\u0018A!1\u0011DB\u0011\u001b\t\u0019YB\u0003\u0003\u0004\u001e\r}\u0011!C;oG\",7m[3e\u0015\tqh-\u0003\u0003\u0004$\rm!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u00111\u0011\u0006\t\u0005\u0005;\u001cY#\u0003\u0003\u0004.\t}'AB(cU\u0016\u001cG\u000f\u000b\u0003!w\ne\u0003\u0006B\u0010|\u00053\u0002")
public class RandomForestClassificationModel
extends ProbabilisticClassificationModel<Vector, RandomForestClassificationModel>
implements RandomForestClassifierParams,
TreeEnsembleModel<DecisionTreeClassificationModel>,
MLWritable,
HasTrainingSummary<RandomForestClassificationTrainingSummary> {
    private double[] _treeWeights;
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeClassificationModel[] _trees;
    private final int numFeatures;
    private final int numClasses;
    private Option<RandomForestClassificationTrainingSummary> trainingSummary;
    private int totalNumNodes;
    private Param<String> impurity;
    private IntParam numTrees;
    private BooleanParam bootstrap;
    private DoubleParam subsamplingRate;
    private Param<String> featureSubsetStrategy;
    private Param<String> leafCol;
    private IntParam maxDepth;
    private IntParam maxBins;
    private IntParam minInstancesPerNode;
    private DoubleParam minWeightFractionPerNode;
    private DoubleParam minInfoGain;
    private IntParam maxMemoryInMB;
    private BooleanParam cacheNodeIds;
    private Param<String> weightCol;
    private LongParam seed;
    private IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static RandomForestClassificationModel load(String path) {
        return RandomForestClassificationModel$.MODULE$.load(path);
    }

    public static MLReader<RandomForestClassificationModel> read() {
        return RandomForestClassificationModel$.MODULE$.read();
    }

    @Override
    public boolean hasSummary() {
        return HasTrainingSummary.hasSummary$(this);
    }

    @Override
    public HasTrainingSummary<RandomForestClassificationTrainingSummary> setSummary(Option<RandomForestClassificationTrainingSummary> summary) {
        return HasTrainingSummary.setSummary$(this, summary);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public DecisionTreeModel getTree(int i) {
        return TreeEnsembleModel.getTree$(this, i);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public long getEstimatedSize() {
        return TreeEnsembleModel.getEstimatedSize$(this);
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final int getNumTrees() {
        return RandomForestParams.getNumTrees$(this);
    }

    @Override
    public final boolean getBootstrap() {
        return RandomForestParams.getBootstrap$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public final Option<RandomForestClassificationTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    @Override
    public final void trainingSummary_$eq(Option<RandomForestClassificationTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    private int totalNumNodes$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.totalNumNodes$lzycompute();
        }
        return this.totalNumNodes;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final IntParam numTrees() {
        return this.numTrees;
    }

    @Override
    public final BooleanParam bootstrap() {
        return this.bootstrap;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$numTrees_$eq(IntParam x$1) {
        this.numTrees = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$bootstrap_$eq(BooleanParam x$1) {
        this.bootstrap = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeClassificationModel[] _trees() {
        return this._trees;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    @Override
    public long estimatedSize() {
        return this.getEstimatedSize();
    }

    public DecisionTreeClassificationModel[] trees() {
        return this._trees();
    }

    private double[] _treeWeights$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._treeWeights = (double[])Array$.MODULE$.fill(this._trees().length, (Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0, (ClassTag)ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._treeWeights;
    }

    private double[] _treeWeights() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this._treeWeights$lzycompute();
        }
        return this._treeWeights;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public RandomForestClassificationTrainingSummary summary() {
        return (RandomForestClassificationTrainingSummary)HasTrainingSummary.summary$(this);
    }

    public BinaryRandomForestClassificationTrainingSummary binarySummary() {
        RandomForestClassificationTrainingSummary randomForestClassificationTrainingSummary = this.summary();
        if (randomForestClassificationTrainingSummary instanceof BinaryRandomForestClassificationTrainingSummary) {
            BinaryRandomForestClassificationTrainingSummary binaryRandomForestClassificationTrainingSummary = (BinaryRandomForestClassificationTrainingSummary)randomForestClassificationTrainingSummary;
            return binaryRandomForestClassificationTrainingSummary;
        }
        throw new RuntimeException("Cannot create a binary summary for a non-binary model(numClasses=" + this.numClasses() + "), use summary instead.");
    }

    public RandomForestClassificationSummary evaluate(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple32._1();
        String probabilityColName2 = (String)tuple32._2();
        String predictionColName2 = (String)tuple32._3();
        if (this.numClasses() > 2) {
            return new RandomForestClassificationSummaryImpl(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), weightColName);
        }
        return new BinaryRandomForestClassificationSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), weightColName);
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block0: {
            outputSchema = super.transformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return outputSchema;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Dataset<Row> outputData = super.transform(dataset);
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RandomForestClassificationModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RandomForestClassificationModel.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1(RandomForestClassificationModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1(RandomForestClassificationModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> this.predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_RandomForestClassificationModel$$typecreator2$1(null)));
            return outputData.withColumn(this.$(this.leafCol()), leafUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})), outputSchema.apply(this.$(this.leafCol())).metadata());
        }
        return outputData;
    }

    @Override
    public Vector predictRaw(Vector features) {
        double[] votes = (double[])Array$.MODULE$.ofDim(this.numClasses(), (ClassTag)ClassTag$.MODULE$.Double());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)tree -> {
            RandomForestClassificationModel.$anonfun$predictRaw$1(this, features, votes, tree);
            return BoxedUnit.UNIT;
        });
        return Vectors$.MODULE$.dense(votes);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
            return denseVector;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in RandomForestClassificationModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public RandomForestClassificationModel copy(ParamMap extra) {
        return (RandomForestClassificationModel)((Model)this.copyValues(new RandomForestClassificationModel(this.uid(), this._trees(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return "RandomForestClassificationModel: uid=" + this.uid() + ", numTrees=" + this.getNumTrees() + ", numClasses=" + this.numClasses() + ", numFeatures=" + this.numFeatures();
    }

    private Vector featureImportances$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), TreeEnsembleModel$.MODULE$.featureImportances$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.featureImportances$lzycompute();
        }
        return this.featureImportances;
    }

    public RandomForestModel toOld() {
        return new RandomForestModel(Algo$.MODULE$.Classification(), (org.apache.spark.mllib.tree.model.DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$4 -> x$4.toOld(), ClassTag$.MODULE$.apply(org.apache.spark.mllib.tree.model.DecisionTreeModel.class)));
    }

    @Override
    public MLWriter write() {
        return new RandomForestClassificationModelWriter(this);
    }

    public void createSummary(Dataset<?> dataset) {
        String weightColName = !this.isDefined(this.weightCol()) ? "weightCol" : this.$(this.weightCol());
        Tuple3 tuple3 = this.findSummaryModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        ProbabilisticClassificationModel summaryModel = (ProbabilisticClassificationModel)tuple3._1();
        String probabilityColName = (String)tuple3._2();
        String predictionColName = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)summaryModel, (Object)probabilityColName, (Object)predictionColName);
        ProbabilisticClassificationModel summaryModel2 = (ProbabilisticClassificationModel)tuple32._1();
        String probabilityColName2 = (String)tuple32._2();
        String predictionColName2 = (String)tuple32._3();
        RandomForestClassificationSummaryImpl rfSummary = this.numClasses() <= 2 ? new BinaryRandomForestClassificationTrainingSummaryImpl(summaryModel2.transform(dataset), probabilityColName2, predictionColName2, this.$(this.labelCol()), weightColName, new double[]{0.0}) : new RandomForestClassificationTrainingSummaryImpl(summaryModel2.transform(dataset), predictionColName2, this.$(this.labelCol()), weightColName, new double[]{0.0});
        this.setSummary((Option<RandomForestClassificationTrainingSummary>)new Some((Object)rfSummary));
    }

    @Override
    public void saveSummary(String path) {
    }

    @Override
    public void loadSummary(String path, Dataset<Row> dataset) {
        this.createSummary(dataset);
    }

    public static final /* synthetic */ void $anonfun$predictRaw$1(RandomForestClassificationModel $this, Vector features$1, double[] votes$1, DecisionTreeClassificationModel tree) {
        double[] classCounts = tree.rootNode().predictImpl(features$1).impurityStats().stats();
        double total = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray(classCounts).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        if (total != 0.0) {
            for (int i = 0; i < $this.numClasses(); ++i) {
                int n = i;
                votes$1[n] = votes$1[n] + classCounts[i] / total;
            }
            return;
        }
    }

    public RandomForestClassificationModel(String uid, DecisionTreeClassificationModel[] _trees, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        RandomForestParams.$init$(this);
        TreeEnsembleClassifierParams.$init$(this);
        TreeClassifierParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        HasTrainingSummary.$init$(this);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])_trees)), (Function0 & Serializable)() -> "RandomForestClassificationModel requires at least 1 tree.");
        Statics.releaseFence();
    }

    public RandomForestClassificationModel(DecisionTreeClassificationModel[] trees, int numFeatures, int numClasses) {
        this(Identifiable$.MODULE$.randomUID("rfc"), trees, numFeatures, numClasses);
    }

    public RandomForestClassificationModel() {
        this("", (DecisionTreeClassificationModel[])((Object[])new DecisionTreeClassificationModel[]{new DecisionTreeClassificationModel()}), -1, -1);
    }

    private static class RandomForestClassificationModelReader
    extends MLReader<RandomForestClassificationModel> {
        private final String className = RandomForestClassificationModel.class.getName();
        private final String treeClassName = DecisionTreeClassificationModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public RandomForestClassificationModel load(String path) {
            DefaultParamsReader.Metadata metadata;
            Tuple2[] treesData;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    treesData = (Tuple2[])tuple3._2();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            Tuple2[] tuple2Array = treesData;
            Tuple2 tuple2 = new Tuple2((Object)metadata, (Object)tuple2Array);
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple2._1();
            Tuple2[] treesData2 = (Tuple2[])tuple2._2();
            int numFeatures = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), "numFeatures")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numClasses = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), "numClasses")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), "numTrees")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeClassificationModel[] trees = (DecisionTreeClassificationModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])treesData2), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                    Node root = (Node)tuple2._2();
                    DecisionTreeClassificationModel tree = new DecisionTreeClassificationModel(treeMetadata.uid(), root, numFeatures, numClasses);
                    treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                    return tree;
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(DecisionTreeClassificationModel.class));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable)() -> "RandomForestClassificationModel.load expected " + numTrees + " trees based on metadata but found " + trees.length + " trees.");
            RandomForestClassificationModel model = new RandomForestClassificationModel(metadata3.uid(), trees, numFeatures, numClasses);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class RandomForestClassificationModelWriter
    extends MLWriter {
        private final RandomForestClassificationModel instance;

        @Override
        public void saveImpl(String path) {
            JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numClasses"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numClasses())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public RandomForestClassificationModelWriter(RandomForestClassificationModel instance) {
            this.instance = instance;
        }
    }
}

