/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class PushBlockStream
extends BlockTransferMessage {
    public final String appId;
    public final int appAttemptId;
    public final int shuffleId;
    public final int shuffleMergeId;
    public final int mapIndex;
    public final int reduceId;
    public final int index;

    public PushBlockStream(String appId, int appAttemptId, int shuffleId, int shuffleMergeId, int mapIndex, int reduceId, int index) {
        this.appId = appId;
        this.appAttemptId = appAttemptId;
        this.shuffleId = shuffleId;
        this.shuffleMergeId = shuffleMergeId;
        this.mapIndex = mapIndex;
        this.reduceId = reduceId;
        this.index = index;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.PUSH_BLOCK_STREAM;
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.appAttemptId, this.shuffleId, this.shuffleMergeId, this.mapIndex, this.reduceId, this.index);
    }

    public String toString() {
        return "PushBlockStream[appId=" + this.appId + ",attemptId=" + this.appAttemptId + ",shuffleId=" + this.shuffleId + ",shuffleMergeId=" + this.shuffleMergeId + ",mapIndex=" + this.mapIndex + ",reduceId=" + this.reduceId + ",index=" + this.index + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof PushBlockStream) {
            PushBlockStream o = (PushBlockStream)other;
            return Objects.equals(this.appId, o.appId) && this.appAttemptId == o.appAttemptId && this.shuffleId == o.shuffleId && this.shuffleMergeId == o.shuffleMergeId && this.mapIndex == o.mapIndex && this.reduceId == o.reduceId && this.index == o.index;
        }
        return false;
    }

    public int encodedLength() {
        return Encoders.Strings.encodedLength((String)this.appId) + 4 + 4 + 4 + 4 + 4 + 4;
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.appId);
        buf.writeInt(this.appAttemptId);
        buf.writeInt(this.shuffleId);
        buf.writeInt(this.shuffleMergeId);
        buf.writeInt(this.mapIndex);
        buf.writeInt(this.reduceId);
        buf.writeInt(this.index);
    }

    public static PushBlockStream decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        int attemptId = buf.readInt();
        int shuffleId = buf.readInt();
        int shuffleMergeId = buf.readInt();
        int mapIdx = buf.readInt();
        int reduceId = buf.readInt();
        int index = buf.readInt();
        return new PushBlockStream(appId, attemptId, shuffleId, shuffleMergeId, mapIdx, reduceId, index);
    }
}

