/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.dmg.pmml.adapters;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import org.sparkproject.dmg.pmml.tree.ComplexNode;
import org.sparkproject.dmg.pmml.tree.Node;
import org.sparkproject.dmg.pmml.tree.NodeTransformer;
import org.sparkproject.dmg.pmml.tree.SimplifyingNodeTransformer;

public class NodeAdapter
extends XmlAdapter<ComplexNode, Node> {
    public static final ThreadLocal<NodeTransformer> NODE_TRANSFORMER_PROVIDER = new ThreadLocal<NodeTransformer>(){

        @Override
        public NodeTransformer initialValue() {
            return SimplifyingNodeTransformer.INSTANCE;
        }
    };

    public Node unmarshal(ComplexNode value) {
        NodeTransformer nodeTransformer = NODE_TRANSFORMER_PROVIDER.get();
        if (nodeTransformer != null) {
            return nodeTransformer.fromComplexNode(value);
        }
        return value;
    }

    public ComplexNode marshal(Node node) {
        NodeTransformer nodeTransformer = NODE_TRANSFORMER_PROVIDER.get();
        if (nodeTransformer != null) {
            return nodeTransformer.toComplexNode(node);
        }
        return node.toComplexNode();
    }
}

