/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Gradient;
import org.apache.spark.mllib.optimization.LBFGS$;
import org.apache.spark.mllib.optimization.LogisticGradient;
import org.apache.spark.mllib.optimization.SquaredL2Updater;
import org.apache.spark.mllib.optimization.Updater;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class LBFGSExample$ {
    public static final LBFGSExample$ MODULE$ = new LBFGSExample$();

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("LBFGSExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        int numFeatures = ((LabeledPoint[])data.take(1))[0].features().size();
        RDD[] splits = data.randomSplit(new double[]{0.6, 0.4}, 11L);
        RDD training = splits[0].map((Function1 & Serializable)x -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)x.label()), (Object)MLUtils$.MODULE$.appendBias(x.features())), ClassTag$.MODULE$.apply(Tuple2.class)).cache();
        RDD test = splits[1];
        int numCorrections = 10;
        double convergenceTol = 1.0E-4;
        int maxNumIterations = 20;
        double regParam = 0.1;
        Vector initialWeightsWithIntercept = Vectors$.MODULE$.dense(new double[numFeatures + 1]);
        Tuple2 tuple2 = LBFGS$.MODULE$.runLBFGS(training, (Gradient)new LogisticGradient(), (Updater)new SquaredL2Updater(), numCorrections, convergenceTol, maxNumIterations, regParam, initialWeightsWithIntercept);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector weightsWithIntercept = (Vector)tuple2._1();
        double[] loss = (double[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)weightsWithIntercept, (Object)loss);
        Vector weightsWithIntercept2 = (Vector)tuple22._1();
        double[] loss2 = (double[])tuple22._2();
        LogisticRegressionModel model = new LogisticRegressionModel(Vectors$.MODULE$.dense((double[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.doubleArrayOps(weightsWithIntercept2.toArray()), 0, weightsWithIntercept2.size() - 1)), weightsWithIntercept2.apply(weightsWithIntercept2.size() - 1));
        model.clearThreshold();
        RDD scoreAndLabels = test.map((Function1 & Serializable)point -> {
            double score = model.predict(point.features());
            return new Tuple2.mcDD.sp(score, point.label());
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics(scoreAndLabels);
        double auROC = metrics.areaUnderROC();
        Predef$.MODULE$.println((Object)"Loss of each step in training process");
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.doubleArrayOps(loss2), (Function1 & Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)("Area under ROC = " + auROC));
        sc.stop();
    }

    private LBFGSExample$() {
    }
}

