/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.NullOrdering;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.connector.expressions.filter.Predicate;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.MsSqlServerDialect$;
import org.apache.spark.sql.jdbc.NoLegacyJDBCError;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\rub\u0001\u0002\u001f>\t\"CQA\u0019\u0001\u0005\u0002\rDQ!\u001a\u0001\u0005B\u0019DQ\u0001\u001e\u0001\u0005BUDaa \u0001\u0005B\u0005\u0005\u0001\"CA\u0007\u0001\t\u0007I\u0011BA\b\u0011!\tY\u0003\u0001Q\u0001\n\u0005E\u0001\"CA\u0017\u0001\t\u0007I\u0011BA\b\u0011!\ty\u0003\u0001Q\u0001\n\u0005E\u0001\"CA\u0019\u0001\t\u0007I\u0011BA\b\u0011!\t\u0019\u0004\u0001Q\u0001\n\u0005E\u0001bBA\u001b\u0001\u0011\u0005\u0013q\u0007\u0004\u0007\u0003{\u0001\u0001!a\u0010\t\r\tdA\u0011AA%\u0011\u001d\ti\u0005\u0004C)\u0003\u001fBq!!\u0016\r\t\u0003\n9\u0006C\u0004\u0002|1!\t%! \t\u000f\u0005\u0005E\u0002\"\u0011\u0002\u0004\"9\u0011\u0011\u0013\u0007\u0005B\u0005M\u0005\u0002DAP\u0019A\u0005\t\u0011!A\u0005\u0002\u0005\u0005\u0006bBAV\u0001\u0011\u0005\u0013Q\u0016\u0005\b\u0003o\u0003A\u0011IA]\u0011\u001d\t)\u000f\u0001C!\u0003ODq!!>\u0001\t\u0003\n9\u0010C\u0004\u0002|\u0002!\t%!@\t\u000f\tM\u0001\u0001\"\u0011\u0003\u0016!9!1\u0005\u0001\u0005B\t\u0015\u0002b\u0002B\u001a\u0001\u0011\u0005#Q\u0007\u0005\b\u0005\u007f\u0001A\u0011\tB!\u0011\u001d\u0011Y\u0005\u0001C!\u0005\u001bBqA!\u0017\u0001\t\u0003\u0012YF\u0002\u0004\u0003\n\u0002\u0001!1\u0012\u0005\n\u0005'{\"\u0011!Q\u0001\n%C!B!& \u0005\u0003\u0005\u000b\u0011\u0002BL\u0011\u0019\u0011w\u0004\"\u0001\u0003*\"9\u0011\u0011S\u0010\u0005B\tE\u0006b\u0002BZ\u0001\u0011\u0005#Q\u0017\u0005\b\u0005s\u0003A\u0011\tB^\u0011\u001d\u0011\t\r\u0001C!\u0005\u0007DqA!2\u0001\t\u0003\u0012\u0019\r\u0003\u0005\u0003H\u0002\t\t\u0011\"\u0001d\u0011%\u0011I\rAA\u0001\n\u0003\u0012Y\rC\u0005\u0003N\u0002\t\t\u0011\"\u0001\u0003P\"I!\u0011\u001b\u0001\u0002\u0002\u0013\u0005!1\u001b\u0005\n\u0005/\u0004\u0011\u0011!C!\u00053D\u0011Ba9\u0001\u0003\u0003%\tA!:\t\u0013\t%\b!!A\u0005B\t-\b\"\u0003Bx\u0001\u0005\u0005I\u0011\tBy\u0011%\u0011\u0019\u0010AA\u0001\n\u0003\u0012)\u0010C\u0005\u0003x\u0002\t\t\u0011\"\u0011\u0003z\u001e9!Q`\u001f\t\n\t}hA\u0002\u001f>\u0011\u0013\u0019\t\u0001\u0003\u0004cg\u0011\u000511\u0003\u0005\n\u0007+\u0019$\u0019!C\u0003\u0007/A\u0001b!\b4A\u000351\u0011\u0004\u0005\n\u0007?\u0019$\u0019!C\u0003\u0007CA\u0001ba\n4A\u0003511\u0005\u0005\t\u0007S\u0019\u0014\u0011!CAG\"I11F\u001a\u0002\u0002\u0013\u00055Q\u0006\u0005\n\u0007g\u0019\u0014\u0011!C\u0005\u0007k\u0011!#T:Tc2\u001cVM\u001d<fe\u0012K\u0017\r\\3di*\u0011ahP\u0001\u0005U\u0012\u00147M\u0003\u0002A\u0003\u0006\u00191/\u001d7\u000b\u0005\t\u001b\u0015!B:qCJ\\'B\u0001#F\u0003\u0019\t\u0007/Y2iK*\ta)A\u0002pe\u001e\u001c\u0001aE\u0003\u0001\u00136\u0003f\u000b\u0005\u0002K\u00176\tQ(\u0003\u0002M{\tY!\n\u001a2d\t&\fG.Z2u!\tQe*\u0003\u0002P{\t\tbj\u001c'fO\u0006\u001c\u0017P\u0013#C\u0007\u0016\u0013(o\u001c:\u0011\u0005E#V\"\u0001*\u000b\u0003M\u000bQa]2bY\u0006L!!\u0016*\u0003\u000fA\u0013x\u000eZ;diB\u0011qk\u0018\b\u00031vs!!\u0017/\u000e\u0003iS!aW$\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0016B\u00010S\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Y1\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005y\u0013\u0016A\u0002\u001fj]&$h\bF\u0001e!\tQ\u0005!A\u0005dC:D\u0015M\u001c3mKR\u0011qM\u001b\t\u0003#\"L!!\u001b*\u0003\u000f\t{w\u000e\\3b]\")1N\u0001a\u0001Y\u0006\u0019QO\u001d7\u0011\u00055\fhB\u00018p!\tI&+\u0003\u0002q%\u00061\u0001K]3eK\u001aL!A]:\u0003\rM#(/\u001b8h\u0015\t\u0001(+A\rjg>\u0013'.Z2u\u001d>$hi\\;oI\u0016C8-\u001a9uS>tGCA4w\u0011\u001598\u00011\u0001y\u0003\u0005)\u0007CA=~\u001b\u0005Q(B\u0001!|\u0015\u0005a\u0018\u0001\u00026bm\u0006L!A >\u0003\u0019M\u000bF*\u0012=dKB$\u0018n\u001c8\u0002\u0019\r|W\u000e]5mKZ\u000bG.^3\u0015\t\u0005\r\u0011\u0011\u0002\t\u0004#\u0006\u0015\u0011bAA\u0004%\n\u0019\u0011I\\=\t\u000f\u0005-A\u00011\u0001\u0002\u0004\u0005)a/\u00197vK\u0006Y2/\u001e9q_J$X\rZ!hOJ,w-\u0019;f\rVt7\r^5p]N,\"!!\u0005\u0011\r\u0005M\u0011QDA\u0011\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011!C5n[V$\u0018M\u00197f\u0015\r\tYBU\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0010\u0003+\u00111aU3u!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014w\u0006!A.\u00198h\u0013\r\u0011\u0018QE\u0001\u001dgV\u0004\bo\u001c:uK\u0012\fum\u001a:fO\u0006$XMR;oGRLwN\\:!\u0003a\u0019X\u000f\u001d9peR,Gm\u0015;sS:<g)\u001e8di&|gn]\u0001\u001agV\u0004\bo\u001c:uK\u0012\u001cFO]5oO\u001a+hn\u0019;j_:\u001c\b%\u0001\ntkB\u0004xN\u001d;fI\u001a+hn\u0019;j_:\u001c\u0018aE:vaB|'\u000f^3e\rVt7\r^5p]N\u0004\u0013aE5t'V\u0004\bo\u001c:uK\u00124UO\\2uS>tGcA4\u0002:!1\u00111H\u0006A\u00021\f\u0001BZ;oG:\u000bW.\u001a\u0002\u0016\u001bN\u001c\u0016\u000f\\*feZ,'oU)M\u0005VLG\u000eZ3s'\ra\u0011\u0011\t\t\u0005\u0003\u0007\n)%D\u0001\u0001\u0013\r\t9e\u0013\u0002\u000f\u0015\u0012\u00135iU)M\u0005VLG\u000eZ3s)\t\tY\u0005E\u0002\u0002D1\t\u0011\u0003\u001d:fI&\u001c\u0017\r^3U_&sGoU)M)\ra\u0017\u0011\u000b\u0005\u0007\u0003'r\u0001\u0019\u00017\u0002\u000b%t\u0007/\u001e;\u0002\u001dYL7/\u001b;T_J$xJ\u001d3feR9A.!\u0017\u0002^\u0005E\u0004BBA.\u001f\u0001\u0007A.A\u0004t_J$8*Z=\t\u000f\u0005}s\u00021\u0001\u0002b\u0005i1o\u001c:u\t&\u0014Xm\u0019;j_:\u0004B!a\u0019\u0002n5\u0011\u0011Q\r\u0006\u0005\u0003O\nI'A\u0006fqB\u0014Xm]:j_:\u001c(bAA6\u007f\u0005I1m\u001c8oK\u000e$xN]\u0005\u0005\u0003_\n)GA\u0007T_J$H)\u001b:fGRLwN\u001c\u0005\b\u0003gz\u0001\u0019AA;\u00031qW\u000f\u001c7Pe\u0012,'/\u001b8h!\u0011\t\u0019'a\u001e\n\t\u0005e\u0014Q\r\u0002\r\u001dVdGn\u0014:eKJLgnZ\u0001\u0014I&\fG.Z2u\rVt7\r^5p]:\u000bW.\u001a\u000b\u0004Y\u0006}\u0004BBA\u001e!\u0001\u0007A.\u0001\twSNLGoU)M\rVt7\r^5p]R)A.!\"\u0002\b\"1\u00111H\tA\u00021Dq!!#\u0012\u0001\u0004\tY)\u0001\u0004j]B,Ho\u001d\t\u0005#\u00065E.C\u0002\u0002\u0010J\u0013Q!\u0011:sCf\fQAY;jY\u0012$2\u0001\\AK\u0011\u001d\t9J\u0005a\u0001\u00033\u000bA!\u001a=qeB!\u00111MAN\u0013\u0011\ti*!\u001a\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u000bqe>$Xm\u0019;fI\u0012Jg\u000e];u)>\u001c\u0016\u000b\u0014\u000b\u0005\u0003G\u000bI\u000b\u0006\u0003\u0002\"\u0005\u0015\u0006\"CAT'\u0005\u0005\t\u0019AAM\u0003\rAH%\r\u0005\n\u0003O\u001b\u0012\u0011!a\u0001\u0003\u0017\n\u0011cY8na&dW-\u0012=qe\u0016\u001c8/[8o)\u0011\ty+!.\u0011\tE\u000b\t\f\\\u0005\u0004\u0003g\u0013&AB(qi&|g\u000eC\u0004\u0002\u0018R\u0001\r!!'\u0002\u001f\u001d,GoQ1uC2L8\u000f\u001e+za\u0016$\"\"a/\u0002J\u0006M\u0017q[An!\u0015\t\u0016\u0011WA_!\u0011\ty,!2\u000e\u0005\u0005\u0005'bAAb\u007f\u0005)A/\u001f9fg&!\u0011qYAa\u0005!!\u0015\r^1UsB,\u0007bBAf+\u0001\u0007\u0011QZ\u0001\bgFdG+\u001f9f!\r\t\u0016qZ\u0005\u0004\u0003#\u0014&aA%oi\"1\u0011Q[\u000bA\u00021\f\u0001\u0002^=qK:\u000bW.\u001a\u0005\b\u00033,\u0002\u0019AAg\u0003\u0011\u0019\u0018N_3\t\u000f\u0005uW\u00031\u0001\u0002`\u0006\u0011Q\u000e\u001a\t\u0005\u0003\u007f\u000b\t/\u0003\u0003\u0002d\u0006\u0005'aD'fi\u0006$\u0017\r^1Ck&dG-\u001a:\u0002\u0017\u001d,GO\u0013#C\u0007RK\b/\u001a\u000b\u0005\u0003S\f\t\u0010E\u0003R\u0003c\u000bY\u000fE\u0002K\u0003[L1!a<>\u0005!QEMY2UsB,\u0007bBAz-\u0001\u0007\u0011QX\u0001\u0003IR\f\u0001$[:DCN\u001c\u0017\rZ5oOR\u0013XO\\2bi\u0016$\u0016M\u00197f)\t\tI\u0010\u0005\u0003R\u0003c;\u0017a\u0003:f]\u0006lW\rV1cY\u0016$R\u0001\\A\u0000\u0005\u001fAqA!\u0001\u0019\u0001\u0004\u0011\u0019!\u0001\u0005pY\u0012$\u0016M\u00197f!\u0011\u0011)Aa\u0003\u000e\u0005\t\u001d!\u0002\u0002B\u0005\u0003S\nqaY1uC2|w-\u0003\u0003\u0003\u000e\t\u001d!AC%eK:$\u0018NZ5fe\"9!\u0011\u0003\rA\u0002\t\r\u0011\u0001\u00038foR\u000b'\r\\3\u0002#\u001d,G/\u00113e\u0007>dW/\u001c8Rk\u0016\u0014\u0018\u0010F\u0004m\u0005/\u0011YBa\b\t\r\te\u0011\u00041\u0001m\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0003\u0004\u0003\u001ee\u0001\r\u0001\\\u0001\u000bG>dW/\u001c8OC6,\u0007B\u0002B\u00113\u0001\u0007A.\u0001\u0005eCR\fG+\u001f9f\u0003Q9W\r\u001e*f]\u0006lWmQ8mk6t\u0017+^3ssRIANa\n\u0003*\t-\"q\u0006\u0005\u0007\u00053Q\u0002\u0019\u00017\t\r\tu!\u00041\u0001m\u0011\u0019\u0011iC\u0007a\u0001Y\u00069a.Z<OC6,\u0007b\u0002B\u00195\u0001\u0007\u0011QZ\u0001\u000fI\nl\u0015M[8s-\u0016\u00148/[8o\u0003}9W\r^+qI\u0006$XmQ8mk6tg*\u001e7mC\nLG.\u001b;z#V,'/\u001f\u000b\bY\n]\"\u0011\bB\u001e\u0011\u0019\u0011Ib\u0007a\u0001Y\"1!QD\u000eA\u00021DaA!\u0010\u001c\u0001\u00049\u0017AC5t\u001dVdG.\u00192mK\u0006!r-\u001a;UC\ndWmQ8n[\u0016tG/U;fef$R\u0001\u001cB\"\u0005\u000fBaA!\u0012\u001d\u0001\u0004a\u0017!\u0002;bE2,\u0007B\u0002B%9\u0001\u0007A.A\u0004d_6lWM\u001c;\u0002\u001d\u001d,G\u000fT5nSR\u001cE.Y;tKR\u0019ANa\u0014\t\u000f\tES\u00041\u0001\u0003T\u0005)A.[7jiB!\u00111\u0005B+\u0013\u0011\u00119&!\n\u0003\u000f%sG/Z4fe\u0006\t2\r\\1tg&4\u00170\u0012=dKB$\u0018n\u001c8\u0015\u0019\tu#\u0011\u000fB:\u0005o\u0012\tI!\"\u0013\r\t}#1\rB5\r\u0019\u0011\t\u0007\u0001\u0001\u0003^\taAH]3gS:,W.\u001a8u}A\u0019qK!\u001a\n\u0007\t\u001d\u0014MA\u0005UQJ|w/\u00192mKB!!1\u000eB7\u001b\u0005\t\u0015b\u0001B8\u0003\nq1\u000b]1sWRC'o\\<bE2,\u0007BB<\u001f\u0001\u0004\u0011\u0019\u0007\u0003\u0004\u0003vy\u0001\r\u0001\\\u0001\nG>tG-\u001b;j_:DqA!\u001f\u001f\u0001\u0004\u0011Y(A\tnKN\u001c\u0018mZ3QCJ\fW.\u001a;feN\u0004R!\u001cB?Y2L1Aa t\u0005\ri\u0015\r\u001d\u0005\u0007\u0005\u0007s\u0002\u0019\u00017\u0002\u0017\u0011,7o\u0019:jaRLwN\u001c\u0005\u0007\u0005\u000fs\u0002\u0019A4\u0002\u0013%\u001c(+\u001e8uS6,'AG't'Fd7+\u001a:wKJ\u001c\u0016\u000bT)vKJL()^5mI\u0016\u00148cA\u0010\u0003\u000eB\u0019!Ja$\n\u0007\tEUHA\nKI\n\u001c7+\u0015'Rk\u0016\u0014\u0018PQ;jY\u0012,'/A\u0004eS\u0006dWm\u0019;\u0002\u000f=\u0004H/[8ogB!!\u0011\u0014BS\u001b\t\u0011YJC\u0002?\u0005;SAAa(\u0003\"\u0006YA-\u0019;bg>,(oY3t\u0015\r\u0011\u0019kP\u0001\nKb,7-\u001e;j_:LAAa*\u0003\u001c\nY!\n\u0012\"D\u001fB$\u0018n\u001c8t)\u0019\u0011YK!,\u00030B\u0019\u00111I\u0010\t\r\tM%\u00051\u0001J\u0011\u001d\u0011)J\ta\u0001\u0005/#\u0012\u0001\\\u0001\u0017O\u0016$(\n\u001a2d'Fc\u0015+^3ss\n+\u0018\u000e\u001c3feR!!Q\u0012B\\\u0011\u001d\u0011)\n\na\u0001\u0005/\u000bq#[:Ts:$\u0018\r_#se>\u0014()Z:u\u000b\u001a4wN\u001d;\u0015\u0007\u001d\u0014i\f\u0003\u0004\u0003@\u0016\u0002\r\u0001_\u0001\nKb\u001cW\r\u001d;j_:\fQb];qa>\u0014Ho\u001d'j[&$X#A4\u0002\u0019M,\b\u000f]8siNTu.\u001b8\u0002\t\r|\u0007/_\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u0005\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAAg\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0001\u0003V\"I\u0011qU\u0016\u0002\u0002\u0003\u0007\u0011QZ\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u001c\t\u0007\u0005;\u0014y.a\u0001\u000e\u0005\u0005e\u0011\u0002\u0002Bq\u00033\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019qMa:\t\u0013\u0005\u001dV&!AA\u0002\u0005\r\u0011A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!!\t\u0003n\"I\u0011q\u0015\u0018\u0002\u0002\u0003\u0007\u0011QZ\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QZ\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011E\u0001\u0007KF,\u0018\r\\:\u0015\u0007\u001d\u0014Y\u0010C\u0005\u0002(F\n\t\u00111\u0001\u0002\u0004\u0005\u0011Rj]*rYN+'O^3s\t&\fG.Z2u!\tQ5gE\u00034\u0007\u0007\u0019I\u0001E\u0002R\u0007\u000bI1aa\u0002S\u0005\u0019\te.\u001f*fMB!11BB\t\u001b\t\u0019iAC\u0002\u0004\u0010m\f!![8\n\u0007\u0001\u001ci\u0001\u0006\u0002\u0003\u0000\u0006Aq)R(N\u000bR\u0013\u0016,\u0006\u0002\u0004\u001a=\u001111D\u000f\u0003\u007f\u0010\f\u0011bR#P\u001b\u0016#&+\u0017\u0011\u0002\u0013\u001d+uj\u0012*B!\"KVCAB\u0012\u001f\t\u0019)#\b\u0002\u0000F\u0006Qq)R(H%\u0006\u0003\u0006*\u0017\u0011\u0002\u000b\u0005\u0004\b\u000f\\=\u0002\u000fUt\u0017\r\u001d9msR\u0019qma\f\t\u0011\rE\"(!AA\u0002\u0011\f1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\u00199\u0004\u0005\u0003\u0002$\re\u0012\u0002BB\u001e\u0003K\u0011aa\u00142kK\u000e$\b")
public class MsSqlServerDialect
extends JdbcDialect
implements NoLegacyJDBCError,
Product {
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedStringFunctions;
    private final Set<String> supportedFunctions;

    public static boolean unapply(MsSqlServerDialect x$0) {
        return MsSqlServerDialect$.MODULE$.unapply(x$0);
    }

    public static MsSqlServerDialect apply() {
        return MsSqlServerDialect$.MODULE$.apply();
    }

    public static int GEOGRAPHY() {
        return MsSqlServerDialect$.MODULE$.GEOGRAPHY();
    }

    public static int GEOMETRY() {
        return MsSqlServerDialect$.MODULE$.GEOMETRY();
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:sqlserver");
    }

    @Override
    public boolean isObjectNotFoundException(SQLException e) {
        return e.getErrorCode() == 208;
    }

    @Override
    public Object compileValue(Object value) {
        Object object = value;
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            if (bl) {
                return BoxesRunTime.boxToInteger((int)1);
            }
            return BoxesRunTime.boxToInteger((int)0);
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(byArray), (Function1 & Serializable)x$1 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%02X"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)x$1))})), ClassTag$.MODULE$.apply(String.class))).mkString("0x", "", "");
        }
        return super.compileValue(object);
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedStringFunctions() {
        return this.supportedStringFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<String> compileExpression(Expression expr) {
        Some some;
        MsSqlServerSQLBuilder msSqlServerSQLBuilder = new MsSqlServerSQLBuilder(this);
        try {
            some = new Some((Object)msSqlServerSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Error occurs while compiling V2 expression", throwable2);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        if (typeName.contains("datetimeoffset")) {
            if (SQLConf$.MODULE$.get().legacyMsSqlServerDatetimeOffsetMappingEnabled()) {
                return new Some((Object)StringType$.MODULE$);
            }
            return new Some((Object)TimestampType$.MODULE$);
        }
        if ((5 == n ? true : -6 == n) && !SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled()) {
            return new Some((Object)ShortType$.MODULE$);
        }
        if (7 == n && !SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled()) {
            return new Some((Object)FloatType$.MODULE$);
        }
        if (-157 == n ? true : -158 == n) {
            return new Some((Object)BinaryType$.MODULE$);
        }
        return None$.MODULE$;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (TimestampType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("DATETIME", 93));
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("DATETIME", 93));
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("NVARCHAR(MAX)", -9));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("BIT", -7));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("VARBINARY(MAX)", -3));
        }
        if (ShortType$.MODULE$.equals(dataType) && !SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled()) {
            return new Some((Object)new JdbcType("SMALLINT", 5));
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("SMALLINT", -6));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String renameTable(Identifier oldTable, Identifier newTable) {
        return "EXEC sp_rename " + this.getFullyQualifiedQuotedTableName(oldTable) + ", " + this.getFullyQualifiedQuotedTableName(newTable);
    }

    @Override
    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return "ALTER TABLE " + tableName + " ADD " + this.quoteIdentifier(columnName) + " " + dataType;
    }

    @Override
    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return "EXEC sp_rename '" + tableName + "." + this.quoteIdentifier(columnName) + "', " + this.quoteIdentifier(newName) + ", 'COLUMN'";
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        throw QueryExecutionErrors$.MODULE$.unsupportedUpdateColumnNullabilityError();
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        throw QueryExecutionErrors$.MODULE$.commentOnTableUnsupportedError();
    }

    @Override
    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return "TOP (" + limit + ")";
        }
        return "";
    }

    @Override
    public Throwable classifyException(Throwable e, String condition, Map<String, String> messageParameters, String description, boolean isRuntime) {
        Throwable throwable = e;
        if (throwable instanceof SQLException) {
            SQLException sQLException = (SQLException)throwable;
            int n = sQLException.getErrorCode();
            switch (n) {
                case 3729: {
                    throw new NonEmptyNamespaceException((String[])Option$.MODULE$.option2Iterable(messageParameters.get((Object)"namespace")).toArray(ClassTag$.MODULE$.apply(String.class)), sQLException.getMessage(), (Option)new Some((Object)e));
                }
                case 15335: {
                    String string = condition;
                    String string2 = "FAILED_JDBC.RENAME_TABLE";
                    if (string != null ? !string.equals(string2) : string2 != null) break;
                    String newTable = (String)messageParameters.apply((Object)"newName");
                    throw QueryCompilationErrors$.MODULE$.tableAlreadyExistsError(newTable);
                }
            }
            return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
        }
        return NoLegacyJDBCError.classifyException$(this, e, condition, messageParameters, description, isRuntime);
    }

    @Override
    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new MsSqlServerSQLQueryBuilder(this, this, options);
    }

    @Override
    public boolean isSyntaxErrorBestEffort(SQLException exception) {
        String exceptionMessage = (String)Option$.MODULE$.apply((Object)exception.getMessage()).map((Function1 & Serializable)x$5 -> x$5.toLowerCase(Locale.ROOT)).getOrElse((Function0 & Serializable)() -> "");
        return exceptionMessage.contains("incorrect syntax") || exceptionMessage.contains("syntax error");
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsJoin() {
        return true;
    }

    public MsSqlServerDialect copy() {
        return new MsSqlServerDialect();
    }

    public String productPrefix() {
        return "MsSqlServerDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MsSqlServerDialect;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean equals(Object x$1) {
        Object object = x$1;
        return object instanceof MsSqlServerDialect && ((MsSqlServerDialect)x$1).canEqual(this);
    }

    public MsSqlServerDialect() {
        NoLegacyJDBCError.$init$(this);
        Product.$init$((Product)this);
        this.supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP"}));
        this.supportedStringFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"RPAD", "LPAD"}));
        this.supportedFunctions = (Set)this.supportedAggregateFunctions().$plus$plus(this.supportedStringFunctions());
    }

    public class MsSqlServerSQLBuilder
    extends JdbcDialect.JDBCSQLBuilder {
        public /* synthetic */ String protected$inputToSQL(MsSqlServerSQLBuilder x$1, Expression x$12) {
            return x$1.inputToSQL(x$12);
        }

        @Override
        public String predicateToIntSQL(String input) {
            return "IIF(" + input + ", 1, 0)";
        }

        public String visitSortOrder(String sortKey, SortDirection sortDirection, NullOrdering nullOrdering) {
            Tuple2 tuple2 = new Tuple2((Object)sortDirection, (Object)nullOrdering);
            if (tuple2 != null) {
                SortDirection sortDirection2 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering2 = (NullOrdering)tuple2._2();
                if (SortDirection.ASCENDING.equals(sortDirection2) && NullOrdering.NULLS_FIRST.equals(nullOrdering2)) {
                    return sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection3 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering3 = (NullOrdering)tuple2._2();
                if (SortDirection.ASCENDING.equals(sortDirection3) && NullOrdering.NULLS_LAST.equals(nullOrdering3)) {
                    return "CASE WHEN " + sortKey + " IS NULL THEN 1 ELSE 0 END, " + sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection4 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering4 = (NullOrdering)tuple2._2();
                if (SortDirection.DESCENDING.equals(sortDirection4) && NullOrdering.NULLS_FIRST.equals(nullOrdering4)) {
                    return "CASE WHEN " + sortKey + " IS NULL THEN 0 ELSE 1 END, " + sortKey + " " + sortDirection;
                }
            }
            if (tuple2 != null) {
                SortDirection sortDirection5 = (SortDirection)tuple2._1();
                NullOrdering nullOrdering5 = (NullOrdering)tuple2._2();
                if (SortDirection.DESCENDING.equals(sortDirection5) && NullOrdering.NULLS_LAST.equals(nullOrdering5)) {
                    return sortKey + " " + sortDirection;
                }
            }
            throw new MatchError((Object)tuple2);
        }

        @Override
        public String dialectFunctionName(String funcName) {
            String string = funcName;
            switch (string == null ? 0 : string.hashCode()) {
                case -446106967: {
                    if (!"VAR_SAMP".equals(string)) break;
                    return "VAR";
                }
                case -102600828: {
                    if (!"STDDEV_POP".equals(string)) break;
                    return "STDEVP";
                }
                case 955438329: {
                    if (!"VAR_POP".equals(string)) break;
                    return "VARP";
                }
                case 1114417534: {
                    if (!"STDDEV_SAMP".equals(string)) break;
                    return "STDEV";
                }
            }
            return super.dialectFunctionName(funcName);
        }

        @Override
        public String visitSQLFunction(String funcName, String[] inputs) {
            String string = funcName;
            switch (string == null ? 0 : string.hashCode()) {
                case 2343079: {
                    Object object;
                    if (!"LPAD".equals(string)) break;
                    String[] stringArray = inputs;
                    if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) != 0) {
                        throw new MatchError((Object)stringArray);
                    }
                    String str = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    String len = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                    String pad = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
                    Tuple3 tuple3 = new Tuple3((Object)str, (Object)len, (Object)pad);
                    String str2 = (String)tuple3._1();
                    String len2 = (String)tuple3._2();
                    String pad2 = (String)tuple3._3();
                    return "RIGHT(CONCAT(REPLICATE(" + pad2 + ", " + len2 + "), " + str2 + "), " + len2 + ")";
                }
                case 2521825: {
                    Object object;
                    if (!"RPAD".equals(string)) break;
                    String[] stringArray = inputs;
                    if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 3) != 0) {
                        throw new MatchError((Object)stringArray);
                    }
                    String str = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    String len = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                    String pad = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2);
                    Tuple3 tuple3 = new Tuple3((Object)str, (Object)len, (Object)pad);
                    String str3 = (String)tuple3._1();
                    String len3 = (String)tuple3._2();
                    String pad3 = (String)tuple3._3();
                    return "LEFT(CONCAT(" + str3 + ", REPLICATE(" + pad3 + ", " + len3 + ")), " + len3 + ")";
                }
            }
            return super.visitSQLFunction(funcName, inputs);
        }

        public String build(Expression expr) {
            block19: {
                block20: {
                    Object object;
                    Expression expression = expr;
                    if (!(expression instanceof Predicate)) break block19;
                    Predicate predicate = (Predicate)expression;
                    String string = predicate.name();
                    switch (string == null ? 0 : string.hashCode()) {
                        case -807639319: {
                            if ("CASE_WHEN".equals(string)) {
                                String[] stringArray = (String[])ArrayOps$.MODULE$.grouped$extension(Predef$.MODULE$.refArrayOps((Object[])predicate.children()), 2).flatMap((Function1 & Serializable)x0$1 -> {
                                    Object object;
                                    Object object2;
                                    Expression[] expressionArray = x0$1;
                                    if (expressionArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object2 = Array$.MODULE$.unapplySeq((Object)expressionArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 2) == 0) {
                                        Expression whenExpression = (Expression)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 0);
                                        Expression thenExpression = (Expression)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object2), 1);
                                        return Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.protected$inputToSQL(this, whenExpression), this.inputToSQLNoBool(thenExpression)});
                                    }
                                    if (expressionArray != null && !Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)expressionArray)) && new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1) == 0) {
                                        Expression elseExpression = (Expression)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                                        return Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.inputToSQLNoBool(elseExpression)});
                                    }
                                    throw new MatchError((Object)expressionArray);
                                }).toArray(ClassTag$.MODULE$.apply(String.class));
                                return this.visitCaseWhen(stringArray) + " = 1";
                            }
                            break block20;
                        }
                        case 60: {
                            if ("<".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        case 61: {
                            if ("=".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        case 62: {
                            if (">".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        case 1921: {
                            if ("<=".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        case 1922: {
                            if ("<>".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        case 1983: {
                            if (">=".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        case 59613: {
                            if ("<=>".equals(string)) {
                                break;
                            }
                            break block20;
                        }
                        default: {
                            break block20;
                        }
                    }
                    String[] stringArray = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])predicate.children()), (Function1 & Serializable)input -> this.inputToSQLNoBool((Expression)input), ClassTag$.MODULE$.apply(String.class));
                    if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
                        throw new MatchError((Object)stringArray);
                    }
                    String l = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                    String r = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                    Tuple2 tuple2 = new Tuple2((Object)l, (Object)r);
                    String l2 = (String)tuple2._1();
                    String r2 = (String)tuple2._2();
                    return this.visitBinaryComparison(predicate.name(), l2, r2);
                }
                return super.build(expr);
            }
            return super.build(expr);
        }

        public /* synthetic */ MsSqlServerDialect org$apache$spark$sql$jdbc$MsSqlServerDialect$MsSqlServerSQLBuilder$$$outer() {
            return (MsSqlServerDialect)this.$outer;
        }

        public MsSqlServerSQLBuilder(MsSqlServerDialect $outer) {
        }
    }

    public class MsSqlServerSQLQueryBuilder
    extends JdbcSQLQueryBuilder {
        private final JdbcDialect dialect;
        private final JDBCOptions options;
        public final /* synthetic */ MsSqlServerDialect $outer;

        @Override
        public String build() {
            String limitClause = this.dialect.getLimitClause(Predef$.MODULE$.int2Integer(this.limit()));
            return this.options.prepareQuery() + "SELECT " + limitClause + " " + this.columnList() + " FROM " + this.tableOrQuery() + " " + this.whereClause() + " " + this.groupByClause() + " " + this.orderByClause();
        }

        public /* synthetic */ MsSqlServerDialect org$apache$spark$sql$jdbc$MsSqlServerDialect$MsSqlServerSQLQueryBuilder$$$outer() {
            return this.$outer;
        }

        public MsSqlServerSQLQueryBuilder(MsSqlServerDialect $outer, JdbcDialect dialect, JDBCOptions options) {
            this.dialect = dialect;
            this.options = options;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(dialect, options);
        }
    }
}

