/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;
import org.apache.spark.network.ssl.ReloadingX509TrustManager;
import org.apache.spark.network.util.JavaUtils;

public class SSLFactory {
    private static final SparkLogger logger = SparkLoggerFactory.getLogger(SSLFactory.class);
    private SSLContext jdkSslContext;
    private SslContext nettyClientSslContext;
    private SslContext nettyServerSslContext;
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    private String requestedProtocol;
    private String[] requestedCiphers;

    private SSLFactory(Builder b) {
        this.requestedProtocol = b.requestedProtocol;
        this.requestedCiphers = b.requestedCiphers;
        try {
            if (b.certChain != null && b.privateKey != null) {
                this.initNettySslContexts(b);
            } else {
                this.initJdkSslContext(b);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("SSLFactory creation failed", e);
        }
    }

    private void initJdkSslContext(Builder b) throws IOException, GeneralSecurityException {
        this.keyManagers = SSLFactory.keyManagers(b.keyStore, b.keyPassword, b.keyStorePassword);
        this.trustManagers = SSLFactory.trustStoreManagers(b.trustStore, b.trustStorePassword, b.trustStoreReloadingEnabled, b.trustStoreReloadIntervalMs);
        this.jdkSslContext = SSLFactory.createSSLContext(this.requestedProtocol, this.keyManagers, this.trustManagers);
    }

    private void initNettySslContexts(Builder b) throws SSLException {
        this.nettyClientSslContext = SslContextBuilder.forClient().sslProvider(this.getSslProvider(b)).trustManager(b.certChain).build();
        this.nettyServerSslContext = SslContextBuilder.forServer((File)b.certChain, (File)b.privateKey, (String)b.privateKeyPassword).sslProvider(this.getSslProvider(b)).build();
    }

    private SslProvider getSslProvider(Builder b) {
        if (b.openSslEnabled) {
            if (OpenSsl.isAvailable()) {
                return SslProvider.OPENSSL;
            }
            logger.warn("OpenSSL Provider requested but it is not available, using JDK SSL Provider");
        }
        return SslProvider.JDK;
    }

    public void destroy() {
        if (this.trustManagers != null) {
            for (int i = 0; i < this.trustManagers.length; ++i) {
                TrustManager trustManager = this.trustManagers[i];
                if (!(trustManager instanceof ReloadingX509TrustManager)) continue;
                ReloadingX509TrustManager manager = (ReloadingX509TrustManager)trustManager;
                try {
                    manager.destroy();
                    continue;
                }
                catch (InterruptedException ex) {
                    logger.info("Interrupted while destroying trust manager: ", (Throwable)ex);
                }
            }
            this.trustManagers = null;
        }
        this.keyManagers = null;
        this.jdkSslContext = null;
        this.nettyClientSslContext = null;
        this.nettyServerSslContext = null;
        this.requestedProtocol = null;
        this.requestedCiphers = null;
    }

    private static SSLContext createSSLContext(String requestedProtocol, KeyManager[] keyManagers, TrustManager[] trustManagers) throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance(requestedProtocol);
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    public SSLEngine createSSLEngine(boolean isClient, ByteBufAllocator allocator) {
        SSLEngine engine = this.createEngine(isClient, allocator);
        engine.setUseClientMode(isClient);
        engine.setNeedClientAuth(false);
        engine.setEnabledProtocols(SSLFactory.enabledProtocols(engine, this.requestedProtocol));
        engine.setEnabledCipherSuites(SSLFactory.enabledCipherSuites(engine, this.requestedCiphers));
        return engine;
    }

    private SSLEngine createEngine(boolean isClient, ByteBufAllocator allocator) {
        SSLEngine engine = isClient ? (this.nettyClientSslContext != null ? this.nettyClientSslContext.newEngine(allocator) : this.jdkSslContext.createSSLEngine()) : (this.nettyServerSslContext != null ? this.nettyServerSslContext.newEngine(allocator) : this.jdkSslContext.createSSLEngine());
        return engine;
    }

    private static TrustManager[] credulousTrustStoreManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }};
    }

    private static TrustManager[] trustStoreManagers(File trustStore, String trustStorePassword, boolean trustStoreReloadingEnabled, int trustStoreReloadIntervalMs) throws IOException, GeneralSecurityException {
        if (trustStore == null || !trustStore.exists()) {
            return SSLFactory.credulousTrustStoreManagers();
        }
        if (trustStoreReloadingEnabled) {
            ReloadingX509TrustManager reloading = new ReloadingX509TrustManager(KeyStore.getDefaultType(), trustStore, trustStorePassword, trustStoreReloadIntervalMs);
            reloading.init();
            return new TrustManager[]{reloading};
        }
        return SSLFactory.defaultTrustManagers(trustStore, trustStorePassword);
    }

    private static TrustManager[] defaultTrustManagers(File trustStore, String trustStorePassword) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        try (InputStream input = Files.newInputStream(trustStore.toPath(), new OpenOption[0]);){
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] passwordCharacters = trustStorePassword != null ? trustStorePassword.toCharArray() : null;
            ks.load(input, passwordCharacters);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            TrustManager[] trustManagerArray = tmf.getTrustManagers();
            return trustManagerArray;
        }
    }

    private static KeyManager[] keyManagers(File keyStore, String keyPassword, String keyStorePassword) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, UnrecoverableKeyException {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        char[] keyStorePasswordChars = keyStorePassword != null ? keyStorePassword.toCharArray() : null;
        char[] keyPasswordChars = keyPassword != null ? keyPassword.toCharArray() : keyStorePasswordChars;
        factory.init(SSLFactory.loadKeyStore(keyStore, keyStorePasswordChars), keyPasswordChars);
        return factory.getKeyManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(File keyStore, char[] keyStorePassword) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        if (keyStore == null) {
            throw new KeyStoreException("keyStore cannot be null. Please configure spark.ssl.rpc.keyStore");
        }
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream fin = new FileInputStream(keyStore);
        try {
            ks.load(fin, keyStorePassword);
            KeyStore keyStore2 = ks;
            return keyStore2;
        }
        finally {
            JavaUtils.closeQuietly((Closeable)fin);
        }
    }

    private static String[] enabledProtocols(SSLEngine engine, String requestedProtocol) {
        String[] stringArray;
        String[] supportedProtocols = engine.getSupportedProtocols();
        String[] defaultProtocols = new String[]{"TLSv1.3", "TLSv1.2"};
        if (requestedProtocol == null || requestedProtocol.isEmpty()) {
            stringArray = defaultProtocols;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = requestedProtocol;
        }
        String[] enabledProtocols = stringArray;
        List<String> protocols = SSLFactory.addIfSupported(supportedProtocols, enabledProtocols);
        if (!protocols.isEmpty()) {
            return protocols.toArray(new String[protocols.size()]);
        }
        return supportedProtocols;
    }

    private static String[] enabledCipherSuites(String[] supportedCiphers, String[] defaultCiphers, String[] requestedCiphers) {
        String[] baseCiphers = new String[]{"TLS_CHACHA20_POLY1305_SHA256", "TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384"};
        String[] enabledCiphers = requestedCiphers == null || requestedCiphers.length == 0 ? baseCiphers : requestedCiphers;
        List<String> ciphers = SSLFactory.addIfSupported(supportedCiphers, enabledCiphers);
        if (!ciphers.isEmpty()) {
            return ciphers.toArray(new String[ciphers.size()]);
        }
        return defaultCiphers;
    }

    private static String[] enabledCipherSuites(SSLEngine engine, String[] requestedCiphers) {
        return SSLFactory.enabledCipherSuites(engine.getSupportedCipherSuites(), engine.getEnabledCipherSuites(), requestedCiphers);
    }

    private static List<String> addIfSupported(String[] supported, String ... names) {
        ArrayList<String> enabled = new ArrayList<String>();
        HashSet<String> supportedSet = new HashSet<String>(Arrays.asList(supported));
        for (String n : names) {
            if (!supportedSet.contains(n)) continue;
            enabled.add(n);
        }
        return enabled;
    }

    public static class Builder {
        private String requestedProtocol;
        private String[] requestedCiphers;
        private File keyStore;
        private String keyStorePassword;
        private File privateKey;
        private String privateKeyPassword;
        private String keyPassword;
        private File certChain;
        private File trustStore;
        private String trustStorePassword;
        private boolean trustStoreReloadingEnabled;
        private int trustStoreReloadIntervalMs;
        private boolean openSslEnabled;

        public Builder requestedProtocol(String requestedProtocol) {
            this.requestedProtocol = requestedProtocol == null ? "TLSv1.3" : requestedProtocol;
            return this;
        }

        public Builder requestedCiphers(String[] requestedCiphers) {
            this.requestedCiphers = requestedCiphers;
            return this;
        }

        public Builder keyStore(File keyStore, String keyStorePassword) {
            this.keyStore = keyStore;
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder privateKey(File privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder keyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            return this;
        }

        public Builder privateKeyPassword(String privateKeyPassword) {
            this.privateKeyPassword = privateKeyPassword;
            return this;
        }

        public Builder certChain(File certChain) {
            this.certChain = certChain;
            return this;
        }

        public Builder openSslEnabled(boolean enabled) {
            this.openSslEnabled = enabled;
            return this;
        }

        public Builder trustStore(File trustStore, String trustStorePassword, boolean trustStoreReloadingEnabled, int trustStoreReloadIntervalMs) {
            this.trustStore = trustStore;
            this.trustStorePassword = trustStorePassword;
            this.trustStoreReloadingEnabled = trustStoreReloadingEnabled;
            this.trustStoreReloadIntervalMs = trustStoreReloadIntervalMs;
            return this;
        }

        public SSLFactory build() {
            return new SSLFactory(this);
        }
    }
}

