/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelReader$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.ReadWriteUtils$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\rme\u0001\u0002%J\u0001QC\u0001\"\u001b\u0001\u0003\u0006\u0004%\tE\u001b\u0005\n\u0003\u0007\u0001!\u0011!Q\u0001\n-D!\"a\u0002\u0001\u0005\u000b\u0007I\u0011AA\u0005\u0011%\t\t\u0002\u0001B\u0001B\u0003%\u0011\f\u0003\u0006\u0002\u0016\u0001\u0011)\u0019!C\u0001\u0003/A!\"a\t\u0001\u0005\u0003\u0005\u000b\u0011BA\r\u0011)\t9\u0003\u0001BC\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u0003W\u0001!\u0011!Q\u0001\n\u0005e\u0001\u0002CA\u0018\u0001\u0011\u00051*!\r\t\u0011\u0005=\u0002\u0001\"\u0001L\u0003\u0007Bq!!\u0012\u0001\t\u0003\n9\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j!Y\u0011q\u000e\u0001A\u0002\u0003\u0007I\u0011BA\u0005\u0011-\t\t\b\u0001a\u0001\u0002\u0004%I!a\u001d\t\u0015\u0005}\u0004\u00011A\u0001B\u0003&\u0011\f\u0003\u0005\u0002\u0002\u0002!\teSAB\u0011\u001d\tY\u000b\u0001C\u0005\u0003[Cq!a-\u0001\t\u0003\t)\fC\u0004\u0002>\u0002!\t!a0\t\u000f\u0005\u0015\u0007\u0001\"\u0011\u0002H\"9!\u0011\u0001\u0001\u0005B\t\r\u0001b\u0002B\f\u0001\u0011\u0005#\u0011\u0004\u0005\t\u0005O\u0001A\u0011I'\u0003*!9!\u0011\u0007\u0001\u0005B\tM\u0002b\u0002B\u001f\u0001\u0011\u0005#qH\u0004\b\u0005\u000bJ\u0005\u0012\u0001B$\r\u0019A\u0015\n#\u0001\u0003J!9\u0011q\u0006\u000f\u0005\u0002\t\u001dda\u0002B59\u0001[%1\u000e\u0005\u000b\u0003\u000fq\"Q3A\u0005\u0002\u0005%\u0001\"CA\t=\tE\t\u0015!\u0003Z\u0011)\t)B\bBK\u0002\u0013\u0005\u0011q\u0003\u0005\u000b\u0003Gq\"\u0011#Q\u0001\n\u0005e\u0001BCA\u0014=\tU\r\u0011\"\u0001\u0002\u0018!Q\u00111\u0006\u0010\u0003\u0012\u0003\u0006I!!\u0007\t\u000f\u0005=b\u0004\"\u0001\u0003\u0002\"I!q\u0003\u0010\u0002\u0002\u0013\u0005!Q\u0012\u0005\n\u0005+s\u0012\u0013!C\u0001\u0005/C\u0011Ba+\u001f#\u0003%\tA!,\t\u0013\tEf$%A\u0005\u0002\t5\u0006\"\u0003BZ=\u0005\u0005I\u0011\tB[\u0011%\u0011\tMHA\u0001\n\u0003\t9\u0005C\u0005\u0003Dz\t\t\u0011\"\u0001\u0003F\"I!\u0011\u001a\u0010\u0002\u0002\u0013\u0005#1\u001a\u0005\n\u00053t\u0012\u0011!C\u0001\u00057D\u0011B!:\u001f\u0003\u0003%\tEa:\t\u0013\t-h$!A\u0005B\t5\b\"\u0003B\u001f=\u0005\u0005I\u0011\tBx\u0011%\u0011\tPHA\u0001\n\u0003\u0012\u0019p\u0002\u0006\u0003xr\t\t\u0011#\u0001L\u0005s4!B!\u001b\u001d\u0003\u0003E\ta\u0013B~\u0011\u001d\ty\u0003\u000eC\u0001\u0007\u0013A\u0011B!\u00105\u0003\u0003%)Ea<\t\u0013\r-A'!A\u0005\u0002\u000e5\u0001\"CB\u000bi\u0005\u0005I\u0011QB\f\u0011%\u0019I\u0003NA\u0001\n\u0013\u0019Y\u0003\u0003\u0005\u00044q!\taSB\u001b\u0011!\u0019)\u0005\bC\u0001\u0017\u000e\u001d\u0003bBB*9\u0011\u00053Q\u000b\u0005\b\u0007?bB\u0011IB1\r\u001d\u0019I\u0007\b\u0001\u001d\u0007WB\u0011b!\u001f?\u0005\u0003\u0005\u000b\u0011B0\t\u000f\u0005=b\b\"\u0001\u0004|!91\u0011\u0011 \u0005R\r\reABBD9\u0011\u0019I\tC\u0004\u00020\t#\taa#\t\u0013\r=%I1A\u0005\n\tU\u0006\u0002CBI\u0005\u0002\u0006IAa.\t\u000f\r}#\t\"\u0011\u0004\u0014\"I1\u0011\u0006\u000f\u0002\u0002\u0013%11\u0006\u0002\u001b\u0003\u001a#6+\u001e:wSZ\fGNU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\u0006\u0003\u0015.\u000b!B]3he\u0016\u001c8/[8o\u0015\taU*\u0001\u0002nY*\u0011ajT\u0001\u0006gB\f'o\u001b\u0006\u0003!F\u000ba!\u00199bG\",'\"\u0001*\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001)\u0006m\u0019\t\u0005-^Kv,D\u0001J\u0013\tA\u0016JA\bSK\u001e\u0014Xm]:j_:lu\u000eZ3m!\tQV,D\u0001\\\u0015\ta6*\u0001\u0004mS:\fGnZ\u0005\u0003=n\u0013aAV3di>\u0014\bC\u0001,\u0001!\t1\u0016-\u0003\u0002c\u0013\nY\u0012I\u0012+TkJ4\u0018N^1m%\u0016<'/Z:tS>t\u0007+\u0019:b[N\u0004\"\u0001Z4\u000e\u0003\u0015T!AZ&\u0002\tU$\u0018\u000e\\\u0005\u0003Q\u0016\u0014!\"\u0014'Xe&$\u0018M\u00197f\u0003\r)\u0018\u000eZ\u000b\u0002WB\u0011A.\u001e\b\u0003[N\u0004\"A\\9\u000e\u0003=T!\u0001]*\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0011\u0018!B:dC2\f\u0017B\u0001;r\u0003\u0019\u0001&/\u001a3fM&\u0011ao\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\f\bfA\u0001z\u007fB\u0011!0`\u0007\u0002w*\u0011A0T\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001@|\u0005\u0015\u0019\u0016N\\2fC\t\t\t!A\u00032]Yr\u0003'\u0001\u0003vS\u0012\u0004\u0003f\u0001\u0002z\u007f\u0006a1m\\3gM&\u001c\u0017.\u001a8ugV\t\u0011\f\u000b\u0003\u0004s\u00065\u0011EAA\b\u0003\u0015\u0011d\u0006\r\u00181\u00035\u0019w.\u001a4gS\u000eLWM\u001c;tA!\"A!_A\u0007\u0003%Ig\u000e^3sG\u0016\u0004H/\u0006\u0002\u0002\u001aA!\u00111DA\u000f\u001b\u0005\t\u0018bAA\u0010c\n1Ai\\;cY\u0016D3!B=\u0000\u0003)Ig\u000e^3sG\u0016\u0004H\u000f\t\u0015\u0004\re|\u0018!B:dC2,\u0007fA\u0004z\u007f\u000611oY1mK\u0002B3\u0001C=\u0000\u0003\u0019a\u0014N\\5u}QIq,a\r\u00028\u0005m\u0012q\b\u0005\u0006S&\u0001\ra\u001b\u0015\u0005\u0003gIx\u0010\u0003\u0004\u0002\b%\u0001\r!\u0017\u0015\u0006\u0003oI\u0018Q\u0002\u0005\b\u0003+I\u0001\u0019AA\rQ\u0011\tY$_@\t\u000f\u0005\u001d\u0012\u00021\u0001\u0002\u001a!\"\u0011qH=\u0000)\u0005y\u0016a\u00038v[\u001a+\u0017\r^;sKN,\"!!\u0013\u0011\t\u0005m\u00111J\u0005\u0004\u0003\u001b\n(aA%oi\"\"1\"_A)C\t\t\u0019&A\u00034]Ar\u0003'\u0001\rtKR\fV/\u00198uS2,\u0007K]8cC\nLG.\u001b;jKN$B!!\u0017\u0002\\5\t\u0001\u0001C\u0004\u0002^1\u0001\r!a\u0018\u0002\u000bY\fG.^3\u0011\r\u0005m\u0011\u0011MA\r\u0013\r\t\u0019'\u001d\u0002\u0006\u0003J\u0014\u0018-\u001f\u0015\u0004\u0019e|\u0018aD:fiF+\u0018M\u001c;jY\u0016\u001c8i\u001c7\u0015\t\u0005e\u00131\u000e\u0005\u0007\u0003;j\u0001\u0019A6)\u00075Ix0\u0001\u0006`cV\fg\u000e^5mKN\fabX9vC:$\u0018\u000e\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002v\u0005m\u0004\u0003BA\u000e\u0003oJ1!!\u001fr\u0005\u0011)f.\u001b;\t\u0011\u0005ut\"!AA\u0002e\u000b1\u0001\u001f\u00132\u0003-y\u0016/^1oi&dWm\u001d\u0011\u0002\u001b=t\u0007+\u0019:b[\u000eC\u0017M\\4f)\u0011\t)(!\"\t\u000f\u0005\u001d\u0015\u00031\u0001\u0002\n\u0006)\u0001/\u0019:b[B\"\u00111RAM!\u0019\ti)!%\u0002\u00166\u0011\u0011q\u0012\u0006\u0004\u0003\u000f[\u0015\u0002BAJ\u0003\u001f\u0013Q\u0001U1sC6\u0004B!a&\u0002\u001a2\u0001A\u0001DAN\u0003\u000b\u000b\t\u0011!A\u0003\u0002\u0005u%aA0%gE!\u0011qTAS!\u0011\tY\"!)\n\u0007\u0005\r\u0016OA\u0004O_RD\u0017N\\4\u0011\t\u0005m\u0011qU\u0005\u0004\u0003S\u000b(aA!os\u0006\u0001B.Y7cI\u0006\u0014\u0014+^1oi&dWm\u001d\u000b\u00043\u0006=\u0006bBAY%\u0001\u0007\u0011\u0011D\u0001\u0007Y\u0006l'\rZ1\u0002!A\u0014X\rZ5diF+\u0018M\u001c;jY\u0016\u001cHcA-\u00028\"1\u0011\u0011X\nA\u0002e\u000b\u0001BZ3biV\u0014Xm\u001d\u0015\u0005'e\fi!A\u0004qe\u0016$\u0017n\u0019;\u0015\t\u0005e\u0011\u0011\u0019\u0005\u0007\u0003s#\u0002\u0019A-)\tQI\u0018QB\u0001\niJ\fgn\u001d4pe6$B!!3\u0002lB!\u00111ZAs\u001d\u0011\ti-a8\u000f\t\u0005=\u00171\u001c\b\u0005\u0003#\fIN\u0004\u0003\u0002T\u0006]gb\u00018\u0002V&\t!+\u0003\u0002Q#&\u0011ajT\u0005\u0004\u0003;l\u0015aA:rY&!\u0011\u0011]Ar\u0003\u001d\u0001\u0018mY6bO\u0016T1!!8N\u0013\u0011\t9/!;\u0003\u0013\u0011\u000bG/\u0019$sC6,'\u0002BAq\u0003GDq!!<\u0016\u0001\u0004\ty/A\u0004eCR\f7/\u001a;1\t\u0005E\u00181 \t\u0007\u0003g\f)0!?\u000e\u0005\u0005\r\u0018\u0002BA|\u0003G\u0014q\u0001R1uCN,G\u000f\u0005\u0003\u0002\u0018\u0006mH\u0001DA\u007f\u0003W\f\t\u0011!A\u0003\u0002\u0005u%aA0%i!\"Q#_A\u0007\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003\u0002B\u0003\u0005#\u0001BAa\u0002\u0003\u000e5\u0011!\u0011\u0002\u0006\u0005\u0005\u0017\t\u0019/A\u0003usB,7/\u0003\u0003\u0003\u0010\t%!AC*ueV\u001cG\u000fV=qK\"9!1\u0003\fA\u0002\t\u0015\u0011AB:dQ\u0016l\u0017\rK\u0002\u0017s~\fAaY8qsR\u0019qLa\u0007\t\u000f\tuq\u00031\u0001\u0003 \u0005)Q\r\u001f;sCB!\u0011Q\u0012B\u0011\u0013\u0011\u0011\u0019#a$\u0003\u0011A\u000b'/Y7NCBD3aF=\u0000\u00035)7\u000f^5nCR,GmU5{KV\u0011!1\u0006\t\u0005\u00037\u0011i#C\u0002\u00030E\u0014A\u0001T8oO\u0006)qO]5uKV\u0011!Q\u0007\t\u0004I\n]\u0012b\u0001B\u001dK\nAQ\nT,sSR,'\u000fK\u0002\u001as~\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002W\"\"!$_A)Q\r\u0001\u0011p`\u0001\u001b\u0003\u001a#6+\u001e:wSZ\fGNU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0003-r\u0019r\u0001\bB&\u0005#\u00129\u0006\u0005\u0003\u0002\u001c\t5\u0013b\u0001B(c\n1\u0011I\\=SK\u001a\u0004B\u0001\u001aB*?&\u0019!QK3\u0003\u00155c%+Z1eC\ndW\r\u0005\u0003\u0003Z\t\rTB\u0001B.\u0015\u0011\u0011iFa\u0018\u0002\u0005%|'B\u0001B1\u0003\u0011Q\u0017M^1\n\t\t\u0015$1\f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0005\u000f\u0012A\u0001R1uCN9aDa\u0013\u0003n\tM\u0004\u0003BA\u000e\u0005_J1A!\u001dr\u0005\u001d\u0001&o\u001c3vGR\u0004BA!\u001e\u0003~9!!q\u000fB>\u001d\rq'\u0011P\u0005\u0002e&\u0019\u0011\u0011]9\n\t\t\u0015$q\u0010\u0006\u0004\u0003C\fH\u0003\u0003BB\u0005\u000f\u0013IIa#\u0011\u0007\t\u0015e$D\u0001\u001d\u0011\u0019\t9!\na\u00013\"9\u0011QC\u0013A\u0002\u0005e\u0001bBA\u0014K\u0001\u0007\u0011\u0011\u0004\u000b\t\u0005\u0007\u0013yI!%\u0003\u0014\"A\u0011q\u0001\u0014\u0011\u0002\u0003\u0007\u0011\fC\u0005\u0002\u0016\u0019\u0002\n\u00111\u0001\u0002\u001a!I\u0011q\u0005\u0014\u0011\u0002\u0003\u0007\u0011\u0011D\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011IJK\u0002Z\u00057[#A!(\u0011\t\t}%qU\u0007\u0003\u0005CSAAa)\u0003&\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003yFLAA!+\u0003\"\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!q\u0016\u0016\u0005\u00033\u0011Y*\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00119\f\u0005\u0003\u0003:\n}VB\u0001B^\u0015\u0011\u0011iLa\u0018\u0002\t1\fgnZ\u0005\u0004m\nm\u0016\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003K\u00139\rC\u0005\u0002~1\n\t\u00111\u0001\u0002J\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003NB1!q\u001aBk\u0003Kk!A!5\u000b\u0007\tM\u0017/\u0001\u0006d_2dWm\u0019;j_:LAAa6\u0003R\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011iNa9\u0011\t\u0005m!q\\\u0005\u0004\u0005C\f(a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003{r\u0013\u0011!a\u0001\u0003K\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!!q\u0017Bu\u0011%\tihLA\u0001\u0002\u0004\tI%\u0001\u0005iCND7i\u001c3f)\t\tI\u0005\u0006\u0002\u00038\u00061Q-];bYN$BA!8\u0003v\"I\u0011Q\u0010\u001a\u0002\u0002\u0003\u0007\u0011QU\u0001\u0005\t\u0006$\u0018\rE\u0002\u0003\u0006R\u001aR\u0001\u000eB\u007f\u0005/\u00022Ba@\u0004\u0006e\u000bI\"!\u0007\u0003\u00046\u00111\u0011\u0001\u0006\u0004\u0007\u0007\t\u0018a\u0002:v]RLW.Z\u0005\u0005\u0007\u000f\u0019\tAA\tBEN$(/Y2u\rVt7\r^5p]N\"\"A!?\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\t\r5qBB\t\u0007'Aa!a\u00028\u0001\u0004I\u0006bBA\u000bo\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003O9\u0004\u0019AA\r\u0003\u001d)h.\u00199qYf$Ba!\u0007\u0004&A1\u00111DB\u000e\u0007?I1a!\br\u0005\u0019y\u0005\u000f^5p]BI\u00111DB\u00113\u0006e\u0011\u0011D\u0005\u0004\u0007G\t(A\u0002+va2,7\u0007C\u0005\u0004(a\n\t\u00111\u0001\u0003\u0004\u0006\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\r5\u0002\u0003\u0002B]\u0007_IAa!\r\u0003<\n1qJ\u00196fGR\fQb]3sS\u0006d\u0017N_3ECR\fGCBA;\u0007o\u0019Y\u0004C\u0004\u0004:i\u0002\rAa!\u0002\t\u0011\fG/\u0019\u0005\b\u0007{Q\u0004\u0019AB \u0003\r!wn\u001d\t\u0005\u00053\u001a\t%\u0003\u0003\u0004D\tm#\u0001\u0005#bi\u0006|U\u000f\u001e9viN#(/Z1n\u0003=!Wm]3sS\u0006d\u0017N_3ECR\fG\u0003\u0002BB\u0007\u0013Bqaa\u0013<\u0001\u0004\u0019i%A\u0002eSN\u0004BA!\u0017\u0004P%!1\u0011\u000bB.\u0005=!\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0017\u0001\u0002:fC\u0012,\"aa\u0016\u0011\t\u0011\u001cIfX\u0005\u0004\u00077*'\u0001C'M%\u0016\fG-\u001a:)\u0007qJx0\u0001\u0003m_\u0006$GcA0\u0004d!11QM\u001fA\u0002-\fA\u0001]1uQ\"\u001aQ(_@\u0003A\u00053EkU;sm&4\u0018\r\u001c*fOJ,7o]5p]6{G-\u001a7Xe&$XM]\n\u0006}\tU2Q\u000e\t\u0005\u0007_\u001a)(\u0004\u0002\u0004r)\u001911O'\u0002\u0011%tG/\u001a:oC2LAaa\u001e\u0004r\t9Aj\\4hS:<\u0017\u0001C5ogR\fgnY3\u0015\t\ru4q\u0010\t\u0004\u0005\u000bs\u0004BBB=\u0001\u0002\u0007q,\u0001\u0005tCZ,\u0017*\u001c9m)\u0011\t)h!\"\t\r\r\u0015\u0014\t1\u0001l\u0005\u0001\ne\tV*veZLg/\u00197SK\u001e\u0014Xm]:j_:lu\u000eZ3m%\u0016\fG-\u001a:\u0014\u0007\t\u001b9\u0006\u0006\u0002\u0004\u000eB\u0019!Q\u0011\"\u0002\u0013\rd\u0017m]:OC6,\u0017AC2mCN\u001ch*Y7fAQ\u0019ql!&\t\r\r\u0015d\t1\u0001lQ\ra\u0012p \u0015\u00047e|\b")
public class AFTSurvivalRegressionModel
extends RegressionModel<Vector, AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
MLWritable {
    private final String uid;
    private final Vector coefficients;
    private final double intercept;
    private final double scale;
    private Vector _quantiles;
    private Param<String> censorCol;
    private DoubleArrayParam quantileProbabilities;
    private Param<String> quantilesCol;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private BooleanParam fitIntercept;
    private DoubleParam tol;
    private IntParam maxIter;

    public static AFTSurvivalRegressionModel load(String path) {
        return AFTSurvivalRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<AFTSurvivalRegressionModel> read() {
        return AFTSurvivalRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams.getCensorCol$(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams.getQuantileProbabilities$(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams.getQuantilesCol$(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams.hasQuantilesCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams.validateAndTransformSchema$(this, schema, fitting);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param<String> x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param<String> x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector coefficients() {
        return this.coefficients;
    }

    public double intercept() {
        return this.intercept;
    }

    public double scale() {
        return this.scale;
    }

    @Override
    public int numFeatures() {
        return this.coefficients().size();
    }

    public AFTSurvivalRegressionModel setQuantileProbabilities(double[] value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantileProbabilities(), value);
    }

    public AFTSurvivalRegressionModel setQuantilesCol(String value) {
        return (AFTSurvivalRegressionModel)this.set(this.quantilesCol(), value);
    }

    private Vector _quantiles() {
        return this._quantiles;
    }

    private void _quantiles_$eq(Vector x$1) {
        this._quantiles = x$1;
    }

    @Override
    public void onParamChange(Param<?> param) {
        String string = param.name();
        String string2 = "quantileProbabilities";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            if (this.isDefined(this.quantileProbabilities())) {
                this._quantiles_$eq(Vectors$.MODULE$.dense((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(this.$(this.quantileProbabilities())), (Function1)(JFunction1.mcDD.sp & Serializable)q -> scala.math.package$.MODULE$.exp(scala.math.package$.MODULE$.log(-scala.math.package$.MODULE$.log1p(-q)) * this.scale()), (ClassTag)ClassTag$.MODULE$.Double())));
                return;
            }
            this._quantiles_$eq(null);
            return;
        }
    }

    private Vector lambda2Quantiles(double lambda) {
        Vector quantiles = this._quantiles().copy();
        BLAS$.MODULE$.scal(lambda, quantiles);
        return quantiles;
    }

    public Vector predictQuantiles(Vector features) {
        double lambda = this.predict(features);
        return this.lambda2Quantiles(lambda);
    }

    @Override
    public double predict(Vector features) {
        return scala.math.package$.MODULE$.exp(BLAS$.MODULE$.dot(this.coefficients(), features) + this.intercept());
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)package$.MODULE$.Seq().empty();
        Seq predictionColumns = (Seq)package$.MODULE$.Seq().empty();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(AFTSurvivalRegressionModel $outer) {
                }
            }
            Column predCol = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator1$1(null))).apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predCol.as(this.$(this.predictionCol()), outputSchema.apply(this.$(this.predictionCol())).metadata()));
        }
        if (this.hasQuantilesCol()) {
            Column column;
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1 & Serializable)lambda -> this.lambda2Quantiles(BoxesRunTime.unboxToDouble((Object)lambda)), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator2$1(null)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double()).apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)predictionColumns.head()}));
            } else {
                JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModel.class.getClassLoader());
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1(AFTSurvivalRegressionModel $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1 & Serializable)features -> this.predictQuantiles((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator3$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$$typecreator4$1(null))).apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
            }
            Column quanCol = column;
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.quantilesCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)quanCol.as(this.$(this.quantilesCol()), outputSchema.apply(this.$(this.quantilesCol())).metadata()));
        }
        if (predictionColNames.nonEmpty()) {
            return dataset.withColumns(predictionColNames, predictionColumns);
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ": AFTSurvivalRegressionModel.transform() "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.UUID, this.uid())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"does nothing because no output columns were set."}))).log((Seq)Nil$.MODULE$))));
        return dataset.toDF();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block1: {
            outputSchema = this.validateAndTransformSchema(schema, false);
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
                outputSchema = SchemaUtils$.MODULE$.updateNumeric(outputSchema, this.$(this.predictionCol()));
            }
            if (!this.isDefined(this.quantilesCol()) || !StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.quantilesCol())))) break block1;
            outputSchema = SchemaUtils$.MODULE$.updateAttributeGroupSize(outputSchema, this.$(this.quantilesCol()), this.$(this.quantileProbabilities()).length);
        }
        return outputSchema;
    }

    @Override
    public AFTSurvivalRegressionModel copy(ParamMap extra) {
        return (AFTSurvivalRegressionModel)((Model)this.copyValues(new AFTSurvivalRegressionModel(this.uid(), this.coefficients(), this.intercept(), this.scale()), extra)).setParent(this.parent());
    }

    @Override
    public long estimatedSize() {
        long size;
        block0: {
            size = this.estimateMatadataSize();
            if (this.coefficients() == null) break block0;
            size += this.coefficients().getSizeInBytes();
        }
        return size;
    }

    @Override
    public MLWriter write() {
        return new AFTSurvivalRegressionModelWriter(this);
    }

    @Override
    public String toString() {
        return "AFTSurvivalRegressionModel: uid=" + this.uid() + ", numFeatures=" + this.numFeatures();
    }

    public AFTSurvivalRegressionModel(String uid, Vector coefficients, double intercept, double scale) {
        this.uid = uid;
        this.coefficients = coefficients;
        this.intercept = intercept;
        this.scale = scale;
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasAggregationDepth.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        AFTSurvivalRegressionParams.$init$(this);
        MLWritable.$init$(this);
        Statics.releaseFence();
    }

    public AFTSurvivalRegressionModel() {
        this("", (Vector)Vectors$.MODULE$.empty(), Double.NaN, Double.NaN);
    }

    private static class AFTSurvivalRegressionModelReader
    extends MLReader<AFTSurvivalRegressionModel> {
        private final String className = AFTSurvivalRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public AFTSurvivalRegressionModel load(String path) {
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sparkSession(), this.className());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModelReader.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelReader$$typecreator1$3
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelReader$$typecreator1$3(AFTSurvivalRegressionModelReader $outer) {
                }
            }
            Data data = (Data)ReadWriteUtils$.MODULE$.loadObject(dataPath, this.sparkSession(), (Function1 & Serializable)dis -> AFTSurvivalRegressionModel$.MODULE$.deserializeData((DataInputStream)dis), ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelReader$$typecreator1$3(null)));
            AFTSurvivalRegressionModel model = new AFTSurvivalRegressionModel(metadata.uid(), data.coefficients(), data.intercept(), data.scale());
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class AFTSurvivalRegressionModelWriter
    extends MLWriter {
        private final AFTSurvivalRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            public final class Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.regression.AFTSurvivalRegressionModel.Data").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2(AFTSurvivalRegressionModelWriter $outer) {
                }
            }
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sparkSession());
            Data data2 = new Data(this.instance.coefficients(), this.instance.intercept(), this.instance.scale());
            String dataPath = new Path(path, "data").toString();
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(AFTSurvivalRegressionModelWriter.class.getClassLoader());
            ReadWriteUtils$.MODULE$.saveObject(dataPath, data2, this.sparkSession(), (Function2 & Serializable)(data, dos) -> {
                AFTSurvivalRegressionModel$.MODULE$.serializeData(data, dos);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Data.class), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_AFTSurvivalRegressionModel$AFTSurvivalRegressionModelWriter$$typecreator1$2(null)));
        }

        public AFTSurvivalRegressionModelWriter(AFTSurvivalRegressionModel instance) {
            this.instance = instance;
        }
    }

    public static class Data
    implements Product,
    Serializable {
        private final Vector coefficients;
        private final double intercept;
        private final double scale;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Vector coefficients() {
            return this.coefficients;
        }

        public double intercept() {
            return this.intercept;
        }

        public double scale() {
            return this.scale;
        }

        public Data copy(Vector coefficients, double intercept, double scale) {
            return new Data(coefficients, intercept, scale);
        }

        public Vector copy$default$1() {
            return this.coefficients();
        }

        public double copy$default$2() {
            return this.intercept();
        }

        public double copy$default$3() {
            return this.scale();
        }

        public String productPrefix() {
            return "Data";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.coefficients();
                }
                case 1: {
                    return BoxesRunTime.boxToDouble((double)this.intercept());
                }
                case 2: {
                    return BoxesRunTime.boxToDouble((double)this.scale());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Data;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "coefficients";
                }
                case 1: {
                    return "intercept";
                }
                case 2: {
                    return "scale";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.coefficients()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.intercept()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.scale()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Data)) return false;
            boolean bl = true;
            if (!bl) return false;
            Data data = (Data)x$1;
            if (this.intercept() != data.intercept()) return false;
            if (this.scale() != data.scale()) return false;
            Vector vector = this.coefficients();
            Vector vector2 = data.coefficients();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!vector.equals(vector2)) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public Data(Vector coefficients, double intercept, double scale) {
            this.coefficients = coefficients;
            this.intercept = intercept;
            this.scale = scale;
            Product.$init$((Product)this);
        }
    }
}

