/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl.injectors;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.adapter.Adaptable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.Nullable;

abstract class AbstractInjector {
    AbstractInjector() {
    }

    protected ResourceResolver getResourceResolver(Object adaptable) {
        ResourceResolver resolver = null;
        if (adaptable instanceof Resource) {
            Resource r = (Resource)adaptable;
            resolver = r.getResourceResolver();
        } else if (adaptable instanceof SlingJakartaHttpServletRequest) {
            SlingJakartaHttpServletRequest jakartaRequest = (SlingJakartaHttpServletRequest)adaptable;
            resolver = jakartaRequest.getResourceResolver();
        } else if (adaptable instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest javaxRequest = (SlingHttpServletRequest)adaptable;
            resolver = javaxRequest.getResourceResolver();
        }
        return resolver;
    }

    @Nullable
    protected ValueMap getValueMap(Object adaptable) {
        ValueMap valueMap = null;
        if (adaptable instanceof ValueMap) {
            ValueMap vm;
            valueMap = vm = (ValueMap)adaptable;
        } else if (adaptable instanceof SlingJakartaHttpServletRequest) {
            SlingJakartaHttpServletRequest jakartaRequest = (SlingJakartaHttpServletRequest)adaptable;
            valueMap = this.toValueMap(jakartaRequest.getResource());
        } else if (adaptable instanceof SlingHttpServletRequest) {
            SlingHttpServletRequest javaxRequest = (SlingHttpServletRequest)adaptable;
            valueMap = this.toValueMap(javaxRequest.getResource());
        } else if (adaptable instanceof Adaptable) {
            Adaptable a = (Adaptable)adaptable;
            valueMap = (ValueMap)a.adaptTo(ValueMap.class);
        }
        return valueMap;
    }

    @Nullable
    protected ValueMap toValueMap(Resource resource) {
        ValueMap valueMap = null;
        if (resource != null) {
            valueMap = (ValueMap)resource.adaptTo(ValueMap.class);
        }
        return valueMap;
    }

    protected boolean isDeclaredTypeCollection(Type declaredType) {
        boolean isCollection = false;
        if (declaredType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)declaredType;
            Class collectionType = (Class)type.getRawType();
            isCollection = collectionType.equals(Collection.class) || collectionType.equals(List.class);
        }
        return isCollection;
    }
}

