/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.repoinit.parser.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.apache.sling.repoinit.parser.impl.QuotableStringUtil;
import org.apache.sling.repoinit.parser.operations.AclLine;
import org.apache.sling.repoinit.parser.operations.Operation;
import org.apache.sling.repoinit.parser.operations.RestrictionClause;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
abstract class AclGroupBase
extends Operation {
    public static final String ACL_OPTION_MERGE = "merge";
    public static final String ACL_OPTION_MERGE_PRESERVE = "mergePreserve";
    private final List<AclLine> lines;
    private final List<String> aclOptions;

    protected AclGroupBase(List<AclLine> lines) {
        this(lines, new ArrayList<String>());
    }

    protected AclGroupBase(List<AclLine> lines, List<String> aclOptions) {
        this.lines = Collections.unmodifiableList(lines);
        this.aclOptions = Collections.unmodifiableList(aclOptions);
    }

    @Override
    protected String getParametersDescription() {
        StringBuilder sb = new StringBuilder();
        for (AclLine line : this.lines) {
            sb.append("\n  ").append(line.toString());
        }
        return sb.toString();
    }

    public Collection<AclLine> getLines() {
        return this.lines;
    }

    public List<String> getOptions() {
        return this.aclOptions;
    }

    String asRepoInit(@NotNull String topLine, boolean hasPathLines) {
        try (Formatter formatter = new Formatter();){
            formatter.format("%s", topLine);
            for (AclLine line : this.lines) {
                String pathStr;
                String action = AclGroupBase.actionToString(line.getAction());
                String privileges = AclGroupBase.privilegesToString(line.getAction(), line.getProperty("privileges"));
                String onOrFor = hasPathLines ? ((pathStr = AclGroupBase.pathsToString(line.getProperty("paths"))).isEmpty() ? "" : " on " + pathStr) : " for " + AclGroupBase.listToString(QuotableStringUtil.forRepoInitString(line.getProperty("principals")));
                formatter.format("    %s %s%s%s%s%n", action, privileges, onOrFor, AclGroupBase.nodetypesToString(line.getProperty("nodetypes")), AclGroupBase.restrictionsToString(line.getRestrictions()));
            }
            formatter.format("end%n", new Object[0]);
            String string = formatter.toString();
            return string;
        }
    }

    @NotNull
    String getAclOptionsString() {
        return this.aclOptions.isEmpty() ? "" : " (ACLOptions=" + AclGroupBase.listToString(this.aclOptions) + ")";
    }

    @NotNull
    static String privilegesToString(@NotNull AclLine.Action action, @NotNull List<String> privileges) {
        return action == AclLine.Action.REMOVE_ALL ? "*" : AclGroupBase.listToString(privileges);
    }

    @NotNull
    private static String nodetypesToString(@NotNull List<String> nodetypes) {
        return nodetypes.isEmpty() ? "" : " nodetypes " + AclGroupBase.listToString(nodetypes);
    }

    @NotNull
    private static String restrictionsToString(@NotNull List<RestrictionClause> restrictionClauses) {
        StringBuilder sb = new StringBuilder();
        for (RestrictionClause rc : restrictionClauses) {
            sb.append(" restriction(").append(rc.getName());
            for (String v : rc.getValues()) {
                sb.append(",").append(v);
            }
            sb.append(')');
        }
        return sb.toString();
    }

    @NotNull
    private static String actionToString(@NotNull AclLine.Action action) {
        if (action.equals((Object)AclLine.Action.REMOVE_ALL)) {
            return AclLine.Action.REMOVE.toString().toLowerCase();
        }
        return action.toString().toLowerCase();
    }
}

