/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.finagle;

import com.twitter.finagle.Address;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.finagle.AbstractInterceptor;
import org.apache.skywalking.apm.plugin.finagle.ContextCarrierHelper;
import org.apache.skywalking.apm.plugin.finagle.ContextHolderFactory;
import org.apache.skywalking.apm.plugin.finagle.FinagleCtxs;

public class ClientDestTracingFilterInterceptor
extends AbstractInterceptor {
    @Override
    public void onConstructImpl(EnhancedInstance enhancedInstance, Object[] objects) {
        enhancedInstance.setSkyWalkingDynamicField((Object)this.getRemote(objects));
    }

    @Override
    public void beforeMethodImpl(EnhancedInstance enhancedInstance, Method method, Object[] objects, Class<?>[] classes, MethodInterceptResult methodInterceptResult) throws Throwable {
        String peer = (String)enhancedInstance.getSkyWalkingDynamicField();
        ContextHolderFactory.getLocalContextHolder().let(FinagleCtxs.PEER_HOST, peer);
        ContextCarrierHelper.tryInjectContext(FinagleCtxs.getSpan());
    }

    @Override
    public Object afterMethodImpl(EnhancedInstance enhancedInstance, Method method, Object[] objects, Class<?>[] classes, Object o) throws Throwable {
        ContextHolderFactory.getLocalContextHolder().remove(FinagleCtxs.PEER_HOST);
        return o;
    }

    @Override
    public void handleMethodExceptionImpl(EnhancedInstance enhancedInstance, Method method, Object[] objects, Class<?>[] classes, Throwable t) {
        if (ContextManager.isActive()) {
            ContextManager.activeSpan().log(t);
        }
    }

    private String getRemote(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return "";
        }
        if (objects[0] instanceof InetSocketAddress) {
            return this.formatPeer((InetSocketAddress)objects[0]);
        }
        if (objects[0] instanceof Address.Inet) {
            return this.formatPeer(((Address.Inet)objects[0]).addr());
        }
        return "";
    }

    private String formatPeer(InetSocketAddress socketAddress) {
        return socketAddress.getAddress().getHostAddress() + ":" + socketAddress.getPort();
    }
}

