/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.TopNCondition;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.Owner;
import org.apache.skywalking.oap.server.core.query.type.SelectedRecord;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.query.IAggregationQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class AggregationQueryService
implements Service {
    private final ModuleManager moduleManager;
    private IAggregationQueryDAO aggregationQueryDAO;

    public AggregationQueryService(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private IAggregationQueryDAO getAggregationQueryDAO() {
        if (this.aggregationQueryDAO == null) {
            this.aggregationQueryDAO = (IAggregationQueryDAO)this.moduleManager.find("storage").provider().getService(IAggregationQueryDAO.class);
        }
        return this.aggregationQueryDAO;
    }

    private List<SelectedRecord> invokeSortMetrics(TopNCondition condition, Duration duration) throws IOException {
        if (!condition.senseScope()) {
            return Collections.emptyList();
        }
        String valueCName = ValueColumnMetadata.INSTANCE.getValueCName(condition.getName());
        ArrayList<KeyValue> additionalConditions = null;
        if (StringUtil.isNotEmpty((String)condition.getParentService())) {
            if (condition.getNormal() == null) {
                return Collections.emptyList();
            }
            additionalConditions = new ArrayList<KeyValue>(1);
            String serviceId = IDManager.ServiceID.buildId(condition.getParentService(), condition.getNormal());
            additionalConditions.add(new KeyValue("service_id", serviceId));
        }
        List<SelectedRecord> selectedRecords = this.getAggregationQueryDAO().sortMetricsDebuggable(condition, valueCName, duration, additionalConditions);
        selectedRecords.forEach(selectedRecord -> {
            Owner owner = new Owner();
            owner.setScope(condition.getScope());
            selectedRecord.setOwner(owner);
            switch (condition.getScope()) {
                case Service: {
                    IDManager.ServiceID.ServiceIDDefinition serviceIDDefinition = IDManager.ServiceID.analysisId(selectedRecord.getId());
                    selectedRecord.setName(serviceIDDefinition.getName());
                    owner.setServiceID(selectedRecord.getId());
                    owner.setServiceName(serviceIDDefinition.getName());
                    owner.setNormal(serviceIDDefinition.isReal());
                    break;
                }
                case ServiceInstance: {
                    IDManager.ServiceInstanceID.InstanceIDDefinition instanceIDDefinition = IDManager.ServiceInstanceID.analysisId(selectedRecord.getId());
                    IDManager.ServiceID.ServiceIDDefinition instanceServiceIDDefinition = IDManager.ServiceID.analysisId(instanceIDDefinition.getServiceId());
                    if (StringUtil.isEmpty((String)condition.getParentService())) {
                        selectedRecord.setName(instanceServiceIDDefinition.getName() + " - " + instanceIDDefinition.getName());
                    } else {
                        selectedRecord.setName(instanceIDDefinition.getName());
                    }
                    owner.setServiceID(instanceIDDefinition.getServiceId());
                    owner.setServiceName(instanceServiceIDDefinition.getName());
                    owner.setNormal(instanceServiceIDDefinition.isReal());
                    owner.setServiceInstanceID(selectedRecord.getId());
                    owner.setServiceInstanceName(instanceIDDefinition.getName());
                    break;
                }
                case Endpoint: {
                    IDManager.EndpointID.EndpointIDDefinition endpointIDDefinition = IDManager.EndpointID.analysisId(selectedRecord.getId());
                    IDManager.ServiceID.ServiceIDDefinition endpointServiceIDDefinition = IDManager.ServiceID.analysisId(endpointIDDefinition.getServiceId());
                    if (StringUtil.isEmpty((String)condition.getParentService())) {
                        selectedRecord.setName(endpointServiceIDDefinition.getName() + " - " + endpointIDDefinition.getEndpointName());
                    } else {
                        selectedRecord.setName(endpointIDDefinition.getEndpointName());
                    }
                    owner.setServiceID(endpointIDDefinition.getServiceId());
                    owner.setServiceName(endpointServiceIDDefinition.getName());
                    owner.setNormal(endpointServiceIDDefinition.isReal());
                    owner.setEndpointID(selectedRecord.getId());
                    owner.setEndpointName(endpointIDDefinition.getEndpointName());
                    break;
                }
                default: {
                    selectedRecord.setName("Unknown");
                }
            }
        });
        return selectedRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SelectedRecord> sortMetrics(TopNCondition condition, Duration duration) throws IOException {
        DebuggingTraceContext traceContext = DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan span = null;
        try {
            if (traceContext != null) {
                span = traceContext.createSpan("Query Service: sortMetrics");
                span.setMsg("TopNCondition: " + String.valueOf(condition) + ", Duration: " + String.valueOf(duration));
            }
            List<SelectedRecord> list = this.invokeSortMetrics(condition, duration);
            return list;
        }
        finally {
            if (traceContext != null && span != null) {
                traceContext.stopSpan(span);
            }
        }
    }
}

