/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.zipkin.trace;

import com.google.common.util.concurrent.RateLimiter;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.config.NamingControl;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.core.source.TagAutocomplete;
import org.apache.skywalking.oap.server.core.zipkin.source.ZipkinService;
import org.apache.skywalking.oap.server.core.zipkin.source.ZipkinServiceRelation;
import org.apache.skywalking.oap.server.core.zipkin.source.ZipkinServiceSpan;
import org.apache.skywalking.oap.server.core.zipkin.source.ZipkinSpan;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.zipkin.SpanForwardService;
import org.apache.skywalking.oap.server.receiver.zipkin.ZipkinReceiverConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import zipkin2.Annotation;
import zipkin2.Span;
import zipkin2.internal.HexCodec;

public class SpanForward
implements SpanForwardService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpanForward.class);
    private final ZipkinReceiverConfig config;
    private final ModuleManager moduleManager;
    private final List<String> searchTagKeys;
    private final long samplerBoundary;
    private NamingControl namingControl;
    private SourceReceiver receiver;
    private RateLimiter rateLimiter;

    public SpanForward(ZipkinReceiverConfig config, ModuleManager manager) {
        this.config = config;
        this.moduleManager = manager;
        this.searchTagKeys = Arrays.asList(config.getSearchableTracesTags().split(","));
        float sampleRate = (float)config.getSampleRate() / 10000.0f;
        this.samplerBoundary = (long)(9.223372E18f * sampleRate);
        if (config.getMaxSpansPerSecond() > 0) {
            this.rateLimiter = RateLimiter.create((double)config.getMaxSpansPerSecond());
        }
    }

    @Override
    public List<Span> send(List<Span> spanList) {
        if (CollectionUtils.isEmpty(spanList)) {
            return Collections.emptyList();
        }
        List<Span> sampledTraces = this.getSampledTraces(spanList);
        sampledTraces.forEach(span -> {
            ZipkinSpan zipkinSpan = new ZipkinSpan();
            String serviceName = span.localServiceName();
            if (StringUtil.isEmpty((String)serviceName)) {
                serviceName = "Unknown";
            }
            zipkinSpan.setSpanId(span.id());
            zipkinSpan.setTraceId(span.traceId());
            zipkinSpan.setSpanId(span.id());
            zipkinSpan.setParentId(span.parentId());
            zipkinSpan.setName(this.getNamingControl().formatEndpointName(serviceName, span.name()));
            zipkinSpan.setDuration(span.duration() == null ? 0L : span.duration());
            if (span.kind() != null) {
                zipkinSpan.setKind(span.kind().name());
            }
            zipkinSpan.setLocalEndpointServiceName(this.getNamingControl().formatServiceName(serviceName));
            if (span.localEndpoint() != null) {
                zipkinSpan.setLocalEndpointIPV4(span.localEndpoint().ipv4());
                zipkinSpan.setLocalEndpointIPV6(span.localEndpoint().ipv6());
                Integer localPort = span.localEndpoint().port();
                if (localPort != null) {
                    zipkinSpan.setLocalEndpointPort(localPort.intValue());
                }
            }
            if (span.remoteEndpoint() != null) {
                zipkinSpan.setRemoteEndpointServiceName(this.getNamingControl().formatServiceName(span.remoteServiceName()));
                zipkinSpan.setRemoteEndpointIPV4(span.remoteEndpoint().ipv4());
                zipkinSpan.setRemoteEndpointIPV6(span.remoteEndpoint().ipv6());
                Integer remotePort = span.remoteEndpoint().port();
                if (remotePort != null) {
                    zipkinSpan.setRemoteEndpointPort(remotePort.intValue());
                }
            }
            zipkinSpan.setTimestamp(span.timestampAsLong());
            zipkinSpan.setDebug(span.debug());
            zipkinSpan.setShared(span.shared());
            long timestampMillis = span.timestampAsLong() / 1000L;
            zipkinSpan.setTimestampMillis(timestampMillis);
            long timeBucket = TimeBucket.getRecordTimeBucket((long)timestampMillis);
            zipkinSpan.setTimeBucket(timeBucket);
            long minuteTimeBucket = TimeBucket.getMinuteTimeBucket((long)timestampMillis);
            if (!span.tags().isEmpty() || !span.annotations().isEmpty()) {
                List query = zipkinSpan.getQuery();
                JsonObject annotationsJson = new JsonObject();
                JsonObject tagsJson = new JsonObject();
                for (Annotation annotation : span.annotations()) {
                    annotationsJson.addProperty(Long.toString(annotation.timestamp()), annotation.value());
                    if (annotation.value().length() > 256) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Span annotation : {}  length > : {}, dropped", (Object)annotation.value(), (Object)256);
                        continue;
                    }
                    query.add(annotation.value());
                }
                zipkinSpan.setAnnotations(annotationsJson);
                for (Map.Entry entry : span.tags().entrySet()) {
                    String tagString = (String)entry.getKey() + "=" + (String)entry.getValue();
                    tagsJson.addProperty((String)entry.getKey(), (String)entry.getValue());
                    if (((String)entry.getValue()).length() > 256 || tagString.length() > 256) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Span tag : {} length > : {}, dropped", (Object)tagString, (Object)256);
                        continue;
                    }
                    query.add((String)entry.getKey());
                    query.add(tagString);
                    if (!this.searchTagKeys.contains(entry.getKey())) continue;
                    this.addAutocompleteTags(minuteTimeBucket, (String)entry.getKey(), (String)entry.getValue());
                }
                zipkinSpan.setTags(tagsJson);
            }
            this.getReceiver().receive((ISource)zipkinSpan);
            this.toService(zipkinSpan, minuteTimeBucket);
            this.toServiceSpan(zipkinSpan, minuteTimeBucket);
            if (!StringUtil.isEmpty((String)zipkinSpan.getRemoteEndpointServiceName())) {
                this.toServiceRelation(zipkinSpan, minuteTimeBucket);
            }
        });
        return sampledTraces;
    }

    private void addAutocompleteTags(long minuteTimeBucket, String key, String value) {
        TagAutocomplete tagAutocomplete = new TagAutocomplete();
        tagAutocomplete.setTagKey(key);
        tagAutocomplete.setTagValue(value);
        tagAutocomplete.setTagType(TagType.ZIPKIN);
        tagAutocomplete.setTimeBucket(minuteTimeBucket);
        this.getReceiver().receive((ISource)tagAutocomplete);
    }

    private void toService(ZipkinSpan zipkinSpan, long minuteTimeBucket) {
        ZipkinService service = new ZipkinService();
        service.setServiceName(zipkinSpan.getLocalEndpointServiceName());
        service.setTimeBucket(minuteTimeBucket);
        this.getReceiver().receive((ISource)service);
    }

    private void toServiceSpan(ZipkinSpan zipkinSpan, long minuteTimeBucket) {
        ZipkinServiceSpan serviceSpan = new ZipkinServiceSpan();
        serviceSpan.setServiceName(zipkinSpan.getLocalEndpointServiceName());
        serviceSpan.setSpanName(zipkinSpan.getName());
        serviceSpan.setTimeBucket(minuteTimeBucket);
        this.getReceiver().receive((ISource)serviceSpan);
    }

    private void toServiceRelation(ZipkinSpan zipkinSpan, long minuteTimeBucket) {
        ZipkinServiceRelation relation = new ZipkinServiceRelation();
        relation.setServiceName(zipkinSpan.getLocalEndpointServiceName());
        relation.setRemoteServiceName(zipkinSpan.getRemoteEndpointServiceName());
        relation.setTimeBucket(minuteTimeBucket);
        this.getReceiver().receive((ISource)relation);
    }

    private List<Span> getSampledTraces(List<Span> input) {
        if (this.config.getSampleRate() == 10000 && this.rateLimiter == null) {
            return input;
        }
        ArrayList<Span> sampledTraces = new ArrayList<Span>(input.size());
        for (Span span : input) {
            if (Boolean.TRUE.equals(span.debug())) {
                sampledTraces.add(span);
                continue;
            }
            if (this.rateLimiter != null && !this.rateLimiter.tryAcquire()) {
                log.debug("Span dropped due to maximum spans per minute limit: {}", (Object)span.id());
                continue;
            }
            if (this.config.getSampleRate() == 10000) {
                sampledTraces.add(span);
                continue;
            }
            long traceId = HexCodec.lowerHexToUnsignedLong((String)span.traceId());
            traceId = traceId == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(traceId);
            if (traceId > this.samplerBoundary) continue;
            sampledTraces.add(span);
        }
        return sampledTraces;
    }

    private NamingControl getNamingControl() {
        if (this.namingControl == null) {
            this.namingControl = (NamingControl)this.moduleManager.find("core").provider().getService(NamingControl.class);
        }
        return this.namingControl;
    }

    private SourceReceiver getReceiver() {
        if (this.receiver == null) {
            this.receiver = (SourceReceiver)this.moduleManager.find("core").provider().getService(SourceReceiver.class);
        }
        return this.receiver;
    }
}

