/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.rt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oal.rt.parser.OALScripts;
import org.apache.skywalking.oal.rt.parser.ScriptParser;
import org.apache.skywalking.oal.rt.util.OALClassGenerator;
import org.apache.skywalking.oap.server.core.analysis.DispatcherDetectorListener;
import org.apache.skywalking.oap.server.core.analysis.StreamAnnotationListener;
import org.apache.skywalking.oap.server.core.oal.rt.OALCompileException;
import org.apache.skywalking.oap.server.core.oal.rt.OALDefine;
import org.apache.skywalking.oap.server.core.oal.rt.OALEngine;
import org.apache.skywalking.oap.server.core.storage.StorageBuilderFactory;
import org.apache.skywalking.oap.server.core.storage.StorageException;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OALKernel
implements OALEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OALKernel.class);
    private static boolean IS_RT_TEMP_FOLDER_INIT_COMPLETED = false;
    private OALClassGenerator oalClassGenerator;
    private StreamAnnotationListener streamAnnotationListener;
    private DispatcherDetectorListener dispatcherDetectorListener;
    private final List<Class> metricsClasses;
    private final List<Class> dispatcherClasses;
    private final OALDefine oalDefine;

    public OALKernel(OALDefine define) {
        this.oalDefine = define;
        this.metricsClasses = new ArrayList<Class>();
        this.dispatcherClasses = new ArrayList<Class>();
        this.oalClassGenerator = new OALClassGenerator(define);
    }

    public void setStreamListener(StreamAnnotationListener listener) throws ModuleStartException {
        this.streamAnnotationListener = listener;
    }

    public void setDispatcherListener(DispatcherDetectorListener listener) throws ModuleStartException {
        this.dispatcherDetectorListener = listener;
    }

    public void setStorageBuilderFactory(StorageBuilderFactory factory) {
        this.oalClassGenerator.setStorageBuilderFactory(factory);
    }

    public void start(ClassLoader currentClassLoader) throws ModuleStartException, OALCompileException {
        OALScripts oalScripts;
        Reader read;
        if (!IS_RT_TEMP_FOLDER_INIT_COMPLETED) {
            this.oalClassGenerator.prepareRTTempFolder();
            IS_RT_TEMP_FOLDER_INIT_COMPLETED = true;
        }
        this.oalClassGenerator.setCurrentClassLoader(currentClassLoader);
        try {
            read = ResourceUtils.read((String)this.oalDefine.getConfigFile());
        }
        catch (FileNotFoundException e) {
            throw new ModuleStartException("Can't locate " + this.oalDefine.getConfigFile(), (Throwable)e);
        }
        try {
            ScriptParser scriptParser = ScriptParser.createFromFile(read, this.oalDefine.getSourcePackage());
            oalScripts = scriptParser.parse();
        }
        catch (IOException e) {
            throw new ModuleStartException("OAL script parse analysis failure.", (Throwable)e);
        }
        this.oalClassGenerator.generateClassAtRuntime(oalScripts, this.metricsClasses, this.dispatcherClasses);
    }

    public void notifyAllListeners() throws ModuleStartException {
        for (Class metricsClass : this.metricsClasses) {
            try {
                this.streamAnnotationListener.notify(metricsClass);
            }
            catch (StorageException e) {
                throw new ModuleStartException(e.getMessage(), (Throwable)e);
            }
        }
        for (Class dispatcherClass : this.dispatcherClasses) {
            try {
                this.dispatcherDetectorListener.addIfAsSourceDispatcher(dispatcherClass);
            }
            catch (Exception e) {
                throw new ModuleStartException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected List<Class> getMetricsClasses() {
        return this.metricsClasses;
    }

    protected List<Class> getDispatcherClasses() {
        return this.dispatcherClasses;
    }
}

