/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToggleGroup;
import org.apache.sis.gui.internal.GUIUtilities;
import org.apache.sis.gui.internal.Resources;
import org.apache.sis.gui.referencing.ObjectStringConverter;
import org.apache.sis.gui.referencing.RecentReferenceSystems;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.gazetteer.GazetteerException;
import org.apache.sis.referencing.gazetteer.GazetteerFactory;
import org.apache.sis.referencing.gazetteer.ReferencingByIdentifiers;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;

final class MenuSync
extends SimpleObjectProperty<ReferenceSystem>
implements EventHandler<ActionEvent> {
    private static final int BIDIMENSIONAL = 2;
    private static final String REFERENCE_SYSTEM_KEY = "ReferenceSystem";
    private static final String CHOOSER = "CHOOSER";
    private final List<ReferenceSystem> recentSystems;
    private final List<DerivedCRS> cellIndicesSystems;
    private final ObservableList<MenuItem> rootMenus;
    private final ObservableList<MenuItem> cellIndicesMenus;
    private final ToggleGroup group;
    private final RecentReferenceSystems.SelectionListener action;

    MenuSync(List<ReferenceSystem> systems, boolean byIds, List<DerivedCRS> derived, Menu bean, RecentReferenceSystems.SelectionListener action) {
        super((Object)bean, "value");
        this.recentSystems = systems;
        this.cellIndicesSystems = derived;
        this.rootMenus = bean.getItems();
        this.group = new ToggleGroup();
        this.action = action;
        ArrayList<Object> items = new ArrayList<Object>(systems.size() + 1);
        Locale locale = action.owner().locale;
        for (ReferenceSystem system : systems) {
            if (system == RecentReferenceSystems.OTHER) {
                items.add(new SeparatorMenuItem());
            }
            items.add(this.createItem(system, locale));
        }
        this.rootMenus.addAll(items);
        this.initialize();
        if (byIds) {
            this.addReferencingByIdentifiers(locale);
        }
        if (derived != null) {
            Menu menu = new Menu(Resources.forLocale(locale).getString((short)74));
            this.cellIndicesMenus = menu.getItems();
            this.updateCellIndicesMenus(locale);
            this.rootMenus.add((Object)menu);
        } else {
            this.cellIndicesMenus = null;
        }
    }

    private void initialize() {
        for (ReferenceSystem system : this.recentSystems) {
            if (!(system instanceof CoordinateReferenceSystem) || CRS.getDimensionOrZero((CoordinateReferenceSystem)((CoordinateReferenceSystem)system)) != 2) continue;
            this.set(system);
            break;
        }
    }

    private MenuItem createItem(ReferenceSystem system, Locale locale) {
        if (system == RecentReferenceSystems.OTHER) {
            MenuItem item = new MenuItem(ObjectStringConverter.other(locale));
            item.getProperties().put((Object)REFERENCE_SYSTEM_KEY, (Object)CHOOSER);
            item.setOnAction((EventHandler)this);
            return item;
        }
        RadioMenuItem item = new RadioMenuItem(IdentifiedObjects.getDisplayName((IdentifiedObject)system, (Locale)locale));
        item.getProperties().put((Object)REFERENCE_SYSTEM_KEY, (Object)system);
        item.setToggleGroup(this.group);
        item.setOnAction((EventHandler)this);
        return item;
    }

    private void addReferencingByIdentifiers(Locale locale) {
        GazetteerFactory factory = new GazetteerFactory();
        Resources resources = Resources.forLocale(locale);
        Menu menu = new Menu(resources.getString((short)73));
        for (String name : factory.getSupportedNames()) {
            try {
                ReferencingByIdentifiers system = factory.forName(name);
                MenuItem item = new MenuItem(IdentifiedObjects.getDisplayName((IdentifiedObject)system, (Locale)locale));
                item.getProperties().put((Object)REFERENCE_SYSTEM_KEY, (Object)system);
                item.setOnAction((EventHandler)this);
                menu.getItems().add((Object)item);
            }
            catch (GazetteerException e) {
                RecentReferenceSystems.errorOccurred("createMenuItems", (Exception)((Object)e));
            }
        }
        this.rootMenus.add((Object)menu);
    }

    private void updateCellIndicesMenus(Locale locale) {
        int i;
        int n = this.cellIndicesSystems.size();
        for (i = 0; i < n; ++i) {
            RadioMenuItem item;
            DerivedCRS crs = this.cellIndicesSystems.get(i);
            if (i < this.cellIndicesMenus.size()) {
                item = (RadioMenuItem)this.cellIndicesMenus.get(i);
            } else {
                item = new RadioMenuItem();
                item.setToggleGroup(this.group);
                item.setOnAction((EventHandler)this);
                this.cellIndicesMenus.add((Object)item);
            }
            if (item.getProperties().put((Object)REFERENCE_SYSTEM_KEY, (Object)crs) == crs) continue;
            item.setText(IdentifiedObjects.getDisplayName((IdentifiedObject)crs, (Locale)locale));
        }
        i = this.cellIndicesMenus.size();
        while (--i >= n) {
            RadioMenuItem item = (RadioMenuItem)this.cellIndicesMenus.remove(i);
            item.setToggleGroup(null);
            item.setOnAction(null);
        }
    }

    private static void dispose(MenuItem item) {
        if (item != null) {
            item.setOnAction(null);
            if (item instanceof RadioMenuItem) {
                ((RadioMenuItem)item).setToggleGroup(null);
            }
        }
    }

    final void notifyChanges() {
        int i;
        SeparatorMenuItem separator = null;
        ArrayList<Menu> subMenus = new ArrayList<Menu>(2);
        IdentityHashMap<Object, MenuItem> mapping = new IdentityHashMap<Object, MenuItem>(10);
        Iterator it = this.rootMenus.iterator();
        while (it.hasNext()) {
            MenuItem item = (MenuItem)it.next();
            if (item instanceof Menu) {
                subMenus.add((Menu)item);
                continue;
            }
            if (item instanceof SeparatorMenuItem) {
                separator = (SeparatorMenuItem)item;
                continue;
            }
            if (mapping.putIfAbsent(item.getProperties().get((Object)REFERENCE_SYSTEM_KEY), item) == null) continue;
            it.remove();
            MenuSync.dispose(item);
        }
        int newCount = this.recentSystems.size();
        ArrayList<Object> items = new ArrayList<Object>(newCount + 4);
        for (Object key : this.recentSystems) {
            if (key == RecentReferenceSystems.OTHER) {
                key = CHOOSER;
            }
            items.add((MenuItem)mapping.remove(key));
        }
        MenuSync.dispose((MenuItem)mapping.remove(CHOOSER));
        ReferenceSystem selected = (ReferenceSystem)this.get();
        Iterator recycle = mapping.values().iterator();
        Locale locale = this.action.owner().locale;
        for (i = 0; i < newCount; ++i) {
            MenuItem item;
            if (items.get(i) != null) continue;
            ReferenceSystem system = this.recentSystems.get(i);
            if (system != RecentReferenceSystems.OTHER && recycle.hasNext()) {
                item = (MenuItem)recycle.next();
                assert (item instanceof RadioMenuItem) : item;
                item.setText(IdentifiedObjects.getDisplayName((IdentifiedObject)system, (Locale)locale));
                item.getProperties().put((Object)REFERENCE_SYSTEM_KEY, (Object)system);
            } else {
                item = this.createItem(system, locale);
            }
            if (selected != null && system == selected) {
                ((RadioMenuItem)item).setSelected(true);
                selected = null;
            }
            items.set(i, item);
        }
        while (recycle.hasNext()) {
            MenuSync.dispose((MenuItem)recycle.next());
        }
        i = items.size();
        while (--i >= 0) {
            if (((MenuItem)items.get(i)).getClass() != MenuItem.class) continue;
            if (separator == null) {
                separator = new SeparatorMenuItem();
            }
            items.add(i, separator);
            break;
        }
        items.addAll(subMenus);
        GUIUtilities.copyAsDiff(items, this.rootMenus);
        if (this.get() == null) {
            this.initialize();
        }
        if (this.cellIndicesSystems != null) {
            this.updateCellIndicesMenus(locale);
        }
    }

    public void handle(ActionEvent event) {
        MenuItem source = (MenuItem)event.getSource();
        Object value = source.getProperties().get((Object)REFERENCE_SYSTEM_KEY);
        if (value == CHOOSER) {
            this.action.changed((ObservableValue<? extends ReferenceSystem>)this, (ReferenceSystem)this.get(), RecentReferenceSystems.OTHER);
        } else {
            ReferenceSystem system = (ReferenceSystem)value;
            if (this.cellIndicesMenus != null && this.cellIndicesMenus.contains((Object)source)) {
                ReferenceSystem old = (ReferenceSystem)this.get();
                super.set((Object)system);
                this.action.action.changed((ObservableValue)this, (Object)old, (Object)system);
            } else {
                this.set(system);
            }
        }
    }

    public void set(ReferenceSystem system) {
        ReferenceSystem old = (ReferenceSystem)this.get();
        if (old != system) {
            ComparisonMode mode = (ComparisonMode)this.action.owner().duplicationCriterion.get();
            for (MenuItem item : this.rootMenus) {
                Object current;
                if (!(item instanceof RadioMenuItem) || !Utilities.deepEquals((Object)(current = item.getProperties().get((Object)REFERENCE_SYSTEM_KEY)), (Object)system, (ComparisonMode)mode)) continue;
                system = (ReferenceSystem)current;
                super.set((Object)system);
                ((RadioMenuItem)item).setSelected(true);
                this.action.changed((ObservableValue<? extends ReferenceSystem>)this, old, system);
                return;
            }
            super.set((Object)system);
            this.group.selectToggle(null);
            this.action.owner().addSelected(system);
            if (system != RecentReferenceSystems.OTHER) {
                this.action.changed((ObservableValue<? extends ReferenceSystem>)this, old, system);
            }
        }
    }
}

