/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import org.apache.sis.math.NumberType;
import org.apache.sis.math.Vector;

public enum DataType {
    UNKNOWN(NumberType.VOID, Object.class, false, false, 0, null),
    BYTE(NumberType.BYTE, Byte.class, true, false, 7, org.apache.sis.image.DataType.BYTE),
    CHAR(NumberType.BYTE, Character.class, false, true, 2, null),
    SHORT(NumberType.SHORT, Short.class, true, false, 8, org.apache.sis.image.DataType.SHORT),
    INT(NumberType.INTEGER, Integer.class, true, false, 9, org.apache.sis.image.DataType.INT),
    FLOAT(NumberType.FLOAT, Float.class, false, false, 5, org.apache.sis.image.DataType.FLOAT),
    DOUBLE(NumberType.DOUBLE, Double.class, false, false, 6, org.apache.sis.image.DataType.DOUBLE),
    UBYTE(NumberType.BYTE, Short.class, true, true, 1, org.apache.sis.image.DataType.BYTE),
    USHORT(NumberType.SHORT, Integer.class, true, true, 3, org.apache.sis.image.DataType.USHORT),
    UINT(NumberType.INTEGER, Long.class, true, true, 4, org.apache.sis.image.DataType.UINT),
    INT64(NumberType.LONG, Long.class, true, false, 11, null),
    UINT64(NumberType.LONG, Number.class, true, true, 10, null),
    STRING(NumberType.VOID, String.class, false, false, 12, null);

    public final NumberType number;
    public final boolean isInteger;
    public final boolean isUnsigned;
    private final byte opposite;
    public final org.apache.sis.image.DataType rasterDataType;
    private final Class<?> classe;
    private static final DataType[] VALUES;

    private DataType(NumberType number, Class<?> classe, boolean isInteger, boolean isUnsigned, byte opposite, org.apache.sis.image.DataType rasterDataType) {
        this.number = number;
        this.classe = classe;
        this.isInteger = isInteger;
        this.isUnsigned = isUnsigned;
        this.opposite = opposite;
        this.rasterDataType = rasterDataType;
    }

    final Class<?> getClass(boolean vector) {
        if (vector) {
            if (this.classe == Character.class) {
                return String.class;
            }
            if (Number.class.isAssignableFrom(this.classe)) {
                return Vector.class;
            }
            return Object.class;
        }
        return this.classe;
    }

    public final int size() {
        switch (this.number) {
            case BYTE: {
                return 1;
            }
            case SHORT: {
                return 2;
            }
            case INTEGER: 
            case FLOAT: {
                return 4;
            }
            case LONG: 
            case DOUBLE: {
                return 8;
            }
        }
        return 0;
    }

    public final DataType unsigned(boolean u) {
        return u == this.isUnsigned ? this : DataType.valueOf(this.opposite);
    }

    public static DataType valueOf(int code) {
        return code >= 0 && code < VALUES.length ? VALUES[code] : UNKNOWN;
    }

    static {
        VALUES = DataType.values();
    }
}

