/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.ServiceNameResolver;
import org.apache.pulsar.common.net.ServiceURI;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.io.netty.util.internal.PlatformDependent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarServiceNameResolver
implements ServiceNameResolver {
    private static final Logger log = LoggerFactory.getLogger(PulsarServiceNameResolver.class);
    private volatile ServiceURI serviceUri;
    private volatile String serviceUrl;
    private static final AtomicIntegerFieldUpdater<PulsarServiceNameResolver> CURRENT_INDEX_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PulsarServiceNameResolver.class, "currentIndex");
    private volatile int currentIndex;
    private volatile List<InetSocketAddress> addressList;

    @Override
    public InetSocketAddress resolveHost() {
        List<InetSocketAddress> list = this.addressList;
        Preconditions.checkState(list != null, "No service url is provided yet");
        Preconditions.checkState(!list.isEmpty(), "No hosts found for service url : " + this.serviceUrl);
        if (list.size() == 1) {
            return list.get(0);
        }
        int originalIndex = CURRENT_INDEX_UPDATER.getAndUpdate(this, last -> (last + 1) % list.size());
        return list.get((originalIndex + 1) % list.size());
    }

    @Override
    public URI resolveHostUri() {
        InetSocketAddress host = this.resolveHost();
        String hostUrl = this.serviceUri.getServiceScheme() + "://" + host.getHostString() + ":" + host.getPort();
        return URI.create(hostUrl);
    }

    @Override
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Override
    public ServiceURI getServiceUri() {
        return this.serviceUri;
    }

    @Override
    public void updateServiceUrl(String serviceUrl) throws PulsarClientException.InvalidServiceURL {
        ServiceURI uri;
        try {
            uri = ServiceURI.create(serviceUrl);
        }
        catch (IllegalArgumentException iae) {
            log.error("Invalid service-url {} provided {}", new Object[]{serviceUrl, iae.getMessage(), iae});
            throw new PulsarClientException.InvalidServiceURL((Throwable)iae);
        }
        String[] hosts = uri.getServiceHosts();
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>(hosts.length);
        for (String host : hosts) {
            String hostUrl = uri.getServiceScheme() + "://" + host;
            try {
                URI hostUri = new URI(hostUrl);
                addresses.add(InetSocketAddress.createUnresolved(hostUri.getHost(), hostUri.getPort()));
            }
            catch (URISyntaxException e) {
                log.error("Invalid host provided {}", (Object)hostUrl, (Object)e);
                throw new PulsarClientException.InvalidServiceURL((Throwable)e);
            }
        }
        this.addressList = addresses;
        this.serviceUrl = serviceUrl;
        this.serviceUri = uri;
        this.currentIndex = PulsarServiceNameResolver.randomIndex(addresses.size());
    }

    private static int randomIndex(int numAddresses) {
        return numAddresses == 1 ? 0 : PlatformDependent.threadLocalRandom().nextInt(numAddresses);
    }
}

