/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class RuntimeFieldsType
implements JsonpSerializable {
    private final long charsMax;
    private final long charsTotal;
    private final long count;
    private final long docMax;
    private final long docTotal;
    private final long indexCount;
    private final List<String> lang;
    private final long linesMax;
    private final long linesTotal;
    private final String name;
    private final long scriptlessCount;
    private final long shadowedCount;
    private final long sourceMax;
    private final long sourceTotal;
    public static final JsonpDeserializer<RuntimeFieldsType> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RuntimeFieldsType::setupRuntimeFieldsTypeDeserializer);

    private RuntimeFieldsType(Builder builder) {
        this.charsMax = ApiTypeHelper.requireNonNull(builder.charsMax, this, "charsMax");
        this.charsTotal = ApiTypeHelper.requireNonNull(builder.charsTotal, this, "charsTotal");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.docMax = ApiTypeHelper.requireNonNull(builder.docMax, this, "docMax");
        this.docTotal = ApiTypeHelper.requireNonNull(builder.docTotal, this, "docTotal");
        this.indexCount = ApiTypeHelper.requireNonNull(builder.indexCount, this, "indexCount");
        this.lang = ApiTypeHelper.unmodifiableRequired(builder.lang, (Object)this, "lang");
        this.linesMax = ApiTypeHelper.requireNonNull(builder.linesMax, this, "linesMax");
        this.linesTotal = ApiTypeHelper.requireNonNull(builder.linesTotal, this, "linesTotal");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.scriptlessCount = ApiTypeHelper.requireNonNull(builder.scriptlessCount, this, "scriptlessCount");
        this.shadowedCount = ApiTypeHelper.requireNonNull(builder.shadowedCount, this, "shadowedCount");
        this.sourceMax = ApiTypeHelper.requireNonNull(builder.sourceMax, this, "sourceMax");
        this.sourceTotal = ApiTypeHelper.requireNonNull(builder.sourceTotal, this, "sourceTotal");
    }

    public static RuntimeFieldsType of(Function<Builder, ObjectBuilder<RuntimeFieldsType>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long charsMax() {
        return this.charsMax;
    }

    public final long charsTotal() {
        return this.charsTotal;
    }

    public final long count() {
        return this.count;
    }

    public final long docMax() {
        return this.docMax;
    }

    public final long docTotal() {
        return this.docTotal;
    }

    public final long indexCount() {
        return this.indexCount;
    }

    public final List<String> lang() {
        return this.lang;
    }

    public final long linesMax() {
        return this.linesMax;
    }

    public final long linesTotal() {
        return this.linesTotal;
    }

    public final String name() {
        return this.name;
    }

    public final long scriptlessCount() {
        return this.scriptlessCount;
    }

    public final long shadowedCount() {
        return this.shadowedCount;
    }

    public final long sourceMax() {
        return this.sourceMax;
    }

    public final long sourceTotal() {
        return this.sourceTotal;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("chars_max");
        generator.write(this.charsMax);
        generator.writeKey("chars_total");
        generator.write(this.charsTotal);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("doc_max");
        generator.write(this.docMax);
        generator.writeKey("doc_total");
        generator.write(this.docTotal);
        generator.writeKey("index_count");
        generator.write(this.indexCount);
        if (ApiTypeHelper.isDefined(this.lang)) {
            generator.writeKey("lang");
            generator.writeStartArray();
            for (String item0 : this.lang) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("lines_max");
        generator.write(this.linesMax);
        generator.writeKey("lines_total");
        generator.write(this.linesTotal);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("scriptless_count");
        generator.write(this.scriptlessCount);
        generator.writeKey("shadowed_count");
        generator.write(this.shadowedCount);
        generator.writeKey("source_max");
        generator.write(this.sourceMax);
        generator.writeKey("source_total");
        generator.write(this.sourceTotal);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRuntimeFieldsTypeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::charsMax, JsonpDeserializer.longDeserializer(), "chars_max");
        op.add(Builder::charsTotal, JsonpDeserializer.longDeserializer(), "chars_total");
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::docMax, JsonpDeserializer.longDeserializer(), "doc_max");
        op.add(Builder::docTotal, JsonpDeserializer.longDeserializer(), "doc_total");
        op.add(Builder::indexCount, JsonpDeserializer.longDeserializer(), "index_count");
        op.add(Builder::lang, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "lang");
        op.add(Builder::linesMax, JsonpDeserializer.longDeserializer(), "lines_max");
        op.add(Builder::linesTotal, JsonpDeserializer.longDeserializer(), "lines_total");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::scriptlessCount, JsonpDeserializer.longDeserializer(), "scriptless_count");
        op.add(Builder::shadowedCount, JsonpDeserializer.longDeserializer(), "shadowed_count");
        op.add(Builder::sourceMax, JsonpDeserializer.longDeserializer(), "source_max");
        op.add(Builder::sourceTotal, JsonpDeserializer.longDeserializer(), "source_total");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RuntimeFieldsType> {
        private Long charsMax;
        private Long charsTotal;
        private Long count;
        private Long docMax;
        private Long docTotal;
        private Long indexCount;
        private List<String> lang;
        private Long linesMax;
        private Long linesTotal;
        private String name;
        private Long scriptlessCount;
        private Long shadowedCount;
        private Long sourceMax;
        private Long sourceTotal;

        public final Builder charsMax(long value) {
            this.charsMax = value;
            return this;
        }

        public final Builder charsTotal(long value) {
            this.charsTotal = value;
            return this;
        }

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder docMax(long value) {
            this.docMax = value;
            return this;
        }

        public final Builder docTotal(long value) {
            this.docTotal = value;
            return this;
        }

        public final Builder indexCount(long value) {
            this.indexCount = value;
            return this;
        }

        public final Builder lang(List<String> list) {
            this.lang = Builder._listAddAll(this.lang, list);
            return this;
        }

        public final Builder lang(String value, String ... values) {
            this.lang = Builder._listAdd(this.lang, value, values);
            return this;
        }

        public final Builder linesMax(long value) {
            this.linesMax = value;
            return this;
        }

        public final Builder linesTotal(long value) {
            this.linesTotal = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder scriptlessCount(long value) {
            this.scriptlessCount = value;
            return this;
        }

        public final Builder shadowedCount(long value) {
            this.shadowedCount = value;
            return this;
        }

        public final Builder sourceMax(long value) {
            this.sourceMax = value;
            return this;
        }

        public final Builder sourceTotal(long value) {
            this.sourceTotal = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RuntimeFieldsType build() {
            this._checkSingleUse();
            return new RuntimeFieldsType(this);
        }
    }
}

