/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.api;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public interface ShenyuPlugin {
    public static final Logger LOG = LoggerFactory.getLogger(ShenyuPlugin.class);

    public Mono<Void> execute(ServerWebExchange var1, ShenyuPluginChain var2);

    public int getOrder();

    default public String named() {
        return "";
    }

    default public boolean skip(ServerWebExchange exchange) {
        return false;
    }

    default public boolean skip(ServerWebExchange exchange, RpcTypeEnum ... rpcTypes) {
        if (ArrayUtils.isEmpty((Object[])rpcTypes)) {
            return false;
        }
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        Objects.requireNonNull(shenyuContext);
        return Arrays.stream(rpcTypes).anyMatch(type -> Objects.equals(shenyuContext.getRpcType(), type.getName()));
    }

    default public boolean skipExcept(ServerWebExchange exchange, RpcTypeEnum ... exceptRpcTypes) {
        return !this.skip(exchange, exceptRpcTypes);
    }

    default public boolean skipExceptHttpLike(ServerWebExchange exchange) {
        return !this.skip(exchange, RpcTypeEnum.HTTP, RpcTypeEnum.SPRING_CLOUD, RpcTypeEnum.AI);
    }

    default public void before(ServerWebExchange exchange) {
        exchange.getAttributes().put("pluginStartTime:" + this.named(), System.currentTimeMillis());
    }

    default public void after(ServerWebExchange exchange) {
        long currentTimeMillis = System.currentTimeMillis();
        long startTime = (Long)exchange.getAttributes().get("pluginStartTime:" + this.named());
        LOG.debug("shenyu traceId:{}, plugin named:{}, cost:{}", new Object[]{exchange.getLogPrefix(), this.named(), currentTimeMillis - startTime});
        exchange.getAttributes().remove("pluginStartTime:" + this.named());
    }
}

