/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.reactivestreams;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.internal.reactivestreams.RxJavaSynchronizedProducer;

public class SubscriberAdapter<T>
implements org.reactivestreams.Subscriber<T> {
    private final Subscriber<? super T> rxSubscriber;
    private final AtomicBoolean started = new AtomicBoolean();

    public SubscriberAdapter(Subscriber<? super T> rxSubscriber) {
        this.rxSubscriber = rxSubscriber;
    }

    public void onSubscribe(org.reactivestreams.Subscription rsSubscription) {
        if (rsSubscription == null) {
            throw new NullPointerException("onSubscribe(null)");
        }
        if (this.started.compareAndSet(false, true)) {
            RxJavaSynchronizedProducer sp = new RxJavaSynchronizedProducer(rsSubscription);
            this.rxSubscriber.add((Subscription)sp);
            this.rxSubscriber.setProducer((Producer)sp);
        } else {
            rsSubscription.cancel();
        }
    }

    public void onNext(T t) {
        if (t == null) {
            throw new NullPointerException("onNext(null)");
        }
        this.rxSubscriber.onNext(t);
    }

    public void onError(Throwable t) {
        if (t == null) {
            throw new NullPointerException("onError(null)");
        }
        this.rxSubscriber.onError(t);
    }

    public void onComplete() {
        this.rxSubscriber.onCompleted();
    }
}

