/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.thread;

import com.alipay.common.tracer.core.async.SofaTracerCallable;
import com.alipay.common.tracer.core.async.SofaTracerRunnable;
import com.alipay.sofa.common.thread.ExecutingRunnable;
import com.alipay.sofa.common.utils.ClassUtil;
import java.util.concurrent.Callable;

public class SofaTracerCommandFactory {
    private static final String SOFA_TRACER_RUNNABLE_CLASS_NAME = "com.alipay.common.tracer.core.async.SofaTracerRunnable";
    private static final boolean SOFA_TRACER_CLASS_PRESENT = ClassUtil.isPresent("com.alipay.common.tracer.core.async.SofaTracerRunnable", SofaTracerCommandFactory.class.getClassLoader());

    static ExecutingRunnable ofExecutingRunnable(Runnable runnable) {
        if (!SOFA_TRACER_CLASS_PRESENT) {
            return new ExecutingRunnable(runnable);
        }
        return new SofaTracerExecutingRunnable(runnable);
    }

    static Runnable ofRunnable(Runnable runnable) {
        if (!SOFA_TRACER_CLASS_PRESENT) {
            return runnable;
        }
        if (runnable instanceof SofaTracerRunnable) {
            return runnable;
        }
        return new SofaTracerRunnable(runnable);
    }

    static <V> Callable<V> ofCallable(Callable<V> callable) {
        if (!SOFA_TRACER_CLASS_PRESENT) {
            return callable;
        }
        if (callable instanceof SofaTracerCallable) {
            return callable;
        }
        return new SofaTracerCallable(callable);
    }

    public static class SofaTracerExecutingRunnable
    extends ExecutingRunnable {
        private final SofaTracerRunnable sofaTracerRunnable;

        public SofaTracerExecutingRunnable(Runnable originRunnable) {
            super(originRunnable);
            this.sofaTracerRunnable = originRunnable instanceof SofaTracerRunnable ? (SofaTracerRunnable)originRunnable : new SofaTracerRunnable(originRunnable);
        }

        @Override
        public void run() {
            this.sofaTracerRunnable.run();
        }
    }
}

