/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.log;

import com.alipay.sofa.common.log.MultiAppLoggerSpaceManager;
import com.alipay.sofa.common.log.SpaceId;
import com.alipay.sofa.common.log.adapter.level.AdapterLevel;
import com.alipay.sofa.common.utils.ClassLoaderUtil;
import java.util.Collections;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class LoggerSpaceManager {
    public static Logger getLoggerBySpace(String name, String spaceName) {
        return LoggerSpaceManager.getLoggerBySpace(name, new com.alipay.sofa.common.space.SpaceId(spaceName), Collections.emptyMap());
    }

    public static Logger getLoggerBySpace(String name, String spaceName, ClassLoader spaceClassloader) {
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, spaceName, spaceClassloader);
    }

    public static Logger getLoggerBySpace(String name, com.alipay.sofa.common.space.SpaceId spaceId, Map<String, String> properties) {
        ClassLoader callerClassLoader = ClassLoaderUtil.getCallerClassLoader();
        return LoggerSpaceManager.getLoggerBySpace(name, spaceId, properties, callerClassLoader);
    }

    @Deprecated
    public static Logger getLoggerBySpace(String name, SpaceId spaceId, Map<String, String> properties) {
        return LoggerSpaceManager.getLoggerBySpace(name, (com.alipay.sofa.common.space.SpaceId)spaceId, properties);
    }

    public static Logger getLoggerBySpace(String name, com.alipay.sofa.common.space.SpaceId spaceId, Map<String, String> properties, ClassLoader spaceClassloader) {
        if (!MultiAppLoggerSpaceManager.isSpaceInitialized(spaceId)) {
            MultiAppLoggerSpaceManager.init(spaceId, properties, spaceClassloader);
        }
        return MultiAppLoggerSpaceManager.getLoggerBySpace(name, spaceId, spaceClassloader);
    }

    @Deprecated
    public static Logger getLoggerBySpace(String name, SpaceId spaceId, Map<String, String> properties, ClassLoader spaceClassloader) {
        return LoggerSpaceManager.getLoggerBySpace(name, (com.alipay.sofa.common.space.SpaceId)spaceId, properties, spaceClassloader);
    }

    public static Logger setLoggerLevel(String loggerName, String spaceName, AdapterLevel adapterLevel) {
        return LoggerSpaceManager.setLoggerLevel(loggerName, new com.alipay.sofa.common.space.SpaceId(spaceName), adapterLevel);
    }

    public static Logger setLoggerLevel(String loggerName, com.alipay.sofa.common.space.SpaceId spaceId, AdapterLevel adapterLevel) {
        return MultiAppLoggerSpaceManager.setLoggerLevel(loggerName, spaceId, adapterLevel);
    }

    @Deprecated
    public static Logger setLoggerLevel(String loggerName, SpaceId spaceId, AdapterLevel adapterLevel) {
        return MultiAppLoggerSpaceManager.setLoggerLevel(loggerName, spaceId, adapterLevel);
    }

    public static ILoggerFactory removeILoggerFactoryBySpaceName(String spaceName) {
        return LoggerSpaceManager.removeILoggerFactoryBySpaceId(new com.alipay.sofa.common.space.SpaceId(spaceName));
    }

    public static ILoggerFactory removeILoggerFactoryBySpaceId(com.alipay.sofa.common.space.SpaceId spaceId) {
        return MultiAppLoggerSpaceManager.removeILoggerFactoryBySpaceId(spaceId);
    }

    @Deprecated
    public static ILoggerFactory removeILoggerFactoryBySpaceId(SpaceId spaceId) {
        return MultiAppLoggerSpaceManager.removeILoggerFactoryBySpaceId(spaceId);
    }
}

