/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.loadbalancer.spi;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.spi.AbstractLoadBalancer;
import org.apache.shenyu.spi.Join;

@Join
public class ShortestResponseLoadBalancer
extends AbstractLoadBalancer {
    @Override
    protected Upstream doSelect(List<Upstream> upstreamList, String ip) {
        int length = upstreamList.size();
        long shortestResponse = Long.MAX_VALUE;
        int shortestCount = 0;
        int[] shortestIndexes = new int[length];
        int[] weights = new int[length];
        int totalWeight = 0;
        int firstWeight = 0;
        boolean sameWeight = true;
        for (int i = 0; i < upstreamList.size(); ++i) {
            int afterWarmup;
            Upstream upstream = upstreamList.get(i);
            AtomicLong inflight = upstream.getInflight();
            long estimateResponse = upstream.getSucceededAverageElapsed() * inflight.get();
            weights[i] = afterWarmup = this.getWeight(upstream);
            if (estimateResponse < shortestResponse) {
                shortestResponse = estimateResponse;
                shortestCount = 1;
                shortestIndexes[0] = i;
                totalWeight = afterWarmup;
                firstWeight = afterWarmup;
                sameWeight = true;
                continue;
            }
            if (estimateResponse != shortestResponse) continue;
            shortestIndexes[shortestCount++] = i;
            totalWeight += afterWarmup;
            if (!sameWeight || i <= 0 || afterWarmup == firstWeight) continue;
            sameWeight = false;
        }
        if (shortestCount == 1) {
            return upstreamList.get(shortestIndexes[0]);
        }
        if (!sameWeight && totalWeight > 0) {
            int offsetWeight = ThreadLocalRandom.current().nextInt(totalWeight);
            for (int i = 0; i < shortestCount; ++i) {
                int shortestIndex = shortestIndexes[i];
                if ((offsetWeight -= weights[shortestIndex]) >= 0) continue;
                return upstreamList.get(shortestIndex);
            }
        }
        return upstreamList.get(shortestIndexes[ThreadLocalRandom.current().nextInt(shortestCount)]);
    }
}

