/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io.throwable;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractSerializer;
import com.caucho.hessian.io.JavaDeserializer;
import com.caucho.hessian.io.throwable.ReflectThrowableSerializer;
import com.caucho.hessian.io.throwable.ThrowableDeserializer;
import com.caucho.hessian.io.throwable.ThrowableSerializer;
import com.caucho.hessian.io.throwable.adapter.EnumConstantNotPresentExceptionDeserializer;
import com.caucho.hessian.io.throwable.adapter.EnumConstantNotPresentExceptionSerializer;
import java.util.HashMap;
import java.util.Map;

public class ThrowableHelper {
    private static final boolean isLessThanJdk17 = ThrowableHelper.isLessThanJdk17();
    private static final boolean reflectionWorks = ThrowableHelper.isReflectionWorks();
    private static final Map<String, AbstractSerializer> throwableSerializerMap = new HashMap<String, AbstractSerializer>();

    private static boolean isLessThanJdk17() {
        String javaVersion = System.getProperty("java.specification.version");
        return Double.parseDouble(javaVersion) < 17.0;
    }

    private static boolean isReflectionWorks() {
        try {
            Throwable.class.getDeclaredField("cause").setAccessible(true);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static AbstractDeserializer getDeserializer(Class<?> cl) {
        if (isLessThanJdk17 || reflectionWorks) {
            return new JavaDeserializer(cl);
        }
        if (EnumConstantNotPresentException.class.isAssignableFrom(cl)) {
            return new EnumConstantNotPresentExceptionDeserializer((Class)cl);
        }
        return new ThrowableDeserializer((Class)cl);
    }

    public static AbstractSerializer getSerializer(Class<?> cl) {
        if (isLessThanJdk17 || reflectionWorks) {
            return new ReflectThrowableSerializer(cl);
        }
        if (throwableSerializerMap.containsKey(cl.getName())) {
            return throwableSerializerMap.get(cl.getName());
        }
        return new ThrowableSerializer(cl);
    }

    static {
        throwableSerializerMap.put(EnumConstantNotPresentException.class.getName(), new EnumConstantNotPresentExceptionSerializer());
    }
}

